/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.support;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.rhq.core.clientapi.agent.support.SupportAgentService;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.support.SupportManagerLocal;
import org.rhq.enterprise.server.support.SupportManagerRemote;
import org.rhq.enterprise.server.util.LookupUtil;

@Stateless
public class SupportManagerBean
implements SupportManagerLocal,
SupportManagerRemote {
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private ServerManagerLocal serverManager;
    @EJB
    private SubjectManagerLocal subjectManager;

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public InputStream getSnapshotReportStream(Subject subject, int resourceId, String name, String description) throws Exception {
        AgentClient agentClient = this.agentManager.getAgentClient(this.subjectManager.getOverlord(), resourceId);
        SupportAgentService supportService = agentClient.getSupportAgentService();
        InputStream snapshotStream = supportService.getSnapshotReport(resourceId, name, description);
        return snapshotStream;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public URL getSnapshotReport(Subject subject, int resourceId, String name, String description) throws Exception {
        InputStream snapshotStream = this.getSnapshotReportStream(subject, resourceId, name, description);
        File dir = this.getDownloadsDir();
        File downloadFile = File.createTempFile(name + "-" + resourceId + "-", ".zip", dir);
        StreamUtil.copy((InputStream)snapshotStream, (OutputStream)new FileOutputStream(downloadFile));
        Server thisServer = this.serverManager.getServer();
        String addr = thisServer.getAddress();
        int port = thisServer.getPort();
        return new URL(String.format("http://%s:%d/downloads/support/%s", addr, port, downloadFile.getName()));
    }

    private File getDownloadsDir() throws Exception {
        File serverHomeDir = LookupUtil.getCoreServer().getJBossServerHomeDir();
        File downloadDir = new File(serverHomeDir, "deploy/rhq.ear/rhq-downloads/support");
        if (!downloadDir.isDirectory()) {
            downloadDir.mkdirs();
            if (!downloadDir.isDirectory()) {
                throw new FileNotFoundException("Missing downloads directory at [" + downloadDir + "]");
            }
        }
        return downloadDir;
    }
}

