/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync.validators;

import java.util.Collections;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.xml.stream.XMLStreamException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.sync.entity.SystemSettings;
import org.rhq.enterprise.server.sync.ExportReader;
import org.rhq.enterprise.server.sync.ExportWriter;
import org.rhq.enterprise.server.sync.ValidationException;
import org.rhq.enterprise.server.sync.validators.ConsistencyValidator;
import org.rhq.enterprise.server.sync.validators.InconsistentStateException;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class SystemSettingsValidator
implements ConsistencyValidator {
    private Subject subject;
    private SystemManagerLocal systemManager;

    public SystemSettingsValidator() {
        this(LookupUtil.getSystemManager());
    }

    public SystemSettingsValidator(SystemManagerLocal systemManager) {
        this.systemManager = systemManager;
    }

    @Override
    public void initialize(Subject subject, EntityManager entityManager) {
        this.subject = subject;
    }

    @Override
    public void exportState(ExportWriter writer) throws XMLStreamException {
    }

    @Override
    public void initializeExportedStateValidation(ExportReader reader) throws XMLStreamException {
    }

    @Override
    public void validateExportedState() throws InconsistentStateException {
    }

    @Override
    public Set<Class<?>> getValidatedEntityTypes() {
        return Collections.singleton(SystemSettings.class);
    }

    @Override
    public void validateExportedEntity(Object entity) throws ValidationException {
        if (entity instanceof SystemSettings) {
            try {
                this.systemManager.validateSystemConfiguration(this.subject, ((SystemSettings)entity).toProperties());
            }
            catch (Exception e) {
                throw new ValidationException("The system settings failed to validate: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SystemSettingsValidator;
    }
}

