/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.model;

import java.util.regex.Pattern;
import org.rhq.core.domain.drift.DriftChangeSetCategory;
import org.rhq.enterprise.server.alert.engine.model.AbstractCacheElement;
import org.rhq.enterprise.server.alert.engine.model.AlertConditionOperator;
import org.rhq.enterprise.server.alert.engine.model.InvalidCacheElementException;
import org.rhq.enterprise.server.alert.engine.model.UnsupportedAlertConditionOperatorException;
import org.rhq.enterprise.server.plugin.pc.drift.DriftChangeSetSummary;

public class DriftCacheElement
extends AbstractCacheElement<Object> {
    public static final Object UNUSED_CONDITION_VALUE = "Drift Detected";
    private final Pattern driftDefNameRegex;
    private final Pattern driftPathNameRegex;

    public DriftCacheElement(AlertConditionOperator operator, String driftDefNameRegexStr, String driftPathNameRegexStr, int conditionTriggerId) {
        super(operator, UNUSED_CONDITION_VALUE, conditionTriggerId);
        try {
            this.driftDefNameRegex = driftDefNameRegexStr != null && driftDefNameRegexStr.length() > 0 ? Pattern.compile(driftDefNameRegexStr) : null;
            this.driftPathNameRegex = driftPathNameRegexStr != null && driftPathNameRegexStr.length() > 0 ? Pattern.compile(driftPathNameRegexStr) : null;
        }
        catch (Exception e) {
            throw new InvalidCacheElementException("Failed to compile regex for drift condition", e);
        }
    }

    @Override
    public boolean matches(Object providedValue, Object ... extraParams) {
        if (this.alertConditionOperator == AlertConditionOperator.CHANGES) {
            boolean pathNameMatches;
            DriftChangeSetSummary summary = (DriftChangeSetSummary)extraParams[0];
            if (summary.getCategory() == DriftChangeSetCategory.COVERAGE) {
                return false;
            }
            if (this.driftDefNameRegex != null && !this.driftDefNameRegex.matcher(summary.getDriftDefinitionName()).matches()) {
                return false;
            }
            if (this.driftPathNameRegex != null) {
                pathNameMatches = false;
                for (String pathname : summary.getDriftPathnames()) {
                    if (!this.driftPathNameRegex.matcher(pathname).matches()) continue;
                    pathNameMatches = true;
                    break;
                }
            } else {
                pathNameMatches = true;
            }
            return pathNameMatches;
        }
        throw new UnsupportedAlertConditionOperatorException(this.getClass().getSimpleName() + " does not support " + (Object)((Object)this.alertConditionOperator));
    }

    @Override
    public AlertConditionOperator.Type getOperatorSupportsType(AlertConditionOperator operator) {
        if (operator == AlertConditionOperator.CHANGES) {
            return operator.getDefaultType();
        }
        return AlertConditionOperator.Type.NONE;
    }
}

