/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.cloud.instance;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.cloud.PartitionEventType;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.communications.GlobalSuspendCommandListener;
import org.rhq.enterprise.communications.command.server.CommandListener;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.cloud.CloudManagerLocal;
import org.rhq.enterprise.server.cloud.PartitionEventManagerLocal;
import org.rhq.enterprise.server.cloud.StatusManagerLocal;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;
import org.rhq.enterprise.server.cloud.instance.ServerNotFoundException;
import org.rhq.enterprise.server.cloud.instance.SyncEndpointAddressException;
import org.rhq.enterprise.server.core.comm.ServerCommunicationsServiceUtil;

@Stateless
public class ServerManagerBean
implements ServerManagerLocal {
    private final Log log = LogFactory.getLog(ServerManagerBean.class);
    private static final String RHQ_SERVER_NAME_PROPERTY = "rhq.server.high-availability.name";
    private static Server.OperationMode lastEstablishedServerMode = null;
    @Resource
    private TimerService timerService;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private CloudManagerLocal cloudManager;
    @EJB
    private StatusManagerLocal agentStatusManager;
    @EJB
    private PartitionEventManagerLocal partitionEventManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private ServerManagerLocal serverManager;
    private final String TIMER_DATA = "ServerManagerBean.beat";

    @Override
    public void scheduleServerHeartbeat() {
        Collection timers = this.timerService.getTimers();
        for (Timer existingTimer : timers) {
            this.log.debug((Object)("Found timer - attempting to cancel: " + existingTimer.toString()));
            try {
                existingTimer.cancel();
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed in attempting to cancel timer: " + existingTimer.toString()));
            }
        }
        this.timerService.createTimer(30000L, (Serializable)((Object)"ServerManagerBean.beat"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Timeout
    public void handleHeartbeatTimer(Timer timer) {
        try {
            this.serverManager.beat();
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to handle cloud heartbeat timer - will try again later. Cause: " + t));
        }
        finally {
            try {
                this.timerService.createTimer(30000L, (Serializable)((Object)"ServerManagerBean.beat"));
            }
            catch (Throwable t) {
                this.log.error((Object)("Failed to reschedule cloud heartbeat timer! Server status handling will not work from this point. A server restart may be needed after issue is resolved:" + t));
            }
        }
    }

    @Override
    public int create(Server server) {
        this.entityManager.persist((Object)server);
        return server.getId();
    }

    @Override
    public String getIdentity() {
        String identity = System.getProperty(RHQ_SERVER_NAME_PROPERTY, "");
        if (identity.equals("")) {
            return "localhost";
        }
        return identity;
    }

    @Override
    public List<Agent> getAgents() {
        String identity = this.getIdentity();
        List<Agent> results = this.cloudManager.getAgentsByServerName(identity);
        return results;
    }

    @Override
    public List<Integer> getAndClearAgentsWithStatus() {
        List<Integer> results = this.agentStatusManager.getAndClearAgentsWithStatusForServer(this.getIdentity());
        return results;
    }

    @Override
    public boolean getAndClearServerStatus() {
        String identity = this.getIdentity();
        Server server = this.cloudManager.getServerByName(identity);
        if (server == null) {
            return false;
        }
        boolean hadStatus = server.getStatus() != 0;
        server.clearStatus();
        return hadStatus;
    }

    @Override
    public Server getServer() throws ServerNotFoundException {
        String identity = this.getIdentity();
        Server result = this.cloudManager.getServerByName(identity);
        if (result == null) {
            throw new ServerNotFoundException("Could not find server; is the rhq.server.high-availability.name property set in rhq-server.properties?");
        }
        return result;
    }

    public void printWithTrace(String message) {
        try {
            new IllegalArgumentException(message);
        }
        catch (IllegalArgumentException iae) {
            String stackTrace = ThrowableUtil.getStackAsString((Throwable)iae);
            LogFactory.getLog((String)"HighAvailabilityLogic").fatal((Object)stackTrace);
        }
    }

    @Override
    public void establishCurrentServerMode() {
        Server server = this.getServer();
        Server.OperationMode serverMode = server.getOperationMode();
        if (serverMode == lastEstablishedServerMode) {
            return;
        }
        if (null == lastEstablishedServerMode) {
            this.printWithTrace("establishCurrentServerMode: NULL->" + serverMode + ", clearing agent references");
            this.clearAgentReferences(server);
        }
        try {
            if (Server.OperationMode.NORMAL == serverMode) {
                if (Server.OperationMode.MAINTENANCE == lastEstablishedServerMode) {
                    this.printWithTrace("establishCurrentServerMode: MAINTENANCE->NORMAL, clearing agent references");
                    this.clearAgentReferences(server);
                    ServerCommunicationsServiceUtil.getService().safeGetServiceContainer().removeCommandListener((CommandListener)this.getMaintenanceModeListener());
                    this.log.info((Object)("Notified communication layer of server operation mode " + serverMode));
                }
            } else if (Server.OperationMode.MAINTENANCE == serverMode) {
                ServerCommunicationsServiceUtil.getService().safeGetServiceContainer().addCommandListener((CommandListener)this.getMaintenanceModeListener());
                this.log.info((Object)("Notified communication layer of server operation mode " + serverMode));
            } else if (Server.OperationMode.INSTALLED == serverMode) {
                lastEstablishedServerMode = serverMode;
                serverMode = Server.OperationMode.NORMAL;
                server.setOperationMode(serverMode);
                server.setMtime(System.currentTimeMillis());
            } else if (Server.OperationMode.DOWN == serverMode) {
                lastEstablishedServerMode = serverMode;
                serverMode = Server.OperationMode.NORMAL;
                server.setOperationMode(serverMode);
                server.setMtime(System.currentTimeMillis());
            }
            String audit = server.getName() + ": " + (null != lastEstablishedServerMode ? lastEstablishedServerMode : Server.OperationMode.DOWN) + " --> " + serverMode;
            if (Server.OperationMode.NORMAL == serverMode && Server.OperationMode.INSTALLED == lastEstablishedServerMode) {
                this.partitionEventManager.cloudPartitionEventRequest(this.subjectManager.getOverlord(), PartitionEventType.OPERATION_MODE_CHANGE, audit);
            } else {
                this.partitionEventManager.auditPartitionEvent(this.subjectManager.getOverlord(), PartitionEventType.OPERATION_MODE_CHANGE, audit);
            }
            lastEstablishedServerMode = serverMode;
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to change HA Server Mode from " + lastEstablishedServerMode + " to " + serverMode + ": " + e));
        }
    }

    private void clearAgentReferences(Server server) {
        Query query = this.entityManager.createNamedQuery("Agent.removeServerReference");
        query.setParameter("serverId", (Object)server.getId());
        int numRows = query.executeUpdate();
        if (numRows > 0) {
            this.log.info((Object)("Removed " + numRows + " obsolete agent reference(s) to server " + server.getName()));
        }
    }

    private GlobalSuspendCommandListener getMaintenanceModeListener() {
        return new GlobalSuspendCommandListener(Server.OperationMode.MAINTENANCE.name(), Server.OperationMode.MAINTENANCE.name());
    }

    @Override
    public void syncEndpointAddress() throws SyncEndpointAddressException {
        Server server = this.getServer();
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            if (!hostName.equals(server.getAddress())) {
                server.setAddress(hostName);
            }
        }
        catch (UnknownHostException e) {
            throw new SyncEndpointAddressException("Failed to sync endpoint address for " + server, e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void beat() {
        Server server = this.getServer();
        server.setMtime(System.currentTimeMillis());
        this.establishCurrentServerMode();
    }
}

