/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.configuration.util;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.configuration.AbstractPropertyMap;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;

public class ConfigurationMaskingUtility {
    public static void maskConfiguration(@NotNull Configuration configuration, @NotNull ConfigurationDefinition configurationDefinition) {
        if (configurationDefinition == null) {
            return;
        }
        Map childPropertyDefinitions = configurationDefinition.getPropertyDefinitions();
        for (PropertyDefinition childPropertyDefinition : childPropertyDefinitions.values()) {
            ConfigurationMaskingUtility.maskProperty(childPropertyDefinition, (AbstractPropertyMap)configuration);
        }
    }

    public static void unmaskConfiguration(@NotNull Configuration configuration, @NotNull Configuration unmaskedConfiguration) {
        Map memberProperties = configuration.getAllProperties();
        for (Property memberProperty : memberProperties.values()) {
            ConfigurationMaskingUtility.unmaskProperty(memberProperty.getName(), (AbstractPropertyMap)configuration, (AbstractPropertyMap)unmaskedConfiguration);
        }
    }

    private static void maskProperty(PropertyDefinition propertyDefinition, AbstractPropertyMap parentPropertyMap) {
        PropertyDefinitionList propertyDefinitionList;
        PropertyDefinition listMemberPropertyDefinition;
        if (parentPropertyMap.get(propertyDefinition.getName()) == null) {
            return;
        }
        if (propertyDefinition instanceof PropertyDefinitionSimple) {
            PropertyDefinitionSimple propertyDefinitionSimple = (PropertyDefinitionSimple)propertyDefinition;
            if (propertyDefinitionSimple.getType() == PropertySimpleType.PASSWORD) {
                PropertySimple propertySimple = parentPropertyMap.getSimple(propertyDefinition.getName());
                propertySimple.mask();
            }
        } else if (propertyDefinition instanceof PropertyDefinitionMap) {
            PropertyMap propertyMap = parentPropertyMap.getMap(propertyDefinition.getName());
            PropertyDefinitionMap propertyDefinitionMap = (PropertyDefinitionMap)propertyDefinition;
            ConfigurationMaskingUtility.maskPropertyMap((AbstractPropertyMap)propertyMap, propertyDefinitionMap);
        } else if (propertyDefinition instanceof PropertyDefinitionList && (listMemberPropertyDefinition = (propertyDefinitionList = (PropertyDefinitionList)propertyDefinition).getMemberDefinition()) instanceof PropertyDefinitionMap) {
            PropertyDefinitionMap propertyDefinitionMap = (PropertyDefinitionMap)listMemberPropertyDefinition;
            PropertyList propertyList = parentPropertyMap.getList(propertyDefinition.getName());
            for (Property property : propertyList.getList()) {
                PropertyMap propertyMap = (PropertyMap)property;
                ConfigurationMaskingUtility.maskPropertyMap((AbstractPropertyMap)propertyMap, propertyDefinitionMap);
            }
        }
    }

    private static void maskPropertyMap(AbstractPropertyMap propertyMap, PropertyDefinitionMap propertyDefinitionMap) {
        Map childPropertyDefinitions = propertyDefinitionMap.getPropertyDefinitions();
        for (PropertyDefinition childPropertyDefinition : childPropertyDefinitions.values()) {
            ConfigurationMaskingUtility.maskProperty(childPropertyDefinition, propertyMap);
        }
    }

    private static void unmaskProperty(String propertyName, AbstractPropertyMap parentPropertyMap, AbstractPropertyMap unmaskedParentPropertyMap) {
        PropertyList unmaskedPropertyList;
        PropertyList propertyList;
        List memberProperties;
        Property property = parentPropertyMap.get(propertyName);
        if (property == null) {
            return;
        }
        if (unmaskedParentPropertyMap == null) {
            return;
        }
        if (property instanceof PropertySimple) {
            PropertySimple propertySimple = (PropertySimple)property;
            ConfigurationMaskingUtility.unmaskPropertySimple(propertySimple, unmaskedParentPropertyMap);
        } else if (property instanceof PropertyMap) {
            PropertyMap propertyMap = (PropertyMap)property;
            PropertyMap unmaskedPropertyMap = unmaskedParentPropertyMap.getMap(property.getName());
            ConfigurationMaskingUtility.unmaskPropertyMap((AbstractPropertyMap)propertyMap, unmaskedPropertyMap);
        } else if (property instanceof PropertyList && !(memberProperties = (propertyList = (PropertyList)property).getList()).isEmpty() && memberProperties.get(0) instanceof PropertyMap && (unmaskedPropertyList = unmaskedParentPropertyMap.getList(propertyList.getName())) != null) {
            List unmaskedMemberProperties = unmaskedPropertyList.getList();
            for (int i = 0; i < memberProperties.size() && i < unmaskedMemberProperties.size(); ++i) {
                PropertyMap propertyMap = (PropertyMap)memberProperties.get(i);
                PropertyMap unmaskedPropertyMap = (PropertyMap)unmaskedMemberProperties.get(i);
                ConfigurationMaskingUtility.unmaskPropertyMap((AbstractPropertyMap)propertyMap, unmaskedPropertyMap);
            }
        }
    }

    private static void unmaskPropertySimple(PropertySimple propertySimple, AbstractPropertyMap unmaskedParentPropertyMap) {
        if (propertySimple.isMasked()) {
            PropertySimple unmaskedPropertySimple = unmaskedParentPropertyMap.getSimple(propertySimple.getName());
            String unmaskedValue = unmaskedPropertySimple != null ? unmaskedPropertySimple.getStringValue() : null;
            propertySimple.setStringValue(unmaskedValue);
        }
    }

    private static void unmaskPropertyMap(AbstractPropertyMap propertyMap, PropertyMap unmaskedPropertyMap) {
        if (unmaskedPropertyMap == null) {
            return;
        }
        Map memberProperties = propertyMap.getMap();
        for (Property memberProperty : memberProperties.values()) {
            ConfigurationMaskingUtility.unmaskProperty(memberProperty.getName(), propertyMap, (AbstractPropertyMap)unmaskedPropertyMap);
        }
    }
}

