/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.core.EmailManagerLocal;

@Stateless
public class EmailManagerBean
implements EmailManagerLocal {
    private static final Log LOG = LogFactory.getLog(EmailManagerBean.class);
    private static final String TEMPLATE_TOKEN_RESOURCE_NAME = "@@@RESOURCE_NAME@@@";
    private static final String TEMPLATE_TOKEN_RESOURCE_HIERARCHY = "@@@FULL_RESOURCE_HIERARCHY@@@";
    private static final String TEMPLATE_TOKEN_ALERT_NAME = "@@@ALERT_NAME@@@";
    private static final String TEMPLATE_TOKEN_PRIORITY = "@@@PRIORITY@@@";
    private static final String TEMPLATE_TOKEN_TIMESTAMP = "@@@TIMESTAMP@@@";
    private static final String TEMPLATE_TOKEN_CONDITIONS = "@@@CONDITIONS@@@";
    private static final String TEMPLATE_TOKEN_ALERT_URL = "@@@ALERT_URL@@@";
    @Resource(mappedName="java:/Mail")
    private Session mailSession;

    @Override
    public Collection<String> sendEmail(Collection<String> toAddresses, String messageSubject, String messageBody) {
        MimeMessage mimeMessage = new MimeMessage(this.mailSession);
        try {
            mimeMessage.setSubject(messageSubject);
            mimeMessage.setContent((Object)messageBody, "text/plain");
        }
        catch (MessagingException e) {
            e.printStackTrace();
            return toAddresses;
        }
        Throwable error = null;
        ArrayList<String> badAdresses = new ArrayList<String>(toAddresses.size());
        for (String toAddress : toAddresses) {
            try {
                LOG.debug((Object)("Sending email [" + messageSubject + "] to recipient [" + toAddress + "]"));
                InternetAddress recipient = new InternetAddress(toAddress);
                Transport.send((Message)mimeMessage, (Address[])new InternetAddress[]{recipient});
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to send email [" + messageSubject + "] to recipient [" + toAddress + "]: " + e.getMessage()));
                badAdresses.add(toAddress);
                if (error != null) continue;
                error = e;
            }
        }
        if (error != null) {
            LOG.error((Object)("Sending of emails failed for this reason: " + error.getMessage()));
        }
        return badAdresses;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public Map<String, String> getAlertEmailMessage(String resourceHierarchy, String resourceName, String alertName, String priority, String timestamp, String conditionLogs, String alertUrl) {
        InputStream templateStream = this.getClass().getClassLoader().getResourceAsStream("alert-email-template.txt");
        String template = new String(StreamUtil.slurp((InputStream)templateStream));
        template = template.replaceAll(TEMPLATE_TOKEN_RESOURCE_HIERARCHY, this.cleanse(resourceHierarchy, "?Unknown Resource Hierarchy?"));
        template = template.replaceAll(TEMPLATE_TOKEN_RESOURCE_NAME, this.cleanse(resourceName, "?Unknown Resource?"));
        template = template.replaceAll(TEMPLATE_TOKEN_ALERT_NAME, this.cleanse(alertName, "?Unknown Alert?"));
        template = template.replaceAll(TEMPLATE_TOKEN_PRIORITY, this.cleanse(priority, "Medium"));
        template = template.replaceAll(TEMPLATE_TOKEN_TIMESTAMP, this.cleanse(timestamp, new Date().toString()));
        template = template.replaceAll(TEMPLATE_TOKEN_CONDITIONS, this.cleanse(conditionLogs, "?Unknown Condition Logs?"));
        template = template.replaceAll(TEMPLATE_TOKEN_ALERT_URL, this.cleanse(alertUrl, "?Unknown URL?"));
        String subject = "[RHQ] Alert";
        if (template.startsWith("Subject:")) {
            try {
                subject = template.substring("Subject:".length(), template.indexOf(10));
            }
            catch (RuntimeException ignore) {
                LOG.warn((Object)"Bad alert template file - can't determine the subject, using a default");
            }
        }
        HashMap<String, String> message = new HashMap<String, String>(1);
        message.put(subject, template);
        return message;
    }

    private String cleanse(String passedValue, String defaultValue) {
        String results = passedValue;
        if (results == null) {
            results = defaultValue;
        }
        return Matcher.quoteReplacement(results);
    }
}

