/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.ResourceAvailability;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.composite.ResourceIdWithAvailabilityComposite;
import org.rhq.core.domain.resource.group.composite.ResourceGroupComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.core.util.StopWatch;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheManagerLocal;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheStats;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityManagerRemote;
import org.rhq.enterprise.server.measurement.AvailabilityPoint;
import org.rhq.enterprise.server.measurement.instrumentation.MeasurementMonitor;
import org.rhq.enterprise.server.resource.ResourceAvailabilityManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;

@Stateless
public class AvailabilityManagerBean
implements AvailabilityManagerLocal,
AvailabilityManagerRemote {
    private final Log log = LogFactory.getLog(AvailabilityManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AvailabilityManagerLocal availabilityManager;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private ResourceAvailabilityManagerLocal resourceAvailabilityManager;
    @EJB
    private AlertConditionCacheManagerLocal alertConditionCacheManager;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=21600)
    public int purgeAvailabilities(long oldest) {
        try {
            Query purgeQuery = this.entityManager.createNativeQuery("DELETE FROM RHQ_AVAILABILITY WHERE END_TIME < ?");
            purgeQuery.setParameter(1, (Object)oldest);
            long startTime = System.currentTimeMillis();
            int deleted = purgeQuery.executeUpdate();
            MeasurementMonitor.getMBean().incrementPurgeTime(System.currentTimeMillis() - startTime);
            MeasurementMonitor.getMBean().setPurgedAvailabilities(deleted);
            return deleted;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to purge availabilities older than [" + oldest + "]", e);
        }
    }

    @Override
    public AvailabilityType getCurrentAvailabilityTypeForResource(Subject subject, int resourceId) {
        return this.resourceAvailabilityManager.getLatestAvailabilityType(subject, resourceId);
    }

    @Override
    public Availability getCurrentAvailabilityForResource(Subject subject, int resourceId) {
        Availability retAvailability;
        if (!this.authorizationManager.canViewResource(subject, resourceId)) {
            throw new PermissionException("User [" + subject + "] does not have permission to view current availability for resource[id=" + resourceId + "]");
        }
        try {
            Query q = this.entityManager.createNamedQuery("Availability.findCurrentByResource");
            q.setParameter("resourceId", (Object)resourceId);
            retAvailability = (Availability)q.getSingleResult();
        }
        catch (NoResultException nre) {
            Resource resource = this.resourceManager.getResourceById(subject, resourceId);
            List availList = resource.getAvailability();
            if (availList != null && availList.size() > 0) {
                this.log.warn((Object)"Could not query for latest avail but found one - missing null end time (this should never happen)");
                retAvailability = (Availability)availList.get(availList.size() - 1);
            }
            retAvailability = new Availability(resource, new Date(), null);
        }
        return retAvailability;
    }

    @Override
    public List<AvailabilityPoint> findAvailabilitiesForResource(Subject subject, int resourceId, long fullRangeBeginTime, long fullRangeEndTime, int numberOfPoints, boolean withCurrentAvailability) {
        EntityContext context = new EntityContext(Integer.valueOf(resourceId), Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(-1));
        return this.getAvailabilitiesForContext(subject, context, fullRangeBeginTime, fullRangeEndTime, numberOfPoints, withCurrentAvailability);
    }

    @Override
    public List<AvailabilityPoint> findAvailabilitiesForResourceGroup(Subject subject, int groupId, long fullRangeBeginTime, long fullRangeEndTime, int numberOfPoints, boolean withCurrentAvailability) {
        EntityContext context = new EntityContext(Integer.valueOf(-1), Integer.valueOf(groupId), Integer.valueOf(-1), Integer.valueOf(-1));
        return this.getAvailabilitiesForContext(subject, context, fullRangeBeginTime, fullRangeEndTime, numberOfPoints, withCurrentAvailability);
    }

    @Override
    public List<AvailabilityPoint> findAvailabilitiesForAutoGroup(Subject subject, int parentResourceId, int resourceTypeId, long fullRangeBeginTime, long fullRangeEndTime, int numberOfPoints, boolean withCurrentAvailability) {
        EntityContext context = new EntityContext(Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(parentResourceId), Integer.valueOf(resourceTypeId));
        return this.getAvailabilitiesForContext(subject, context, fullRangeBeginTime, fullRangeEndTime, numberOfPoints, withCurrentAvailability);
    }

    private List<AvailabilityPoint> getAvailabilitiesForContext(Subject subject, EntityContext context, long fullRangeBeginTime, long fullRangeEndTime, int numberOfPoints, boolean withCurrentAvailability) {
        Availability surrogateAvailability;
        List<Availability> availabilities;
        Date fullRangeEndDate;
        Date fullRangeBeginDate;
        block31: {
            if (context.type == EntityContext.Type.Resource ? !this.authorizationManager.canViewResource(subject, context.resourceId) : context.type == EntityContext.Type.ResourceGroup && !this.authorizationManager.canViewGroup(subject, context.groupId)) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to view " + context.toShortString());
            }
            if (numberOfPoints <= 0 || fullRangeBeginTime >= fullRangeEndTime) {
                return new ArrayList<AvailabilityPoint>();
            }
            fullRangeBeginDate = new Date(fullRangeBeginTime);
            fullRangeEndDate = new Date(fullRangeEndTime);
            try {
                if (context.type == EntityContext.Type.Resource) {
                    availabilities = this.findAvailabilityWithinInterval(context.resourceId, fullRangeBeginDate, fullRangeEndDate);
                    break block31;
                }
                if (context.type == EntityContext.Type.ResourceGroup) {
                    availabilities = this.findResourceGroupAvailabilityWithinInterval(context.groupId, fullRangeBeginDate, fullRangeEndDate);
                    break block31;
                }
                if (context.type == EntityContext.Type.AutoGroup) {
                    availabilities = this.findAutoGroupAvailabilityWithinInterval(context.parentResourceId, context.resourceTypeId, fullRangeBeginDate, fullRangeEndDate);
                    break block31;
                }
                throw new IllegalArgumentException("Do not yet support retrieving availability history for Context[" + context.toShortString() + "]");
            }
            catch (Exception e) {
                this.log.warn((Object)("Can't obtain Availability for " + context.toShortString()), (Throwable)e);
                ArrayList<AvailabilityPoint> availabilityPoints = new ArrayList<AvailabilityPoint>(numberOfPoints);
                long totalMillis = fullRangeEndTime - fullRangeBeginTime;
                long perPointMillis = totalMillis / (long)numberOfPoints;
                for (int i = numberOfPoints; i >= 0; --i) {
                    availabilityPoints.add(new AvailabilityPoint((long)i * perPointMillis));
                }
                Collections.reverse(availabilityPoints);
                return availabilityPoints;
            }
        }
        if (availabilities.size() > 0) {
            Availability earliestAvailability = availabilities.get(0);
            if (earliestAvailability.getStartTime().getTime() > fullRangeBeginDate.getTime()) {
                surrogateAvailability = new Availability(earliestAvailability.getResource(), fullRangeBeginDate, null);
                surrogateAvailability.setEndTime(earliestAvailability.getStartTime());
                availabilities.add(0, surrogateAvailability);
            }
        } else {
            Resource surrogateResource = context.type == EntityContext.Type.Resource ? (Resource)this.entityManager.find(Resource.class, (Object)context.resourceId) : new Resource(-1);
            surrogateAvailability = new Availability(surrogateResource, fullRangeBeginDate, null);
            surrogateAvailability.setEndTime(fullRangeEndDate);
            availabilities.add(surrogateAvailability);
        }
        Date now = new Date();
        if (fullRangeEndDate.getTime() > now.getTime()) {
            Availability latestAvailability = availabilities.get(availabilities.size() - 1);
            latestAvailability.setEndTime(now);
            Availability unknownFuture = new Availability(latestAvailability.getResource(), now, null);
            availabilities.add(unknownFuture);
        }
        long totalMillis = fullRangeEndTime - fullRangeBeginTime;
        long perPointMillis = totalMillis / (long)numberOfPoints;
        ArrayList<AvailabilityPoint> availabilityPoints = new ArrayList<AvailabilityPoint>(numberOfPoints);
        long currentTime = fullRangeEndTime;
        int currentAvailabilityIndex = availabilities.size() - 1;
        long timeUpInDataPoint = 0L;
        boolean hasDownPeriods = false;
        long dataPointStartBarrier = fullRangeEndTime - perPointMillis;
        while (currentTime > fullRangeBeginTime) {
            if (currentAvailabilityIndex <= -1) {
                availabilityPoints.add(new AvailabilityPoint(currentTime));
                currentTime -= perPointMillis;
                continue;
            }
            Availability currentAvailability = availabilities.get(currentAvailabilityIndex);
            long availabilityStartBarrier = currentAvailability.getStartTime().getTime();
            if (dataPointStartBarrier >= availabilityStartBarrier) {
                if (currentAvailability.getAvailabilityType() == null) {
                    if (hasDownPeriods) {
                        availabilityPoints.add(new AvailabilityPoint(AvailabilityType.DOWN, currentTime));
                    } else if (timeUpInDataPoint > 0L) {
                        availabilityPoints.add(new AvailabilityPoint(AvailabilityType.UP, currentTime));
                    } else {
                        availabilityPoints.add(new AvailabilityPoint(currentTime));
                    }
                } else {
                    if (currentAvailability.getAvailabilityType() == AvailabilityType.UP) {
                        timeUpInDataPoint += currentTime - dataPointStartBarrier;
                    }
                    AvailabilityType type = timeUpInDataPoint != perPointMillis ? AvailabilityType.DOWN : AvailabilityType.UP;
                    availabilityPoints.add(new AvailabilityPoint(type, currentTime));
                }
                timeUpInDataPoint = 0L;
                hasDownPeriods = false;
                if (dataPointStartBarrier == availabilityStartBarrier) {
                    --currentAvailabilityIndex;
                }
                currentTime = dataPointStartBarrier;
                dataPointStartBarrier -= perPointMillis;
                continue;
            }
            if (currentAvailability.getAvailabilityType() == AvailabilityType.UP) {
                timeUpInDataPoint += currentTime - availabilityStartBarrier;
            } else if (currentAvailability.getAvailabilityType() == AvailabilityType.DOWN) {
                hasDownPeriods = true;
            }
            --currentAvailabilityIndex;
            currentTime = availabilityStartBarrier;
        }
        Collections.reverse(availabilityPoints);
        if (withCurrentAvailability) {
            AvailabilityPoint oldFirstAvailabilityPoint = (AvailabilityPoint)availabilityPoints.remove(availabilityPoints.size() - 1);
            AvailabilityType newFirstAvailabilityType = oldFirstAvailabilityPoint.getAvailabilityType();
            if (context.type == EntityContext.Type.Resource) {
                newFirstAvailabilityType = this.getCurrentAvailabilityTypeForResource(subject, context.resourceId);
            } else if (context.type == EntityContext.Type.ResourceGroup) {
                ResourceGroupComposite composite = this.resourceGroupManager.getResourceGroupComposite(subject, context.groupId);
                Double firstAvailability = composite.getExplicitAvail();
                newFirstAvailabilityType = firstAvailability == null ? null : (firstAvailability == 1.0 ? AvailabilityType.UP : AvailabilityType.DOWN);
            }
            availabilityPoints.add(new AvailabilityPoint(newFirstAvailabilityType, oldFirstAvailabilityPoint.getTimestamp()));
        }
        if (availabilityPoints.size() != numberOfPoints) {
            String errorMsg = "Calculation of availability did not produce the proper number of data points! " + context.toShortString() + "; begin=[" + fullRangeBeginTime + "(" + new Date(fullRangeBeginTime) + ")" + "]; end=[" + fullRangeEndTime + "(" + new Date(fullRangeEndTime) + ")" + "]; numberOfPoints=[" + numberOfPoints + "]; actual-number=[" + availabilityPoints.size() + "]";
            this.log.warn((Object)errorMsg);
        }
        return availabilityPoints;
    }

    @Override
    public boolean mergeAvailabilityReport(AvailabilityReport report) {
        int reportSize = report.getResourceAvailability().size();
        String agentName = report.getAgentName();
        StopWatch watch = new StopWatch();
        if (reportSize == 0) {
            this.log.error((Object)("Agent [" + agentName + "] sent an empty availability report.  This is a bug, please report it"));
            return true;
        }
        if (this.log.isDebugEnabled() && reportSize > 1) {
            this.log.debug((Object)("Agent [" + agentName + "]: processing availability report of size: " + reportSize));
        }
        int j = 0;
        Availability[] availabilities = new Availability[report.getResourceAvailability().size()];
        for (AvailabilityReport.Datum datum : report.getResourceAvailability()) {
            availabilities[j++] = new Availability(new Resource(datum.getResourceId()), new Date(datum.getStartTime()), datum.getAvailabilityType());
        }
        this.notifyAlertConditionCacheManager("mergeAvailabilityReport", availabilities);
        boolean askForFullReport = false;
        Integer agentToUpdate = this.agentManager.getAgentIdByName(agentName);
        if (agentToUpdate != null) {
            this.availabilityManager.updateLastAvailabilityReport(agentToUpdate);
        }
        int numInserted = 0;
        if (report.isChangesOnlyReport() && this.agentManager.isAgentBackfilled(agentToUpdate)) {
            askForFullReport = true;
        } else {
            Query q = this.entityManager.createNamedQuery("Availability.findCurrentByResource");
            q.setFlushMode(FlushModeType.COMMIT);
            int count = 0;
            for (Availability reported : availabilities) {
                if (++count % 100 == 0) {
                    this.entityManager.flush();
                    this.entityManager.clear();
                }
                reported.setEndTime(null);
                try {
                    q.setParameter("resourceId", (Object)reported.getResource().getId());
                    Availability latest = (Availability)q.getSingleResult();
                    if (reported.getStartTime().getTime() >= latest.getStartTime().getTime()) {
                        if (latest.getAvailabilityType() != reported.getAvailabilityType()) {
                            this.entityManager.persist((Object)reported);
                            ++numInserted;
                            latest.setEndTime(reported.getStartTime());
                            latest = (Availability)this.entityManager.merge((Object)latest);
                            this.updateResourceAvailability(reported);
                        }
                        if (latest.getAvailabilityType() != null) continue;
                        askForFullReport = true;
                        continue;
                    }
                    this.insertAvailability(reported);
                    ++numInserted;
                    askForFullReport = true;
                }
                catch (NoResultException nre) {
                    this.entityManager.persist((Object)reported);
                    this.updateResourceAvailability(reported);
                    ++numInserted;
                }
                catch (NonUniqueResultException nure) {
                    this.log.warn((Object)("Resource [" + reported.getResource() + "] has multiple availabilities without an endtime [" + nure.getMessage() + "] - will attempt to remove the extra ones\n" + report.toString(false)));
                    q.setParameter("resourceId", (Object)reported.getResource().getId());
                    List latest = q.getResultList();
                    int latestCount = latest.size();
                    for (int i = 0; i < latestCount - 1; ++i) {
                        this.entityManager.remove(latest.get(i));
                    }
                    this.updateResourceAvailability((Availability)latest.get(latestCount - 1));
                    askForFullReport = true;
                }
            }
            MeasurementMonitor.getMBean().incrementAvailabilityReports(report.isChangesOnlyReport());
            MeasurementMonitor.getMBean().incrementAvailabilitiesInserted(numInserted);
            MeasurementMonitor.getMBean().incrementAvailabilityInsertTime(watch.getElapsed());
            watch.reset();
        }
        if (agentToUpdate != null) {
            if (askForFullReport && report.isChangesOnlyReport()) {
                this.log.debug((Object)("The server is unsure that it has up-to-date availabilities for agent [" + agentName + "]; asking for a full report to be sent"));
                return false;
            }
        } else {
            this.log.error((Object)("Could not figure out which agent sent availability report. This error is harmless and should stop appearing after a short while if the platform of the agent [" + agentName + "] was recently removed. In any other case this is a bug." + report));
        }
        return true;
    }

    private void updateResourceAvailability(Availability reported) {
        ResourceAvailability currentAvailability = this.resourceAvailabilityManager.getLatestAvailability(reported.getResource().getId());
        if (currentAvailability != null && currentAvailability.getAvailabilityType() != reported.getAvailabilityType()) {
            currentAvailability.setAvailabilityType(reported.getAvailabilityType());
            this.entityManager.merge((Object)currentAvailability);
        } else if (currentAvailability == null) {
            currentAvailability = new ResourceAvailability(reported.getResource(), reported.getAvailabilityType());
            this.entityManager.persist((Object)currentAvailability);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateLastAvailabilityReport(int agentId) {
        String updateStatement = "UPDATE Agent    SET lastAvailabilityReport = :reportTime, backFilled = FALSE  WHERE id = :agentId ";
        Query query = this.entityManager.createQuery(updateStatement);
        query.setParameter("reportTime", (Object)System.currentTimeMillis());
        query.setParameter("agentId", (Object)agentId);
        query.executeUpdate();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setAllAgentResourceAvailabilities(int agentId, AvailabilityType availabilityType) {
        String typeString = availabilityType != null ? availabilityType.toString() : "unknown";
        Query query = this.entityManager.createNamedQuery("Availability.findNonmatchingWithResourceIdByAgentAndType");
        query.setParameter("agentId", (Object)agentId);
        query.setParameter("availabilityType", (Object)availabilityType);
        List resourcesWithStatus = query.getResultList();
        this.log.debug((Object)("Agent #[" + agentId + "] is going to have [" + resourcesWithStatus.size() + "] resources backfilled with [" + typeString + "]"));
        Date now = new Date();
        ArrayList<Availability> newAvailabilities = new ArrayList<Availability>(resourcesWithStatus.size());
        for (ResourceIdWithAvailabilityComposite record : resourcesWithStatus) {
            Availability newAvailabilityInterval = this.getNewInterval(record, now, availabilityType);
            if (newAvailabilityInterval == null) continue;
            newAvailabilities.add(newAvailabilityInterval);
        }
        this.resourceAvailabilityManager.updateAllResourcesAvailabilitiesForAgent(agentId, availabilityType);
        this.notifyAlertConditionCacheManager("setAllAgentResourceAvailabilities", newAvailabilities.toArray(new Availability[newAvailabilities.size()]));
        this.log.debug((Object)("Resources for agent #[" + agentId + "] have been fully backfilled with [" + typeString + "]"));
    }

    private Availability getNewInterval(ResourceIdWithAvailabilityComposite record, Date startDate, AvailabilityType aType) {
        Availability old = record.getAvailability();
        if (old != null) {
            if (old.getAvailabilityType() == aType) {
                old.setEndTime(null);
                return null;
            }
            old.setEndTime(startDate);
        }
        Resource resource = new Resource();
        resource.setId(record.getResourceId());
        Availability newAvail = new Availability(resource, startDate, aType);
        this.entityManager.persist((Object)newAvail);
        return newAvail;
    }

    private void insertAvailability(Availability toInsert) {
        Availability existing;
        Query query = this.entityManager.createNamedQuery("Availability.findByResourceAndDate");
        query.setParameter("resourceId", (Object)toInsert.getResource().getId());
        query.setParameter("aTime", (Object)toInsert.getStartTime().getTime());
        try {
            existing = (Availability)query.getSingleResult();
        }
        catch (NoResultException nre) {
            query = this.entityManager.createNamedQuery("Availability.findByResource");
            query.setParameter("resourceId", (Object)toInsert.getResource().getId());
            query.setMaxResults(1);
            Availability firstAvail = (Availability)query.getResultList().get(0);
            if (firstAvail.getAvailabilityType() != toInsert.getAvailabilityType()) {
                toInsert.setEndTime(firstAvail.getStartTime());
                this.entityManager.persist((Object)toInsert);
            } else {
                firstAvail.setStartTime(toInsert.getStartTime());
            }
            return;
        }
        if (existing.getAvailabilityType() != toInsert.getAvailabilityType()) {
            query = this.entityManager.createNamedQuery("Availability.findByResourceAndDate");
            query.setParameter("resourceId", (Object)toInsert.getResource().getId());
            query.setParameter("aTime", (Object)(existing.getEndTime().getTime() + 1L));
            Availability afterExisting = (Availability)query.getSingleResult();
            afterExisting.setStartTime(toInsert.getStartTime());
            if (existing.getEndTime().getTime() == toInsert.getStartTime().getTime()) {
                this.entityManager.remove((Object)existing);
            } else {
                existing.setEndTime(toInsert.getStartTime());
            }
        }
    }

    @Override
    public List<Availability> findAvailabilityWithinInterval(int resourceId, Date startDate, Date endDate) {
        Query q = this.entityManager.createNamedQuery("Availability.findForResourceWithinInterval");
        q.setParameter("resourceId", (Object)resourceId);
        q.setParameter("start", (Object)startDate.getTime());
        q.setParameter("end", (Object)endDate.getTime());
        List results = q.getResultList();
        return results;
    }

    private List<Availability> findResourceGroupAvailabilityWithinInterval(int groupId, Date startDate, Date endDate) {
        Query q = this.entityManager.createNamedQuery("Availability.findForResourceGroupWithinInterval");
        q.setParameter("groupId", (Object)groupId);
        q.setParameter("start", (Object)startDate.getTime());
        q.setParameter("end", (Object)endDate.getTime());
        List results = q.getResultList();
        return results;
    }

    private List<Availability> findAutoGroupAvailabilityWithinInterval(int parentResourceId, int resourceTypeId, Date startDate, Date endDate) {
        Query q = this.entityManager.createNamedQuery("Availability.findForAutoGroupWithinInterval");
        q.setParameter("parentId", (Object)parentResourceId);
        q.setParameter("typeId", (Object)resourceTypeId);
        q.setParameter("start", (Object)startDate.getTime());
        q.setParameter("end", (Object)endDate.getTime());
        List results = q.getResultList();
        return results;
    }

    @Override
    public PageList<Availability> findAvailabilityForResource(Subject subject, int resourceId, PageControl pageControl) {
        if (!this.authorizationManager.canViewResource(subject, resourceId)) {
            throw new PermissionException("User [" + subject + "] does not have permission to view Availability history for resource[id=" + resourceId + "]");
        }
        pageControl.initDefaultOrderingField("av.startTime", PageOrdering.DESC);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Availability.findByResourceNoSort");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Availability.findByResourceNoSort", (PageControl)pageControl);
        countQuery.setParameter("resourceId", (Object)resourceId);
        query.setParameter("resourceId", (Object)resourceId);
        long count = (Long)countQuery.getSingleResult();
        List availabilities = query.getResultList();
        return new PageList((Collection)availabilities, (int)count, pageControl);
    }

    private void notifyAlertConditionCacheManager(String callingMethod, Availability ... availabilities) {
        AlertConditionCacheStats stats = this.alertConditionCacheManager.checkConditions(availabilities);
        this.log.debug((Object)(callingMethod + ": " + stats.toString()));
    }
}

