/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.IgnoreDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.ResourceAvailability;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceAncestryFormat;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceError;
import org.rhq.core.domain.resource.ResourceErrorType;
import org.rhq.core.domain.resource.ResourceSubCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.DisambiguationReport;
import org.rhq.core.domain.resource.composite.RecentlyAddedResourceComposite;
import org.rhq.core.domain.resource.composite.ResourceAvailabilitySummary;
import org.rhq.core.domain.resource.composite.ResourceComposite;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.core.domain.resource.composite.ResourceHealthComposite;
import org.rhq.core.domain.resource.composite.ResourceIdFlyWeight;
import org.rhq.core.domain.resource.composite.ResourceInstallCount;
import org.rhq.core.domain.resource.composite.ResourceLineageComposite;
import org.rhq.core.domain.resource.composite.ResourceWithAvailability;
import org.rhq.core.domain.resource.flyweight.FlyweightCache;
import org.rhq.core.domain.resource.flyweight.ResourceFlyweight;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.resource.group.composite.AutoGroupComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.core.util.IntExtractor;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.jaxb.adapter.ResourceListAdapter;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.ResourceAlreadyExistsException;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerRemote;
import org.rhq.enterprise.server.resource.ResourceNotFoundException;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.disambiguation.DisambiguationUpdateStrategy;
import org.rhq.enterprise.server.resource.disambiguation.Disambiguator;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;
import org.rhq.enterprise.server.util.QueryUtility;

@Stateless
public class ResourceManagerBean
implements ResourceManagerLocal,
ResourceManagerRemote {
    private final Log log = LogFactory.getLog(ResourceManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private ResourceGroupManagerLocal groupManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private ResourceTypeManagerLocal typeManager;
    @EJB
    @IgnoreDependency
    private MeasurementScheduleManagerLocal measurementScheduleManager;

    @Override
    public void createResource(Subject user, Resource resource, int parentId) throws ResourceAlreadyExistsException {
        Resource parent = null;
        if (parentId != -1) {
            parent = (Resource)this.entityManager.find(Resource.class, (Object)parentId);
            if (parent == null) {
                throw new ResourceNotFoundException("Intended parent for new resource does not exist.");
            }
            if (!this.authorizationManager.hasResourcePermission(user, Permission.CREATE_CHILD_RESOURCES, parent.getId())) {
                throw new PermissionException("You do not have permission to add this resource as a child.");
            }
            if (this.getResourceByParentAndKey(user, parent, resource.getResourceKey(), resource.getResourceType().getPlugin(), resource.getResourceType().getName()) != null) {
                throw new ResourceAlreadyExistsException("Resource with key '" + resource.getResourceKey() + "' already exists.");
            }
        }
        if (parent != Resource.ROOT) {
            resource.setParentResource(parent);
            parent.addChildResource(resource);
        }
        this.entityManager.persist((Object)resource);
        this.log.debug((Object)"********* resource persisted ************");
        Subject overlord = this.subjectManager.getOverlord();
        this.updateImplicitMembership(overlord, resource);
        int[] resourceIds = new int[]{resource.getId()};
        this.measurementScheduleManager.findSchedulesForResourceAndItsDescendants(resourceIds, false);
    }

    private void updateImplicitMembership(Subject subject, Resource resource) {
        if (resource.getParentResource() == null) {
            return;
        }
        this.groupManager.updateImplicitGroupMembership(subject, resource);
    }

    @Override
    public Resource updateResource(Subject user, Resource resource) {
        Resource persistedResource = (Resource)this.entityManager.find(Resource.class, (Object)resource.getId());
        if (persistedResource == null) {
            throw new ResourceNotFoundException(resource.getId());
        }
        if (!this.authorizationManager.hasResourcePermission(user, Permission.MODIFY_RESOURCE, resource.getId())) {
            throw new PermissionException("You do not have permission to modify Resource with id " + resource.getId() + ".");
        }
        if (!persistedResource.getName().equals(resource.getName())) {
            persistedResource.setName(resource.getName());
            this.updateAncestry(persistedResource);
        }
        persistedResource.setLocation(resource.getLocation());
        persistedResource.setDescription(resource.getDescription());
        persistedResource.setAgentSynchronizationNeeded();
        persistedResource.setModifiedBy(user.getName());
        return (Resource)this.entityManager.merge((Object)persistedResource);
    }

    @Override
    public List<Integer> uninventoryResources(Subject user, int[] resourceIds) {
        ArrayList<Integer> uninventoryResourceIds = new ArrayList<Integer>();
        int[] arr$ = resourceIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer resourceId = arr$[i$];
            if (uninventoryResourceIds.contains(resourceId)) continue;
            uninventoryResourceIds.addAll(this.uninventoryResource(user, resourceId));
        }
        return uninventoryResourceIds;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<Integer> uninventoryResource(Subject user, int resourceId) {
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (resource == null) {
            this.log.info((Object)("Delete resource not possible, as resource with id [" + resourceId + "] was not found"));
            return Collections.emptyList();
        }
        if (!this.authorizationManager.hasResourcePermission(user, Permission.DELETE_RESOURCE, resourceId)) {
            throw new PermissionException("You do not have permission to uninventory resource [" + resourceId + "]");
        }
        Agent doomedAgent = null;
        if (resource.getParentResource() == null) {
            try {
                doomedAgent = this.agentManager.getAgentByResourceId(this.subjectManager.getOverlord(), resourceId);
            }
            catch (Exception e) {
                doomedAgent = null;
                this.log.warn((Object)("This warning should occur in TEST code only! " + e));
            }
        }
        AgentClient agentClient = null;
        try {
            agentClient = this.agentManager.getAgentClient(this.subjectManager.getOverlord(), resourceId);
        }
        catch (Throwable t) {
            this.log.warn((Object)("No AgentClient found for resource [" + resource + "]. Unable to inform agent of inventory removal (this may be ok): " + t));
        }
        Subject overlord = this.subjectManager.getOverlord();
        this.log.info((Object)("User [" + user + "] is marking resource [" + resource + "] for asynchronous uninventory"));
        Query toBeDeletedQuery = this.entityManager.createNamedQuery("Resource.findDescendants");
        toBeDeletedQuery.setParameter("resourceId", (Object)resourceId);
        List toBeDeletedResourceIds = toBeDeletedQuery.getResultList();
        int i = 0;
        this.log.debug((Object)("== total size : " + toBeDeletedResourceIds.size()));
        while (i < toBeDeletedResourceIds.size()) {
            int j = i + 1000;
            if (j > toBeDeletedResourceIds.size()) {
                j = toBeDeletedResourceIds.size();
            }
            List<Integer> idsToDelete = toBeDeletedResourceIds.subList(i, j);
            this.log.debug((Object)("== Bounds " + i + ", " + j));
            boolean hasErrors = this.uninventoryResourcesBulkDelete(overlord, idsToDelete);
            if (hasErrors) {
                throw new IllegalArgumentException("Could not remove resources from their containing groups");
            }
            i = j;
        }
        i = 0;
        int resourcesDeleted = 0;
        while (i < toBeDeletedResourceIds.size()) {
            int j = i + 1000;
            if (j > toBeDeletedResourceIds.size()) {
                j = toBeDeletedResourceIds.size();
            }
            List idsToDelete = toBeDeletedResourceIds.subList(i, j);
            Query markDeletedQuery = this.entityManager.createNamedQuery("Resource.markResourcesForAsyncDeletionQuick");
            markDeletedQuery.setParameter("resourceIds", idsToDelete);
            markDeletedQuery.setParameter("status", (Object)InventoryStatus.UNINVENTORIED);
            resourcesDeleted += markDeletedQuery.executeUpdate();
            i = j;
        }
        if (resourcesDeleted != toBeDeletedResourceIds.size()) {
            this.log.error((Object)("Tried to uninventory " + toBeDeletedResourceIds.size() + " resources, but actually uninventoried " + resourcesDeleted));
        }
        if (agentClient != null) {
            try {
                agentClient.getDiscoveryAgentService().uninventoryResource(resourceId);
            }
            catch (Exception e) {
                this.log.warn((Object)(" Unable to inform agent of inventory removal for resource [" + resourceId + "]"), (Throwable)e);
            }
        }
        if (doomedAgent != null) {
            this.agentManager.deleteAgent(doomedAgent);
        }
        return toBeDeletedResourceIds;
    }

    @Override
    public List<Integer> getResourceDescendantsByTypeAndName(Subject user, int resourceId, Integer resourceTypeId, String name) {
        Query descendantQuery = this.entityManager.createNamedQuery("Resource.findDescendantsByTypeAndName");
        descendantQuery.setParameter("resourceId", (Object)resourceId);
        descendantQuery.setParameter("resourceTypeId", (Object)resourceTypeId);
        name = QueryUtility.formatSearchParameter(name);
        descendantQuery.setParameter("name", (Object)name);
        List descendants = descendantQuery.getResultList();
        return descendants;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void uninventoryResourceAsyncWork(Subject user, int resourceId) {
        List backingGroups;
        if (!this.authorizationManager.isOverlord(user)) {
            throw new IllegalArgumentException("Only the overlord can execute out-of-band async resource delete method");
        }
        boolean hasErrors = this.uninventoryResourcesBulkDelete(user, Arrays.asList(resourceId));
        if (hasErrors) {
            return;
        }
        hasErrors = this.uninventoryResourceBulkDeleteAsyncWork(user, resourceId);
        if (hasErrors) {
            return;
        }
        Resource attachedResource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Overlord is asynchronously deleting resource [" + attachedResource + "]"));
        }
        if (attachedResource.getDriftDefinitions() != null) {
            attachedResource.getDriftDefinitions().clear();
        }
        if (attachedResource != null && null != (backingGroups = attachedResource.getAutoGroupBackingGroups()) && !backingGroups.isEmpty()) {
            int size = backingGroups.size();
            int[] backingGroupIds = new int[size];
            for (int i = 0; i < size; ++i) {
                backingGroupIds[i] = ((ResourceGroup)backingGroups.get(i)).getId();
            }
            try {
                this.resourceGroupManager.deleteResourceGroups(user, backingGroupIds);
            }
            catch (Throwable t) {
                if (this.log.isDebugEnabled()) {
                    this.log.error((Object)("Bulk delete error for autogroup backing group deletion for " + backingGroupIds), t);
                }
                this.log.error((Object)("Bulk delete error for autogroup backing group deletion for " + backingGroupIds + ": " + t.getMessage()));
            }
        }
        this.entityManager.remove((Object)attachedResource);
    }

    private boolean uninventoryResourcesBulkDelete(Subject overlord, List<Integer> resourceIds) {
        String[] nativeQueriesToExecute = new String[]{"DELETE FROM RHQ_RESOURCE_GROUP_RES_EXP_MAP WHERE RESOURCE_ID IN ( :resourceIds )", "DELETE FROM RHQ_RESOURCE_GROUP_RES_IMP_MAP WHERE RESOURCE_ID IN ( :resourceIds )"};
        boolean hasErrors = false;
        for (String nativeQueryToExecute : nativeQueriesToExecute) {
            hasErrors |= this.resourceManager.bulkNativeQueryDeleteInNewTransaction(overlord, nativeQueryToExecute, resourceIds);
        }
        return hasErrors;
    }

    private boolean uninventoryResourceBulkDeleteAsyncWork(Subject overlord, int resourceId) {
        String[] namedQueriesToExecute = new String[]{"ResourceRepo.deleteByResources", "MeasurementBaseline.deleteByResources", "MeasurementDataTrait.deleteByResources", "CallTimeDataValue.deleteByResources", "CallTimeDataKey.deleteByResources", "DeleteOOBForResurces", "MeasurementSchedule.deleteByResources", "Availability.deleteByResources", "ResourceError.deleteByResources", "Event.deleteByResources", "EventSource.deleteByResources", "BundleResourceDeploymentHistory.deleteByResources", "BundleResourceDeployment.deleteByResources", "PackageInstallationStep.deleteByResources", "InstalledPackageHistory.deleteByResources", "InstalledPackage.deleteByResources", "ContentServiceRequest.deleteByResources", "ResourceOperationScheduleEntity.QUERY_DELETE_BY_RESOURCES", "ResourceOperationHistory.deleteByResources", "DeleteResourceHistory.deleteByResources", "CreateResourceHistory.deleteByResources", "ResourceConfigurationUpdate.deleteByResources0", "ResourceConfigurationUpdate.deleteByResources1", "ResourceConfigurationUpdate.deleteByResources2", "ResourceConfigurationUpdate.deleteByResources3", "PluginConfigurationUpdate.deleteByResources0", "PluginConfigurationUpdate.deleteByResources1", "PluginConfigurationUpdate.deleteByResources2", "PluginConfigurationUpdate.deleteByResources3", "AlertConditionLog.deleteByResources", "AlertNotificationLog.deleteByResources", "Alert.deleteByResources", "AlertCondition.deleteByResources", "AlertDampeningEvent.deleteByResources", "AlertNotification.deleteByResources", "AlertDefinition.deleteByResources", "JPADrift.deleteByResources", "JPADriftChangeSet.deleteByResources"};
        ArrayList<Integer> resourceIds = new ArrayList<Integer>();
        resourceIds.add(resourceId);
        boolean supportsCascade = DatabaseTypeFactory.getDefaultDatabaseType().supportsSelfReferringCascade();
        boolean hasErrors = false;
        boolean debugEnabled = this.log.isDebugEnabled();
        for (String namedQueryToExecute : namedQueriesToExecute) {
            if (supportsCascade && (namedQueryToExecute.equals("ResourceConfigurationUpdate.deleteByResources0") || namedQueryToExecute.equals("PluginConfigurationUpdate.deleteByResources0"))) continue;
            if (debugEnabled) {
                this.log.debug((Object)("uninv, running query: " + namedQueryToExecute));
            }
            hasErrors |= this.resourceManager.bulkNamedQueryDeleteInNewTransaction(overlord, namedQueryToExecute, resourceIds);
        }
        return hasErrors;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean bulkNativeQueryDeleteInNewTransaction(Subject subject, String nativeQueryString, List<Integer> resourceIds) {
        if (!this.authorizationManager.isOverlord(subject)) {
            throw new IllegalArgumentException("Only the overlord can execute arbitrary native query strings");
        }
        try {
            Query nativeQuery = this.entityManager.createNativeQuery(nativeQueryString);
            nativeQuery.setParameter("resourceIds", resourceIds);
            nativeQuery.executeUpdate();
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)("Bulk native query delete error for '" + nativeQueryString + "' for " + resourceIds), t);
            } else {
                this.log.error((Object)("Bulk native query delete error for '" + nativeQueryString + "' for " + resourceIds + ": " + t.getMessage()));
            }
            return true;
        }
        return false;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean bulkNamedQueryDeleteInNewTransaction(Subject subject, String namedQuery, List<Integer> resourceIds) {
        if (!this.authorizationManager.isOverlord(subject)) {
            throw new IllegalArgumentException("Only the overlord can execute arbitrary named query strings");
        }
        try {
            Query nativeQuery = this.entityManager.createNamedQuery(namedQuery);
            nativeQuery.setParameter("resourceIds", resourceIds);
            nativeQuery.executeUpdate();
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)("Bulk named query delete error for '" + namedQuery + "' for " + resourceIds), t);
            } else {
                this.log.error((Object)("Bulk named query delete error for '" + namedQuery + "' for " + resourceIds + ": " + t.getMessage()));
            }
            return true;
        }
        return false;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Resource setResourceStatus(Subject user, Resource resource, InventoryStatus newStatus, boolean setDescendents) {
        block4: {
            long now;
            block3: {
                if (resource.getParentResource() != null && resource.getParentResource().getInventoryStatus() != InventoryStatus.COMMITTED) {
                    throw new IllegalStateException("Cannot commit resource [" + resource + "] to inventory, because its parent resource [" + resource.getParentResource() + "] has not yet been committed.");
                }
                now = System.currentTimeMillis();
                this.updateInventoryStatus(resource, newStatus, now);
                resource = (Resource)this.entityManager.merge((Object)resource);
                if (!setDescendents) break block3;
                for (Resource childResource : resource.getChildResources()) {
                    this.updateInventoryStatus(childResource, newStatus, now);
                    childResource = (Resource)this.entityManager.merge((Object)childResource);
                    this.setResourceStatus(user, childResource, newStatus, setDescendents);
                }
                break block4;
            }
            if (resource.getResourceType().getCategory() != ResourceCategory.PLATFORM) break block4;
            for (Resource childResource : resource.getChildResources()) {
                if (childResource.getResourceType().getCategory() != ResourceCategory.SERVICE) continue;
                this.updateInventoryStatus(childResource, newStatus, now);
                childResource = (Resource)this.entityManager.merge((Object)childResource);
                this.setResourceStatus(user, childResource, newStatus, setDescendents);
            }
        }
        return resource;
    }

    private void updateInventoryStatus(Resource resource, InventoryStatus newStatus, long now) {
        resource.setInventoryStatus(newStatus);
        resource.setItime(now);
        resource.setAgentSynchronizationNeeded();
    }

    @Override
    public Resource getResourceById(Subject user, int resourceId) {
        Query query = this.entityManager.createNamedQuery("Resource.findById");
        query.setParameter("resourceId", (Object)resourceId);
        List resources = query.getResultList();
        if (resources.size() != 1) {
            throw new ResourceNotFoundException(resourceId);
        }
        if (!this.authorizationManager.canViewResource(user, resourceId)) {
            throw new PermissionException("User [" + user + "] does not have permission to view resource [" + resourceId + "]");
        }
        return (Resource)resources.get(0);
    }

    @Override
    @Nullable
    public Resource getResourceByParentAndKey(Subject user, Resource parent, String key, String plugin, String typeName) {
        Resource resource;
        Query query = this.entityManager.createNamedQuery("Resource.findByParentAndKey");
        query.setParameter("parent", (Object)parent);
        query.setParameter("key", (Object)key);
        query.setParameter("plugin", (Object)plugin);
        query.setParameter("typeName", (Object)typeName);
        try {
            resource = (Resource)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        if (!this.authorizationManager.canViewResource(user, resource.getId())) {
            throw new PermissionException("You do not have permission to get this resource by parent and key.");
        }
        return resource;
    }

    @Override
    public List<ResourceWithAvailability> findResourcesByParentAndType(Subject user, Resource parent, ResourceType type) {
        Query query;
        if (this.authorizationManager.isInventoryManager(user)) {
            query = this.entityManager.createNamedQuery("Resource.findByParentAndType_admin");
        } else {
            query = this.entityManager.createNamedQuery("Resource.findByParentAndType");
            query.setParameter("subject", (Object)user);
        }
        query.setParameter("parent", (Object)parent);
        query.setParameter("type", (Object)type);
        query.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        List objs = query.getResultList();
        ArrayList<ResourceWithAvailability> results = new ArrayList<ResourceWithAvailability>(objs.size());
        for (Object[] ob : objs) {
            Resource r = (Resource)ob[0];
            AvailabilityType at = (AvailabilityType)ob[1];
            ResourceWithAvailability rwa = new ResourceWithAvailability(r, at);
            results.add(rwa);
        }
        return results;
    }

    @Override
    @Nullable
    public Resource getParentResource(int resourceId) {
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (resource == null) {
            throw new ResourceNotFoundException(resourceId);
        }
        Resource parent = resource.getParentResource();
        if (parent != null) {
            parent.getId();
        }
        return parent;
    }

    @Nullable
    private Integer getParentResourceId(int resourceId) {
        Query query = this.entityManager.createNamedQuery("Resource.findParentId");
        query.setParameter("id", (Object)resourceId);
        try {
            return (Integer)query.getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    @Override
    public List<Integer> getResourceIdLineage(int resourceId) {
        ArrayList<Integer> lineage = new ArrayList<Integer>();
        Integer child = resourceId;
        Integer parent = null;
        while ((parent = this.getParentResourceId(child)) != null) {
            lineage.add(parent);
            child = parent;
        }
        return lineage;
    }

    @Override
    public List<Resource> getResourceLineage(int resourceId) {
        Resource parent;
        LinkedList<Resource> resourceLineage = new LinkedList<Resource>();
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (resource == null) {
            throw new ResourceNotFoundException(resourceId);
        }
        resourceLineage.add(resource);
        int childResourceId = resourceId;
        while ((parent = this.getParentResource(childResourceId)) != null) {
            resourceLineage.addFirst(parent);
            childResourceId = parent.getId();
        }
        return resourceLineage;
    }

    @Override
    public List<ResourceLineageComposite> getResourceLineageAndSiblings(Subject subject, int resourceId) {
        List<Resource> rawResourceLineage = this.getResourceLineage(resourceId);
        int depth = rawResourceLineage.size();
        Resource parent = depth > 1 ? rawResourceLineage.get(depth - 2) : null;
        boolean isInventoryManager = this.authorizationManager.isInventoryManager(subject);
        ArrayList<ResourceLineageComposite> resourceLineage = new ArrayList<ResourceLineageComposite>(rawResourceLineage.size());
        for (Resource resource : rawResourceLineage) {
            boolean isLocked = !isInventoryManager && !this.authorizationManager.canViewResource(subject, resource.getId());
            ResourceLineageComposite composite = new ResourceLineageComposite(resource, isLocked);
            resourceLineage.add(composite);
        }
        LinkedList<ResourceLineageComposite> result = new LinkedList<ResourceLineageComposite>();
        for (ResourceLineageComposite ancestor : resourceLineage) {
            result.add(ancestor);
            if (ancestor.isLocked() && ancestor.getResource() != parent) continue;
            PageList<Resource> children = this.findChildResourcesByCategoryAndInventoryStatus(subject, ancestor.getResource(), null, InventoryStatus.COMMITTED, PageControl.getUnlimitedInstance());
            children.removeAll(rawResourceLineage);
            for (Resource child : children) {
                child.getParentResource().getId();
                boolean isLocked = false;
                ResourceLineageComposite composite = new ResourceLineageComposite(child, isLocked);
                result.add(composite);
            }
        }
        return result;
    }

    @Override
    public List<ResourceLineageComposite> getResourceLineage(Subject subject, int resourceId) {
        boolean isInventoryManager = this.authorizationManager.isInventoryManager(subject);
        List<Resource> rawLineage = this.getResourceLineage(resourceId);
        ArrayList<ResourceLineageComposite> resourceLineage = new ArrayList<ResourceLineageComposite>(rawLineage.size());
        for (Resource resource : rawLineage) {
            boolean isLocked = false;
            if (!isInventoryManager) {
                isLocked = !this.authorizationManager.canViewResource(subject, resource.getId());
            }
            resourceLineage.add(new ResourceLineageComposite(resource, isLocked));
        }
        return resourceLineage;
    }

    @Override
    public Map<Integer, String> getResourcesAncestry(Subject subject, Integer[] resourceIds, ResourceAncestryFormat format) {
        HashMap<Integer, String> result = new HashMap<Integer, String>(resourceIds.length);
        if (resourceIds.length == 0) {
            return result;
        }
        ResourceCriteria resourceCriteria = new ResourceCriteria();
        resourceCriteria.addFilterIds(resourceIds);
        resourceCriteria.fetchResourceType(true);
        PageList<Resource> resources = this.findResourcesByCriteria(subject, resourceCriteria);
        if (ResourceAncestryFormat.RAW == format) {
            for (Resource resource : resources) {
                result.put(resource.getId(), resource.getAncestry());
            }
            return result;
        }
        HashSet<Integer> typesSet = new HashSet<Integer>();
        HashSet<String> ancestries = new HashSet<String>();
        for (Resource resource : resources) {
            ResourceType type = resource.getResourceType();
            if (type != null) {
                typesSet.add(type.getId());
            }
            ancestries.add(resource.getAncestry());
        }
        typesSet.addAll(this.getAncestryTypeIds(ancestries));
        ResourceTypeCriteria resourceTypeCriteria = new ResourceTypeCriteria();
        resourceTypeCriteria.addFilterIds(typesSet.toArray(new Integer[typesSet.size()]));
        PageList<ResourceType> types = this.typeManager.findResourceTypesByCriteria(subject, resourceTypeCriteria);
        for (Resource resource : resources) {
            String decodedAncestry = this.getDecodedAncestry(resource, (List<ResourceType>)types, format);
            result.put(resource.getId(), decodedAncestry);
        }
        return result;
    }

    private HashSet<Integer> getAncestryTypeIds(Collection<String> ancestries) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (String ancestry : ancestries) {
            if (null == ancestry) continue;
            String[] ancestryEntries = ancestry.split("_::_");
            for (int i = 0; i < ancestryEntries.length; ++i) {
                String[] entryTokens = ancestryEntries[i].split("_:_");
                int rtId = Integer.valueOf(entryTokens[0]);
                result.add(rtId);
            }
        }
        return result;
    }

    private String getDecodedAncestry(Resource resource, List<ResourceType> typeList, ResourceAncestryFormat format) {
        String ancestry = resource.getAncestry();
        StringBuilder sb = new StringBuilder("");
        if (ResourceAncestryFormat.VERBOSE != format) {
            if (ResourceAncestryFormat.EXTENDED == format) {
                sb.append(resource.getName());
            }
            if (null != ancestry) {
                if (ResourceAncestryFormat.EXTENDED == format) {
                    sb.append(" < ");
                }
                String[] ancestryEntries = ancestry.split("_::_");
                for (int i = 0; i < ancestryEntries.length; ++i) {
                    String[] entryTokens = ancestryEntries[i].split("_:_");
                    String ancestorName = entryTokens[2];
                    sb.append(i > 0 ? " < " : "");
                    sb.append(ancestorName);
                }
            }
        } else {
            HashMap<Integer, ResourceType> types = new HashMap<Integer, ResourceType>(typeList.size());
            for (ResourceType type : typeList) {
                types.put(type.getId(), type);
            }
            ResourceType type = (ResourceType)types.get(resource.getResourceType().getId());
            String resourceLongName = this.getResourceLongName(resource.getName(), type);
            if (null != ancestry) {
                String[] ancestryEntries = ancestry.split("_::_");
                int i = ancestryEntries.length - 1;
                int j = 0;
                while (i >= 0) {
                    String[] entryTokens = ancestryEntries[i].split("_:_");
                    int ancestorTypeId = Integer.valueOf(entryTokens[0]);
                    String ancestorName = entryTokens[2];
                    if (j > 0) {
                        sb.append("\n");
                        for (int k = 0; k < j; ++k) {
                            sb.append("  ");
                        }
                    }
                    type = (ResourceType)types.get(ancestorTypeId);
                    sb.append(this.getResourceLongName(ancestorName, type));
                    --i;
                    ++j;
                }
                sb.append("\n");
                for (int k = 0; k <= ancestryEntries.length; ++k) {
                    sb.append("  ");
                }
                sb.append(resourceLongName);
            } else {
                sb.append(resourceLongName);
            }
        }
        return sb.toString();
    }

    private String getResourceLongName(String resourceName, ResourceType type) {
        StringBuilder sb = new StringBuilder();
        sb.append(resourceName);
        sb.append(" [");
        sb.append(type.getPlugin());
        sb.append(", ");
        sb.append(type.getName());
        sb.append("]");
        return sb.toString();
    }

    @Override
    @NotNull
    public Resource getRootResourceForResource(int resourceId) {
        Query q = this.entityManager.createNamedQuery("Resource.findRootPlatformOfResource");
        q.setParameter("resourceId", (Object)resourceId);
        return (Resource)q.getSingleResult();
    }

    @Override
    public PageList<Resource> findResourceByParentAndInventoryStatus(Subject user, Resource parent, InventoryStatus inventoryStatus, PageControl pageControl) {
        Query query;
        Query queryCount;
        pageControl.initDefaultOrderingField("res.name");
        if (this.authorizationManager.isInventoryManager(user)) {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findByParentAndInventoryStatus_admin");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findByParentAndInventoryStatus_admin", (PageControl)pageControl);
        } else {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findByParentAndInventoryStatus");
            queryCount.setParameter("subject", (Object)user);
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findByParentAndInventoryStatus", (PageControl)pageControl);
            query.setParameter("subject", (Object)user);
        }
        queryCount.setParameter("parent", (Object)parent);
        queryCount.setParameter("inventoryStatus", (Object)inventoryStatus);
        long count = (Long)queryCount.getSingleResult();
        query.setParameter("parent", (Object)parent);
        query.setParameter("inventoryStatus", (Object)inventoryStatus);
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    public PageList<Resource> findChildResources(Subject user, Resource parent, PageControl pageControl) {
        Query query;
        Query queryCount;
        pageControl.initDefaultOrderingField("res.name");
        if (this.authorizationManager.isInventoryManager(user)) {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findChildren_admin");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findChildren_admin", (PageControl)pageControl);
        } else {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findChildren");
            queryCount.setParameter("subject", (Object)user);
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findChildren", (PageControl)pageControl);
            query.setParameter("subject", (Object)user);
        }
        queryCount.setParameter("parent", (Object)parent);
        long count = (Long)queryCount.getSingleResult();
        query.setParameter("parent", (Object)parent);
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public List<Integer> findChildrenResourceIds(int parentResourceId, InventoryStatus status) {
        Query query = this.entityManager.createNamedQuery("Resource.findChildrenIds_admin");
        query.setParameter("parentResourceId", (Object)parentResourceId);
        query.setParameter("inventoryStatus", (Object)status);
        List results = query.getResultList();
        return results;
    }

    @Override
    public PageList<Resource> findChildResourcesByCategoryAndInventoryStatus(Subject user, Resource parent, @Nullable ResourceCategory category, InventoryStatus status, PageControl pageControl) {
        Query query;
        Query queryCount;
        pageControl.initDefaultOrderingField("res.name");
        if (this.authorizationManager.isInventoryManager(user)) {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findChildrenByCategoryAndInventoryStatus_admin");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findChildrenByCategoryAndInventoryStatus_admin", (PageControl)pageControl);
        } else {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findChildrenByCategoryAndInventoryStatus");
            queryCount.setParameter("subject", (Object)user);
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findChildrenByCategoryAndInventoryStatus", (PageControl)pageControl);
            query.setParameter("subject", (Object)user);
        }
        queryCount.setParameter("parent", (Object)parent);
        queryCount.setParameter("category", (Object)category);
        queryCount.setParameter("status", (Object)status);
        long count = (Long)queryCount.getSingleResult();
        query.setParameter("parent", (Object)parent);
        query.setParameter("category", (Object)category);
        query.setParameter("status", (Object)status);
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public PageList<Resource> findResourcesByCategory(Subject user, ResourceCategory category, InventoryStatus inventoryStatus, PageControl pageControl) {
        Query query;
        Query queryCount;
        pageControl.initDefaultOrderingField("res.name");
        if (this.authorizationManager.isInventoryManager(user)) {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findByCategoryAndInventoryStatus_admin");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findByCategoryAndInventoryStatus_admin", (PageControl)pageControl);
        } else {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findByCategoryAndInventoryStatus");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findByCategoryAndInventoryStatus", (PageControl)pageControl);
            queryCount.setParameter("subject", (Object)user);
            query.setParameter("subject", (Object)user);
        }
        queryCount.setParameter("category", (Object)category);
        query.setParameter("category", (Object)category);
        queryCount.setParameter("inventoryStatus", (Object)inventoryStatus);
        query.setParameter("inventoryStatus", (Object)inventoryStatus);
        long count = (Long)queryCount.getSingleResult();
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public PageList<ResourceComposite> findResourceComposites(Subject user, ResourceCategory category, String typeName, String pluginName, Resource parentResource, String searchString, boolean attachParentResource, PageControl pageControl) {
        String queryCountName;
        String queryName;
        pageControl.initDefaultOrderingField("res.name");
        pageControl.addDefaultOrderingField("res.id");
        if (this.authorizationManager.isInventoryManager(user)) {
            queryName = attachParentResource ? "Resource.findCompositeWithParent_admin" : "Resource.findComposite_admin";
            queryCountName = "Resource.findComposite_count_admin";
        } else {
            queryName = attachParentResource ? "Resource.findCompositeWithParent" : "Resource.findComposite";
            queryCountName = "Resource.findComposite_count";
        }
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pageControl);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryCountName);
        if (!this.authorizationManager.isInventoryManager(user)) {
            queryCount.setParameter("subject", (Object)user);
            query.setParameter("subject", (Object)user);
        }
        searchString = QueryUtility.formatSearchParameter(searchString);
        query.setParameter("category", (Object)category);
        queryCount.setParameter("category", (Object)category);
        query.setParameter("resourceTypeName", (Object)typeName);
        queryCount.setParameter("resourceTypeName", (Object)typeName);
        query.setParameter("pluginName", (Object)pluginName);
        queryCount.setParameter("pluginName", (Object)pluginName);
        query.setParameter("search", (Object)searchString);
        queryCount.setParameter("search", (Object)searchString);
        query.setParameter("escapeChar", (Object)QueryUtility.getEscapeCharacter());
        queryCount.setParameter("escapeChar", (Object)QueryUtility.getEscapeCharacter());
        query.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        queryCount.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        query.setParameter("parentResource", (Object)parentResource);
        queryCount.setParameter("parentResource", (Object)parentResource);
        long count = (Long)queryCount.getSingleResult();
        return new PageList((Collection)query.getResultList(), (int)count, pageControl);
    }

    @Override
    public PageList<ResourceComposite> findResourceCompositeForParentAndTypeAndCategory(Subject user, ResourceCategory category, int resourceTypeId, Resource parentResource, PageControl pageControl) {
        ResourceType resourceType = null;
        if (resourceTypeId != -1) {
            try {
                resourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)resourceTypeId);
            }
            catch (NoResultException nre) {
                // empty catch block
            }
        }
        String typeNameFilter = resourceType == null ? null : resourceType.getName();
        String pluginNameFilter = resourceType == null ? null : resourceType.getPlugin();
        return this.findResourceComposites(user, category, typeNameFilter, pluginNameFilter, parentResource, null, false, pageControl);
    }

    public PageList<Resource> findResourcesByType(Subject user, ResourceType resourceType, PageControl pageControl) {
        Query query;
        Query queryCount;
        pageControl.initDefaultOrderingField("res.name");
        if (this.authorizationManager.isInventoryManager(user)) {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findByType_admin");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findByType_admin", (PageControl)pageControl);
        } else {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findByType");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findByType", (PageControl)pageControl);
            queryCount.setParameter("subject", (Object)user);
            query.setParameter("subject", (Object)user);
        }
        queryCount.setParameter("type", (Object)resourceType);
        long count = (Long)queryCount.getSingleResult();
        query.setParameter("type", (Object)resourceType);
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public int[] getResourceCountSummary(Subject user, InventoryStatus status) {
        Query query;
        if (this.authorizationManager.isInventoryManager(user)) {
            query = this.entityManager.createNamedQuery("Resource.findResourceSummaryByInventoryStatus_admin");
        } else {
            query = this.entityManager.createNamedQuery("Resource.findResourceSummaryByInventoryStatus");
            query.setParameter("subject", (Object)user);
        }
        query.setParameter("inventoryStatus", (Object)status);
        int[] counts = new int[3];
        List resultList = query.getResultList();
        for (Object[] row : resultList) {
            switch ((ResourceCategory)row[0]) {
                case PLATFORM: {
                    counts[0] = ((Long)row[1]).intValue();
                    break;
                }
                case SERVER: {
                    counts[1] = ((Long)row[1]).intValue();
                    break;
                }
                case SERVICE: {
                    counts[2] = ((Long)row[1]).intValue();
                }
            }
        }
        return counts;
    }

    @Override
    public int getResourceCountByCategory(Subject user, ResourceCategory category, InventoryStatus status) {
        Query queryCount;
        if (this.authorizationManager.isInventoryManager(user)) {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findByCategoryAndInventoryStatus_admin");
        } else {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findByCategoryAndInventoryStatus");
            queryCount.setParameter("subject", (Object)user);
        }
        queryCount.setParameter("inventoryStatus", (Object)status);
        queryCount.setParameter("category", (Object)category);
        long count = (Long)queryCount.getSingleResult();
        return (int)count;
    }

    @Override
    public int getResourceCountByTypeAndIds(Subject user, ResourceType type, int[] resourceIds) {
        Query queryCount;
        if (this.authorizationManager.isInventoryManager(user)) {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findByTypeAndIds_admin");
        } else {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findByTypeAndIds");
            queryCount.setParameter("subject", (Object)user);
        }
        List resourceList = ArrayUtils.wrapInList((int[])resourceIds);
        queryCount.setParameter("ids", (Object)resourceList);
        queryCount.setParameter("type", (Object)type);
        long count = (Long)queryCount.getSingleResult();
        return (int)count;
    }

    @Override
    public List<Integer> findResourcesMarkedForAsyncDeletion(Subject user) {
        if (!this.authorizationManager.isOverlord(user)) {
            throw new IllegalArgumentException("Only the overlord can purge resources marked for deletion");
        }
        Query query = this.entityManager.createNamedQuery("Resource.findResourcesMarkedForAsyncDeletion");
        List results = query.getResultList();
        return results;
    }

    @Override
    public List<RecentlyAddedResourceComposite> findRecentlyAddedPlatforms(Subject user, long ctime, int maxItems) {
        Query query;
        if (this.authorizationManager.isInventoryManager(user)) {
            query = this.entityManager.createNamedQuery("Resource.findRecentlyAddedPlatforms_admin");
        } else {
            query = this.entityManager.createNamedQuery("Resource.findRecentlyAddedPlatforms");
            query.setParameter("subject", (Object)user);
        }
        query.setParameter("oldestEpochTime", (Object)ctime);
        if (maxItems > 100 || maxItems < 0) {
            query.setMaxResults(100);
        } else {
            query.setMaxResults(maxItems);
        }
        return query.getResultList();
    }

    @Override
    public List<RecentlyAddedResourceComposite> findRecentlyAddedServers(Subject user, long ctime, int platformId) {
        Query query;
        if (this.authorizationManager.isInventoryManager(user)) {
            query = this.entityManager.createNamedQuery("Resource.findRecentlyAddedServers_admin");
        } else {
            query = this.entityManager.createNamedQuery("Resource.findRecentlyAddedServers");
            query.setParameter("subject", (Object)user);
        }
        query.setParameter("oldestEpochTime", (Object)ctime);
        query.setParameter("platformId", (Object)platformId);
        query.setMaxResults(100);
        return query.getResultList();
    }

    @Override
    public AutoGroupComposite getResourceAutoGroup(Subject user, int resourceId) {
        AutoGroupComposite result;
        Query query;
        boolean isInventoryManager = this.authorizationManager.isInventoryManager(user);
        if (isInventoryManager) {
            query = this.entityManager.createNamedQuery("Resource.findResourceAutogroupComposite_admin");
        } else {
            query = this.entityManager.createNamedQuery("Resource.findResourceAutogroupComposite");
            query.setParameter("subject", (Object)user);
        }
        query.setParameter("id", (Object)resourceId);
        try {
            result = (AutoGroupComposite)query.getSingleResult();
        }
        catch (NoResultException nore) {
            return null;
        }
        if (isInventoryManager) {
            query = this.entityManager.createNamedQuery("Resource.findAvailabilityByResourceId_admin");
        } else {
            query = this.entityManager.createNamedQuery("Resource.findAvailabilityByResourceId");
            query.setParameter("subject", (Object)user);
        }
        query.setParameter("id", (Object)resourceId);
        result.setResources(query.getResultList());
        return result;
    }

    @Override
    public List<AutoGroupComposite> findResourcesAutoGroups(Subject subject, int[] resourceIds) {
        AutoGroupComposite oneComp;
        Query query;
        ArrayList<AutoGroupComposite> results = new ArrayList<AutoGroupComposite>();
        List ids = ArrayUtils.wrapInList((int[])resourceIds);
        if (ids == null || ids.size() == 0) {
            return results;
        }
        boolean isInventoryManager = this.authorizationManager.isInventoryManager(subject);
        if (isInventoryManager) {
            query = this.entityManager.createNamedQuery("Resource.findResourceAutogroupsComposite_admin");
        } else {
            query = this.entityManager.createNamedQuery("Resource.findResourceAutogroupsComposite");
            query.setParameter("subject", (Object)subject);
        }
        query.setParameter("ids", (Object)ids);
        try {
            oneComp = (AutoGroupComposite)query.getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
        if (isInventoryManager) {
            query = this.entityManager.createNamedQuery("Resource.findAvailabilityByResourceIds_admin");
        } else {
            query = this.entityManager.createNamedQuery("Resource.findAvailabilityByResourceIds");
            query.setParameter("subject", (Object)subject);
        }
        query.setParameter("ids", (Object)ids);
        List objs = query.getResultList();
        for (Object[] ob : objs) {
            Resource r = (Resource)ob[0];
            AvailabilityType at = (AvailabilityType)ob[1];
            ResourceWithAvailability rwa = new ResourceWithAvailability(r, at);
            AutoGroupComposite comp = new AutoGroupComposite(oneComp);
            ArrayList<ResourceWithAvailability> res = new ArrayList<ResourceWithAvailability>(1);
            res.add(rwa);
            comp.setResources(res);
            results.add(comp);
        }
        return results;
    }

    @Override
    @NotNull
    public List<AutoGroupComposite> findChildrenAutoGroups(Subject user, int parentResourceId, int[] resourceTypeIds) {
        Query query;
        List typeIds = ArrayUtils.wrapInList((int[])resourceTypeIds);
        if (null != typeIds) {
            if (this.authorizationManager.isInventoryManager(user)) {
                query = this.entityManager.createNamedQuery("Resource.findChildrenAutogroupCompositesByType_admin");
            } else {
                query = this.entityManager.createNamedQuery("Resource.findChildrenAutogroupCompositesByType");
                query.setParameter("subject", (Object)user);
            }
            query.setParameter("resourceTypeIds", (Object)typeIds);
        } else if (this.authorizationManager.isInventoryManager(user)) {
            query = this.entityManager.createNamedQuery("Resource.findChildrenAutogroupComposites_admin");
        } else {
            query = this.entityManager.createNamedQuery("Resource.findChildrenAutogroupComposites");
            query.setParameter("subject", (Object)user);
        }
        Resource parentResource = (Resource)this.entityManager.getReference(Resource.class, (Object)parentResourceId);
        query.setParameter("parent", (Object)parentResource);
        query.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        List resourceAutoGroups = query.getResultList();
        for (AutoGroupComposite composite : resourceAutoGroups) {
            ResourceSubCategory sc = composite.getResourceType().getSubCategory();
            if (sc != null) {
                sc.getId();
            }
            if (this.authorizationManager.isInventoryManager(user)) {
                query = this.entityManager.createNamedQuery("Resource.findByParentAndType_admin");
            } else {
                query = this.entityManager.createNamedQuery("Resource.findByParentAndType");
                query.setParameter("subject", (Object)user);
            }
            query.setParameter("parent", (Object)parentResource);
            query.setParameter("type", (Object)composite.getResourceType());
            query.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
            List objs = query.getResultList();
            ArrayList<ResourceWithAvailability> results = new ArrayList<ResourceWithAvailability>(objs.size());
            for (Object[] ob : objs) {
                Resource r = (Resource)ob[0];
                AvailabilityType at = (AvailabilityType)ob[1];
                ResourceWithAvailability rwa = new ResourceWithAvailability(r, at);
                results.add(rwa);
            }
            composite.setResources(results);
        }
        ArrayList<AutoGroupComposite> fullComposites = new ArrayList<AutoGroupComposite>();
        this.calculateSubcategorySummary(parentResource, parentResource.getResourceType().getChildSubCategories(), resourceAutoGroups, 0, fullComposites);
        fullComposites.addAll(resourceAutoGroups);
        return fullComposites;
    }

    @Override
    public List<AutoGroupComposite> findChildrenAutoGroups(Subject user, int parentResourceId) {
        return this.findChildrenAutoGroups(user, parentResourceId, null);
    }

    private void calculateSubcategorySummary(Resource parentResource, List<ResourceSubCategory> subcategories, List<AutoGroupComposite> resourceAutoGroups, int depth, List<AutoGroupComposite> fullComposites) {
        for (ResourceSubCategory subCategory : subcategories) {
            ArrayList<AutoGroupComposite> matches = new ArrayList<AutoGroupComposite>();
            for (AutoGroupComposite ac : resourceAutoGroups) {
                for (ResourceSubCategory searchCategory = ac.getResourceType().getSubCategory(); searchCategory != null; searchCategory = searchCategory.getParentSubCategory()) {
                    if (!subCategory.equals((Object)searchCategory)) continue;
                    matches.add(ac);
                }
            }
            if (matches.size() > 0) {
                int count = 0;
                double avail = 0.0;
                for (AutoGroupComposite mac : matches) {
                    count = (int)((long)count + mac.getMemberCount());
                    avail += (mac.getAvailability() == null ? 0.0 : mac.getAvailability()) * (double)mac.getMemberCount();
                }
                AutoGroupComposite categoryComposite = new AutoGroupComposite(Double.valueOf(avail /= (double)count), parentResource, subCategory, (long)count);
                categoryComposite.setDepth(depth);
                fullComposites.add(categoryComposite);
            }
            if (subCategory.getChildSubCategories() != null) {
                this.calculateSubcategorySummary(parentResource, subCategory.getChildSubCategories(), resourceAutoGroups, depth + 1, fullComposites);
            }
            for (AutoGroupComposite match : matches) {
                if (!match.getResourceType().getSubCategory().equals((Object)subCategory)) continue;
                match.setDepth(depth + 1);
                fullComposites.add(match);
                resourceAutoGroups.remove(match);
            }
        }
    }

    @Override
    public PageList<Resource> findExplicitResourcesByResourceGroup(Subject user, ResourceGroup group, PageControl pageControl) {
        Query query;
        Query queryCount;
        pageControl.initDefaultOrderingField("res.name");
        if (this.authorizationManager.isInventoryManager(user)) {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findByExplicitResourceGroup_admin");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findByExplicitResourceGroup_admin", (PageControl)pageControl);
        } else {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findByExplicitResourceGroup");
            queryCount.setParameter("subject", (Object)user);
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findByExplicitResourceGroup", (PageControl)pageControl);
            query.setParameter("subject", (Object)user);
        }
        queryCount.setParameter("group", (Object)group);
        long count = (Long)queryCount.getSingleResult();
        query.setParameter("group", (Object)group);
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public List<Integer> findExplicitResourceIdsByResourceGroup(int resourceGroupId) {
        Query query = this.entityManager.createNamedQuery("Resource.findExplicitIdsByResourceGroup_admin");
        query.setParameter("groupId", (Object)resourceGroupId);
        List results = query.getResultList();
        return results;
    }

    @Override
    public List<Integer> findImplicitResourceIdsByResourceGroup(int resourceGroupId) {
        Query query = this.entityManager.createNamedQuery("Resource.findImplicitIdsByResourceGroup_admin");
        query.setParameter("groupId", (Object)resourceGroupId);
        List results = query.getResultList();
        return results;
    }

    @Override
    public List<ResourceIdFlyWeight> findFlyWeights(int[] resourceIds) {
        Object[] ids = ArrayUtils.wrapInArray((int[])resourceIds);
        if (ids.length == 0) {
            return new ArrayList<ResourceIdFlyWeight>();
        }
        ArrayList<ResourceIdFlyWeight> results = new ArrayList<ResourceIdFlyWeight>();
        Arrays.sort(ids);
        Query query = this.entityManager.createNamedQuery("Resource.findFlyWeights");
        for (int i = 0; i < ids.length; i += 1000) {
            Integer[] batchRange = (Integer[])ArrayUtils.copyOfRange((Object[])ids, (int)i, (int)(i + 1000));
            query.setParameter("resourceIds", Arrays.asList(batchRange));
            List batchResults = query.getResultList();
            results.addAll(batchResults);
        }
        return results;
    }

    @Override
    public PageList<Resource> findImplicitResourcesByResourceGroup(Subject user, ResourceGroup group, PageControl pageControl) {
        Query query;
        Query queryCount;
        pageControl.initDefaultOrderingField("res.name");
        if (this.authorizationManager.isInventoryManager(user)) {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findByImplicitResourceGroup_admin");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findByImplicitResourceGroup_admin", (PageControl)pageControl);
        } else {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findByImplicitResourceGroup");
            queryCount.setParameter("subject", (Object)user);
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findByImplicitResourceGroup", (PageControl)pageControl);
            query.setParameter("subject", (Object)user);
        }
        queryCount.setParameter("group", (Object)group);
        long count = (Long)queryCount.getSingleResult();
        query.setParameter("group", (Object)group);
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public PageList<ResourceWithAvailability> findExplicitResourceWithAvailabilityByResourceGroup(Subject subject, ResourceGroup group, PageControl pageControl) {
        Query query;
        Query queryCount;
        pageControl.initDefaultOrderingField("res.name");
        if (this.authorizationManager.isInventoryManager(subject)) {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ResourceWithAvailability.findExplicitByResourceGroup_count_admin");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ResourceWithAvailability.findExplicitByResourceGroup_admin", (PageControl)pageControl);
        } else {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ResourceWithAvailability.findExplicitByResourceGroup_count");
            queryCount.setParameter("subject", (Object)subject);
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ResourceWithAvailability.findExplicitByResourceGroup", (PageControl)pageControl);
            query.setParameter("subject", (Object)subject);
        }
        queryCount.setParameter("groupId", (Object)group.getId());
        long count = (Long)queryCount.getSingleResult();
        query.setParameter("groupId", (Object)group.getId());
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public PageList<ResourceWithAvailability> findImplicitResourceWithAvailabilityByResourceGroup(Subject subject, ResourceGroup group, PageControl pageControl) {
        Query query;
        Query queryCount;
        pageControl.initDefaultOrderingField("res.name");
        if (this.authorizationManager.isInventoryManager(subject)) {
            queryCount = this.entityManager.createNamedQuery("ResourceWithAvailability.findImplicitByResourceGroup_count_admin");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ResourceWithAvailability.findImplicitByResourceGroup_admin", (PageControl)pageControl);
        } else {
            queryCount = this.entityManager.createNamedQuery("ResourceWithAvailability.findImplicitByResourceGroup_count");
            queryCount.setParameter("subject", (Object)subject);
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ResourceWithAvailability.findImplicitByResourceGroup", (PageControl)pageControl);
            query.setParameter("subject", (Object)subject);
        }
        queryCount.setParameter("groupId", (Object)group.getId());
        long count = (Long)queryCount.getSingleResult();
        query.setParameter("groupId", (Object)group.getId());
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public PageList<ResourceHealthComposite> findResourceHealth(Subject user, int[] resourceIds, PageControl pc) {
        pc.initDefaultOrderingField("res.name");
        List resourceIdList = ArrayUtils.wrapInList((int[])resourceIds);
        if (resourceIdList == null || resourceIdList.size() == 0) {
            return new PageList(pc);
        }
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.getResourceHealthByIds");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.getResourceHealthByIds", (PageControl)pc);
        queryCount.setParameter("resourceIds", (Object)resourceIdList);
        query.setParameter("resourceIds", (Object)resourceIdList);
        long count = queryCount.getResultList().size();
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pc);
    }

    private void setImplicitMarkers(ResourceGroup group, List<ResourceWithAvailability> resources) {
        for (ResourceWithAvailability res : resources) {
            boolean explicitMember = false;
            for (ResourceGroup explicitGroup : res.getResource().getExplicitGroups()) {
                if (explicitGroup.getId() != group.getId()) continue;
                explicitMember = true;
                break;
            }
            res.setExplicit(explicitMember);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Resource> findAvailableResourcesForResourceGroup(Subject user, int groupId, ResourceType type, ResourceCategory category, String nameFilter, int[] excludeIds, PageControl pageControl) {
        Query query;
        Query queryCount;
        pageControl.initDefaultOrderingField("res.name");
        List excludeList = ArrayUtils.wrapInList((int[])excludeIds);
        if (excludeList != null && excludeList.size() != 0) {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.getAvailableResourcesForResourceGroupWithExcludes");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.getAvailableResourcesWithParentForResourceGroupWithExcludes", (PageControl)pageControl);
        } else {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.getAvailableResourcesForResourceGroup");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.getAvailableResourcesWithParentForResourceGroup", (PageControl)pageControl);
        }
        if (excludeList != null && excludeList.size() != 0) {
            queryCount.setParameter("excludeIds", (Object)excludeList);
            query.setParameter("excludeIds", (Object)excludeList);
        }
        nameFilter = QueryUtility.formatSearchParameter(nameFilter);
        queryCount.setParameter("groupId", (Object)groupId);
        query.setParameter("groupId", (Object)groupId);
        queryCount.setParameter("type", (Object)type);
        query.setParameter("type", (Object)type);
        queryCount.setParameter("category", (Object)category);
        query.setParameter("category", (Object)category);
        query.setParameter("search", (Object)nameFilter);
        queryCount.setParameter("search", (Object)nameFilter);
        query.setParameter("escapeChar", (Object)QueryUtility.getEscapeCharacter());
        queryCount.setParameter("escapeChar", (Object)QueryUtility.getEscapeCharacter());
        query.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        queryCount.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        long count = (Long)queryCount.getSingleResult();
        List resources = query.getResultList();
        return new PageList((Collection)resources, (int)count, pageControl);
    }

    @Override
    public PageList<Resource> findAvailableResourcesForRepo(Subject user, int repoId, String search, ResourceCategory category, PageControl pageControl) {
        pageControl.initDefaultOrderingField("res.name");
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.getAvailableResourcesForRepo");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.getAvailableResourcesForRepo", (PageControl)pageControl);
        queryCount.setParameter("repoId", (Object)repoId);
        query.setParameter("repoId", (Object)repoId);
        search = QueryUtility.formatSearchParameter(search);
        queryCount.setParameter("search", (Object)search);
        query.setParameter("search", (Object)search);
        query.setParameter("escapeChar", (Object)QueryUtility.getEscapeCharacter());
        queryCount.setParameter("escapeChar", (Object)QueryUtility.getEscapeCharacter());
        queryCount.setParameter("category", (Object)category);
        query.setParameter("category", (Object)category);
        query.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        queryCount.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        long count = (Long)queryCount.getSingleResult();
        List resources = query.getResultList();
        return new PageList((Collection)resources, (int)count, pageControl);
    }

    @Override
    public PageList<Resource> findAvailableResourcesForDashboardPortlet(Subject user, Integer typeId, ResourceCategory category, int[] excludeIds, PageControl pageControl) {
        Query query;
        Query queryCount;
        pageControl.initDefaultOrderingField("res.name");
        List excludeList = ArrayUtils.wrapInList((int[])excludeIds);
        if (excludeList != null && excludeList.size() != 0) {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.getAvailableResourcesForDashboardPortletWithExcludes");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.getAvailableResourcesForDashboardPortletWithExcludes", (PageControl)pageControl);
        } else {
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.getAvailableResourcesForDashboardPortlet");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.getAvailableResourcesForDashboardPortlet", (PageControl)pageControl);
        }
        if (excludeList != null && excludeList.size() != 0) {
            queryCount.setParameter("excludeIds", (Object)excludeList);
            query.setParameter("excludeIds", (Object)excludeList);
        }
        queryCount.setParameter("typeId", (Object)typeId);
        query.setParameter("typeId", (Object)typeId);
        queryCount.setParameter("category", (Object)category);
        query.setParameter("category", (Object)category);
        query.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        queryCount.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        long count = (Long)queryCount.getSingleResult();
        List resources = query.getResultList();
        return new PageList((Collection)resources, (int)count, pageControl);
    }

    @Override
    public PageList<Resource> findResourceByIds(Subject subject, int[] resourceIds, boolean attachParentResource, PageControl pageControl) {
        String queryCountName;
        String queryName;
        pageControl.initDefaultOrderingField("res.name");
        List idList = ArrayUtils.wrapInList((int[])resourceIds);
        if (idList == null || idList.size() == 0) {
            return new PageList((Collection)Collections.EMPTY_LIST, 0, pageControl);
        }
        if (this.authorizationManager.isInventoryManager(subject)) {
            queryName = attachParentResource ? "Resource.findWithParentByIds_admin" : "Resource.findByIds_admin";
            queryCountName = "Resource.findByIds_admin";
        } else {
            queryName = attachParentResource ? "Resource.findWithParentByIds" : "Resource.findByIds";
            queryCountName = "Resource.findByIds";
        }
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryCountName);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pageControl);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            queryCount.setParameter("subject", (Object)subject);
            query.setParameter("subject", (Object)subject);
        }
        queryCount.setParameter("ids", (Object)idList);
        query.setParameter("ids", (Object)idList);
        long count = (Long)queryCount.getSingleResult();
        List resources = query.getResultList();
        return new PageList((Collection)resources, (int)count, pageControl);
    }

    @Override
    public Resource getResourceTree(int rootResourceId, boolean recursive) {
        Subject overlord = this.subjectManager.getOverlord();
        Resource root = this.getResourceById(overlord, rootResourceId);
        if (root != null) {
            this.prefetchResource(root, recursive);
            if (root.getParentResource() != null) {
                root.getParentResource().getId();
            }
        }
        return root;
    }

    @Override
    @NotNull
    public List<ResourceError> findResourceErrors(Subject user, int resourceId, ResourceErrorType errorType) {
        if (!this.authorizationManager.canViewResource(user, resourceId)) {
            throw new PermissionException("User [" + user + "] does not have permission to view resource [" + resourceId + "]");
        }
        Query query = this.entityManager.createNamedQuery("ResourceError.findByResourceAndErrorType");
        query.setParameter("resourceId", (Object)resourceId);
        query.setParameter("errorType", (Object)errorType);
        return query.getResultList();
    }

    @Override
    @NotNull
    public List<ResourceError> findResourceErrors(Subject user, int resourceId) {
        if (!this.authorizationManager.canViewResource(user, resourceId)) {
            throw new PermissionException("User [" + user + "] does not have permission to view resource [" + resourceId + "]");
        }
        Query query = this.entityManager.createNamedQuery("ResourceError.findByResource");
        query.setParameter("resourceId", (Object)resourceId);
        return query.getResultList();
    }

    @Override
    public void addResourceError(ResourceError resourceError) {
        ResourceErrorType resourceErrorType = resourceError.getErrorType();
        if (resourceErrorType == ResourceErrorType.INVALID_PLUGIN_CONFIGURATION || resourceErrorType == ResourceErrorType.AVAILABILITY_CHECK || resourceErrorType == ResourceErrorType.UPGRADE) {
            Subject overlord = this.subjectManager.getOverlord();
            int resourceId = resourceError.getResource().getId();
            this.resourceManager.clearResourceConfigErrorByType(overlord, resourceId, resourceErrorType);
        }
        this.entityManager.persist((Object)resourceError);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public int clearResourceConfigErrorByType(Subject subject, int resourceId, ResourceErrorType resourceErrorType) {
        if (!this.authorizationManager.canViewResource(subject, resourceId)) {
            throw new PermissionException("Cannot delete resource errors of type [" + resourceErrorType + "]. User [" + subject.getName() + "] does not have permission to operate on resource ID [" + resourceId + "].");
        }
        Query q = this.entityManager.createQuery("DELETE FROM ResourceError e WHERE e.resource.id = :resourceId AND e.errorType = :type");
        q.setParameter("resourceId", (Object)resourceId);
        q.setParameter("type", (Object)resourceErrorType);
        int updates = q.executeUpdate();
        return updates;
    }

    @Override
    public void clearResourceConfigError(int resourceId) {
        Subject s = this.subjectManager.getOverlord();
        int cleared = this.clearResourceConfigErrorByType(s, resourceId, ResourceErrorType.INVALID_PLUGIN_CONFIGURATION);
        if (cleared > 1) {
            this.log.warn((Object)("Resource [" + resourceId + "] had [" + cleared + "] INVALID_PLUGIN_CONFIGURATION ResourceErrors associated with it."));
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void deleteResourceError(Subject user, int resourceErrorId) {
        ResourceError error = (ResourceError)this.entityManager.find(ResourceError.class, (Object)resourceErrorId);
        if (error != null) {
            if (!this.authorizationManager.hasResourcePermission(user, Permission.MODIFY_RESOURCE, error.getResource().getId())) {
                throw new PermissionException("Cannot delete Resource error [" + resourceErrorId + "]. User [" + user + "] does not have permission to modify Resource [" + error.getResource().getName() + "].");
            }
            this.entityManager.remove((Object)error);
        }
    }

    @Override
    public Map<Integer, InventoryStatus> getResourceStatuses(int rootResourceId, boolean descendents) {
        Resource root = (Resource)this.entityManager.find(Resource.class, (Object)rootResourceId);
        LinkedHashMap<Integer, InventoryStatus> statuses = new LinkedHashMap<Integer, InventoryStatus>();
        statuses.put(root.getId(), root.getInventoryStatus());
        this.getResourceStatuses(rootResourceId, descendents, statuses);
        return statuses;
    }

    @Override
    public Resource getPlatform(Agent agent) {
        Query query = this.entityManager.createNamedQuery("Resource.findPlatformByAgent");
        query.setParameter("category", (Object)ResourceCategory.PLATFORM);
        query.setParameter("agent", (Object)agent);
        try {
            Resource platform = (Resource)query.getSingleResult();
            return platform;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public ResourceAvailabilitySummary getAvailabilitySummary(Subject user, int resourceId) {
        if (!this.authorizationManager.canViewResource(user, resourceId)) {
            throw new PermissionException("Cannot view resource availability. User [" + user + "] does not have permission to view the resource [" + resourceId + "].");
        }
        Query query = this.entityManager.createNamedQuery("Availability.findByResource");
        query.setParameter("resourceId", (Object)resourceId);
        List availabilities = query.getResultList();
        long upTime = 0L;
        long downTime = 0L;
        int failures = 0;
        long lastChange = 0L;
        AvailabilityType current = null;
        for (Availability avail : availabilities) {
            if (avail.getAvailabilityType() == AvailabilityType.UP) {
                upTime += (avail.getEndTime() != null ? avail.getEndTime().getTime() : System.currentTimeMillis()) - avail.getStartTime().getTime();
            } else {
                downTime += (avail.getEndTime() != null ? avail.getEndTime().getTime() : System.currentTimeMillis()) - avail.getStartTime().getTime();
                ++failures;
            }
            if (avail.getEndTime() != null) continue;
            lastChange = avail.getStartTime().getTime();
            current = avail.getAvailabilityType();
        }
        return new ResourceAvailabilitySummary(upTime, downTime, failures, lastChange, current);
    }

    @Override
    public List<ResourceFlyweight> findResourcesByAgent(Subject user, int agentId, PageControl unlimitedInstance) {
        String reportingQueryString = "    SELECT res.id, res.uuid, res.name, res.resourceKey,            parent.id, parent.name,            currentAvail.availabilityType,            type.id, type.name, type.plugin, type.singleton, type.category,            subCategory.id, subCategory.name,            parentSubCategory.id, parentSubCategory.name       FROM Resource res       JOIN res.currentAvailability currentAvail       JOIN res.resourceType type  LEFT JOIN type.subCategory subCategory  LEFT JOIN subCategory.parentSubCategory parentSubCategory  LEFT JOIN res.parentResource parent      WHERE res.inventoryStatus = :inventoryStatus        AND res.agent.id = :agentId";
        Query reportingQuery = this.entityManager.createQuery(reportingQueryString);
        reportingQuery.setParameter("agentId", (Object)agentId);
        reportingQuery.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        List reportingQueryResults = reportingQuery.getResultList();
        List<ResourceFlyweight> resources = this.getFlyWeightObjectGraphFromReportingQueryResults(reportingQueryResults);
        if (!this.authorizationManager.isInventoryManager(user)) {
            String authorizationQueryString = "SELECT res.id   FROM Resource res  WHERE res.inventoryStatus = :inventoryStatus    AND res.agent.id = :agentId    AND res.id IN ( SELECT rr.id                      FROM Resource rr                      JOIN rr.implicitGroups g                      JOIN g.roles r                      JOIN r.subjects s                     WHERE s = :subject)";
            Query authorizationQuery = this.entityManager.createQuery(authorizationQueryString);
            authorizationQuery.setParameter("agentId", (Object)agentId);
            authorizationQuery.setParameter("subject", (Object)user);
            authorizationQuery.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
            List visibleResources = authorizationQuery.getResultList();
            HashSet visibleIdSet = new HashSet(visibleResources);
            ListIterator<ResourceFlyweight> iter = resources.listIterator();
            while (iter.hasNext()) {
                ResourceFlyweight res;
                res.setLocked(!visibleIdSet.contains((res = iter.next()).getId()));
            }
        }
        return resources;
    }

    private List<ResourceFlyweight> getFlyWeightObjectGraphFromReportingQueryResults(List<Object[]> reportQueryResults) {
        ArrayList<ResourceFlyweight> resources = new ArrayList<ResourceFlyweight>();
        FlyweightCache flyweightCache = new FlyweightCache();
        for (Object[] prefetched : reportQueryResults) {
            int i = 0;
            Integer resourceId = (Integer)prefetched[i++];
            String resourceUuid = (String)prefetched[i++];
            String resourceName = (String)prefetched[i++];
            String resourceKey = (String)prefetched[i++];
            Integer parentId = (Integer)prefetched[i++];
            String parentName = (String)prefetched[i++];
            AvailabilityType availType = (AvailabilityType)prefetched[i++];
            Integer typeId = (Integer)prefetched[i++];
            String typeName = (String)prefetched[i++];
            String typePlugin = (String)prefetched[i++];
            Boolean typeSingleton = (Boolean)prefetched[i++];
            ResourceCategory typeCategory = (ResourceCategory)prefetched[i++];
            Integer subCategoryId = (Integer)prefetched[i++];
            String subCategoryName = (String)prefetched[i++];
            Integer parentSubCategoryId = (Integer)prefetched[i++];
            String parentSubCategoryName = (String)prefetched[i++];
            if (subCategoryId != null) {
                flyweightCache.constructSubCategory(subCategoryId.intValue(), subCategoryName, parentSubCategoryId, parentSubCategoryName);
            }
            flyweightCache.constructResourceType(typeId.intValue(), typeName, typePlugin, typeSingleton.booleanValue(), typeCategory, subCategoryId);
            ResourceFlyweight resourceFlyweight = flyweightCache.constructResource(resourceId.intValue(), resourceName, resourceUuid, resourceKey, parentId, typeId.intValue(), availType);
            resources.add(resourceFlyweight);
        }
        return resources;
    }

    @Override
    public List<ResourceFlyweight> findResourcesByCompatibleGroup(Subject user, int compatibleGroupId, PageControl pageControl) {
        String reportingQueryString = "    SELECT res.id, res.uuid, res.name, res.resourceKey,            parent.id, parent.name,            currentAvail.availabilityType,            type.id, type.name, type.plugin, type.singleton, type.category,            subCategory.id, subCategory.name,            parentSubCategory.id, parentSubCategory.name       FROM Resource res       JOIN res.implicitGroups g       JOIN res.currentAvailability currentAvail       JOIN res.resourceType type  LEFT JOIN type.subCategory subCategory  LEFT JOIN subCategory.parentSubCategory parentSubCategory  LEFT JOIN res.parentResource parent      WHERE res.inventoryStatus = :inventoryStatus        AND g.id = :groupId";
        Query reportingQuery = this.entityManager.createQuery(reportingQueryString);
        reportingQuery.setParameter("groupId", (Object)compatibleGroupId);
        reportingQuery.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        List reportingQueryResults = reportingQuery.getResultList();
        List<ResourceFlyweight> resources = this.getFlyWeightObjectGraphFromReportingQueryResults(reportingQueryResults);
        return resources;
    }

    private void getResourceStatuses(int parentResourceId, boolean descendents, Map<Integer, InventoryStatus> statuses) {
        Query query = this.entityManager.createNamedQuery("Resource.getStatusesByParent");
        query.setParameter("parentResourceId", (Object)parentResourceId);
        for (Object[] is : query.getResultList()) {
            statuses.put((Integer)is[0], (InventoryStatus)is[1]);
            if (!descendents) continue;
            this.getResourceStatuses((Integer)is[0], descendents, statuses);
        }
    }

    private void prefetchResource(Resource resource, boolean recursive) {
        if (resource == null) {
            return;
        }
        resource.getId();
        resource.getPluginConfiguration().getNotes();
        this.prefetchResource(resource.getParentResource(), false);
        if (recursive) {
            for (Resource child : resource.getChildResources()) {
                this.prefetchResource(child, recursive);
            }
        }
    }

    @Override
    public Resource getResource(Subject subject, int resourceId) {
        return this.getResourceById(subject, resourceId);
    }

    @Override
    public ResourceAvailability getLiveResourceAvailability(Subject subject, int resourceId) {
        Resource res = this.getResourceById(subject, resourceId);
        ResourceAvailability results = new ResourceAvailability(res, null);
        try {
            Agent agent = res.getAgent();
            if (agent == null) {
                throw new IllegalStateException("No agent is associated with the resource with id [" + resourceId + "]");
            }
            AgentClient client = this.agentManager.getAgentClient(agent);
            boolean agentPing = client.ping(5000L);
            if (agentPing) {
                Resource bareResource = new Resource(res.getResourceKey(), res.getName(), res.getResourceType());
                bareResource.setId(res.getId());
                bareResource.setUuid(res.getUuid());
                Availability avail = client.getDiscoveryAgentService().getCurrentAvailability(bareResource);
                if (avail != null) {
                    results.setAvailabilityType(avail.getAvailabilityType());
                }
            }
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        return results;
    }

    @Override
    @XmlJavaTypeAdapter(value=ResourceListAdapter.class)
    public List<Resource> findResourceLineage(Subject subject, int resourceId) {
        List<Resource> result = this.getResourceLineage(resourceId);
        for (Resource resource : result) {
            if (this.authorizationManager.canViewResource(subject, resource.getId())) continue;
            throw new PermissionException("User [" + subject + "] does not have permission to view resource [" + resource.getId() + "]");
        }
        return result;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public List<ResourceInstallCount> findResourceInstallCounts(Subject subject, boolean groupByVersions) {
        String queryName = groupByVersions ? "Resource.findResourceVersionReport" : "Resource.findResourceReport";
        Query query = this.entityManager.createNamedQuery(queryName);
        List results = query.getResultList();
        return results;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public List<ResourceInstallCount> findResourceComplianceCounts(Subject subject) {
        Query query = null;
        List results = null;
        query = this.entityManager.createNamedQuery("Resource.findResourceVersionDriftInCompliance");
        results = query.getResultList();
        query = this.entityManager.createNamedQuery("Resource.findResourceVersionDriftOutOfCompliance");
        results.addAll(query.getResultList());
        return results;
    }

    @Override
    public PageList<ResourceComposite> findResourceCompositesByCriteria(Subject subject, ResourceCriteria criteria) {
        String compositeProjection;
        boolean isInventoryManager = this.authorizationManager.isInventoryManager(subject);
        if (isInventoryManager) {
            compositeProjection = "new org.rhq.core.domain.resource.composite.ResourceComposite(   %alias%,    %alias%.currentAvailability.availabilityType ) ";
        } else {
            compositeProjection = " new org.rhq.core.domain.resource.composite.ResourceComposite(   %alias%,    %alias%.currentAvailability.availabilityType,    ( SELECT count(p) FROM %alias%.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 8 ),    ( SELECT count(p) FROM %alias%.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 4 ),    ( SELECT count(p) FROM %alias%.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 10 ),    ( SELECT count(p) FROM %alias%.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 7 ),    ( SELECT count(p) FROM %alias%.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 14 ),    ( SELECT count(p) FROM %alias%.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 13 ),    ( SELECT count(p) FROM %alias%.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 11 ),    ( SELECT count(p) FROM %alias%.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 9 ),    ( SELECT count(p) FROM %alias%.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 6 ),    ( SELECT count(p) FROM %alias%.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 5 ),    ( SELECT count(p) FROM %alias%.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 16 ))";
            compositeProjection = compositeProjection.replace("%subjectId%", String.valueOf(subject.getId()));
        }
        compositeProjection = compositeProjection.replace("%alias%", criteria.getAlias());
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        generator.alterProjection(compositeProjection);
        if (!isInventoryManager) {
            if (criteria.isInventoryManagerRequired()) {
                throw new PermissionException("Subject [" + subject.getName() + "] requires InventoryManager permission for requested query criteria.");
            }
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, null, subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager, false);
        PageList results = queryRunner.execute();
        for (ResourceComposite nextComposite : results) {
            Resource nextResource = nextComposite.getResource();
            ResourceType nextResourceType = nextResource.getResourceType();
            ResourceFacets facets = this.typeManager.getResourceFacets(nextResourceType.getId());
            queryRunner.initFetchFields(nextResource);
            nextComposite.setResourceFacets(facets);
        }
        return results;
    }

    @Override
    public PageList<Resource> findResourcesByCriteria(Subject subject, ResourceCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            if (criteria.isInventoryManagerRequired()) {
                throw new PermissionException("Subject [" + subject.getName() + "] requires InventoryManager permission for requested query criteria.");
            }
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, null, subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        PageList results = queryRunner.execute();
        return results;
    }

    @Override
    public Resource getPlaformOfResource(Subject subject, int resourceId) {
        Resource resource = null;
        Resource parent = null;
        do {
            if ((resource = parent) != null) {
                resourceId = parent.getId();
            }
            if ((parent = this.getParentResource(resourceId)) == null) break;
            if (!parent.getResourceType().getCategory().equals((Object)ResourceCategory.PLATFORM)) continue;
            resource = parent;
            parent = null;
            break;
        } while (parent != null);
        if (resource != null && !this.authorizationManager.canViewResource(subject, resource.getId())) {
            throw new PermissionException("User [" + subject + "] does not have permission to view resource [" + resource.getId() + "]");
        }
        return resource;
    }

    @Override
    public Resource getParentResource(Subject subject, int resourceId) {
        Resource resource = this.getParentResource(resourceId);
        if (!this.authorizationManager.canViewResource(subject, resource.getId())) {
            throw new PermissionException("User [" + subject + "] does not have permission to view resource [" + resource.getId() + "]");
        }
        return resource;
    }

    @Override
    public PageList<Resource> findChildResources(Subject subject, int parentResourceId, PageControl pageControl) {
        Resource parentResource = this.getResourceById(subject, parentResourceId);
        return this.findChildResources(subject, parentResource, pageControl);
    }

    @Override
    public <T> List<DisambiguationReport<T>> disambiguate(List<T> results, IntExtractor<? super T> extractor, DisambiguationUpdateStrategy updateStrategy) {
        return Disambiguator.disambiguate(results, updateStrategy, extractor, this.entityManager, this.typeManager.getDuplicateTypeNames());
    }

    @Override
    public void updateAncestry(Subject subject, int resourceId) {
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (null == resource) {
            throw new ResourceNotFoundException(resourceId);
        }
        this.updateAncestry(resource);
    }

    private void updateAncestry(Resource resource) {
        resource.updateAncestryForResource();
        for (Resource child : resource.getChildResources()) {
            child.setParentResource(resource);
            this.updateAncestry(child);
        }
    }

    @Override
    public List<Integer> findIdsByTypeIds(List<Integer> resourceTypeIds) {
        return this.entityManager.createNamedQuery("Resource.findIDsByType").setParameter("resourceTypeIds", resourceTypeIds).getResultList();
    }

    @Override
    public Integer getResourceCount(List<Integer> resourceTypeIds) {
        return (Integer)this.entityManager.createNamedQuery("Resource.findCountByTypes").setParameter("resourceTypeIds", resourceTypeIds).getSingleResult();
    }
}

