/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.util.Collection;
import java.util.List;
import javax.ejb.Local;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.rhq.enterprise.server.rest.domain.Baseline;
import org.rhq.enterprise.server.rest.domain.MetricAggregate;
import org.rhq.enterprise.server.rest.domain.MetricSchedule;
import org.rhq.enterprise.server.rest.domain.NumericDataPoint;
import org.rhq.enterprise.server.rest.domain.StringValue;

@Produces(value={"application/json", "application/xml", "text/html"})
@Path(value="/metric")
@Local
public interface MetricHandlerLocal {
    @GET
    @Path(value="data/{scheduleId}")
    @Produces(value={"application/json", "application/xml", "text/html"})
    public Response getMetricData(@PathParam(value="scheduleId") int var1, @QueryParam(value="startTime") long var2, @QueryParam(value="endTime") long var4, @QueryParam(value="dataPoints") @DefaultValue(value="60") int var6, @QueryParam(value="hideEmpty") boolean var7, @Context Request var8, @Context HttpHeaders var9);

    @GET
    @Path(value="data")
    @Produces(value={"application/json", "application/xml", "text/html"})
    public Response getMetricDataMulti(@QueryParam(value="sid") String var1, @QueryParam(value="startTime") long var2, @QueryParam(value="endTime") long var4, @QueryParam(value="dataPoints") int var6, @QueryParam(value="hideEmpty") boolean var7, @Context Request var8, @Context HttpHeaders var9);

    @GET
    @Path(value="data/resource/{resourceId}")
    public List<MetricAggregate> getAggregatesForResource(@PathParam(value="resourceId") int var1);

    @GET
    @Path(value="/schedule/{id}")
    @Produces(value={"application/json", "application/xml", "text/html"})
    public Response getSchedule(@PathParam(value="id") int var1, @Context Request var2, @Context HttpHeaders var3, @Context UriInfo var4);

    @PUT
    @Path(value="/schedule/{id}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response updateSchedule(@PathParam(value="id") int var1, MetricSchedule var2, @Context HttpHeaders var3);

    @GET
    @Path(value="data/{scheduleId}/raw")
    @Produces(value={"application/json", "application/xml", "text/csv", "text/html"})
    public StreamingOutput getMetricDataRaw(@PathParam(value="scheduleId") int var1, @QueryParam(value="startTime") long var2, @QueryParam(value="endTime") long var4, @QueryParam(value="duration") long var6, @Context Request var8, @Context HttpHeaders var9);

    @PUT
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="data/{scheduleId}/raw/{timeStamp}")
    public Response putMetricValue(@PathParam(value="scheduleId") int var1, @PathParam(value="timeStamp") long var2, NumericDataPoint var4, @Context HttpHeaders var5, @Context UriInfo var6);

    @POST
    @Path(value="data/raw")
    @Consumes(value={"application/json", "application/xml"})
    public Response postMetricValues(Collection<NumericDataPoint> var1, @Context HttpHeaders var2);

    @GET
    @Path(value="data/{scheduleId}/baseline")
    @Produces(value={"application/json", "application/xml"})
    public Baseline getBaseline(@PathParam(value="scheduleId") int var1, @Context HttpHeaders var2, @Context UriInfo var3);

    @PUT
    @Path(value="data/{scheduleId}/baseline")
    @Consumes(value={"application/json", "application/xml"})
    public void setBaseline(@PathParam(value="scheduleId") int var1, Baseline var2, @Context HttpHeaders var3, @Context UriInfo var4);

    @PUT
    @Path(value="data/{scheduleId}/trait")
    @Consumes(value={"application/json", "application/xml"})
    public Response putTraitValue(@PathParam(value="scheduleId") int var1, StringValue var2);

    @GET
    @Path(value="data/{scheduleId}/trait")
    @Produces(value={"application/json", "application/xml"})
    public Response getTraitValue(@PathParam(value="scheduleId") int var1);
}

