/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.security.Principal;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.EJBContext;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.auth.SessionManager;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;

public class SetCallerInterceptor {
    @Resource
    EJBContext ejbContext;
    @EJB
    SubjectManagerLocal subjectManager;
    private SessionManager sessionManager = SessionManager.getInstance();

    @AroundInvoke
    public Object setCaller(InvocationContext ctx) throws Exception {
        Subject caller = null;
        Principal p = this.ejbContext.getCallerPrincipal();
        if (p != null) {
            caller = this.subjectManager.getSubjectByName(p.getName());
        }
        if (caller == null) {
            throw new IllegalAccessException("No calling principal provided");
        }
        caller = this.sessionManager.put(caller);
        AbstractRestBean target = (AbstractRestBean)ctx.getTarget();
        target.caller = caller;
        Object result = ctx.proceed();
        this.sessionManager.invalidate(caller.getSessionId());
        return result;
    }
}

