/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.auth.prefs;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.common.EntityManagerFacadeLocal;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class SubjectPreferencesCache {
    protected final Log log = LogFactory.getLog(SubjectPreferencesCache.class);
    private Map<Integer, Configuration> subjectPreferences = new HashMap<Integer, Configuration>();
    private static final SubjectPreferencesCache instance = new SubjectPreferencesCache();
    private SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
    private EntityManagerFacadeLocal entityManagerFacade = LookupUtil.getEntityManagerFacade();
    private ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();

    private SubjectPreferencesCache() {
    }

    public static SubjectPreferencesCache getInstance() {
        return instance;
    }

    private void load(int subjectId) {
        if (subjectId != 0 && !this.subjectPreferences.containsKey(subjectId)) {
            try {
                Subject subject = this.subjectManager.loadUserConfiguration(subjectId);
                Configuration configuration = subject.getUserConfiguration();
                this.subjectPreferences.put(subjectId, configuration);
            }
            catch (Throwable t) {
                this.log.warn((Object)("Can not get preferences for subject[id=" + subjectId + "], subject does not exist yet"));
            }
        }
    }

    public synchronized PropertySimple getUserProperty(int subjectId, String propertyName) {
        this.load(subjectId);
        Configuration config = this.subjectPreferences.get(subjectId);
        if (config == null) {
            return null;
        }
        PropertySimple prop = config.getSimple(propertyName);
        if (prop == null) {
            return null;
        }
        return new PropertySimple(propertyName, (Object)prop.getStringValue());
    }

    public synchronized void setUserProperty(int subjectId, String propertyName, String value) {
        this.load(subjectId);
        Configuration config = this.subjectPreferences.get(subjectId);
        if (config == null) {
            return;
        }
        PropertySimple prop = config.getSimple(propertyName);
        if (prop == null) {
            prop = new PropertySimple(propertyName, (Object)value);
            config.put((Property)prop);
            this.mergeProperty(prop);
        } else if (prop.getStringValue() == null || !prop.getStringValue().equals(value)) {
            prop.setStringValue(value);
            this.mergeProperty(prop);
        }
    }

    private void mergeProperty(PropertySimple prop) {
        PropertySimple mergedProperty = this.entityManagerFacade.merge(prop);
        if (prop.getId() == 0) {
            prop.setId(mergedProperty.getId());
        }
    }

    public synchronized void unsetUserProperty(int subjectId, String propertyName) {
        this.load(subjectId);
        Configuration config = this.subjectPreferences.get(subjectId);
        if (config == null) {
            return;
        }
        Property property = config.remove(propertyName);
        if (property != null && property.getId() != 0) {
            try {
                this.configurationManager.deleteProperties(new int[]{property.getId()});
            }
            catch (Throwable t) {
                this.log.error((Object)("Could not remove " + property), t);
            }
        }
    }

    public synchronized Configuration getPreferences(int subjectId) {
        this.load(subjectId);
        Configuration config = this.subjectPreferences.get(subjectId);
        if (config == null) {
            return new Configuration();
        }
        return config.deepCopy();
    }

    public synchronized void clearConfiguration(int subjectId) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Removing PreferencesCache For " + subjectId));
        }
        this.subjectPreferences.remove(subjectId);
    }
}

