/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.plugin;

import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.clientapi.descriptor.AgentPluginDescriptorUtil;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.file.FileUtil;
import org.rhq.enterprise.server.core.plugin.AgentPluginScanner;
import org.rhq.enterprise.server.core.plugin.PluginDeploymentScannerMBean;
import org.rhq.enterprise.server.core.plugin.ServerPluginScanner;
import org.rhq.enterprise.server.util.LoggingThreadFactory;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorUtil;

public class PluginDeploymentScanner
implements PluginDeploymentScannerMBean {
    private Log log = LogFactory.getLog(PluginDeploymentScanner.class);
    private long scanPeriod = 300000L;
    private ScheduledExecutorService poller;
    private File userPluginDir = null;
    private AgentPluginScanner agentPluginScanner = new AgentPluginScanner();
    private ServerPluginScanner serverPluginScanner = new ServerPluginScanner();

    @Override
    @NotNull
    public Long getScanPeriod() {
        return this.scanPeriod;
    }

    @Override
    public void setScanPeriod(@Nullable Long ms) {
        this.scanPeriod = ms != null ? ms : 300000L;
    }

    @Override
    public File getUserPluginDir() {
        return this.userPluginDir;
    }

    @Override
    public void setUserPluginDir(File dir) {
        this.userPluginDir = dir;
    }

    @Override
    public File getServerPluginDir() {
        return this.serverPluginScanner.getServerPluginDir();
    }

    @Override
    public void setServerPluginDir(File dir) {
        this.serverPluginScanner.setServerPluginDir(dir);
    }

    @Override
    public File getAgentPluginDir() {
        return this.agentPluginScanner.getAgentPluginDeployer().getPluginDir();
    }

    @Override
    public void setAgentPluginDir(File dir) {
        this.agentPluginScanner.getAgentPluginDeployer().setPluginDir(dir);
    }

    @Override
    public PluginMetadataManager getPluginMetadataManager() {
        return this.agentPluginScanner.getAgentPluginDeployer().getPluginMetadataManager();
    }

    @Override
    public void start() throws Exception {
        this.agentPluginScanner.fixMissingAgentPluginContent();
        this.agentPluginScanner.getAgentPluginDeployer().start();
        this.shutdownPoller();
        this.poller = Executors.newSingleThreadScheduledExecutor(new LoggingThreadFactory("PluginScanner", true));
    }

    @Override
    public void stop() {
        this.agentPluginScanner.getAgentPluginDeployer().stop();
        this.shutdownPoller();
    }

    private void shutdownPoller() {
        if (this.poller != null) {
            this.poller.shutdownNow();
            this.poller = null;
        }
    }

    @Override
    public void startDeployment() {
        this.agentPluginScanner.getAgentPluginDeployer().startDeployment();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        PluginDeploymentScanner.this.scanAndRegister();
                    }
                    catch (Throwable t) {
                        PluginDeploymentScanner.this.log.error((Object)("Scan failed. Cause: " + ThrowableUtil.getAllMessages((Throwable)t)));
                        if (!PluginDeploymentScanner.this.log.isDebugEnabled()) break block2;
                        PluginDeploymentScanner.this.log.debug((Object)"Scan failure stack trace follows:", t);
                    }
                }
            }
        };
        runnable.run();
        this.poller.scheduleWithFixedDelay(runnable, this.scanPeriod, this.scanPeriod, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void scan() throws Exception {
        this.scanUserDirectory();
        this.agentPluginScanner.agentPluginScan();
        this.serverPluginScanner.serverPluginScan();
    }

    @Override
    public synchronized void scanAndRegister() throws Exception {
        this.scan();
        this.agentPluginScanner.registerAgentPlugins();
        this.serverPluginScanner.registerServerPlugins();
    }

    private void scanUserDirectory() {
        File userDir = this.getUserPluginDir();
        if (userDir == null || !userDir.isDirectory()) {
            return;
        }
        File[] listFiles = userDir.listFiles();
        if (listFiles == null || listFiles.length == 0) {
            return;
        }
        for (File file : listFiles) {
            File destinationDirectory;
            if (!file.getName().endsWith(".jar")) continue;
            try {
                if (null == AgentPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)file.toURI().toURL())) {
                    throw new NullPointerException("no xml descriptor found in jar");
                }
                destinationDirectory = this.getAgentPluginDir();
            }
            catch (Exception e) {
                try {
                    this.log.debug((Object)("[" + file.getAbsolutePath() + "] is not an agent plugin jar (Cause: " + ThrowableUtil.getAllMessages((Throwable)e) + "). Will see if its a server plugin jar"));
                    if (null == ServerPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)file.toURI().toURL())) {
                        throw new NullPointerException("no xml descriptor found in jar");
                    }
                    destinationDirectory = this.getServerPluginDir();
                }
                catch (Exception e1) {
                    File fixmeFile = new File(file.getAbsolutePath() + ".fixme");
                    boolean renamed = file.renameTo(fixmeFile);
                    this.log.warn((Object)("Does not look like [" + (renamed ? fixmeFile : file).getAbsolutePath() + "] is a plugin jar -(Cause: " + ThrowableUtil.getAllMessages((Throwable)e1) + "). It will be ignored. Please fix that file or remove it."));
                    continue;
                }
            }
            try {
                boolean deleted;
                String fileMd5 = MessageDigestGenerator.getDigestString((File)file);
                File realPluginFile = new File(destinationDirectory, file.getName());
                String realPluginFileMd5 = null;
                if (realPluginFile.exists()) {
                    realPluginFileMd5 = MessageDigestGenerator.getDigestString((File)realPluginFile);
                }
                if (!fileMd5.equals(realPluginFileMd5) && file.lastModified() > realPluginFile.lastModified()) {
                    FileUtil.copyFile((File)file, (File)realPluginFile);
                    boolean succeeded = realPluginFile.setLastModified(file.lastModified());
                    if (!succeeded) {
                        this.log.error((Object)("Failed to set mtime to [" + new Date(file.lastModified()) + "] on file [" + realPluginFile + "]."));
                    }
                    this.log.info((Object)("Found plugin jar at [" + file.getAbsolutePath() + "] and placed it at [" + realPluginFile.getAbsolutePath() + "]"));
                }
                if (deleted = file.delete()) continue;
                this.log.info((Object)("The plugin jar found at[" + file.getAbsolutePath() + "] has been processed and can be deleted. It failed to get deleted, " + "so it may get processed again. You should delete it manually now."));
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to process plugin [" + file.getAbsolutePath() + "], ignoring it"), (Throwable)e);
            }
        }
    }
}

