/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.event;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.H2DatabaseType;
import org.rhq.core.db.OracleDatabaseType;
import org.rhq.core.db.PostgresqlDatabaseType;
import org.rhq.core.db.SQLServerDatabaseType;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.EventCriteria;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.event.EventSource;
import org.rhq.core.domain.event.composite.EventComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheManagerLocal;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheStats;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.event.EventException;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.event.EventManagerRemote;
import org.rhq.enterprise.server.measurement.instrumentation.MeasurementMonitor;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

@Stateless
@Resource(name="RHQ_DS", mappedName="java:/RHQDS")
public class EventManagerBean
implements EventManagerLocal,
EventManagerRemote {
    private static final String EVENT_SOURCE_INSERT_STMT = "INSERT INTO RHQ_Event_Source (id, event_def_id, resource_id, location) SELECT %s, (SELECT id FROM RHQ_Event_Def WHERE name = ? AND resource_type_id = (SELECT id FROM RHQ_Resource_Type WHERE name = ? AND plugin = ?)), ?, ? FROM RHQ_Numbers WHERE i = 42 AND NOT EXISTS (SELECT * FROM RHQ_Event_Source WHERE event_def_id = (SELECT id FROM RHQ_Event_Def WHERE name = ? AND resource_type_id = (SELECT id FROM RHQ_Resource_Type WHERE name = ? AND plugin = ?)) AND resource_id = ? AND location = ?)";
    private static final String EVENT_SOURCE_INSERT_STMT_AUTOINC = "INSERT INTO RHQ_Event_Source (event_def_id, resource_id, location) SELECT (SELECT id FROM RHQ_Event_Def WHERE name = ? AND resource_type_id = (SELECT id FROM RHQ_Resource_Type WHERE name = ? AND plugin = ?)), ?, ? FROM RHQ_Numbers WHERE i = 42 AND NOT EXISTS (SELECT * FROM RHQ_Event_Source WHERE event_def_id = (SELECT id FROM RHQ_Event_Def WHERE name = ? AND resource_type_id = (SELECT id FROM RHQ_Resource_Type WHERE name = ? AND plugin = ?)) AND resource_id = ? AND location = ?)";
    private static final String EVENT_INSERT_STMT = "INSERT INTO RHQ_Event (id, event_source_id, timestamp, severity, detail) VALUES (%s, (SELECT id FROM RHQ_Event_Source WHERE event_def_id = (SELECT id FROM RHQ_Event_Def WHERE name = ? AND resource_type_id = (SELECT id FROM RHQ_Resource_Type WHERE name = ? AND plugin = ?)) AND resource_id = ? AND location = ?), ?, ?, ?)";
    private static final String EVENT_INSERT_STMT_AUTOINC = "INSERT INTO RHQ_Event (event_source_id, timestamp, severity, detail) VALUES ((SELECT id FROM RHQ_Event_Source WHERE event_def_id = (SELECT id FROM RHQ_Event_Def WHERE name = ? AND resource_type_id = (SELECT id FROM RHQ_Resource_Type WHERE name = ? AND plugin = ?)) AND resource_id = ? AND location = ?), ?, ?, ?)";
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS")
    private DataSource rhqDs;
    @EJB
    private AlertConditionCacheManagerLocal alertConditionCacheManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    Log log = LogFactory.getLog(EventManagerBean.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventData(Map<EventSource, Set<Event>> events) {
        if (events == null || events.size() == 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String statementSql;
            String nextvalSql;
            conn = this.rhqDs.getConnection();
            DatabaseType dbType = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            if (dbType instanceof PostgresqlDatabaseType || dbType instanceof OracleDatabaseType || dbType instanceof H2DatabaseType) {
                nextvalSql = JDBCUtil.getNextValSql((Connection)conn, (String)"RHQ_EVENT_SOURCE");
                statementSql = String.format(EVENT_SOURCE_INSERT_STMT, nextvalSql);
            } else if (dbType instanceof SQLServerDatabaseType) {
                statementSql = EVENT_SOURCE_INSERT_STMT_AUTOINC;
            } else {
                throw new IllegalArgumentException("Unknown database type, can't continue: " + dbType);
            }
            ps = conn.prepareStatement(statementSql);
            try {
                for (EventSource eventSource : events.keySet()) {
                    int paramIndex = 1;
                    ps.setString(paramIndex++, eventSource.getEventDefinition().getName());
                    ps.setString(paramIndex++, eventSource.getEventDefinition().getResourceType().getName());
                    ps.setString(paramIndex++, eventSource.getEventDefinition().getResourceType().getPlugin());
                    ps.setInt(paramIndex++, eventSource.getResource().getId());
                    ps.setString(paramIndex++, eventSource.getLocation());
                    ps.setString(paramIndex++, eventSource.getEventDefinition().getName());
                    ps.setString(paramIndex++, eventSource.getEventDefinition().getResourceType().getName());
                    ps.setString(paramIndex++, eventSource.getEventDefinition().getResourceType().getPlugin());
                    ps.setInt(paramIndex++, eventSource.getResource().getId());
                    ps.setString(paramIndex++, eventSource.getLocation());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            finally {
                JDBCUtil.safeClose((Statement)ps);
            }
            if (dbType instanceof PostgresqlDatabaseType || dbType instanceof OracleDatabaseType || dbType instanceof H2DatabaseType) {
                nextvalSql = JDBCUtil.getNextValSql((Connection)conn, (String)"RHQ_EVENT");
                statementSql = String.format(EVENT_INSERT_STMT, nextvalSql);
            } else if (dbType instanceof SQLServerDatabaseType) {
                statementSql = EVENT_INSERT_STMT_AUTOINC;
            } else {
                throw new IllegalArgumentException("Unknown database type, can't continue: " + dbType);
            }
            ps = conn.prepareStatement(statementSql);
            try {
                for (EventSource eventSource : events.keySet()) {
                    Set<Event> eventData = events.get(eventSource);
                    for (Event event : eventData) {
                        int paramIndex = 1;
                        ps.setString(paramIndex++, eventSource.getEventDefinition().getName());
                        ps.setString(paramIndex++, eventSource.getEventDefinition().getResourceType().getName());
                        ps.setString(paramIndex++, eventSource.getEventDefinition().getResourceType().getPlugin());
                        ps.setInt(paramIndex++, eventSource.getResource().getId());
                        ps.setString(paramIndex++, eventSource.getLocation());
                        ps.setLong(paramIndex++, event.getTimestamp());
                        ps.setString(paramIndex++, event.getSeverity().toString());
                        ps.setString(paramIndex++, event.getDetail());
                        ps.addBatch();
                    }
                    this.notifyAlertConditionCacheManager("addEventData", eventSource, eventData.toArray(new Event[eventData.size()]));
                }
                ps.executeBatch();
            }
            finally {
                JDBCUtil.safeClose((Statement)ps);
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("addEventData: Insert of events failed : " + t.getMessage()));
            if (t instanceof SQLException) {
                SQLException e = (SQLException)t;
                SQLException e2 = e.getNextException();
                if (e2 != null) {
                    this.log.warn((Object)("     : " + e2.getMessage()));
                }
                if (t.getCause() != null) {
                    this.log.warn((Object)("     : " + t.getCause().getMessage()));
                }
            }
        }
        finally {
            JDBCUtil.safeClose((Connection)conn);
        }
    }

    private void notifyAlertConditionCacheManager(String callingMethod, EventSource source, Event ... events) {
        AlertConditionCacheStats stats = this.alertConditionCacheManager.checkConditions(source, events);
        this.log.debug((Object)(callingMethod + ": " + stats.toString()));
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=21600)
    public int purgeEventData(Date deleteUpToTime) throws SQLException {
        Query q = this.entityManager.createQuery("DELETE FROM Event e WHERE e.timestamp < :cutOff");
        q.setParameter("cutOff", (Object)deleteUpToTime.getTime());
        long startTime = System.currentTimeMillis();
        int deleted = q.executeUpdate();
        MeasurementMonitor.getMBean().incrementPurgeTime(System.currentTimeMillis() - startTime);
        MeasurementMonitor.getMBean().setPurgedEvents(deleted);
        return deleted;
    }

    @Override
    public int[] getEventCounts(Subject subject, int resourceId, long begin, long end, int numBuckets) {
        int[] buckets = new int[numBuckets];
        PageList<EventComposite> events = this.findEventComposites(subject, EntityContext.forResource((int)resourceId), begin, end, null, null, null, PageControl.getUnlimitedInstance());
        long timeDiff = end - begin;
        long timePerBucket = timeDiff / (long)numBuckets;
        for (EventComposite event : events) {
            int bucket;
            long evTime = event.getTimestamp().getTime();
            int n = bucket = (int)((evTime -= begin) / timePerBucket);
            buckets[n] = buckets[n] + 1;
        }
        return buckets;
    }

    @Override
    public EventComposite getEventDetailForEventId(Subject subject, int eventId) throws EventException {
        Query q = this.entityManager.createNamedQuery("Event.GET_DETAILS_FOR_EVENT_IDS");
        ArrayList<Integer> eventIds = new ArrayList<Integer>(1);
        eventIds.add(eventId);
        q.setParameter("eventIds", eventIds);
        List composites = q.getResultList();
        if (composites.size() == 1) {
            return (EventComposite)composites.get(0);
        }
        throw new EventException("No event found for eventId[" + eventId + "]");
    }

    @Override
    public void deleteEventSourcesForDefinition(EventDefinition def) {
        Query q = this.entityManager.createNamedQuery("EventSource.deletebyEventDefinition");
        q.setParameter("definition", (Object)def);
        List sources = q.getResultList();
        for (EventSource source : sources) {
            this.entityManager.remove((Object)source);
        }
    }

    @Override
    public int deleteEventsForContext(Subject subject, EntityContext context, List<Integer> eventIds) {
        if (eventIds == null || eventIds.size() == 0) {
            return 0;
        }
        if (context.type == EntityContext.Type.Resource) {
            if (!this.authorizationManager.hasResourcePermission(subject, Permission.MANAGE_EVENTS, context.resourceId)) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permissions to delete events for resource[id=" + context.resourceId + "]");
            }
        } else if (context.type == EntityContext.Type.ResourceGroup) {
            if (!this.authorizationManager.hasGroupPermission(subject, Permission.MANAGE_EVENTS, context.groupId)) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permissions to delete events for resourceGroup[id=" + context.groupId + "]");
            }
        } else if (context.type == EntityContext.Type.AutoGroup && !this.authorizationManager.canViewAutoGroup(subject, context.parentResourceId, context.resourceTypeId)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view event history for autoGroup[parentResourceId=" + context.parentResourceId + ", resourceTypeId=" + context.resourceTypeId + "]");
        }
        Query q = this.entityManager.createNamedQuery("Event.deleteByEventIds");
        q.setParameter("eventIds", eventIds);
        int deletedCount = q.executeUpdate();
        return deletedCount;
    }

    @Override
    public int purgeEventsForContext(Subject subject, EntityContext context) {
        if (context.type == EntityContext.Type.Resource) {
            if (!this.authorizationManager.hasResourcePermission(subject, Permission.MANAGE_EVENTS, context.resourceId)) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permissions to purge events for resource[id=" + context.resourceId + "]");
            }
        } else if (context.type == EntityContext.Type.ResourceGroup) {
            if (!this.authorizationManager.hasGroupPermission(subject, Permission.MANAGE_EVENTS, context.groupId)) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permissions to purge events for resourceGroup[id=" + context.groupId + "]");
            }
        } else {
            throw new IllegalArgumentException(context.getUnknownContextMessage());
        }
        Query purgeQuery = null;
        if (context.type == EntityContext.Type.Resource) {
            purgeQuery = this.entityManager.createNamedQuery("Event.deleteAllByResource");
            purgeQuery.setParameter("resourceId", (Object)context.resourceId);
        } else if (context.type == EntityContext.Type.ResourceGroup) {
            purgeQuery = this.entityManager.createNamedQuery("Event.deleteAllByResourceGroup");
            purgeQuery.setParameter("groupId", (Object)context.groupId);
        }
        int deletedCount = purgeQuery.executeUpdate();
        return deletedCount;
    }

    @Override
    public Map<EventSeverity, Integer> getEventCountsBySeverity(Subject subject, int resourceId, long startDate, long endDate) {
        HashMap<EventSeverity, Integer> results = new HashMap<EventSeverity, Integer>();
        Query q = this.entityManager.createNamedQuery("Event.eventCountsBySeverity");
        q.setParameter("resourceId", (Object)resourceId);
        q.setParameter("start", (Object)startDate);
        q.setParameter("end", (Object)endDate);
        List rawResults = q.getResultList();
        for (Object[] rawResult : rawResults) {
            EventSeverity severity = (EventSeverity)rawResult[0];
            long count = (Long)rawResult[1];
            results.put(severity, (int)count);
        }
        return results;
    }

    @Override
    public Map<EventSeverity, Integer> getEventCountsBySeverityForGroup(Subject subject, int groupId, long startDate, long endDate) {
        HashMap<EventSeverity, Integer> results = new HashMap<EventSeverity, Integer>();
        Query q = this.entityManager.createNamedQuery("Event.eventCountsBySeverityGroup");
        q.setParameter("groupId", (Object)groupId);
        q.setParameter("start", (Object)startDate);
        q.setParameter("end", (Object)endDate);
        List rawResults = q.getResultList();
        for (Object[] rawResult : rawResults) {
            EventSeverity severity = (EventSeverity)rawResult[0];
            long count = (Long)rawResult[1];
            results.put(severity, (int)count);
        }
        return results;
    }

    @Override
    public EventSeverity[] getSeverityBucketsByContext(Subject subject, EntityContext context, long begin, long end, int bucketCount) {
        EventCriteria criteria = new EventCriteria();
        criteria.addFilterStartTime(Long.valueOf(begin));
        criteria.addFilterEndTime(Long.valueOf(end));
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        String replacementSelectList = " event.severity, event.timestamp ";
        generator.alterProjection(replacementSelectList);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, "source.resource", subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        PageList flyWeights = queryRunner.execute();
        EventSeverity[] buckets = new EventSeverity[bucketCount];
        long timeDiff = end - begin;
        long timePerBucket = timeDiff / (long)bucketCount;
        for (Object[] nextFly : flyWeights) {
            long eventTime = (Long)nextFly[1];
            EventSeverity eventSeverity = (EventSeverity)nextFly[0];
            int bucket = (int)((eventTime -= begin) / timePerBucket);
            if (!eventSeverity.isMoreSevereThan(buckets[bucket])) continue;
            buckets[bucket] = eventSeverity;
        }
        return buckets;
    }

    @Override
    public PageList<EventComposite> findEventComposites(Subject subject, EntityContext context, long begin, long end, EventSeverity[] severities, String source, String detail, PageControl pc) {
        if (context.type == EntityContext.Type.Resource) {
            if (!this.authorizationManager.canViewResource(subject, context.resourceId)) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to view event history for resource[id=" + context.resourceId + "]");
            }
        } else if (context.type == EntityContext.Type.ResourceGroup) {
            if (!this.authorizationManager.canViewGroup(subject, context.groupId)) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to view event history for resourceGroup[id=" + context.groupId + "]");
            }
        } else if (context.type == EntityContext.Type.AutoGroup && !this.authorizationManager.canViewAutoGroup(subject, context.parentResourceId, context.resourceTypeId)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view event history for autoGroup[parentResourceId=" + context.parentResourceId + ", resourceTypeId=" + context.resourceTypeId + "]");
        }
        EventCriteria criteria = new EventCriteria();
        criteria.addFilterStartTime(Long.valueOf(begin));
        criteria.addFilterEndTime(Long.valueOf(end));
        criteria.addFilterSeverities(severities);
        if (source != null && !source.trim().equals("")) {
            criteria.addFilterSourceName(source);
        }
        if (detail != null && !detail.trim().equals("")) {
            criteria.addFilterDetail(detail);
        }
        criteria.setPageControl(pc);
        if (context.type == EntityContext.Type.Resource) {
            criteria.addFilterResourceId(Integer.valueOf(context.resourceId));
        } else if (context.type == EntityContext.Type.ResourceGroup) {
            criteria.addFilterResourceGroupId(Integer.valueOf(context.groupId));
        } else if (context.type == EntityContext.Type.AutoGroup) {
            criteria.addFilterAutoGroupParentResourceId(Integer.valueOf(context.parentResourceId));
            criteria.addFilterAutoGroupResourceTypeId(Integer.valueOf(context.resourceTypeId));
        }
        return this.findEventCompositesByCriteria(subject, criteria);
    }

    @Override
    public PageList<EventComposite> findEventCompositesByCriteria(Subject subject, EventCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        String replacementSelectList = " new org.rhq.core.domain.event.composite.EventComposite(    event.detail,   event.source.resource.id,   event.source.resource.name,   event.source.resource.ancestry,   event.source.resource.resourceType.id,   event.id,   event.severity,   event.source.location,   event.timestamp ) ";
        generator.alterProjection(replacementSelectList);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, "source.resource", subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<Event> findEventsByCriteria(Subject subject, EventCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, "source.resource", subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public EventSeverity[] getSeverityBuckets(Subject subject, int resourceId, long begin, long end, int numBuckets) {
        return this.getSeverityBucketsByContext(subject, EntityContext.forResource((int)resourceId), begin, end, numBuckets);
    }

    @Override
    public EventSeverity[] getSeverityBucketsForAutoGroup(Subject subject, int parentResourceId, int resourceTypeId, long begin, long end, int numBuckets) {
        return this.getSeverityBucketsByContext(subject, EntityContext.forAutoGroup((int)parentResourceId, (int)resourceTypeId), begin, end, numBuckets);
    }

    @Override
    public EventSeverity[] getSeverityBucketsForCompGroup(Subject subject, int resourceGroupId, long begin, long end, int numBuckets) {
        return this.getSeverityBucketsByContext(subject, EntityContext.forGroup((int)resourceGroupId), begin, end, numBuckets);
    }
}

