/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.inventory;

import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.inventory.InventoryManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.metadata.ResourceMetadataManagerLocal;
import org.rhq.enterprise.server.util.BatchIterator;

@Stateless
public class InventoryManagerBean
implements InventoryManagerLocal {
    @PersistenceContext(unitName="rhqpu")
    EntityManager entityMgr;
    @EJB
    private SubjectManagerLocal subjectMgr;
    @EJB
    private ResourceTypeManagerLocal resourceTypeMgr;
    @EJB
    private ResourceManagerLocal resourceMgr;
    @EJB
    private ResourceMetadataManagerLocal metadataMgr;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public int markTypesDeleted(List<Integer> resourceTypeIds) {
        int typesDeleted = 0;
        BatchIterator<Integer> batchIterator = new BatchIterator<Integer>(resourceTypeIds);
        for (List<Integer> list : batchIterator) {
            List<Integer> resourceIds = this.resourceMgr.findIdsByTypeIds(list);
            this.resourceMgr.uninventoryResources(this.subjectMgr.getOverlord(), this.toIntArray(resourceIds));
            Query query = this.entityMgr.createNamedQuery("ResourceType.markTypesDeleted");
            query.setParameter("resourceTypeIds", list);
            typesDeleted += query.executeUpdate();
        }
        return typesDeleted;
    }

    private int[] toIntArray(List<Integer> list) {
        int[] array = new int[list.size()];
        int i = 0;
        for (Integer integer : list) {
            array[i++] = integer;
        }
        return array;
    }

    @Override
    public List<ResourceType> getDeletedTypes() {
        ResourceTypeCriteria criteria = new ResourceTypeCriteria();
        criteria.addFilterDeleted(true);
        return this.resourceTypeMgr.findResourceTypesByCriteria(this.subjectMgr.getOverlord(), criteria);
    }

    @Override
    public boolean isReadyForPermanentRemoval(ResourceType resourceType) {
        if (!resourceType.isDeleted()) {
            return false;
        }
        Number count = (Number)this.entityMgr.createQuery("select count(r) from Resource r where r.resourceType = :type").setParameter("type", (Object)resourceType).getSingleResult();
        return count.intValue() == 0;
    }

    @Override
    public void purgeDeletedResourceType(ResourceType resourceType) {
        try {
            this.metadataMgr.completeRemoveResourceType(this.subjectMgr.getOverlord(), resourceType);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to purge resource types", e);
        }
    }
}

