/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.measurement.MeasurementStorageException;
import org.rhq.enterprise.server.measurement.util.MeasurementDataManagerUtility;

public class DataInserter {
    private static final long INTERVAL = 300000L;
    private static final long HOUR = 3600000L;
    private static Connection c;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(long time, int numSchedules) throws SQLException {
        c.setAutoCommit(false);
        int count = 0;
        long start = System.currentTimeMillis();
        try {
            ArrayList<Integer> scheduleIds = new ArrayList<Integer>();
            Statement s = c.createStatement();
            try {
                ResultSet rs = s.executeQuery("SELECT id FROM RHQ_MEASUREMENT_SCHED");
                try {
                    while (rs.next() && numSchedules > 0) {
                        scheduleIds.add(rs.getInt(1));
                        --numSchedules;
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                s.close();
            }
            System.out.println("INSERTING for " + scheduleIds.size() + " schedules starting at " + new Date(time));
            for (long i = 0L; i < 3600000L; i += 300000L) {
                long ts = (long)((double)(time + i) + Math.random() * 1000.0);
                PreparedStatement ps = null;
                try {
                    int[] res;
                    String table = MeasurementDataManagerUtility.getTable(ts);
                    String insertSql = "INSERT INTO " + table + "(schedule_id,time_stamp,value) VALUES(?,?,?)";
                    ps = c.prepareStatement(insertSql);
                    Iterator i$ = scheduleIds.iterator();
                    while (i$.hasNext()) {
                        int scheduleId = (Integer)i$.next();
                        ps.setInt(1, scheduleId);
                        ps.setLong(2, ts);
                        ps.setInt(3, (int)(Math.random() * 100.0));
                        ps.addBatch();
                    }
                    for (int updates : res = ps.executeBatch()) {
                        if (updates != 1) {
                            throw new MeasurementStorageException("Unexpected batch update size [" + updates + "]");
                        }
                        ++count;
                    }
                    c.commit();
                    System.out.print(".");
                    System.out.flush();
                    JDBCUtil.safeClose((Statement)ps);
                    JDBCUtil.safeClose((Statement)ps);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    JDBCUtil.safeClose(ps);
                }
            }
            System.out.println(" " + count + " rows added in " + (System.currentTimeMillis() - start) + "ms starting in " + MeasurementDataManagerUtility.getTable(time));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int sum(int[] arr) {
        int count = 0;
        for (int ar : arr) {
            count += ar;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        String driver = System.getProperty("driver", "org.postgresql.Driver");
        String url = System.getProperty("url", "jdbc:postgresql://127.0.0.1:5432");
        String username = System.getProperty("username", "jon");
        String password = System.getProperty("password", "jon");
        int numSchedules = Integer.parseInt(System.getProperty("numSchedules", "5"));
        System.out.println("driver=" + driver);
        System.out.println("url=" + url);
        System.out.println("username=" + username);
        System.out.println("password=" + password);
        System.out.println("numSchedules=" + numSchedules);
        System.out.println("(to override these, set system properties of the same names as above)");
        Class.forName(driver);
        c = DriverManager.getConnection(url, username, password);
        try {
            long time = System.currentTimeMillis() - 604800000L;
            time -= time % 3600000L;
            for (int i = 0; i < 168; ++i) {
                long bucket = time + (long)i * 3600000L;
                DataInserter.insert(bucket, numSchedules);
            }
        }
        finally {
            JDBCUtil.safeClose((Connection)c, null, null);
        }
    }
}

