/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.Management;
import org.jboss.annotation.ejb.Service;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainerConfiguration;
import org.rhq.enterprise.server.plugin.pc.ServerPluginServiceManagement;
import org.rhq.enterprise.server.util.LookupUtil;

@Management(value=ServerPluginServiceManagement.class)
@Service(objectName="rhq.serverplugin:service=ServerPluginService")
public class ServerPluginService
implements ServerPluginServiceManagement {
    private static final Log log = LogFactory.getLog(ServerPluginService.class);
    private boolean started;
    private MasterServerPluginContainer masterPluginContainer;

    @Override
    public synchronized void start() {
        log.debug((Object)"The server plugin service has been deployed (but master plugin container will not be started yet)");
        this.started = true;
    }

    @Override
    public synchronized void startMasterPluginContainer() {
        if (!this.started) {
            throw new IllegalStateException("The server plugin service is not started - cannot start the master plugin container");
        }
        if (this.masterPluginContainer == null) {
            log.debug((Object)"The server plugin service is now starting the master server plugin container");
            this.masterPluginContainer = this.createMasterPluginContainer();
            this.masterPluginContainer.scheduleAllPluginJobs();
        }
    }

    @Override
    public synchronized void stopMasterPluginContainer() {
        if (this.started && this.masterPluginContainer != null) {
            log.info((Object)"The server plugin service is now stopping - the master plugin container will be shutdown now");
            this.masterPluginContainer.shutdown();
            this.masterPluginContainer = null;
        }
    }

    @Override
    public synchronized void stop() {
        if (this.started) {
            this.stopMasterPluginContainer();
            this.started = false;
        }
    }

    @Override
    public synchronized void restartMasterPluginContainer() {
        this.stopMasterPluginContainer();
        this.startMasterPluginContainer();
    }

    @Override
    public synchronized void startMasterPluginContainerWithoutSchedulingJobs() {
        if (!this.started) {
            throw new IllegalStateException("The server plugin service is not started - cannot start the master plugin container!");
        }
        if (this.masterPluginContainer == null) {
            log.debug((Object)"The server plugin service is now starting the master server plugin container!");
            this.masterPluginContainer = this.createMasterPluginContainer();
        }
    }

    @Override
    public MasterServerPluginContainer getMasterPluginContainer() {
        return this.masterPluginContainer;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isMasterPluginContainerStarted() {
        return this.masterPluginContainer != null;
    }

    @Override
    public File getServerPluginsDirectory() {
        File serverHomeDir = LookupUtil.getCoreServer().getJBossServerHomeDir();
        File pluginDir = new File(serverHomeDir, "deploy/rhq.ear/rhq-serverplugins");
        return pluginDir;
    }

    protected MasterServerPluginContainer createMasterPluginContainer() {
        MasterServerPluginContainer pc = new MasterServerPluginContainer();
        File pluginDir = this.getServerPluginsDirectory();
        File serverDataDir = LookupUtil.getCoreServer().getJBossServerDataDir();
        File dataDir = new File(serverDataDir, "server-plugins");
        dataDir.mkdirs();
        File tmpDir = LookupUtil.getCoreServer().getJBossServerTempDir();
        StringBuilder defaultRegex = new StringBuilder();
        defaultRegex.append("(org\\.apache\\.tools\\..*)");
        MasterServerPluginContainerConfiguration config = new MasterServerPluginContainerConfiguration(pluginDir, dataDir, tmpDir, defaultRegex.toString());
        pc.initialize(config);
        return pc;
    }
}

