/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.remote;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.invocation.NameBasedInvocation;
import org.rhq.core.domain.server.ExternalizableStrategy;
import org.rhq.core.util.exception.WrappedRemotingException;
import org.rhq.enterprise.server.remote.RemoteSafeInvocationHandlerMetrics;
import org.rhq.enterprise.server.remote.RemoteSafeInvocationHandlerMetricsMBean;
import org.rhq.enterprise.server.safeinvoker.HibernateDetachUtility;

public class RemoteSafeInvocationHandler
implements ServerInvocationHandler {
    private static final Log log = LogFactory.getLog(RemoteSafeInvocationHandler.class);
    private static final Map<String, Class<?>> PRIMITIVE_CLASSES = new HashMap();
    private RemoteSafeInvocationHandlerMetrics metrics = new RemoteSafeInvocationHandlerMetrics();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object invoke(InvocationRequest invocationRequest) throws Throwable {
        Object result;
        block22: {
            long time;
            boolean successful;
            String methodName;
            block21: {
                if (invocationRequest == null) {
                    throw new IllegalArgumentException("InvocationRequest was null.");
                }
                methodName = null;
                successful = false;
                result = null;
                time = System.currentTimeMillis();
                InitialContext ic = new InitialContext();
                NameBasedInvocation nbi = (NameBasedInvocation)invocationRequest.getParameter();
                if (null == nbi) {
                    throw new IllegalArgumentException("InvocationRequest did not supply method.");
                }
                methodName = nbi.getMethodName();
                String[] methodInfo = methodName.split(":");
                String jndiName = "rhq/" + methodInfo[0];
                Object target = ic.lookup(jndiName + "/remote");
                target = ic.lookup(jndiName + "/local");
                String[] signature = nbi.getSignature();
                int signatureLength = signature.length;
                Class[] sig = new Class[signatureLength];
                for (int i = 0; i < signatureLength; ++i) {
                    sig[i] = this.getClass(signature[i]);
                }
                Method m = target.getClass().getMethod(methodInfo[1], sig);
                result = m.invoke(target, nbi.getParameters());
                successful = true;
                if (result == null) break block21;
                ExternalizableStrategy.setStrategy((ExternalizableStrategy.Subsystem)ExternalizableStrategy.Subsystem.REFLECTIVE_SERIALIZATION);
                try {
                    HibernateDetachUtility.nullOutUninitializedFields((Object)result, (HibernateDetachUtility.SerializationType)HibernateDetachUtility.SerializationType.SERIALIZATION);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to null out uninitialized fields", (Throwable)e);
                    this.metrics.addData(methodName, System.currentTimeMillis() - time, false);
                    return new WrappedRemotingException((Throwable)e);
                }
            }
            long executionTime = System.currentTimeMillis() - time;
            this.metrics.addData(methodName, executionTime, successful);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remote request [" + methodName + "] execution time (ms): " + executionTime));
            }
            break block22;
            catch (InvocationTargetException e) {
                log.error((Object)"Failed to invoke remote request", (Throwable)e);
                WrappedRemotingException wrappedRemotingException = new WrappedRemotingException(e.getTargetException());
                return wrappedRemotingException;
            }
            catch (Exception e2) {
                log.error((Object)"Failed to invoke remote request", (Throwable)e2);
                WrappedRemotingException wrappedRemotingException = new WrappedRemotingException((Throwable)e2);
                return wrappedRemotingException;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (result != null) {
                    ExternalizableStrategy.setStrategy((ExternalizableStrategy.Subsystem)ExternalizableStrategy.Subsystem.REFLECTIVE_SERIALIZATION);
                    try {
                        HibernateDetachUtility.nullOutUninitializedFields(result, (HibernateDetachUtility.SerializationType)HibernateDetachUtility.SerializationType.SERIALIZATION);
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to null out uninitialized fields", (Throwable)e);
                        this.metrics.addData(methodName, System.currentTimeMillis() - time, false);
                        return new WrappedRemotingException((Throwable)e);
                    }
                }
                long executionTime2 = System.currentTimeMillis() - time;
                this.metrics.addData(methodName, executionTime2, successful);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Remote request [" + methodName + "] execution time (ms): " + executionTime2));
                }
            }
        }
        return result;
    }

    Class<?> getClass(String name) throws ClassNotFoundException {
        if (PRIMITIVE_CLASSES.containsKey(name)) {
            return PRIMITIVE_CLASSES.get(name);
        }
        return Class.forName(name);
    }

    public void registerMetricsMBean(MBeanServer mbs) {
        try {
            mbs.registerMBean(this.metrics, RemoteSafeInvocationHandlerMetricsMBean.OBJECTNAME_METRICS);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to register the metrics object, will not be able to monitor remote API: " + e));
        }
    }

    public void unregisterMetricsMBean(MBeanServer mbs) {
        try {
            mbs.unregisterMBean(RemoteSafeInvocationHandlerMetricsMBean.OBJECTNAME_METRICS);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to unregister the metrics object: " + e));
        }
    }

    public void addListener(InvokerCallbackHandler handler) {
    }

    public void removeListener(InvokerCallbackHandler handler) {
    }

    public void setInvoker(ServerInvoker invoker) {
    }

    public void setMBeanServer(MBeanServer mbs) {
    }

    static {
        PRIMITIVE_CLASSES.put(Short.TYPE.getName(), Short.TYPE);
        PRIMITIVE_CLASSES.put(Integer.TYPE.getName(), Integer.TYPE);
        PRIMITIVE_CLASSES.put(Long.TYPE.getName(), Long.TYPE);
        PRIMITIVE_CLASSES.put(Float.TYPE.getName(), Float.TYPE);
        PRIMITIVE_CLASSES.put(Double.TYPE.getName(), Double.TYPE);
        PRIMITIVE_CLASSES.put(Boolean.TYPE.getName(), Boolean.TYPE);
        PRIMITIVE_CLASSES.put(Character.TYPE.getName(), Character.TYPE);
        PRIMITIVE_CLASSES.put(Byte.TYPE.getName(), Byte.TYPE);
    }
}

