/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.configuration.metadata.ConfigurationDefinitionUpdateReport;
import org.rhq.enterprise.server.configuration.metadata.ConfigurationMetadataManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.metadata.PluginConfigurationMetadataManagerLocal;

@Stateless
public class PluginConfigurationMetadataManagerBean
implements PluginConfigurationMetadataManagerLocal {
    private static Log log = LogFactory.getLog(PluginConfigurationMetadataManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityMgr;
    @EJB
    private ConfigurationMetadataManagerLocal configurationMetadataMgr;
    @EJB
    private SubjectManagerLocal subjectMgr;
    @EJB
    private ResourceManagerLocal resourceMgr;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updatePluginConfigurationDefinition(ResourceType existingType, ResourceType newType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating plugin configuration definition for " + existingType));
        }
        existingType = (ResourceType)this.entityMgr.find(ResourceType.class, (Object)existingType.getId());
        ConfigurationDefinition existingConfigurationDefinition = existingType.getPluginConfigurationDefinition();
        if (newType.getPluginConfigurationDefinition() != null) {
            if (existingConfigurationDefinition == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(existingType + " currently does not have a plugin configuration definition. Adding " + "new plugin configuration."));
                }
                this.entityMgr.persist((Object)newType.getPluginConfigurationDefinition());
                existingType.setPluginConfigurationDefinition(newType.getPluginConfigurationDefinition());
            } else {
                ConfigurationDefinitionUpdateReport updateReport;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updating plugin configuration definition for " + existingType));
                }
                if ((updateReport = this.configurationMetadataMgr.updateConfigurationDefinition(newType.getPluginConfigurationDefinition(), existingConfigurationDefinition)).getNewPropertyDefinitions().size() > 0 || updateReport.getUpdatedPropertyDefinitions().size() > 0) {
                    Subject overlord = this.subjectMgr.getOverlord();
                    ResourceCriteria criteria = new ResourceCriteria();
                    criteria.addFilterResourceTypeId(Integer.valueOf(existingType.getId()));
                    PageList<Resource> resources = this.resourceMgr.findResourcesByCriteria(overlord, criteria);
                    for (Resource resource : resources) {
                        this.updateResourcePluginConfiguration(resource, updateReport);
                    }
                }
            }
        } else if (existingConfigurationDefinition != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing plugin configuration definition for " + existingType));
            }
            existingType.setPluginConfigurationDefinition(null);
            this.entityMgr.remove((Object)existingConfigurationDefinition);
        }
    }

    private void updateResourcePluginConfiguration(Resource resource, ConfigurationDefinitionUpdateReport updateReport) {
        Configuration pluginConfiguration = resource.getPluginConfiguration();
        boolean modified = false;
        int numberOfProperties = pluginConfiguration.getProperties().size();
        ConfigurationTemplate template = updateReport.getConfigurationDefinition().getDefaultTemplate();
        Configuration templateConfiguration = template.getConfiguration();
        for (PropertyDefinition propertyDef : updateReport.getNewPropertyDefinitions()) {
            if (!propertyDef.isRequired()) continue;
            Property templateProperty = templateConfiguration.get(propertyDef.getName());
            if (templateProperty == null) {
                throw new IllegalArgumentException("The property [" + propertyDef.getName() + "] marked as required in the configuration definition of [" + propertyDef.getConfigurationDefinition().getName() + "] has no attribute 'default'");
            }
            pluginConfiguration.put(templateProperty.deepCopy(false));
            modified = true;
        }
        for (PropertyDefinition propertyDef : updateReport.getUpdatedPropertyDefinitions()) {
            String propertyValue;
            if (!propertyDef.isRequired() || (propertyValue = pluginConfiguration.getSimpleValue(propertyDef.getName(), null)) != null) continue;
            Property templateProperty = templateConfiguration.get(propertyDef.getName());
            pluginConfiguration.put(templateProperty.deepCopy(false));
            modified = true;
        }
        if (modified) {
            resource.setAgentSynchronizationNeeded();
        }
    }
}

