/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.metadata.PluginDependencyGraph;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.clientapi.descriptor.AgentPluginDescriptorUtil;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.plugin.PluginStatusType;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.inventory.InventoryManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.resource.metadata.PluginStats;
import org.rhq.enterprise.server.resource.metadata.ResourceMetadataManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

@Stateless
public class PluginManagerBean
implements PluginManagerLocal {
    private final Log log = LogFactory.getLog(PluginManagerBean.class);
    @Resource(name="RHQ_DS", mappedName="java:/RHQDS")
    private DataSource dataSource;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private ResourceMetadataManagerLocal resourceMetadataManager;
    @EJB
    private PluginManagerLocal pluginMgr;
    @EJB
    private InventoryManagerLocal inventoryMgr;
    @EJB
    private ResourceTypeManagerLocal resourceTypeMgr;
    @EJB
    private ResourceManagerLocal resourceMgr;
    @EJB
    private SubjectManagerLocal subjectMgr;

    @Override
    public Plugin getPlugin(String name) {
        Query query = this.entityManager.createNamedQuery("Plugin.findByName");
        query.setParameter("name", (Object)name);
        Plugin plugin = (Plugin)query.getSingleResult();
        return plugin;
    }

    @Override
    public void markPluginsForPurge(Subject subject, List<Integer> pluginIds) throws Exception {
        for (Integer id : pluginIds) {
            Plugin plugin = (Plugin)this.entityManager.find(Plugin.class, (Object)id);
            plugin.setCtime(-1L);
            this.log.info((Object)("Scheduling plugin [" + plugin + "] to be purged from the database."));
        }
    }

    @Override
    public boolean isReadyForPurge(Plugin plugin) {
        ResourceTypeCriteria criteria = new ResourceTypeCriteria();
        criteria.addFilterPluginName(plugin.getName());
        criteria.setRestriction(Criteria.Restriction.COUNT_ONLY);
        PageList<ResourceType> results = this.resourceTypeMgr.findResourceTypesByCriteria(this.subjectMgr.getOverlord(), criteria);
        return results.getTotalSize() == 0;
    }

    @Override
    public void purgePlugins(List<Plugin> plugins) {
        this.entityManager.createNamedQuery("Plugin.purgePlugins").setParameter("plugins", plugins).executeUpdate();
    }

    @Override
    public List<Plugin> getPlugins() {
        return this.entityManager.createNamedQuery("Plugin.findAll").getResultList();
    }

    @Override
    public List<Plugin> getInstalledPlugins() {
        Query q = this.entityManager.createNamedQuery("Plugin.findAllInstalled");
        return q.getResultList();
    }

    @Override
    public List<Plugin> findAllDeletedPlugins() {
        return this.entityManager.createNamedQuery("Plugin.findAllDeleted").getResultList();
    }

    @Override
    public List<Plugin> findPluginsMarkedForPurge() {
        return this.entityManager.createNamedQuery("Plugin.findAllToPurge").getResultList();
    }

    @Override
    public List<Plugin> getAllPluginsById(List<Integer> pluginIds) {
        if (pluginIds == null || pluginIds.size() == 0) {
            return new ArrayList<Plugin>();
        }
        Query query = this.entityManager.createNamedQuery("Plugin.findAllByIds");
        query.setParameter("ids", pluginIds);
        return query.getResultList();
    }

    @Override
    public List<Plugin> getPluginsByResourceTypeAndCategory(String resourceTypeName, ResourceCategory resourceCategory) {
        Query query = this.entityManager.createNamedQuery("Plugin.findByResourceType");
        query.setParameter("resourceTypeName", (Object)resourceTypeName);
        query.setParameter("resourceCategory", (Object)resourceCategory);
        List results = query.getResultList();
        return results;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void enablePlugins(Subject subject, List<Integer> pluginIds) throws Exception {
        if (pluginIds == null || pluginIds.size() == 0) {
            return;
        }
        PluginDependencyGraph graph = this.getPluginMetadataManager().buildDependencyGraph();
        List<Plugin> allPlugins = this.getInstalledPlugins();
        HashSet<String> pluginsThatNeedToBeEnabled = new HashSet<String>();
        for (Integer pluginId : pluginIds) {
            Plugin plugin = this.getPluginFromListById(allPlugins, pluginId);
            if (plugin == null) continue;
            Collection dependencyNames = graph.getAllDependencies(plugin.getName());
            for (String dependencyName : dependencyNames) {
                Plugin dependencyPlugin = this.getPluginFromListByName(allPlugins, dependencyName);
                if (dependencyPlugin == null || dependencyPlugin.isEnabled() || pluginIds.contains(dependencyPlugin.getId())) continue;
                pluginsThatNeedToBeEnabled.add(dependencyPlugin.getDisplayName());
            }
        }
        if (!pluginsThatNeedToBeEnabled.isEmpty()) {
            throw new IllegalArgumentException("You must enable the following plugin dependencies also: " + pluginsThatNeedToBeEnabled);
        }
        for (Integer pluginId : pluginIds) {
            this.setPluginEnabledFlag(subject, pluginId, true);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void disablePlugins(Subject subject, List<Integer> pluginIds) throws Exception {
        if (pluginIds == null || pluginIds.size() == 0) {
            return;
        }
        PluginDependencyGraph graph = this.getPluginMetadataManager().buildDependencyGraph();
        List<Plugin> allPlugins = this.getInstalledPlugins();
        HashSet<String> pluginsThatNeedToBeDisabled = new HashSet<String>();
        for (Integer pluginId : pluginIds) {
            Plugin plugin = this.getPluginFromListById(allPlugins, pluginId);
            if (plugin == null) continue;
            Collection dependentNames = graph.getAllDependents(plugin.getName());
            for (String dependentName : dependentNames) {
                Plugin dependentPlugin = this.getPluginFromListByName(allPlugins, dependentName);
                if (dependentPlugin == null || !dependentPlugin.isEnabled() || pluginIds.contains(dependentPlugin.getId())) continue;
                pluginsThatNeedToBeDisabled.add(dependentPlugin.getDisplayName());
            }
        }
        if (!pluginsThatNeedToBeDisabled.isEmpty()) {
            throw new IllegalArgumentException("You must disable the following dependent plugins also: " + pluginsThatNeedToBeDisabled);
        }
        for (Integer pluginId : pluginIds) {
            this.setPluginEnabledFlag(subject, pluginId, false);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void deletePlugins(Subject subject, List<Integer> pluginIds) throws Exception {
        if (pluginIds.isEmpty()) {
            return;
        }
        PluginDependencyGraph graph = this.getPluginMetadataManager().buildDependencyGraph();
        List<Plugin> allPlugins = this.getInstalledPlugins();
        HashSet<String> pluginsToDelete = new HashSet<String>();
        for (Integer pluginId : pluginIds) {
            Plugin plugin = this.getPluginFromListById(allPlugins, pluginId);
            if (plugin == null || !plugin.getStatus().equals((Object)PluginStatusType.INSTALLED)) continue;
            Collection dependentNames = graph.getAllDependents(plugin.getName());
            for (String dependentName : dependentNames) {
                Plugin dependentPlugin = this.getPluginFromListByName(allPlugins, dependentName);
                if (dependentPlugin == null || !dependentPlugin.isEnabled() || pluginIds.contains(dependentPlugin.getId())) continue;
                pluginsToDelete.add(dependentPlugin.getDisplayName());
            }
        }
        if (!pluginsToDelete.isEmpty()) {
            throw new IllegalArgumentException("You must delete the following dependent plugins also: " + pluginsToDelete);
        }
        List<Plugin> plugins = this.getAllPluginsById(pluginIds);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(subject + " preparing to delete the following plugins: " + plugins));
        }
        for (Plugin plugin : plugins) {
            if (plugin.getStatus().equals((Object)PluginStatusType.INSTALLED)) {
                long startTime = System.currentTimeMillis();
                List<Integer> resourceTypeIds = this.resourceTypeMgr.getResourceTypeIdsByPlugin(plugin.getName());
                Plugin managedPlugin = (Plugin)this.entityManager.merge((Object)plugin);
                this.inventoryMgr.markTypesDeleted(resourceTypeIds);
                managedPlugin.setStatus(PluginStatusType.DELETED);
                long endTime = System.currentTimeMillis();
                this.log.debug((Object)("Deleted " + plugin + " in " + (endTime - startTime) + " ms"));
                continue;
            }
            this.log.debug((Object)("Skipping " + plugin + ". It is already deleted."));
        }
    }

    @Override
    public List<PluginStats> getPluginStats(List<Integer> pluginIds) {
        ArrayList<PluginStats> stats = new ArrayList<PluginStats>();
        List<Plugin> plugins = this.getAllPluginsById(pluginIds);
        for (Plugin plugin : plugins) {
            List<Integer> resourceTypeIds = this.resourceTypeMgr.getResourceTypeIdsByPlugin(plugin.getName());
            Integer resourceCount = this.resourceMgr.getResourceCount(resourceTypeIds);
            stats.add(new PluginStats(plugin, resourceTypeIds.size(), resourceCount));
        }
        return stats;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setPluginEnabledFlag(Subject subject, int pluginId, boolean enabled) throws Exception {
        Query q = this.entityManager.createNamedQuery("Plugin.updatePluginEnabledById");
        q.setParameter("id", (Object)pluginId);
        q.setParameter("enabled", (Object)enabled);
        q.executeUpdate();
        this.log.info((Object)((enabled ? "Enabling" : "Disabling") + " plugin [" + pluginId + "]"));
    }

    @Override
    public File getPluginDropboxDirectory() {
        File dir = LookupUtil.getPluginDeploymentScanner().getUserPluginDir();
        return dir;
    }

    private Plugin getPluginFromListById(List<Plugin> plugins, int id) {
        for (Plugin plugin : plugins) {
            if (id != plugin.getId()) continue;
            return plugin;
        }
        return null;
    }

    private Plugin getPluginFromListByName(List<Plugin> plugins, String name) {
        for (Plugin plugin : plugins) {
            if (!name.equals(plugin.getName())) continue;
            return plugin;
        }
        return null;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void registerPlugin(Subject subject, Plugin plugin, PluginDescriptor pluginDescriptor, File pluginFile, boolean forceUpdate) throws Exception {
        this.log.debug((Object)("Registering " + plugin));
        long startTime = System.currentTimeMillis();
        boolean newOrUpdated = this.pluginMgr.installPluginJar(subject, plugin, pluginDescriptor, pluginFile);
        boolean typesUpdated = this.pluginMgr.registerPluginTypes(plugin.getName(), pluginDescriptor, newOrUpdated, forceUpdate);
        if (typesUpdated) {
            PluginMetadataManager metadataManager = this.getPluginMetadataManager();
            Map extensions = metadataManager.getEmbeddedExtensions(plugin.getName());
            if (extensions != null && extensions.size() > 0) {
                for (Map.Entry entry : extensions.entrySet()) {
                    String extPluginName = (String)entry.getKey();
                    PluginDescriptor extPluginDescriptor = (PluginDescriptor)entry.getValue();
                    this.log.debug((Object)("Plugin [" + extPluginName + "] will be re-registered because it embeds types from plugin [" + plugin.getName() + "]"));
                    this.pluginMgr.registerPluginTypes(extPluginName, extPluginDescriptor, false, true);
                    this.resourceMetadataManager.removeObsoleteTypes(subject, extPluginName, metadataManager);
                }
            }
            this.resourceMetadataManager.removeObsoleteTypes(subject, plugin.getName(), metadataManager);
        }
        long endTime = System.currentTimeMillis();
        this.log.debug((Object)("Finished registering " + plugin + " in " + (endTime - startTime) + " ms"));
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean installPluginJar(Subject subject, Plugin newPlugin, PluginDescriptor pluginDescriptor, File pluginFile) throws Exception {
        Plugin existingPlugin = null;
        boolean newOrUpdated = false;
        try {
            existingPlugin = this.getPlugin(newPlugin.getName());
        }
        catch (NoResultException nre) {
            newOrUpdated = true;
        }
        if (existingPlugin != null) {
            Plugin obsolete = AgentPluginDescriptorUtil.determineObsoletePlugin((Plugin)newPlugin, (Plugin)existingPlugin);
            if (obsolete == existingPlugin) {
                newOrUpdated = true;
            }
            newPlugin.setId(existingPlugin.getId());
            newPlugin.setEnabled(existingPlugin.isEnabled());
        }
        if (newOrUpdated) {
            if (newPlugin.getDisplayName() == null) {
                newPlugin.setDisplayName(newPlugin.getName());
            }
            newPlugin = this.updatePluginExceptContent(newPlugin);
            if (pluginFile != null) {
                this.entityManager.flush();
                this.streamPluginFileContentToDatabase(newPlugin.getId(), pluginFile);
            }
            this.log.debug((Object)("Updated plugin entity [" + newPlugin + "]"));
        }
        return newOrUpdated;
    }

    @Override
    public boolean registerPluginTypes(String newPluginName, PluginDescriptor pluginDescriptor, boolean newOrUpdated, boolean forceUpdate) throws Exception {
        boolean typesUpdated = false;
        PluginMetadataManager metadataManager = this.getPluginMetadataManager();
        if (newOrUpdated || forceUpdate || !metadataManager.getPluginNames().contains(newPluginName)) {
            Set rootResourceTypes = metadataManager.loadPlugin(pluginDescriptor);
            if (rootResourceTypes == null) {
                throw new Exception("Failed to load plugin [" + newPluginName + "].");
            }
            if (newOrUpdated || forceUpdate) {
                this.resourceMetadataManager.updateTypes(rootResourceTypes);
                typesUpdated = true;
            }
        }
        return typesUpdated;
    }

    private Plugin updatePluginExceptContent(Plugin plugin) throws Exception {
        if (plugin.getId() == 0) {
            this.entityManager.persist((Object)plugin);
        } else {
            Plugin pluginEntity = (Plugin)this.entityManager.getReference(Plugin.class, (Object)plugin.getId());
            pluginEntity.setName(plugin.getName());
            pluginEntity.setPath(plugin.getPath());
            pluginEntity.setDisplayName(plugin.getDisplayName());
            pluginEntity.setEnabled(plugin.isEnabled());
            pluginEntity.setStatus(plugin.getStatus());
            pluginEntity.setMd5(plugin.getMD5());
            pluginEntity.setVersion(plugin.getVersion());
            pluginEntity.setAmpsVersion(plugin.getAmpsVersion());
            pluginEntity.setDeployment(plugin.getDeployment());
            pluginEntity.setDescription(plugin.getDescription());
            pluginEntity.setHelp(plugin.getHelp());
            pluginEntity.setMtime(plugin.getMtime());
            try {
                this.entityManager.flush();
            }
            catch (Exception e) {
                throw new Exception("Failed to update a plugin that matches [" + plugin + "]");
            }
        }
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamPluginFileContentToDatabase(int id, File file) throws Exception {
        FileInputStream fis;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            rs = null;
            fis = new FileInputStream(file);
            try {
                conn = this.dataSource.getConnection();
                ps = conn.prepareStatement("UPDATE RHQ_PLUGIN SET CONTENT = ? WHERE ID = ?");
                ps.setBinaryStream(1, (InputStream)new BufferedInputStream(fis), (int)file.length());
                ps.setInt(2, id);
                int updateResults = ps.executeUpdate();
                if (updateResults == 1) break block6;
                throw new Exception("Failed to update content for plugin [" + id + "] from [" + file + "]");
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose((Connection)conn, ps, rs);
                try {
                    fis.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        JDBCUtil.safeClose((Connection)conn, (Statement)ps, rs);
        try {
            fis.close();
        }
        catch (Throwable t) {}
    }

    private PluginMetadataManager getPluginMetadataManager() {
        return LookupUtil.getPluginDeploymentScanner().getPluginMetadataManager();
    }
}

