/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCacheMBean;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;

@Resource(name="cache", type=TreeCacheMBean.class, mappedName="RhqCache")
public class AbstractRestBean {
    Log log = LogFactory.getLog((String)this.getClass().getName());
    protected Subject caller;
    @Resource(name="cache")
    TreeCacheMBean treeCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String renderTemplate(String templateName, Object objectToRender) {
        block7: {
            String string;
            Configuration config = new Configuration();
            ClassTemplateLoader ctl = new ClassTemplateLoader(this.getClass(), "/rest_templates/");
            TemplateLoader[] loaders = new TemplateLoader[]{ctl};
            MultiTemplateLoader mtl = new MultiTemplateLoader(loaders);
            config.setTemplateLoader((TemplateLoader)mtl);
            if (!templateName.endsWith(".ftl")) {
                templateName = templateName + ".ftl";
            }
            Template template = config.getTemplate(templateName);
            StringWriter out = new StringWriter();
            try {
                HashMap<String, Object> root = new HashMap<String, Object>();
                root.put("var", objectToRender);
                template.process(root, (Writer)out);
                string = out.toString();
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    this.log.error((Object)ioe);
                    break block7;
                }
                catch (TemplateException te) {
                    this.log.error((Object)te.getMessage());
                }
            }
            out.close();
            return string;
        }
        return null;
    }

    protected <T> T getFromCache(int id, Class<T> clazz) {
        Fqn fqn = this.getFqn(id, clazz);
        return this.getFromCache(fqn, clazz);
    }

    protected <T> T getFromCache(Fqn fqn, Class<T> clazz) {
        Object o = null;
        if (this.treeCache.exists(fqn)) {
            this.log.debug((Object)("Hit for " + fqn.toString()));
            try {
                Node n = this.treeCache.get(fqn);
                Set readers = (Set)n.get((Object)"readers");
                if (readers.contains(this.caller.getId())) {
                    o = n.get((Object)"item");
                } else {
                    this.log.debug((Object)("No object for caller " + this.caller.toString() + " found"));
                }
            }
            catch (CacheException e) {
                this.log.debug((Object)("Miss for " + fqn.toString()));
            }
        }
        return (T)o;
    }

    protected <T> boolean putToCache(Fqn fqn, T o) {
        boolean success = false;
        try {
            Set<Integer> readers;
            if (this.treeCache.exists(fqn)) {
                Node n = this.treeCache.get(fqn);
                readers = (Set)n.get((Object)"readers");
            } else {
                readers = new HashSet<Integer>();
            }
            readers.add(this.caller.getId());
            this.treeCache.put(fqn, (Object)"readers", readers);
            this.treeCache.put(fqn, (Object)"item", o);
            success = true;
            this.log.debug((Object)("Put " + fqn));
        }
        catch (CacheException e) {
            this.log.warn((Object)e.getMessage());
        }
        return success;
    }

    protected <T> boolean putToCache(int id, Class<T> clazz, T o) {
        Fqn fqn = this.getFqn(id, clazz);
        return this.putToCache(fqn, o);
    }

    protected void putResourceToCache(org.rhq.core.domain.resource.Resource res) {
        this.putToCache(res.getId(), org.rhq.core.domain.resource.Resource.class, res);
        Fqn callerFqn = new Fqn((Object[])new String[]{"user", String.valueOf(this.caller.getId()), "resources"});
        try {
            Set<Integer> visibleResources;
            if (this.treeCache.exists(callerFqn)) {
                Node n = this.treeCache.get(callerFqn);
                visibleResources = (Set)n.get((Object)"visibleResources");
            } else {
                visibleResources = new HashSet<Integer>();
            }
            visibleResources.add(res.getId());
            this.treeCache.put(callerFqn, (Object)"visibleResources", visibleResources);
            Fqn resourceMeta = new Fqn((Object[])new String[]{"resourceMeta"});
            Map childParentMap = this.treeCache.exists(resourceMeta) ? (Map)this.treeCache.get(resourceMeta, (Object)"childParentMap") : new HashMap();
            int pid = res.getParentResource() == null ? 0 : res.getParentResource().getId();
            childParentMap.put(res.getId(), pid);
            this.treeCache.put(resourceMeta, (Object)"childParentMap", childParentMap);
        }
        catch (CacheException e) {
            this.log.warn((Object)e.getMessage());
        }
    }

    protected List<org.rhq.core.domain.resource.Resource> getResourcesFromCacheByParentId(int pid) {
        ArrayList candidateIds = new ArrayList();
        ArrayList<org.rhq.core.domain.resource.Resource> ret = new ArrayList<org.rhq.core.domain.resource.Resource>();
        Fqn resourceMeta = new Fqn((Object[])new String[]{"resourceMeta"});
        if (this.treeCache.exists(resourceMeta)) {
            try {
                Map childParentMap = (Map)this.treeCache.get(resourceMeta, (Object)"childParentMap");
                for (Map.Entry entry : childParentMap.entrySet()) {
                    if ((Integer)entry.getValue() != pid) continue;
                    candidateIds.add(entry.getKey());
                }
                Fqn callerFqn = new Fqn((Object[])new String[]{"user", String.valueOf(this.caller.getId()), "resources"});
                Set visibleResources = (Set)this.treeCache.get(callerFqn, (Object)"visibleResources");
                Iterator iter = candidateIds.iterator();
                while (iter.hasNext()) {
                    Integer resId = (Integer)iter.next();
                    if (visibleResources.contains(resId)) continue;
                    iter.remove();
                }
                for (Integer resId : candidateIds) {
                    ret.add(this.getFromCache(resId, org.rhq.core.domain.resource.Resource.class));
                }
            }
            catch (CacheException e) {
                this.log.warn((Object)e.getMessage());
            }
        }
        return ret;
    }

    protected org.rhq.core.domain.resource.Resource getResourceFromCache(int resourceid) {
        org.rhq.core.domain.resource.Resource res = null;
        Fqn callerFqn = new Fqn((Object[])new String[]{"user", String.valueOf(this.caller.getId()), "resources"});
        if (this.treeCache.exists(callerFqn)) {
            try {
                Set visibleResources = (Set)this.treeCache.get(callerFqn, (Object)"visibleResources");
                if (visibleResources.contains(resourceid)) {
                    res = this.getFromCache(resourceid, org.rhq.core.domain.resource.Resource.class);
                }
            }
            catch (CacheException e) {
                this.log.warn((Object)e.getMessage());
            }
        }
        return res;
    }

    protected <T> Fqn getFqn(int id, Class<T> clazz) {
        return new Fqn(new Object[]{clazz.getName(), String.valueOf(id)});
    }

    protected <T> boolean removeFromCache(int operationId, Class<T> clazz) {
        Fqn fqn = this.getFqn(operationId, clazz);
        if (this.treeCache.exists(fqn)) {
            try {
                this.treeCache.remove(fqn);
                this.log.debug((Object)("Cancel " + fqn));
                return true;
            }
            catch (CacheException e) {
                return false;
            }
        }
        return true;
    }

    public ResourceWithType fillRWT(org.rhq.core.domain.resource.Resource res, UriInfo uriInfo) {
        ResourceType resourceType = res.getResourceType();
        ResourceWithType rwt = new ResourceWithType(res.getName(), res.getId());
        rwt.setTypeName(resourceType.getName());
        rwt.setTypeId(resourceType.getId());
        rwt.setPluginName(resourceType.getPlugin());
        org.rhq.core.domain.resource.Resource parent = res.getParentResource();
        if (parent != null) {
            rwt.setParentId(parent.getId());
        } else {
            rwt.setParentId(0);
        }
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/operation/definitions");
        uriBuilder.queryParam("resourceId", new Object[]{res.getId()});
        URI uri = uriBuilder.build(new Object[0]);
        Link link = new Link("operationDefinitions", uri.toString());
        rwt.addLink(link);
        uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/resource/{id}");
        uri = uriBuilder.build(new Object[]{res.getId()});
        link = new Link("self", uri.toString());
        rwt.addLink(link);
        uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/resource/{id}/schedules");
        uri = uriBuilder.build(new Object[]{res.getId()});
        link = new Link("schedules", uri.toString());
        rwt.addLink(link);
        uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/resource/{id}/children");
        uri = uriBuilder.build(new Object[]{res.getId()});
        link = new Link("children", uri.toString());
        rwt.addLink(link);
        if (parent != null) {
            uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/{id}/");
            uri = uriBuilder.build(new Object[]{parent.getId()});
            link = new Link("parent", uri.toString());
            rwt.addLink(link);
        }
        return rwt;
    }
}

