/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.criteria.ResourceGroupCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.resource.group.ResourceGroupDeleteException;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.GroupHandlerLocal;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.GroupRest;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;

@Stateless
@Interceptors(value={SetCallerInterceptor.class})
public class GroupHandlerBean
extends AbstractRestBean
implements GroupHandlerLocal {
    private final Log log = LogFactory.getLog(GroupHandlerBean.class);
    @EJB
    ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    ResourceManagerLocal resourceManager;
    @EJB
    ResourceTypeManagerLocal resourceTypeManager;

    @Override
    public Response getGroups(@Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        ResourceGroupCriteria criteria = new ResourceGroupCriteria();
        PageList<ResourceGroup> groups = this.resourceGroupManager.findResourceGroupsByCriteria(this.caller, criteria);
        ArrayList<GroupRest> list = new ArrayList<GroupRest>(groups.size());
        for (ResourceGroup group : groups) {
            list.add(this.fillGroup(group, uriInfo));
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listGroup", list), (MediaType)mediaType);
        } else {
            GenericEntity<List<GroupRest>> ret = new GenericEntity<List<GroupRest>>(list){};
            builder = Response.ok((Object)ret);
        }
        return builder.build();
    }

    @Override
    @GET
    @Path(value="{id}")
    public Response getGroup(@PathParam(value="id") int id, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        ResourceGroup group = this.fetchGroup(id);
        GroupRest groupRest = this.fillGroup(group, uriInfo);
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        Response.ResponseBuilder builder = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("group", groupRest), (MediaType)mediaType) : Response.ok((Object)groupRest, (MediaType)mediaType);
        return builder.build();
    }

    @Override
    @POST
    @Path(value="/")
    public Response createGroup(GroupRest group, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        ResourceGroup newGroup = new ResourceGroup(group.getName());
        if (group.getResourceTypeId() != null) {
            ResourceType resourceType = null;
            try {
                resourceType = this.resourceTypeManager.getResourceTypeById(this.caller, group.getResourceTypeId());
                newGroup.setResourceType(resourceType);
            }
            catch (ResourceTypeNotFoundException e) {
                e.printStackTrace();
                throw new StuffNotFoundException("ResourceType with id " + group.getResourceTypeId());
            }
        }
        try {
            newGroup = this.resourceGroupManager.createResourceGroup(this.caller, newGroup);
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/group/{id}");
            URI uri = uriBuilder.build(new Object[]{newGroup.getId()});
            builder = Response.created((URI)uri);
            this.putToCache(newGroup.getId(), ResourceGroup.class, newGroup);
        }
        catch (Exception e) {
            e.printStackTrace();
            builder = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE);
        }
        return builder.build();
    }

    @Override
    @PUT
    @Path(value="{id}")
    public Response updateGroup(@PathParam(value="id") int id, GroupRest in, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        ResourceGroup resourceGroup = this.fetchGroup(id);
        resourceGroup.setName(in.getName());
        try {
            resourceGroup = this.resourceGroupManager.updateResourceGroup(this.caller, resourceGroup);
            builder = Response.ok((Object)this.fillGroup(resourceGroup, uriInfo));
            this.putToCache(resourceGroup.getId(), ResourceGroup.class, resourceGroup);
        }
        catch (Exception e) {
            builder = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE);
        }
        return builder.build();
    }

    @Override
    @DELETE
    @Path(value="{id}")
    public Response deleteGroup(@PathParam(value="id") int id, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        try {
            this.resourceGroupManager.deleteResourceGroup(this.caller, id);
            this.removeFromCache(id, ResourceGroup.class);
            return Response.ok().build();
        }
        catch (ResourceGroupDeleteException e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
    }

    @Override
    @GET
    @Path(value="{id}/resources")
    public Response getResources(@PathParam(value="id") int id, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        ResourceGroup resourceGroup = this.fetchGroup(id);
        Set resources = resourceGroup.getExplicitResources();
        ArrayList<ResourceWithType> rwtList = new ArrayList<ResourceWithType>(resources.size());
        for (Resource res : resources) {
            rwtList.add(this.fillRWT(res, uriInfo));
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listResourceWithType", rwtList), (MediaType)mediaType);
        } else {
            GenericEntity<List<ResourceWithType>> list = new GenericEntity<List<ResourceWithType>>(rwtList){};
            builder = Response.ok((Object)list);
        }
        return builder.build();
    }

    @Override
    @PUT
    @Path(value="{id}/resource/{resourceId}")
    public Response addResource(@PathParam(value="id") int id, @PathParam(value="resourceId") int resourceId, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        ResourceGroup resourceGroup = this.fetchGroup(id);
        Resource res = this.resourceManager.getResource(this.caller, resourceId);
        if (res == null) {
            throw new StuffNotFoundException("Resource with id " + resourceId);
        }
        if (resourceGroup.getResourceType() != null && !res.getResourceType().equals((Object)resourceGroup.getResourceType())) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        resourceGroup.addExplicitResource(res);
        return Response.ok().build();
    }

    @Override
    @DELETE
    @Path(value="{id}/resource/{resourceId}")
    public Response removeResource(@PathParam(value="id") int id, @PathParam(value="resourceId") int resourceId, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        ResourceGroup resourceGroup = this.fetchGroup(id);
        Resource res = this.resourceManager.getResource(this.caller, resourceId);
        if (res == null) {
            throw new StuffNotFoundException("Resource with id " + resourceId);
        }
        resourceGroup.removeExplicitResource(res);
        return Response.ok().build();
    }

    private ResourceGroup fetchGroup(int groupId) {
        ResourceGroup resourceGroup = this.getFromCache(groupId, ResourceGroup.class);
        if (resourceGroup == null) {
            resourceGroup = this.resourceGroupManager.getResourceGroup(this.caller, groupId);
            if (resourceGroup == null) {
                throw new StuffNotFoundException("Group with id " + groupId);
            }
            this.putToCache(groupId, ResourceGroup.class, resourceGroup);
        }
        return resourceGroup;
    }

    private GroupRest fillGroup(ResourceGroup group, UriInfo uriInfo) {
        GroupRest gr = new GroupRest(group.getName());
        gr.setId(group.getId());
        gr.setCategory(group.getGroupCategory());
        gr.setRecursive(group.isRecursive());
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/group/{id}");
        URI uri = uriBuilder.build(new Object[]{group.getId()});
        Link link = new Link("edit", uri.toASCIIString());
        gr.getLinks().add(link);
        return gr;
    }
}

