/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.criteria.ResourceOperationHistoryCriteria;
import org.rhq.core.domain.operation.HistoryJobId;
import org.rhq.core.domain.operation.JobId;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.operation.bean.ResourceOperationSchedule;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.OperationsHandlerLocal;
import org.rhq.enterprise.server.rest.ParameterMissingException;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.domain.OperationDefinitionRest;
import org.rhq.enterprise.server.rest.domain.OperationHistoryRest;
import org.rhq.enterprise.server.rest.domain.OperationRest;

@Stateless
@Interceptors(value={SetCallerInterceptor.class})
public class OperationsHandlerBean
extends AbstractRestBean
implements OperationsHandlerLocal {
    @EJB
    OperationManagerLocal opsManager;
    @EJB
    ResourceManagerLocal resourceManager;

    @Override
    public Response getOperationDefinition(int definitionId, Integer resourceId, UriInfo uriInfo, Request request, HttpHeaders httpHeaders) {
        EntityTag eTag;
        Response.ResponseBuilder builder;
        OperationDefinition def = this.getFromCache(definitionId, OperationDefinition.class);
        if (def == null) {
            def = this.opsManager.getOperationDefinition(this.caller, definitionId);
            if (def == null) {
                throw new StuffNotFoundException("OperationDefinition with id " + definitionId);
            }
            this.putToCache(definitionId, OperationDefinition.class, def);
        }
        if ((builder = request.evaluatePreconditions(eTag = new EntityTag(Integer.toHexString(def.hashCode())))) == null) {
            OperationDefinitionRest odr = new OperationDefinitionRest();
            odr.setId(def.getId());
            odr.setName(def.getName());
            builder = Response.ok((Object)odr);
            if (resourceId != null) {
                UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
                uriBuilder.path("/operation/definition/{id}");
                uriBuilder.queryParam("resourceId", new Object[]{resourceId});
                Link createLink = new Link("create", uriBuilder.build(new Object[]{definitionId}).toString());
                odr.addLink(createLink);
            }
        }
        builder.tag(eTag);
        return builder.build();
    }

    @Override
    public Response getOperationDefinitions(Integer resourceId, UriInfo uriInfo, Request request) {
        if (resourceId == null) {
            throw new ParameterMissingException("resourceId");
        }
        Resource res = this.resourceManager.getResource(this.caller, resourceId);
        if (res == null) {
            throw new StuffNotFoundException("resource with id " + resourceId);
        }
        ResourceType resourceType = res.getResourceType();
        EntityTag eTag = new EntityTag(Integer.toHexString(resourceType.hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            Set opDefList = resourceType.getOperationDefinitions();
            ArrayList<OperationDefinitionRest> resultList = new ArrayList<OperationDefinitionRest>(opDefList.size());
            for (OperationDefinition def : opDefList) {
                this.putToCache(def.getId(), OperationDefinition.class, def);
                OperationDefinitionRest odr = new OperationDefinitionRest();
                odr.setId(def.getId());
                odr.setName(def.getName());
                UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
                uriBuilder.path("/operation/definition/{id}");
                uriBuilder.queryParam("resourceId", new Object[]{resourceId});
                Link createLink = new Link("create", uriBuilder.build(new Object[]{def.getId()}).toString());
                odr.addLink(createLink);
                resultList.add(odr);
            }
            GenericEntity<List<OperationDefinitionRest>> entity = new GenericEntity<List<OperationDefinitionRest>>(resultList){};
            builder = Response.ok((Object)entity);
        }
        builder.tag(eTag);
        return builder.build();
    }

    @Override
    public Response createOperation(@PathParam(value="id") int definitionId, @QueryParam(value="resourceId") Integer resourceId, UriInfo uriInfo) {
        if (resourceId == null) {
            throw new ParameterMissingException("resourceId");
        }
        Resource res = this.resourceManager.getResource(this.caller, resourceId);
        if (res == null) {
            throw new StuffNotFoundException("resource with id " + resourceId);
        }
        OperationDefinition opDef = this.opsManager.getOperationDefinition(this.caller, definitionId);
        if (opDef == null) {
            throw new StuffNotFoundException("Operation definition with id " + definitionId);
        }
        OperationRest operationRest = new OperationRest(resourceId, definitionId);
        operationRest.setId((int)System.currentTimeMillis());
        operationRest.setState("creating");
        operationRest.setName(opDef.getName());
        ConfigurationDefinition paramDefinition = opDef.getParametersConfigurationDefinition();
        if (paramDefinition != null) {
            for (PropertyDefinition propDefs : paramDefinition.getNonGroupedProperties()) {
                operationRest.getParams().put(propDefs.getName(), "TODO");
            }
        }
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/operation/{id}");
        URI uri = uriBuilder.build(new Object[]{operationRest.getId()});
        Link editLink = new Link("edit", uri.toString());
        operationRest.addLink(editLink);
        Response.ResponseBuilder builder = Response.ok((Object)operationRest);
        this.putToCache(operationRest.getId(), OperationRest.class, operationRest);
        return builder.build();
    }

    @Override
    public Response getOperation(@PathParam(value="id") int operationId) {
        OperationRest op = this.getFromCache(operationId, OperationRest.class);
        if (op == null) {
            throw new StuffNotFoundException("Operation with id " + operationId);
        }
        return Response.ok((Object)op).build();
    }

    @Override
    public Response updateOperation(@PathParam(value="id") int operationId, OperationRest operation, UriInfo uriInfo) {
        if (operation.getState().equals("creating") && operation.getDefinitionId() > 0 && !operation.getName().isEmpty()) {
            operation.setState("ready");
        }
        if (operation.getState().equals("ready")) {
            Configuration parameters = new Configuration();
            for (Map.Entry<String, Object> entry : operation.getParams().entrySet()) {
                parameters.put((Property)new PropertySimple(entry.getKey(), entry.getValue()));
            }
            ResourceOperationSchedule sched = this.opsManager.scheduleResourceOperation(this.caller, operation.getResourceId(), operation.getName(), 0L, 0L, 0, -1, parameters, "TEst");
            JobId jobId = new JobId(sched.getJobName(), sched.getJobGroup());
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/operation/history/{id}");
            URI uri = uriBuilder.build(new Object[]{jobId});
            Link histLink = new Link("history", uri.toString());
            operation.addLink(histLink);
        } else {
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/operation/{id}");
            URI uri = uriBuilder.build(new Object[]{operation.getId()});
            Link editLink = new Link("edit", uri.toString());
            operation.addLink(editLink);
        }
        this.putToCache(operation.getId(), OperationRest.class, operation);
        Response.ResponseBuilder builder = Response.ok((Object)operation);
        return builder.build();
    }

    @Override
    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json", "application/xml"})
    public Response cancelOperation(@PathParam(value="id") int operationId) {
        this.log.info((Object)"Cancel called");
        this.removeFromCache(operationId, OperationRest.class);
        return null;
    }

    @Override
    @GET
    @Path(value="history/{id}")
    public Response outcome(@PathParam(value="id") String jobName, @Context UriInfo uriInfo) {
        ResourceOperationHistoryCriteria criteria = new ResourceOperationHistoryCriteria();
        criteria.addFilterJobId(new JobId(jobName));
        PageList<ResourceOperationHistory> list = this.opsManager.findResourceOperationHistoriesByCriteria(this.caller, criteria);
        if (list == null || list.isEmpty()) {
            this.log.info((Object)("No history with id " + new HistoryJobId(jobName) + " found"));
            throw new StuffNotFoundException("OperationHistory with id " + new HistoryJobId(jobName));
        }
        ResourceOperationHistory history = (ResourceOperationHistory)list.get(0);
        String status = history.getStatus() == null ? " - no infomation yet -" : history.getStatus().getDisplayName();
        OperationHistoryRest hist = new OperationHistoryRest();
        hist.setStatus(status);
        if (history.getErrorMessage() != null) {
            hist.setErrorMessage(history.getErrorMessage());
        }
        if (history.getResults() != null) {
            Configuration results = history.getResults();
            for (Property p : results.getProperties()) {
                hist.getResult().put(p.getName(), p.toString());
            }
        }
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/operation/history/{id}");
        URI url = uriBuilder.build(new Object[]{new JobId(jobName)});
        Link self = new Link("self", url.toString());
        hist.getLinks().add(self);
        return Response.ok((Object)hist).build();
    }
}

