/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.ResourceHandlerLocal;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.AvailabilityRest;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.domain.MetricSchedule;
import org.rhq.enterprise.server.rest.domain.ResourceWithChildren;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;

@Interceptors(value={SetCallerInterceptor.class})
@Stateless
public class ResourceHandlerBean
extends AbstractRestBean
implements ResourceHandlerLocal {
    @EJB
    ResourceManagerLocal resMgr;
    @EJB
    AvailabilityManagerLocal availMgr;
    @EJB
    MeasurementScheduleManagerLocal scheduleManager;
    @EJB
    AlertManagerLocal alertManager;

    @Override
    public Response getResource(int id, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        EntityTag eTag;
        Resource res = this.fetchResource(id);
        long mtime = res.getMtime();
        Response.ResponseBuilder builder = request.evaluatePreconditions(new Date(mtime), eTag = new EntityTag(Long.toOctalString((long)res.hashCode() + mtime)));
        if (builder != null) {
            return builder.build();
        }
        ResourceWithType rwt = this.fillRWT(res, uriInfo);
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        builder = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("resourceWithType", rwt), (MediaType)mediaType) : Response.ok((Object)rwt);
        return builder.build();
    }

    @Override
    public Response getPlatforms(@Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        PageControl pc = new PageControl();
        PageList<Resource> ret = this.resMgr.findResourcesByCategory(this.caller, ResourceCategory.PLATFORM, InventoryStatus.COMMITTED, pc);
        ArrayList<ResourceWithType> rwtList = new ArrayList<ResourceWithType>(ret.size());
        for (Resource r : ret) {
            this.putToCache(r.getId(), Resource.class, r);
            ResourceWithType rwt = this.fillRWT(r, uriInfo);
            rwtList.add(rwt);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listResourceWithType", rwtList), (MediaType)mediaType);
        } else {
            GenericEntity<List<ResourceWithType>> list = new GenericEntity<List<ResourceWithType>>(rwtList){};
            builder = Response.ok((Object)list);
        }
        return builder.build();
    }

    @Override
    public ResourceWithChildren getHierarchy(int baseResourceId) {
        Resource start = this.obtainResource(baseResourceId);
        ResourceWithChildren rwc = this.getHierarchy(start);
        return rwc;
    }

    ResourceWithChildren getHierarchy(Resource baseResource) {
        ResourceWithChildren rwc = new ResourceWithChildren("" + baseResource.getId(), baseResource.getName());
        PageControl pc = new PageControl();
        PageList<Resource> ret = this.resMgr.findResourceByParentAndInventoryStatus(this.caller, baseResource, InventoryStatus.COMMITTED, pc);
        if (!ret.isEmpty()) {
            ArrayList<ResourceWithChildren> resList = new ArrayList<ResourceWithChildren>(ret.size());
            for (Resource res : ret) {
                ResourceWithChildren child = this.getHierarchy(res);
                resList.add(child);
                this.putToCache(res.getId(), Resource.class, res);
            }
            if (!resList.isEmpty()) {
                rwc.setChildren(resList);
            }
        }
        return rwc;
    }

    @Override
    public AvailabilityRest getAvailability(int resourceId) {
        Availability avail = this.availMgr.getCurrentAvailabilityForResource(this.caller, resourceId);
        AvailabilityRest availabilityRest = avail.getAvailabilityType() != null ? new AvailabilityRest(avail.getAvailabilityType(), avail.getStartTime(), avail.getResource().getId()) : new AvailabilityRest(avail.getStartTime(), resourceId);
        return availabilityRest;
    }

    @Override
    public void reportAvailability(int resourceId, AvailabilityRest avail) {
        if (avail.getResourceId() != resourceId) {
            throw new IllegalArgumentException("Resource Ids do not match");
        }
        Resource resource = this.obtainResource(resourceId);
        AvailabilityType at = AvailabilityType.valueOf((String)avail.getType());
        AvailabilityReport report = new AvailabilityReport(true, resource.getAgent().getName());
        Availability availability = new Availability(resource, Long.valueOf(avail.getSince()), at);
        report.addAvailability(availability);
        this.availMgr.mergeAvailabilityReport(report);
    }

    @Override
    public Response getSchedules(int resourceId, String scheduleType, boolean enabledOnly, String name, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        if (scheduleType.equals("metric")) {
            scheduleType = DataType.MEASUREMENT.toString().toLowerCase();
        }
        Resource res = this.resMgr.getResource(this.caller, resourceId);
        Set schedules = res.getSchedules();
        ArrayList<MetricSchedule> ret = new ArrayList<MetricSchedule>(schedules.size());
        for (MeasurementSchedule schedule : schedules) {
            URI uri;
            UriBuilder uriBuilder;
            this.putToCache(schedule.getId(), MeasurementSchedule.class, schedule);
            MeasurementDefinition definition = schedule.getDefinition();
            if (!"all".equals(scheduleType) && !scheduleType.toLowerCase().equals(definition.getDataType().toString().toLowerCase()) || enabledOnly && (!enabledOnly || !schedule.isEnabled()) || name != null && (name == null || !name.equals(definition.getName()))) continue;
            MetricSchedule ms = new MetricSchedule(schedule.getId(), definition.getName(), definition.getDisplayName(), schedule.isEnabled(), schedule.getInterval(), definition.getUnits().toString(), definition.getDataType().toString());
            if (definition.getDataType() == DataType.MEASUREMENT) {
                uriBuilder = uriInfo.getBaseUriBuilder();
                uriBuilder.path("/metric/data/{id}");
                uri = uriBuilder.build(new Object[]{schedule.getId()});
                Link metricLink = new Link("metric", uri.toString());
                ms.addLink(metricLink);
            }
            uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("resource/" + schedule.getResource().getId());
            uri = uriBuilder.build(new Object[0]);
            Link link = new Link("resource", uri.toString());
            ms.addLink(link);
            ret.add(ms);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listMetricSchedule", ret), (MediaType)mediaType);
        } else {
            GenericEntity<List<MetricSchedule>> list = new GenericEntity<List<MetricSchedule>>(ret){};
            builder = Response.ok((Object)list, (MediaType)mediaType);
        }
        return builder.build();
    }

    @Override
    public Response getChildren(int id, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        PageControl pc = new PageControl();
        Resource parent = this.fetchResource(id);
        PageList<Resource> ret = this.resMgr.findResourceByParentAndInventoryStatus(this.caller, parent, InventoryStatus.COMMITTED, pc);
        ArrayList<ResourceWithType> rwtList = new ArrayList<ResourceWithType>(ret.size());
        for (Resource r : ret) {
            ResourceWithType rwt = this.fillRWT(r, uriInfo);
            rwtList.add(rwt);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listResourceWithType", rwtList), (MediaType)mediaType);
        } else {
            GenericEntity<List<ResourceWithType>> list = new GenericEntity<List<ResourceWithType>>(rwtList){};
            builder = Response.ok((Object)list);
        }
        return builder.build();
    }

    private Resource obtainResource(int resourceId) {
        Resource resource = this.getFromCache(resourceId, Resource.class);
        if (resource == null && (resource = this.resMgr.getResource(this.caller, resourceId)) != null) {
            this.putToCache(resourceId, Resource.class, resource);
        }
        return resource;
    }

    @Override
    public List<Link> getAlertsForResource(int resourceId) {
        AlertCriteria criteria = new AlertCriteria();
        criteria.addFilterResourceIds(new Integer[]{resourceId});
        PageList<Alert> alerts = this.alertManager.findAlertsByCriteria(this.caller, criteria);
        ArrayList<Link> links = new ArrayList<Link>(alerts.size());
        for (Alert al : alerts) {
            Link link = new Link();
            link.setRel("alert");
            link.setHref("/alert/" + al.getId());
            links.add(link);
        }
        return links;
    }

    private Resource fetchResource(int resourceId) {
        Resource res = this.getFromCache(resourceId, Resource.class);
        if (res == null) {
            res = this.resMgr.getResource(this.caller, resourceId);
            if (res != null) {
                this.putToCache(resourceId, Resource.class, res);
            } else {
                throw new StuffNotFoundException("Resource with id " + resourceId);
            }
        }
        return res;
    }
}

