/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.reporting;

import java.util.LinkedHashMap;
import java.util.List;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.StreamingOutput;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.drift.DriftComplianceStatus;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.composite.ResourceInstallCount;
import org.rhq.enterprise.server.rest.ReportsInterceptor;
import org.rhq.enterprise.server.rest.reporting.DriftComplianceLocal;
import org.rhq.enterprise.server.rest.reporting.InventorySummaryHandler;
import org.rhq.enterprise.server.rest.reporting.PropertyConverter;

@Interceptors(value={ReportsInterceptor.class})
@Stateless
public class DriftComplianceHandler
extends InventorySummaryHandler
implements DriftComplianceLocal {
    @Override
    public StreamingOutput generateReport(HttpServletRequest request, String resourceTypeId, String version) {
        return super.generateReport(request, resourceTypeId, version);
    }

    @Override
    protected List<ResourceInstallCount> getSummaryCounts() {
        return this.resourceMgr.findResourceComplianceCounts(this.caller);
    }

    @Override
    protected ResourceCriteria getDetailsQueryCriteria(Integer resourceTypeId, String version) {
        ResourceCriteria criteria = super.getDetailsQueryCriteria(resourceTypeId, version);
        criteria.fetchDriftDefinitions(true);
        return criteria;
    }

    @Override
    protected String getHeader() {
        return super.getHeader() + ",In Compliance?";
    }

    @Override
    protected String getDetailsHeader() {
        return "Resource Type,Plugin,Category,Version,Name,Ancestry,Description,Availability,In Compliance?,Details URL";
    }

    @Override
    protected List<String> getColumns() {
        List<String> columns = super.getColumns();
        columns.add("inCompliance");
        return columns;
    }

    @Override
    protected List<String> getDetailsColumns() {
        List<String> columns = super.getDetailsColumns();
        columns.add(columns.size() - 1, "inCompliance");
        return columns;
    }

    @Override
    protected LinkedHashMap<String, PropertyConverter<Resource>> getPropertyConverters(HttpServletRequest request) {
        LinkedHashMap<String, PropertyConverter<Resource>> propertyConverters = super.getPropertyConverters(request);
        propertyConverters.put("inCompliance", new PropertyConverter<Resource>(){

            @Override
            public Object convert(Resource resource, String propertyName) {
                for (DriftDefinition def : resource.getDriftDefinitions()) {
                    if (def.getComplianceStatus() == DriftComplianceStatus.IN_COMPLIANCE) continue;
                    return false;
                }
                return true;
            }
        });
        return propertyConverters;
    }

    @Override
    protected String getDebugReportName() {
        return "drift compliance";
    }
}

