/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.reporting;

import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.resource.composite.PlatformMetricsSummary;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.resource.PlatformUtilizationManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.ReportsInterceptor;
import org.rhq.enterprise.server.rest.reporting.CsvWriter;
import org.rhq.enterprise.server.rest.reporting.PlatformUtilizationLocal;
import org.rhq.enterprise.server.rest.reporting.PropertyConverter;

@Interceptors(value={ReportsInterceptor.class})
@Stateless
public class PlatformUtilizationHandler
extends AbstractRestBean
implements PlatformUtilizationLocal {
    private final Log log = LogFactory.getLog(PlatformUtilizationHandler.class);
    @EJB
    private PlatformUtilizationManagerLocal platformUtilizationMgr;

    @Override
    public StreamingOutput generateReport(HttpServletRequest request) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received request to generate report for " + this.caller));
        }
        return new StreamingOutput(){
            private NumberFormat numberFormat = NumberFormat.getPercentInstance();
            {
                this.numberFormat.setMaximumFractionDigits(2);
            }

            public void write(OutputStream output) throws IOException, WebApplicationException {
                CsvWriter<PlatformMetricsSummary> csvWriter = new CsvWriter<PlatformMetricsSummary>();
                csvWriter.setColumns("resource.name", "resource.version", "CPUUsage", "memoryUsage", "swapUsage");
                csvWriter.setPropertyConverter("CPUUsage", new PropertyConverter<PlatformMetricsSummary>(){

                    @Override
                    public Object convert(PlatformMetricsSummary summary, String propertyName) {
                        return this.calculateCPUUsage(summary);
                    }
                });
                csvWriter.setPropertyConverter("memoryUsage", new PropertyConverter<PlatformMetricsSummary>(){

                    @Override
                    public Object convert(PlatformMetricsSummary summary, String propertyName) {
                        return this.calculateMemoryUsage(summary);
                    }
                });
                csvWriter.setPropertyConverter("swapUsage", new PropertyConverter<PlatformMetricsSummary>(){

                    @Override
                    public Object convert(PlatformMetricsSummary summary, String propertyName) {
                        return this.calculateSwapUsage(summary);
                    }
                });
                output.write((this.getHeader() + "\n").getBytes());
                PageList<PlatformMetricsSummary> summaries = PlatformUtilizationHandler.this.platformUtilizationMgr.loadPlatformMetrics(PlatformUtilizationHandler.this.caller);
                for (PlatformMetricsSummary summary : summaries) {
                    csvWriter.write(summary, output);
                }
            }

            private String getHeader() {
                return "Name,Version,CPU,Memory,Swap";
            }

            private String calculateCPUUsage(PlatformMetricsSummary summary) {
                if (!summary.isMetricsAvailable()) {
                    return "NA";
                }
                Double systemCPU = (Double)summary.getSystemCPU().getValue();
                Double userCPU = (Double)summary.getUserCPU().getValue();
                return this.numberFormat.format(systemCPU + userCPU);
            }

            private String calculateMemoryUsage(PlatformMetricsSummary summary) {
                if (!summary.isMetricsAvailable()) {
                    return "NA";
                }
                Double totalMemory = (Double)summary.getTotalMemory().getValue();
                Double usedMemory = (Double)summary.getActualUsedMemory().getValue();
                return this.numberFormat.format(usedMemory / totalMemory);
            }

            private String calculateSwapUsage(PlatformMetricsSummary summary) {
                if (!summary.isMetricsAvailable()) {
                    return "NA";
                }
                Double totalSwap = (Double)summary.getTotalSwap().getValue();
                Double usedSwap = (Double)summary.getUsedSwap().getValue();
                return this.numberFormat.format(usedSwap / totalSwap);
            }
        };
    }
}

