/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.test;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.PersistenceContext;
import org.hibernate.Hibernate;
import org.rhq.enterprise.server.test.AccessLocal;

@Stateless
public class AccessBean
implements AccessLocal {
    public static final int MAX_RESULTS = 2000;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager manager;
    static List<String> types = new ArrayList<String>();

    @Override
    public List<String> getKnownTypes() {
        return types;
    }

    @Override
    public List getAll(String type) {
        return this.manager.createQuery("from " + type + " d").setMaxResults(2000).getResultList();
    }

    public EntityManager getManager() {
        return this.manager;
    }

    @Override
    public List getAllDeep(String type) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        List l = this.getAll(type);
        if (l.size() == 0) {
            return l;
        }
        BeanInfo info = Introspector.getBeanInfo(l.get(0).getClass());
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        for (Object o : l) {
            for (PropertyDescriptor pd : pds) {
                if (!Collection.class.isAssignableFrom(pd.getPropertyType())) continue;
                Object v = pd.getReadMethod().invoke(o, new Object[0]);
                System.out.println(pd.getName() + ": " + v);
            }
        }
        return l;
    }

    @Override
    public List getAllFetching(String type, String ... properties) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        List l = this.getAll(type);
        if (l.size() == 0) {
            return l;
        }
        BeanInfo info = Introspector.getBeanInfo(l.get(0).getClass());
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        HashSet<String> propsToLoad = new HashSet<String>(Arrays.asList(properties));
        for (Object o : l) {
            for (PropertyDescriptor pd : pds) {
                if (!propsToLoad.contains(pd.getName())) continue;
                Object v = pd.getReadMethod().invoke(o, new Object[0]);
                System.out.println(pd.getName() + ": " + v);
            }
        }
        return l;
    }

    @Override
    public Object findDeep(String typeName, Object key) throws IllegalAccessException, IntrospectionException, InvocationTargetException, ClassNotFoundException {
        PropertyDescriptor[] pds;
        Class<?> type = Class.forName(typeName);
        BeanInfo info = Introspector.getBeanInfo(type);
        Object convertedKey = this.getConvertedKey(type, key);
        Object o = this.find(type, convertedKey);
        if (o == null) {
            return null;
        }
        for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
            Object v;
            Method m;
            if (pd.getName().equals("id")) {
                pd.getReadMethod().invoke(o, new Object[0]);
            }
            if (Collection.class.isAssignableFrom(pd.getPropertyType()) && (m = pd.getReadMethod()) != null) {
                v = pd.getReadMethod().invoke(o, new Object[0]);
            }
            if ((m = pd.getReadMethod()) == null || Hibernate.isInitialized((Object)(v = pd.getReadMethod().invoke(o, new Object[0])))) continue;
            Hibernate.initialize((Object)v);
        }
        return o;
    }

    @Override
    public void delete(String entityName, String key) {
        try {
            Class<?> type = Class.forName(entityName);
            Object objectKey = this.getConvertedKey(type, key);
            this.manager.remove(this.manager.find(type, objectKey));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public Object getConvertedKey(Class type, Object key) {
        Class keyType = this.getKeyType(type);
        System.out.println("Key type is: " + keyType);
        PropertyEditor ed = PropertyEditorManager.findEditor(keyType);
        if (ed != null) {
            ed.setAsText(String.valueOf(key));
            return ed.getValue();
        }
        return key;
    }

    public Class getKeyType(Class type) {
        Field[] fields;
        for (Field f : fields = type.getDeclaredFields()) {
            Id id = f.getAnnotation(Id.class);
            if (id == null) continue;
            return f.getType();
        }
        return Integer.class;
    }

    @Override
    public Object find(Class type, Object key) {
        return this.manager.find(type, key);
    }

    static {
        types.add("Resource");
        types.add("Agent");
        types.add("Role");
        PropertyEditorManager.registerEditor(BigInteger.class, BigIntegerEditor.class);
    }

    public static class BigIntegerEditor
    extends PropertyEditorSupport {
        BigInteger val;

        @Override
        public void setValue(Object value) {
            this.val = (BigInteger)value;
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public String getAsText() {
            return this.val.toString();
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            this.val = new BigInteger(text);
        }
    }
}

