/*
 * RHQ Management Platform
 * Copyright (C) 2005-2011 Red Hat, Inc.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package org.rhq.enterprise.server.rest;

import javax.ejb.Local;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;

import org.jboss.resteasy.annotations.GZIP;

import org.rhq.enterprise.server.rest.domain.StringValue;

/**
 * Return some status information about the system
 * @author Heiko W. Rupp
 */
@Api(value = "Provide system status information")
@Path("/status")
@Local
@Produces({"application/json","application/xml","text/html"})
public interface StatusHandlerLocal {

    @GZIP
    @ApiOperation(value="Retrieve the current configured state of the server along with some runtime information." +
            "Caller must have MANAGE_SETTINGS to access this endpoint.",
    responseClass = "Map 'values' with map of key-value pairs describing the status")
    @GET
    @Path("/")
    Response getStatus(@Context HttpHeaders httpHeaders);

    @GET
    @Path("/server")
    @ApiOperation(value = "Get the operation mode of this server")
    StringValue serverState();
}
