/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.metadata.ConfigurationMetadataParser;
import org.rhq.core.clientapi.descriptor.configuration.ConfigurationDescriptor;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertDefinitionContext;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.AbstractPropertyMap;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertDefinitionUpdateException;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.alert.AlertTemplateManagerLocal;
import org.rhq.enterprise.server.alert.GroupAlertDefinitionManagerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.plugin.ServerPluginsLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSenderInfo;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSenderPluginManager;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSenderValidationResults;
import org.rhq.enterprise.server.plugin.pc.alert.CustomAlertSenderBackingBean;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.alert.AlertPluginDescriptorType;

@Stateless
public class AlertNotificationManagerBean
implements AlertNotificationManagerLocal {
    private static final Log LOG = LogFactory.getLog(AlertNotificationManagerBean.class);
    @EJB
    private AlertDefinitionManagerLocal alertDefinitionManager;
    @EJB
    private AlertTemplateManagerLocal alertTemplateManager;
    @EJB
    private AlertManagerLocal alertManager;
    @EJB
    private GroupAlertDefinitionManagerLocal groupAlertDefintionManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private ServerPluginsLocal serverPluginsBean;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    private AlertDefinition getDetachedAlertDefinition(int alertDefinitionId) {
        AlertDefinition alertDefinition = this.alertDefinitionManager.getAlertDefinitionById(this.subjectManager.getOverlord(), alertDefinitionId);
        return alertDefinition;
    }

    @Override
    @Deprecated
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public AlertNotification addAlertNotification(Subject user, int alertDefinitionId, AlertNotification notification) throws AlertDefinitionUpdateException {
        List<String> validSenders = this.listAllAlertSenders();
        if (!validSenders.contains(notification.getSenderName())) {
            throw new AlertDefinitionUpdateException(notification.getSenderName() + " is not a valid alert sender, options are: " + validSenders);
        }
        AlertDefinition definition = this.getDetachedAlertDefinition(alertDefinitionId);
        List notifications = definition.getAlertNotifications();
        notifications.add(notification);
        this.postProcessAlertDefinition(user, definition);
        return notification;
    }

    @Override
    @Deprecated
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void updateAlertNotification(Subject subject, int alertDefinitionId, AlertNotification notification) {
        AlertDefinition alertDefinition = this.getDetachedAlertDefinition(alertDefinitionId);
        if (notification != null) {
            List notifications = alertDefinition.getAlertNotifications();
            notifications.remove(notification);
            notifications.add(notification);
        }
        this.postProcessAlertDefinition(subject, alertDefinition);
    }

    @Override
    @Deprecated
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public int removeNotifications(Subject subject, Integer alertDefinitionId, Integer[] notificationIds) {
        AlertDefinition alertDefinition = this.getDetachedAlertDefinition(alertDefinitionId);
        if (notificationIds == null || notificationIds.length == 0) {
            return 0;
        }
        HashSet<Integer> notificationIdSet = new HashSet<Integer>(Arrays.asList(notificationIds));
        List notifications = alertDefinition.getAlertNotifications();
        ArrayList<AlertNotification> toBeRemoved = new ArrayList<AlertNotification>();
        int removed = 0;
        for (AlertNotification notification : notifications) {
            if (!notificationIdSet.contains(notification.getId())) continue;
            toBeRemoved.add(notification);
            --removed;
        }
        alertDefinition.getAlertNotifications().removeAll(toBeRemoved);
        this.postProcessAlertDefinition(subject, alertDefinition);
        return removed;
    }

    @Override
    public int purgeOrphanedAlertNotifications() {
        Query purgeQuery = this.entityManager.createNamedQuery("AlertNotification.deleteOrphaned");
        return purgeQuery.executeUpdate();
    }

    private AlertDefinition postProcessAlertDefinition(Subject subject, AlertDefinition definition) {
        AlertDefinition updated = null;
        AlertDefinitionContext context = definition.getContext();
        if (context == AlertDefinitionContext.Type) {
            updated = this.alertTemplateManager.updateAlertTemplate(subject, definition, true);
        } else if (context == AlertDefinitionContext.Group) {
            updated = this.groupAlertDefintionManager.updateGroupAlertDefinitions(subject, definition, true);
        } else if (context == AlertDefinitionContext.Resource) {
            updated = this.alertDefinitionManager.updateAlertDefinition(subject, definition.getId(), definition, false);
        } else {
            throw new IllegalStateException("No support for updating alert notifications for AlertDefinitionContext: " + definition.getContext());
        }
        return updated;
    }

    @Override
    public ConfigurationDefinition getConfigurationDefinitionForSender(String shortName) {
        AlertSenderPluginManager pluginmanager = this.alertManager.getAlertPluginManager();
        AlertSenderInfo senderInfo = pluginmanager.getAlertSenderInfo(shortName);
        String pluginName = senderInfo.getPluginName();
        PluginKey key = senderInfo.getPluginKey();
        try {
            AlertPluginDescriptorType descriptor = (AlertPluginDescriptorType)this.serverPluginsBean.getServerPluginDescriptor(key);
            ConfigurationDefinition pluginConfigurationDefinition = ConfigurationMetadataParser.parse((String)("alerts:" + pluginName), (ConfigurationDescriptor)descriptor.getAlertConfiguration());
            return pluginConfigurationDefinition;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Override
    public List<String> listAllAlertSenders() {
        AlertSenderPluginManager pluginmanager = this.alertManager.getAlertPluginManager();
        List<String> senders = pluginmanager.getPluginList();
        return senders;
    }

    @Override
    public AlertSenderInfo getAlertInfoForSender(String shortName) {
        AlertSenderPluginManager pluginmanager = this.alertManager.getAlertPluginManager();
        AlertSenderInfo info = pluginmanager.getAlertSenderInfo(shortName);
        return info;
    }

    @Override
    public CustomAlertSenderBackingBean getBackingBeanForSender(String shortName, Integer alertNotificationId) {
        AlertNotification notification;
        AlertSenderPluginManager pluginmanager = this.alertManager.getAlertPluginManager();
        CustomAlertSenderBackingBean bean = pluginmanager.getBackingBeanForSender(shortName);
        if (alertNotificationId != null && (notification = (AlertNotification)this.entityManager.find(AlertNotification.class, (Object)alertNotificationId)) != null && bean != null) {
            bean.setAlertParameters(notification.getConfiguration().deepCopy(true));
            if (notification.getExtraConfiguration() != null) {
                bean.setExtraParameters(notification.getExtraConfiguration().deepCopy(true));
            }
        }
        return bean;
    }

    @Override
    public String getBackingBeanNameForSender(String shortName) {
        AlertSenderPluginManager pluginmanager = this.alertManager.getAlertPluginManager();
        return pluginmanager.getBackingBeanNameForSender(shortName);
    }

    @Override
    public List<AlertNotification> getNotificationsForAlertDefinition(Subject user, int alertDefinitionId) {
        AlertDefinition definition = this.alertDefinitionManager.getAlertDefinition(user, alertDefinitionId);
        if (definition == null) {
            LOG.error((Object)("Did not find definition for id [" + alertDefinitionId + "]"));
            return new ArrayList<AlertNotification>();
        }
        List notifications = definition.getAlertNotifications();
        for (AlertNotification notification : notifications) {
            notification.getConfiguration().getProperties().size();
            if (notification.getExtraConfiguration() == null) continue;
            notification.getExtraConfiguration().getProperties().size();
        }
        return notifications;
    }

    @Override
    public AlertNotification getAlertNotification(Subject user, int alertNotificationId) {
        AlertNotification notification = (AlertNotification)this.entityManager.find(AlertNotification.class, (Object)alertNotificationId);
        if (notification == null) {
            return null;
        }
        notification.getConfiguration().getProperties().size();
        if (notification.getExtraConfiguration() != null) {
            notification.getExtraConfiguration().getProperties().size();
        }
        return notification;
    }

    @Override
    public boolean finalizeNotifications(Subject subject, List<AlertNotification> notifications) {
        boolean hasErrors = false;
        if (notifications != null && notifications.size() > 0) {
            AlertSenderPluginManager pluginManager = this.alertManager.getAlertPluginManager();
            for (AlertNotification notification : notifications) {
                AlertSender sender = pluginManager.getAlertSenderForNotification(notification);
                if (sender == null) continue;
                AlertSenderValidationResults validation = sender.validateAndFinalizeConfiguration(subject);
                notification.setConfiguration(validation.getAlertParameters());
                notification.setExtraConfiguration(validation.getExtraParameters());
                hasErrors = hasErrors || this.hasErrors((AbstractPropertyMap)validation.getAlertParameters()) || this.hasErrors((AbstractPropertyMap)validation.getExtraParameters());
            }
        }
        return !hasErrors;
    }

    @Override
    public int cleanseAlertNotificationBySubject(int subjectId) {
        return this.cleanseParameterValueForAlertSender("System Users", "subjectId", String.valueOf(subjectId));
    }

    @Override
    public int cleanseAlertNotificationByRole(int roleId) {
        return this.cleanseParameterValueForAlertSender("System Roles", "roleId", String.valueOf(roleId));
    }

    @Override
    public void massReconfigure(List<Integer> alertNotificationIds, Map<String, String> newConfigurationValues) {
        Query query = this.entityManager.createNamedQuery("AlertNotification.updateParameterForNotifications");
        query.setParameter("alertNotificationIds", alertNotificationIds);
        for (Map.Entry<String, String> entry : newConfigurationValues.entrySet()) {
            query.setParameter("propertyName", (Object)entry.getKey());
            query.setParameter("propertyValue", (Object)entry.getValue());
            query.executeUpdate();
        }
    }

    private int cleanseParameterValueForAlertSender(String senderName, String propertyName, String valueToCleanse) {
        Query query = this.entityManager.createNamedQuery("AlertNotification.cleanseParameterValueForAlertSender");
        query.setParameter("senderName", (Object)senderName);
        query.setParameter("propertyName", (Object)propertyName);
        query.setParameter("paramValue", (Object)("|" + valueToCleanse + "|"));
        int affectedRows = query.executeUpdate();
        return affectedRows;
    }

    private boolean hasErrors(AbstractPropertyMap configuration) {
        if (configuration instanceof PropertyMap && ((PropertyMap)configuration).getErrorMessage() != null) {
            return true;
        }
        for (Map.Entry entry : configuration.getMap().entrySet()) {
            if (!this.hasErrors((Property)entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean hasErrors(PropertyList list) {
        if (list.getErrorMessage() != null) {
            return true;
        }
        for (Property p : list.getList()) {
            if (!this.hasErrors(p)) continue;
            return true;
        }
        return false;
    }

    private boolean hasErrors(Property property) {
        if (property instanceof PropertySimple) {
            return property.getErrorMessage() != null;
        }
        if (property instanceof PropertyList) {
            return this.hasErrors((PropertyList)property);
        }
        if (property instanceof PropertyMap) {
            return this.hasErrors((AbstractPropertyMap)property);
        }
        return false;
    }
}

