/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.model;

import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.rhq.core.domain.alert.AlertConditionOperator;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.alert.engine.model.AbstractEnumCacheElement;
import org.rhq.enterprise.server.scheduler.jobs.AlertAvailabilityDurationJob;
import org.rhq.enterprise.server.util.LookupUtil;

public final class AvailabilityDurationCacheElement
extends AbstractEnumCacheElement<AvailabilityType> {
    public AvailabilityDurationCacheElement(AlertConditionOperator operator, String operatorOption, AvailabilityType value, int conditionTriggerId) {
        super(operator, (Object)operatorOption, value, conditionTriggerId);
    }

    public static void checkCacheElements(List<AvailabilityDurationCacheElement> cacheElements, Resource resource, AvailabilityType providedValue) {
        if (null == cacheElements) {
            return;
        }
        for (AvailabilityDurationCacheElement cacheElement : cacheElements) {
            switch (cacheElement.getAlertConditionOperator()) {
                case AVAIL_DURATION_DOWN: {
                    if (AvailabilityType.DOWN != providedValue || AvailabilityType.DOWN == cacheElement.getAlertConditionValue()) break;
                    AvailabilityDurationCacheElement.scheduleAvailabilityDurationCheck(cacheElement, resource);
                    break;
                }
                case AVAIL_DURATION_NOT_UP: {
                    if (AvailabilityType.UP == providedValue || AvailabilityType.UP != cacheElement.getAlertConditionValue()) break;
                    AvailabilityDurationCacheElement.scheduleAvailabilityDurationCheck(cacheElement, resource);
                }
            }
            cacheElement.setAlertConditionValue(providedValue);
        }
    }

    private static void scheduleAvailabilityDurationCheck(AvailabilityDurationCacheElement cacheElement, Resource resource) {
        Log log = LogFactory.getLog((String)AvailabilityDurationCacheElement.class.getName());
        String jobName = AlertAvailabilityDurationJob.class.getName();
        String jobGroupName = AlertAvailabilityDurationJob.class.getName();
        String operator = cacheElement.getAlertConditionOperator().name();
        String triggerName = operator + "-" + resource.getId();
        String duration = (String)cacheElement.getAlertConditionOperatorOption();
        Date jobTime = new Date(System.currentTimeMillis() + Long.valueOf(duration) * 1000L);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Scheduling availability duration job for [" + DateFormat.getDateTimeInstance().format(jobTime) + "]"));
        }
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("alertConditionId", String.valueOf(cacheElement.getAlertConditionTriggerId()));
        jobDataMap.put("resourceId", String.valueOf(resource.getId()));
        jobDataMap.put("alertConditionOperator", operator);
        jobDataMap.put("duration", duration);
        SimpleTrigger trigger = new SimpleTrigger(triggerName, jobGroupName, jobTime);
        trigger.setJobName(jobName);
        trigger.setJobGroup(jobGroupName);
        trigger.setJobDataMap(jobDataMap);
        try {
            LookupUtil.getSchedulerBean().scheduleJob((Trigger)trigger);
        }
        catch (Throwable t) {
            log.warn((Object)("Unable to schedule availability duration job for [" + resource + "] with JobData [" + jobDataMap.values() + "]"), t);
        }
    }

    @Override
    public boolean matches(AvailabilityType providedValue, Object ... extraParams) {
        if (null == providedValue) {
            return false;
        }
        boolean result = false;
        switch (this.alertConditionOperator) {
            case AVAIL_DURATION_DOWN: {
                result = AvailabilityType.DOWN == providedValue;
                break;
            }
            case AVAIL_DURATION_NOT_UP: {
                result = AvailabilityType.UP != providedValue;
            }
        }
        this.alertConditionValue = providedValue;
        return result;
    }

    @Override
    public AlertConditionOperator.Type getOperatorSupportsType(AlertConditionOperator operator) {
        switch (operator) {
            case AVAIL_DURATION_DOWN: 
            case AVAIL_DURATION_NOT_UP: {
                return operator.getDefaultType();
            }
        }
        return AlertConditionOperator.Type.NONE;
    }
}

