/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.server.core.AgentNotSupportedException;
import org.rhq.core.clientapi.server.core.AgentRegistrationException;
import org.rhq.core.clientapi.server.core.AgentRegistrationRequest;
import org.rhq.core.clientapi.server.core.AgentRegistrationResults;
import org.rhq.core.clientapi.server.core.AgentVersion;
import org.rhq.core.clientapi.server.core.ConnectAgentRequest;
import org.rhq.core.clientapi.server.core.ConnectAgentResults;
import org.rhq.core.clientapi.server.core.CoreServerService;
import org.rhq.core.clientapi.server.core.PingRequest;
import org.rhq.core.domain.cloud.PartitionEventType;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.cloud.composite.FailoverListComposite;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.util.Base64;
import org.rhq.core.util.exception.WrappedRemotingException;
import org.rhq.enterprise.communications.command.client.RemoteInputStream;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheManagerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.cloud.FailoverListManagerLocal;
import org.rhq.enterprise.server.cloud.PartitionEventManagerLocal;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.core.comm.ServerCommunicationsServiceMBean;
import org.rhq.enterprise.server.core.comm.ServerCommunicationsServiceUtil;
import org.rhq.enterprise.server.util.LookupUtil;

public class CoreServerServiceImpl
implements CoreServerService {
    private final Log log = LogFactory.getLog(CoreServerServiceImpl.class);
    private AgentManagerLocal agentManager;
    private AlertConditionCacheManagerLocal alertConditionCacheManager;
    private FailoverListManagerLocal failoverListManager;
    private PartitionEventManagerLocal partitionEventManager;
    private ServerManagerLocal serverManager;
    private SubjectManagerLocal subjectManager;
    private SecureRandom random;

    public AgentRegistrationResults registerAgent(AgentRegistrationRequest request) throws AgentRegistrationException, AgentNotSupportedException {
        if (!this.getAgentManager().isAgentVersionSupported(request.getAgentVersion())) {
            this.log.warn((Object)("Agent [" + request.getName() + "][" + request.getAddress() + ':' + request.getPort() + "][" + request.getAgentVersion() + "] would like to register with this server but it is not supported"));
            throw new AgentNotSupportedException("Agent [" + request.getName() + "] is an unsupported agent: " + request.getAgentVersion());
        }
        this.pingEndpoint(request.getRemoteEndpoint());
        Agent agentByName = this.getAgentManager().getAgentByName(request.getName());
        if (request.getOriginalToken() != null) {
            Agent agentByAddressPort;
            Agent agentByToken = this.getAgentManager().getAgentByAgentToken(request.getOriginalToken());
            if (agentByToken != null) {
                if (!agentByToken.getName().equals(request.getName())) {
                    String msg = "The agent asking for registration is already registered with the name [" + agentByToken.getName() + "], it cannot change its name to [" + request.getName() + "]";
                    throw new AgentRegistrationException(msg);
                }
                agentByAddressPort = this.getAgentManager().getAgentByAddressAndPort(request.getAddress(), request.getPort());
                if (agentByAddressPort != null && !agentByAddressPort.getName().equals(request.getName())) {
                    String msg = "The agent asking for registration [" + request.getName() + "] is trying to register the same address/port [" + request.getAddress() + ":" + request.getPort() + "] that is already registered under a different name [" + agentByAddressPort.getName() + "]";
                    throw new AgentRegistrationException(msg);
                }
            } else {
                if (agentByName != null) {
                    String msg = "The agent asking for registration under the name [" + request.getName() + "] provided an invalid security token. This request will fail. " + this.securityTokenMessage();
                    throw new AgentRegistrationException(msg);
                }
                agentByAddressPort = this.getAgentManager().getAgentByAddressAndPort(request.getAddress(), request.getPort());
                if (agentByAddressPort != null) {
                    String msg = "The agent asking for registration under the name [" + request.getName() + "] is attempting to take another agent's address/port [" + request.getAddress() + ":" + request.getPort() + "] with an unknown security token. This request will fail.";
                    throw new AgentRegistrationException(msg);
                }
            }
        } else {
            Agent agentByAddressPort = this.getAgentManager().getAgentByAddressAndPort(request.getAddress(), request.getPort());
            if (agentByAddressPort != null) {
                if (!agentByAddressPort.getName().equals(request.getName())) {
                    String msg = "The agent asking for registration is trying to register the same address/port [" + request.getAddress() + ":" + request.getPort() + "] that is already registered under a different name [" + agentByAddressPort.getName() + "]; if this new agent is actually the same as the original, then re-register with the same name" + " and same security token.";
                    throw new AgentRegistrationException(msg);
                }
                String msg = "The agent [" + request.getName() + "] is attempting to re-register without a security token. " + this.securityTokenMessage();
                throw new AgentRegistrationException(msg);
            }
            if (agentByName != null) {
                String msg = "An agent is trying to register with an existing agent name [" + request.getName() + "] without providing a valid security token. If you are attempting to re-register this agent, " + "you will need the agent's security token. " + this.securityTokenMessage();
                throw new AgentRegistrationException(msg);
            }
        }
        Server registeringServer = this.getServerManager().getServer();
        try {
            String address = request.getAddress();
            String fullEndpoint = request.getRemoteEndpoint();
            boolean loopbackRegistration = false;
            if (address.equals("127.0.0.1") || address.equalsIgnoreCase("localhost")) {
                loopbackRegistration = true;
            } else if (fullEndpoint != null && (fullEndpoint.contains("127.0.0.1") || fullEndpoint.contains("localhost"))) {
                loopbackRegistration = true;
            }
            if (loopbackRegistration) {
                this.log.warn((Object)("An agent [" + request.getName() + "] has registered with a loopback address. This should only be done " + "for testing or demo purposes - this agent can only ever interact with this server. " + request));
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (agentByName != null) {
            this.log.info((Object)("Got agent registration request for existing agent: " + agentByName.getName() + "[" + agentByName.getAddress() + ":" + agentByName.getPort() + "][" + request.getAgentVersion() + "] - Will " + (request.getRegenerateToken() ? "" : "not") + " regenerate a new token"));
            agentByName.setServer(registeringServer);
            agentByName.setAddress(request.getAddress());
            agentByName.setPort(request.getPort());
            agentByName.setRemoteEndpoint(request.getRemoteEndpoint());
            if (request.getRegenerateToken()) {
                agentByName.setAgentToken(this.generateAgentToken());
            }
            try {
                this.agentManager.updateAgent(agentByName);
            }
            catch (Exception e) {
                this.log.warn((Object)"Could not update the agent in database", (Throwable)e);
                throw new AgentRegistrationException((Throwable)new WrappedRemotingException((Throwable)e));
            }
        }
        this.log.info((Object)("Got agent registration request for new agent: " + request.getName() + "[" + request.getAddress() + ":" + request.getPort() + "][" + request.getAgentVersion() + "]"));
        try {
            agentByName = new Agent(request.getName(), request.getAddress(), request.getPort(), request.getRemoteEndpoint(), this.generateAgentToken());
            agentByName.setServer(registeringServer);
            this.agentManager.createAgent(agentByName);
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to create agent in database", (Throwable)e);
            throw new AgentRegistrationException((Throwable)new WrappedRemotingException((Throwable)e));
        }
        FailoverListComposite failoverList = this.getPartitionEventManager().agentPartitionEvent(this.getSubjectManager().getOverlord(), agentByName.getName(), PartitionEventType.AGENT_REGISTRATION, agentByName.getName() + " - " + registeringServer.getName());
        AgentRegistrationResults results = new AgentRegistrationResults();
        results.setAgentToken(agentByName.getAgentToken());
        results.setFailoverList(failoverList);
        return results;
    }

    private String securityTokenMessage() {
        return "Please consult an administrator to obtain the agent's proper security token and restart the agent with the option \"-Drhq.agent.security-token=<the valid security token>\". An administrator can find the agent's security token by navigating to the GUI page \"Administration (Topology) > Agents\" and drilling down to this specific agent. You will see the long security token string there. For more information, read: https://docs.jboss.org/author/display/RHQ/Agent+Registration";
    }

    public ConnectAgentResults connectAgent(ConnectAgentRequest request) throws AgentRegistrationException, AgentNotSupportedException {
        String agentName = request.getAgentName();
        AgentVersion agentVersion = request.getAgentVersion();
        this.log.info((Object)("Agent [" + agentName + "][" + agentVersion + "] would like to connect to this server"));
        if (!this.getAgentManager().isAgentVersionSupported(agentVersion)) {
            this.log.warn((Object)("Agent [" + agentName + "][" + agentVersion + "] would like to connect to this server but it is not supported"));
            throw new AgentNotSupportedException("Agent [" + agentName + "] is an unsupported agent: " + agentVersion);
        }
        Agent agent = this.getAgentManager().getAgentByName(agentName);
        if (agent == null) {
            throw new AgentRegistrationException("Agent [" + agentName + "] is not registered");
        }
        Server server = this.getServerManager().getServer();
        agent.setServer(server);
        this.getAgentManager().updateAgent(agent);
        this.getAlertConditionCacheManager().reloadCachesForAgent(agent.getId());
        this.getPartitionEventManager().auditPartitionEvent(this.getSubjectManager().getOverlord(), PartitionEventType.AGENT_CONNECT, agentName + " - " + server.getName());
        this.log.info((Object)("Agent [" + agentName + "] has connected to this server at " + new Date()));
        return new ConnectAgentResults(System.currentTimeMillis());
    }

    public List<Plugin> getLatestPlugins() {
        EntityManager em = null;
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        try {
            em = LookupUtil.getEntityManager();
            Query q = em.createNamedQuery("Plugin.findAllInstalled");
            List resultList = q.getResultList();
            for (Plugin potentialPlugin : resultList) {
                if (!potentialPlugin.isEnabled()) continue;
                plugins.add(potentialPlugin);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to get the list of latest plugins", (Throwable)e);
            throw new WrappedRemotingException((Throwable)e);
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        return plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getPluginArchive(String pluginName) {
        EntityManager em = null;
        try {
            em = LookupUtil.getEntityManager();
            Query q = em.createNamedQuery("Plugin.findByName");
            q.setParameter("name", (Object)pluginName);
            Plugin plugin = (Plugin)q.getSingleResult();
            InputStream inputStream = this.getFileContents(new File("rhq-plugins", plugin.getPath()).getPath());
            return inputStream;
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
    }

    public InputStream getFileContents(String file) {
        if (file.indexOf("..") >= 0) {
            String err_string = "WARNING: agent is attempting to download a file from an invalid location: " + file;
            this.log.error((Object)err_string);
            throw new IllegalArgumentException(err_string);
        }
        try {
            ServerCommunicationsServiceMBean sc = ServerCommunicationsServiceUtil.getService();
            String dir = sc.getConfiguration().getAgentFilesDirectory();
            File file_to_stream = new File(dir, file);
            if (!file_to_stream.exists()) {
                this.log.debug((Object)("Agent is asking for a plugin that isn't on file system [" + file_to_stream + "] - performing plugin scan"));
                LookupUtil.getPluginDeploymentScanner().scan();
            }
            FileInputStream fis = new FileInputStream(file_to_stream);
            BufferedInputStream bis = new BufferedInputStream(fis, 32768);
            RemoteInputStream in = ServerCommunicationsServiceUtil.remoteInputStream(bis);
            return in;
        }
        catch (Exception e) {
            throw new WrappedRemotingException((Throwable)e);
        }
    }

    public void agentIsShuttingDown(String agentName) {
        this.log.debug((Object)("Agent [" + agentName + "] is sending a notification that it is going down!"));
        this.getAgentManager().agentIsShuttingDown(agentName);
        this.getPartitionEventManager().auditPartitionEvent(this.getSubjectManager().getOverlord(), PartitionEventType.AGENT_SHUTDOWN, agentName);
    }

    public FailoverListComposite getFailoverList(String agentName) {
        return this.getFailoverListManager().getExistingForSingleAgent(agentName);
    }

    public PingRequest ping(PingRequest request) {
        return this.getAgentManager().handlePingRequest(request);
    }

    private AgentManagerLocal getAgentManager() {
        if (this.agentManager == null) {
            this.agentManager = LookupUtil.getAgentManager();
        }
        return this.agentManager;
    }

    private AlertConditionCacheManagerLocal getAlertConditionCacheManager() {
        if (this.alertConditionCacheManager == null) {
            this.alertConditionCacheManager = LookupUtil.getAlertConditionCacheManager();
        }
        return this.alertConditionCacheManager;
    }

    private FailoverListManagerLocal getFailoverListManager() {
        if (this.failoverListManager == null) {
            this.failoverListManager = LookupUtil.getFailoverListManager();
        }
        return this.failoverListManager;
    }

    private PartitionEventManagerLocal getPartitionEventManager() {
        if (this.partitionEventManager == null) {
            this.partitionEventManager = LookupUtil.getPartitionEventManager();
        }
        return this.partitionEventManager;
    }

    private ServerManagerLocal getServerManager() {
        if (this.serverManager == null) {
            this.serverManager = LookupUtil.getServerManager();
        }
        return this.serverManager;
    }

    private SubjectManagerLocal getSubjectManager() {
        if (this.subjectManager == null) {
            this.subjectManager = LookupUtil.getSubjectManager();
        }
        return this.subjectManager;
    }

    private void pingEndpoint(String endpoint) throws AgentRegistrationException {
        AgentRegistrationException failure = null;
        try {
            ServerCommunicationsServiceMBean sc = ServerCommunicationsServiceUtil.getService();
            boolean ping = sc.pingEndpoint(endpoint, 10000L);
            if (!ping && !(ping = sc.pingEndpoint(endpoint, 20000L))) {
                failure = new AgentRegistrationException("Server cannot ping the agent's endpoint. The agent's endpoint is probably invalid or there is a firewall preventing the server from connecting to the agent. Endpoint: " + endpoint);
            }
        }
        catch (Exception e) {
            failure = new AgentRegistrationException("Cannot verify agent endpoint due to internal error.", (Throwable)new WrappedRemotingException((Throwable)e));
        }
        if (failure != null) {
            throw failure;
        }
        this.log.debug((Object)("A new agent has passed its endpoint verification test: " + endpoint));
    }

    private synchronized String generateAgentToken() {
        if (this.random == null) {
            try {
                this.random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Could not load SecureRandom algorithm", e);
            }
        }
        byte[] tokenBytes = new byte[50];
        this.random.nextBytes(tokenBytes);
        return Base64.encode((byte[])tokenBytes);
    }
}

