/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.drift;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.drift.DriftManagerLocal;
import org.rhq.enterprise.server.drift.DriftUploadRequest;
import org.rhq.enterprise.server.drift.DriftUtil;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/DriftChangesetQueue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="NonDurable")})
public class DriftChangesetBean
implements MessageListener {
    private final Log log = LogFactory.getLog(DriftChangesetBean.class);
    @EJB
    private DriftManagerLocal driftManager;
    @EJB
    private SubjectManagerLocal subjectManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block10: {
            try {
                InputStream is;
                BufferedOutputStream os;
                block9: {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Received drift change set message");
                    }
                    ObjectMessage msg = (ObjectMessage)message;
                    DriftUploadRequest request = (DriftUploadRequest)msg.getObject();
                    File tempFile = null;
                    os = null;
                    is = null;
                    try {
                        tempFile = File.createTempFile("drift-changeset", ".zip");
                        os = new BufferedOutputStream(new FileOutputStream(tempFile));
                        is = DriftUtil.remoteStream(request.getDataStream());
                        StreamUtil.copy((InputStream)is, (OutputStream)os);
                        is = null;
                        os = null;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Copied [" + request.getDataSize() + "] bytes from agent into [" + tempFile.getPath() + "]"));
                        }
                        this.driftManager.saveChangeSet(this.subjectManager.getOverlord(), request.getResourceId(), tempFile);
                        if (null == tempFile) break block9;
                        tempFile.delete();
                    }
                    catch (IOException e) {
                        block11: {
                            try {
                                this.log.error((Object)e);
                                if (null == tempFile) break block11;
                                tempFile.delete();
                            }
                            catch (Throwable throwable) {
                                if (null != tempFile) {
                                    tempFile.delete();
                                }
                                DriftUtil.safeClose(os);
                                DriftUtil.safeClose(is);
                                throw throwable;
                            }
                        }
                        DriftUtil.safeClose(os);
                        DriftUtil.safeClose(is);
                        break block10;
                    }
                }
                DriftUtil.safeClose(os);
                DriftUtil.safeClose(is);
            }
            catch (Throwable t) {
                this.log.error((Object)"Error processing drift changeset message", t);
            }
        }
    }
}

