/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.drift;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.DriftDefinitionCriteria;
import org.rhq.core.domain.criteria.DriftDefinitionTemplateCriteria;
import org.rhq.core.domain.drift.Drift;
import org.rhq.core.domain.drift.DriftChangeSet;
import org.rhq.core.domain.drift.DriftChangeSetCategory;
import org.rhq.core.domain.drift.DriftConfigurationDefinition;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftDefinitionComparator;
import org.rhq.core.domain.drift.DriftDefinitionTemplate;
import org.rhq.core.domain.drift.DriftSnapshot;
import org.rhq.core.domain.drift.DriftSnapshotRequest;
import org.rhq.core.domain.drift.dto.DriftChangeSetDTO;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.drift.DriftManagerBean;
import org.rhq.enterprise.server.drift.DriftManagerLocal;
import org.rhq.enterprise.server.drift.DriftTemplateManagerLocal;
import org.rhq.enterprise.server.drift.DriftTemplateManagerRemote;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

@Stateless
public class DriftTemplateManagerBean
implements DriftTemplateManagerLocal,
DriftTemplateManagerRemote {
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityMgr;
    @EJB
    ResourceTypeManagerLocal resourceTypeMgr;
    @EJB
    DriftManagerLocal driftMgr;
    @EJB
    DriftTemplateManagerLocal templateMgr;

    @Override
    public PageList<DriftDefinitionTemplate> findTemplatesByCriteria(Subject subject, DriftDefinitionTemplateCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityMgr);
        PageList result = queryRunner.execute();
        return result;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public DriftDefinitionTemplate createTemplate(Subject subject, int resourceTypeId, boolean isUserDefined, DriftDefinition definition) {
        try {
            if (isUserDefined) {
                DriftManagerBean.validateDriftDefinition(definition);
            }
            ResourceType resourceType = this.resourceTypeMgr.getResourceTypeById(subject, resourceTypeId);
            DriftDefinitionTemplate template = new DriftDefinitionTemplate();
            template.setName(definition.getName());
            template.setDescription(definition.getDescription());
            template.setUserDefined(isUserDefined);
            template.setTemplateDefinition(definition);
            if (this.isDuplicateName(resourceType, template)) {
                throw new IllegalArgumentException("Drift definition template name must be unique. A template named [" + template.getName() + "] already exists for " + resourceType);
            }
            resourceType.addDriftDefinitionTemplate(template);
            this.entityMgr.persist((Object)template);
            return template;
        }
        catch (ResourceTypeNotFoundException e) {
            throw new RuntimeException("Failed to create template", e);
        }
    }

    private boolean isDuplicateName(ResourceType resourceType, DriftDefinitionTemplate newTemplate) {
        for (DriftDefinitionTemplate template : resourceType.getDriftDefinitionTemplates()) {
            if (!template.getName().equals(newTemplate.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void pinTemplate(Subject subject, int templateId, int driftDefId, int snapshotVersion) {
        this.templateMgr.createTemplateChangeSet(subject, templateId, driftDefId, snapshotVersion);
        DriftDefinitionTemplateCriteria templateCriteria = new DriftDefinitionTemplateCriteria();
        templateCriteria.addFilterId(Integer.valueOf(templateId));
        templateCriteria.fetchDriftDefinitions(true);
        PageList<DriftDefinitionTemplate> templates = this.templateMgr.findTemplatesByCriteria(subject, templateCriteria);
        DriftDefinitionTemplate template = (DriftDefinitionTemplate)templates.get(0);
        DriftDefinitionCriteria criteria = new DriftDefinitionCriteria();
        criteria.addFilterTemplateId(Integer.valueOf(templateId));
        criteria.fetchConfiguration(Boolean.valueOf(true));
        criteria.fetchResource(Boolean.valueOf(true));
        PageList<DriftDefinition> definitions = this.driftMgr.findDriftDefinitionsByCriteria(subject, criteria);
        for (DriftDefinition def : definitions) {
            if (!def.isAttached()) continue;
            int resourceId = def.getResource().getId();
            this.driftMgr.deleteDriftDefinition(subject, EntityContext.forResource((int)resourceId), def.getName());
            DriftDefinition newDef = new DriftDefinition(def.getConfiguration().deepCopyWithoutProxies());
            newDef.setTemplate(template);
            newDef.setPinned(true);
            this.driftMgr.updateDriftDefinition(subject, EntityContext.forResource((int)resourceId), newDef);
        }
    }

    @Override
    @TransactionAttribute
    public void createTemplateChangeSet(Subject subject, int templateId, int driftDefId, int snapshotVersion) {
        DriftDefinitionTemplate template = (DriftDefinitionTemplate)this.entityMgr.find(DriftDefinitionTemplate.class, (Object)templateId);
        DriftSnapshot snapshot = this.driftMgr.getSnapshot(subject, new DriftSnapshotRequest(driftDefId, Integer.valueOf(snapshotVersion)));
        DriftChangeSetDTO changeSetDTO = new DriftChangeSetDTO();
        changeSetDTO.setCategory(DriftChangeSetCategory.COVERAGE);
        changeSetDTO.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        changeSetDTO.setVersion(0);
        String newChangeSetId = this.driftMgr.persistSnapshot(subject, snapshot, (DriftChangeSet<? extends Drift<?, ?>>)changeSetDTO);
        template.setChangeSetId(newChangeSetId);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void deleteTemplate(Subject subject, int templateId) {
        DriftDefinitionTemplate template = (DriftDefinitionTemplate)this.entityMgr.find(DriftDefinitionTemplate.class, (Object)templateId);
        if (!template.isUserDefined()) {
            throw new IllegalArgumentException(template.getName() + " is a plugin defined template. Plugin defined " + "templates cannot be deleted.");
        }
        for (DriftDefinition defintion : template.getDriftDefinitions()) {
            if (defintion.isAttached()) {
                this.driftMgr.deleteDriftDefinition(subject, EntityContext.forResource((int)defintion.getResource().getId()), defintion.getName());
                continue;
            }
            defintion.setTemplate(null);
        }
        this.entityMgr.remove((Object)template);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void updateTemplate(Subject subject, DriftDefinitionTemplate updatedTemplate) {
        DriftDefinitionTemplate template = (DriftDefinitionTemplate)this.entityMgr.find(DriftDefinitionTemplate.class, (Object)updatedTemplate.getId());
        if (null == template) {
            throw new IllegalArgumentException("Template with id [" + updatedTemplate.getId() + "] not found");
        }
        if (!template.isUserDefined()) {
            throw new IllegalArgumentException("Plugin-defined templates cannot be be modified");
        }
        if (!template.getName().equals(updatedTemplate.getName())) {
            throw new IllegalArgumentException("The template's name cannot be modified");
        }
        DriftDefinitionComparator comparator = new DriftDefinitionComparator(DriftDefinitionComparator.CompareMode.ONLY_DIRECTORY_SPECIFICATIONS);
        if (comparator.compare(template.getTemplateDefinition(), updatedTemplate.getTemplateDefinition()) != 0) {
            throw new IllegalArgumentException("The template's base directory and filters cannot be modified");
        }
        template.setTemplateDefinition(updatedTemplate.getTemplateDefinition());
        template = (DriftDefinitionTemplate)this.entityMgr.merge((Object)template);
        DriftDefinition templateDef = template.getTemplateDefinition();
        for (DriftDefinition resourceDef : template.getDriftDefinitions()) {
            DriftDefinition driftDef = (DriftDefinition)this.entityMgr.find(DriftDefinition.class, (Object)resourceDef.getId());
            if (!driftDef.isAttached()) continue;
            driftDef.setInterval(Long.valueOf(templateDef.getInterval()));
            driftDef.setDriftHandlingMode(templateDef.getDriftHandlingMode());
            driftDef.setEnabled(Boolean.valueOf(templateDef.isEnabled()));
            this.driftMgr.updateDriftDefinition(subject, EntityContext.forResource((int)driftDef.getResource().getId()), driftDef);
        }
    }
}

