/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerBean;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.scheduler.jobs.AbstractStatefulJob;
import org.rhq.enterprise.server.util.LookupUtil;

public class NotifyAgentsOfScheduleUpdatesJob
extends AbstractStatefulJob {
    private final Log log = LogFactory.getLog(MeasurementScheduleManagerBean.class);

    @Override
    public void executeJobCode(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        String triggerName = (String)jobDataMap.get((Object)"TriggerName");
        String triggerGroupName = (String)jobDataMap.get((Object)"TriggerGroupName");
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        try {
            scheduler.unscheduleJob(triggerName, triggerGroupName);
        }
        catch (SchedulerException e) {
            this.log.error((Object)("Failed to unschedule Quartz trigger [" + triggerName + "]."), (Throwable)e);
        }
        String scheduleSubQuery = (String)jobDataMap.get((Object)"ScheduleSubQuery");
        EntityContext entityContext = new EntityContext(Integer.valueOf(Integer.parseInt((String)jobDataMap.get((Object)"EntityContext.resourceId"))), Integer.valueOf(Integer.parseInt((String)jobDataMap.get((Object)"EntityContext.groupId"))), Integer.valueOf(Integer.parseInt((String)jobDataMap.get((Object)"EntityContext.parentResourceId"))), Integer.valueOf(Integer.parseInt((String)jobDataMap.get((Object)"EntityContext.resourceTypeId"))));
        MeasurementScheduleManagerLocal scheduleManager = LookupUtil.getMeasurementScheduleManager();
        scheduleManager.notifyAgentsOfScheduleUpdates(entityContext, scheduleSubQuery);
    }
}

