/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement.util;

import org.rhq.core.domain.measurement.MeasurementBaseline;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.util.MeasurementConversionException;
import org.rhq.core.server.MeasurementConverter;

public class MeasurementFormatter {
    private static final String MEASUREMENT_BASELINE_MIN_TEXT = "Min Value";
    private static final String MEASUREMENT_BASELINE_MEAN_TEXT = "Baseline Value";
    private static final String MEASUREMENT_BASELINE_MAX_TEXT = "Max Value";

    public static String getBaselineText(String baselineOption, MeasurementSchedule schedule) {
        if (null != schedule && null != schedule.getBaseline()) {
            MeasurementBaseline baseline = schedule.getBaseline();
            String lookupText = null;
            Double value = null;
            if (baselineOption.equals("min")) {
                lookupText = MEASUREMENT_BASELINE_MIN_TEXT;
                value = baseline.getMin();
            } else if (baselineOption.equals("mean")) {
                lookupText = MEASUREMENT_BASELINE_MEAN_TEXT;
                value = baseline.getMean();
            } else if (baselineOption.equals("max")) {
                lookupText = MEASUREMENT_BASELINE_MAX_TEXT;
                value = baseline.getMax();
            }
            if (value != null) {
                try {
                    String formatted = MeasurementConverter.scaleAndFormat(value, schedule, true);
                    return formatted + " (" + lookupText + ")";
                }
                catch (MeasurementConversionException mce) {
                    return lookupText;
                }
            }
        }
        if ("min".equals(baselineOption)) {
            return MEASUREMENT_BASELINE_MIN_TEXT;
        }
        if ("max".equals(baselineOption)) {
            return MEASUREMENT_BASELINE_MAX_TEXT;
        }
        return MEASUREMENT_BASELINE_MEAN_TEXT;
    }
}

