/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.group;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.sql.DataSource;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.IgnoreDependency;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.H2DatabaseType;
import org.rhq.core.db.OracleDatabaseType;
import org.rhq.core.db.PostgresqlDatabaseType;
import org.rhq.core.db.SQLServerDatabaseType;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.ResourceGroupCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.operation.bean.GroupOperationSchedule;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.core.domain.resource.composite.ResourcePermission;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.resource.group.composite.ResourceGroupComposite;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.alert.GroupAlertDefinitionManagerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.jaxb.adapter.ResourceGroupAdapter;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.group.RecursivityChangeType;
import org.rhq.enterprise.server.resource.group.ResourceGroupAlreadyExistsException;
import org.rhq.enterprise.server.resource.group.ResourceGroupDeleteException;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerRemote;
import org.rhq.enterprise.server.resource.group.ResourceGroupNotFoundException;
import org.rhq.enterprise.server.resource.group.ResourceGroupUpdateException;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;
import org.rhq.enterprise.server.util.QueryUtility;

@Stateless
@Resource(name="RHQ_DS", mappedName="java:/RHQDS")
public class ResourceGroupManagerBean
implements ResourceGroupManagerLocal,
ResourceGroupManagerRemote {
    private final Log log = LogFactory.getLog(ResourceGroupManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    @IgnoreDependency
    private OperationManagerLocal operationManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    @IgnoreDependency
    private ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    @IgnoreDependency
    private ResourceManagerLocal resourceManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private GroupAlertDefinitionManagerLocal groupAlertDefinitionManager;
    @Resource(name="RHQ_DS")
    private DataSource rhqDs;
    private DatabaseType dbType;

    @PostConstruct
    public void init() {
        Connection conn = null;
        try {
            conn = this.rhqDs.getConnection();
            this.dbType = DatabaseTypeFactory.getDatabaseType((Connection)conn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            JDBCUtil.safeClose((Connection)conn);
        }
    }

    @Override
    public ResourceGroup createPrivateResourceGroup(Subject subject, @XmlJavaTypeAdapter(value=ResourceGroupAdapter.class) ResourceGroup group) {
        group.setSubject(subject);
        group.setRecursive(false);
        return this.resourceGroupManager.createResourceGroup(this.subjectManager.getOverlord(), group);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public ResourceGroup createResourceGroup(Subject user, @XmlJavaTypeAdapter(value=ResourceGroupAdapter.class) ResourceGroup group) {
        Query query = this.entityManager.createNamedQuery("ResourceGroup.findByNameVisibleGroup");
        query.setParameter("name", (Object)group.getName());
        List groups = query.getResultList();
        if (groups.size() != 0) {
            throw new ResourceGroupAlreadyExistsException("ResourceGroup with name " + group.getName() + " already exists");
        }
        long time = System.currentTimeMillis();
        group.setCtime(Long.valueOf(time));
        group.setMtime(Long.valueOf(time));
        group.setModifiedBy(user.getName());
        this.entityManager.persist((Object)group);
        return group;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public ResourceGroup updateResourceGroup(Subject subject, ResourceGroup group) throws ResourceGroupUpdateException {
        return this.updateResourceGroup(subject, group, null, true);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public ResourceGroup updateResourceGroup(Subject subject, ResourceGroup group, RecursivityChangeType changeType) throws ResourceGroupUpdateException {
        return this.updateResourceGroup(subject, group, changeType, true);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public ResourceGroup updateResourceGroup(Subject user, ResourceGroup group, RecursivityChangeType changeType, boolean updateMembership) throws ResourceGroupUpdateException {
        int groupId = group.getId();
        ResourceGroup attachedGroup = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)groupId);
        if (attachedGroup == null) {
            throw new ResourceGroupNotFoundException(groupId);
        }
        if (!this.authorizationManager.hasGroupPermission(user, Permission.MODIFY_RESOURCE, groupId)) {
            throw new PermissionException("User [" + user + "] does not have permission to modify Resource group with id [" + groupId + "].");
        }
        group.getRoles().clear();
        group.getRoles().addAll(attachedGroup.getRoles());
        if (changeType == null) {
            changeType = RecursivityChangeType.None;
            if (attachedGroup.isRecursive() && !group.isRecursive()) {
                changeType = RecursivityChangeType.RemovedRecursion;
            } else if (!attachedGroup.isRecursive() && group.isRecursive()) {
                changeType = RecursivityChangeType.AddedRecursion;
            }
        }
        if (!updateMembership) {
            group.setExplicitResources(attachedGroup.getExplicitResources());
            group.setImplicitResources(attachedGroup.getImplicitResources());
        }
        group.setMtime(Long.valueOf(System.currentTimeMillis()));
        group.setModifiedBy(user.getName());
        ResourceGroup newlyAttachedGroup = (ResourceGroup)this.entityManager.merge((Object)group);
        if (changeType == RecursivityChangeType.AddedRecursion) {
            newlyAttachedGroup.setRecursive(true);
            this.enableRecursivityForGroup(user, groupId);
        } else if (changeType == RecursivityChangeType.RemovedRecursion) {
            newlyAttachedGroup.setRecursive(false);
            this.clearImplicitResources(groupId);
            this.makeImplicitMirrorExplicit(groupId);
        }
        if (updateMembership) {
            try {
                this.setResourceType(groupId);
            }
            catch (ResourceGroupDeleteException e) {
                throw new ResourceGroupNotFoundException(e.getMessage());
            }
        }
        return newlyAttachedGroup;
    }

    private void clearImplicitResources(int resourceGroupId) throws ResourceGroupUpdateException {
        Connection conn = null;
        PreparedStatement removeImplicitStatement = null;
        try {
            conn = this.rhqDs.getConnection();
            removeImplicitStatement = conn.prepareStatement("DELETE FROM rhq_resource_group_res_imp_map implicitMap       WHERE implicitMap.resource_group_id = ?");
            removeImplicitStatement.setInt(1, resourceGroupId);
            removeImplicitStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                this.log.error((Object)("Error removing implicit resources from group[id=" + resourceGroupId + "]: "), (Throwable)sqle);
                throw new ResourceGroupUpdateException("Error removing implicit resources from group[id=" + resourceGroupId + "]: " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(removeImplicitStatement);
                JDBCUtil.safeClose((Connection)conn);
                throw throwable;
            }
        }
        JDBCUtil.safeClose((Statement)removeImplicitStatement);
        JDBCUtil.safeClose((Connection)conn);
    }

    private void makeImplicitMirrorExplicit(int resourceGroupId) throws ResourceGroupUpdateException {
        Connection conn = null;
        PreparedStatement updateImplicitMirrorExplicitStatement = null;
        try {
            conn = this.rhqDs.getConnection();
            updateImplicitMirrorExplicitStatement = conn.prepareStatement("INSERT INTO rhq_resource_group_res_imp_map (resource_id, resource_group_id)      SELECT explicitMap.resource_id, explicitMap.resource_group_id        FROM rhq_resource_group_res_exp_map explicitMap       WHERE explicitMap.resource_group_id = ?");
            updateImplicitMirrorExplicitStatement.setInt(1, resourceGroupId);
            updateImplicitMirrorExplicitStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                this.log.error((Object)("Error making implicit resources mirror explicit resources for group[id=" + resourceGroupId + "]: "), (Throwable)sqle);
                throw new ResourceGroupUpdateException("Error making implicit resources mirror explicit resources for group[id=" + resourceGroupId + "]: " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(updateImplicitMirrorExplicitStatement);
                JDBCUtil.safeClose((Connection)conn);
                throw throwable;
            }
        }
        JDBCUtil.safeClose((Statement)updateImplicitMirrorExplicitStatement);
        JDBCUtil.safeClose((Connection)conn);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void deleteResourceGroup(Subject subject, int groupId) throws ResourceGroupNotFoundException, ResourceGroupDeleteException {
        ResourceGroup group = this.getResourceGroupById(subject, groupId, null);
        for (Role doomedRoleRelationship : group.getRoles()) {
            group.removeRole(doomedRoleRelationship);
            this.entityManager.merge((Object)doomedRoleRelationship);
        }
        this.resourceGroupManager.removeAllResourcesFromGroup(subject, groupId);
        if (group.getGroupCategory() == GroupCategory.COMPATIBLE) {
            this.removeCompatibleGroupConstructs(subject, group);
        }
        Query q = null;
        q = this.entityManager.createNamedQuery("ResourceConfigurationUpdate.deleteGroupUpdatesForGroup");
        q.setParameter("groupId", (Object)group.getId());
        q.executeUpdate();
        q = this.entityManager.createNamedQuery("pluginConfigurationUpdate.deleteGroupUpdatesForGroup");
        q.setParameter("groupId", (Object)group.getId());
        q.executeUpdate();
        this.entityManager.remove((Object)group);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void deleteResourceGroups(Subject subject, int[] groupIds) throws ResourceGroupNotFoundException, ResourceGroupDeleteException {
        for (int nextGroupId : groupIds) {
            this.deleteResourceGroup(subject, nextGroupId);
        }
    }

    private void removeCompatibleGroupConstructs(Subject subject, ResourceGroup group) throws ResourceGroupDeleteException {
        for (ResourceGroup referringGroup : group.getClusterBackingGroups()) {
            this.deleteResourceGroup(subject, referringGroup.getId());
        }
        Subject overlord = this.subjectManager.getOverlord();
        try {
            List<GroupOperationSchedule> ops = this.operationManager.findScheduledGroupOperations(overlord, group.getId());
            for (GroupOperationSchedule schedule : ops) {
                this.operationManager.unscheduleGroupOperation(overlord, schedule.getJobId().toString(), group.getId());
            }
        }
        catch (Exception e) {
            throw new ResourceGroupDeleteException("Failed to get jobs for a group being deleted [" + group + "]; will not attempt to unschedule anything", e);
        }
        this.groupAlertDefinitionManager.purgeAllGroupAlertDefinitions(subject, group.getId());
    }

    @Override
    public ResourceGroup getResourceGroupById(Subject user, int id, GroupCategory category) throws ResourceGroupNotFoundException {
        ResourceGroup group = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)id);
        if (group == null) {
            throw new ResourceGroupNotFoundException(id);
        }
        if (!this.authorizationManager.canViewGroup(user, group.getId())) {
            throw new PermissionException("You do not have permission to view this resource group");
        }
        if (category != null && category != group.getGroupCategory()) {
            throw new ResourceGroupNotFoundException("Expected group to belong to '" + category + "' category, " + "it belongs to '" + group.getGroupCategory() + "' category instead");
        }
        this.initLazyFields(group);
        return group;
    }

    private void initLazyFields(ResourceGroup group) {
        group.getAlertDefinitions().size();
    }

    @Override
    public int[] getResourceGroupCountSummary(Subject user) {
        Query query;
        if (this.authorizationManager.isInventoryManager(user)) {
            query = this.entityManager.createNamedQuery("ResourceGroup.findResourceGroupSummary_admin");
        } else {
            query = this.entityManager.createNamedQuery("ResourceGroup.findResourceGroupSummary");
            query.setParameter("subject", (Object)user);
        }
        int[] counts = new int[2];
        List resultList = query.getResultList();
        for (Object[] row : resultList) {
            switch ((GroupCategory)row[0]) {
                case MIXED: {
                    counts[0] = ((Long)row[1]).intValue();
                    break;
                }
                case COMPATIBLE: {
                    counts[1] = ((Long)row[1]).intValue();
                }
            }
        }
        return counts;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void enableRecursivityForGroup(Subject subject, int groupId) throws ResourceGroupNotFoundException, ResourceGroupUpdateException {
        this.clearImplicitResources(groupId);
        List<Integer> explicitResourceIdList = this.resourceManager.findExplicitResourceIdsByResourceGroup(groupId);
        this.addResourcesToGroupImplicit(subject, groupId, explicitResourceIdList, false, true);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void addResourcesToGroup(Subject subject, int groupId, int[] resourceIds) {
        this.addResourcesToGroup(subject, groupId, resourceIds, true);
    }

    private void addResourcesToGroup(Subject subject, int groupId, int[] resourceIds, boolean setType) {
        Object[] ids = ArrayUtils.wrapInArray((int[])resourceIds);
        if (ids == null || ids.length == 0) {
            return;
        }
        boolean isRecursive = this.isRecursive(groupId);
        for (int batchIndex = 0; batchIndex < ids.length; batchIndex += 1000) {
            Integer[] batchIdArray = (Integer[])ArrayUtils.copyOfRange((Object[])ids, (int)batchIndex, (int)(batchIndex + 1000));
            List<Integer> batchIds = Arrays.asList(batchIdArray);
            this.addResourcesToGroupImplicit(subject, groupId, batchIds, true, isRecursive);
            this.addResourcesToGroupExplicit(subject, groupId, batchIds, isRecursive);
        }
        if (setType) {
            try {
                this.setResourceType(groupId);
            }
            catch (ResourceGroupDeleteException e) {
                throw new ResourceGroupNotFoundException(e.getMessage());
            }
        }
    }

    private void addResourcesToGroupExplicit(Subject subject, Integer groupId, List<Integer> resourceIds, boolean isRecursive) throws ResourceGroupUpdateException {
        if (resourceIds == null || resourceIds.size() == 0) {
            return;
        }
        List<Integer> nonMemberResources = this.getNonMemberExplicitResources(groupId, resourceIds);
        if (nonMemberResources.size() == 0) {
            return;
        }
        int[] resourceIdsToAdd = ArrayUtils.unwrapCollection(nonMemberResources);
        this.groupAlertDefinitionManager.addGroupAlertDefinitions(subject, groupId, resourceIdsToAdd);
        Connection conn = null;
        PreparedStatement insertExplicitStatement = null;
        try {
            conn = this.rhqDs.getConnection();
            String insertExplicitQueryString = JDBCUtil.transformQueryForMultipleInParameters((String)"    insert into RHQ_RESOURCE_GROUP_RES_EXP_MAP ( RESOURCE_ID, RESOURCE_GROUP_ID )          select res.ID, ?            from RHQ_RESOURCE res           where res.ID in ( @@RESOURCE_IDS@@ ) ", (String)"@@RESOURCE_IDS@@", (int)resourceIdsToAdd.length);
            insertExplicitStatement = conn.prepareStatement(insertExplicitQueryString);
            insertExplicitStatement.setInt(1, groupId);
            JDBCUtil.bindNTimes((PreparedStatement)insertExplicitStatement, (int[])resourceIdsToAdd, (int)2);
            insertExplicitStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                this.log.error((Object)("Error adding resources to group[id=" + groupId + "]: "), (Throwable)sqle);
                throw new ResourceGroupUpdateException("Error adding resources from group[id=" + groupId + "]: " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(insertExplicitStatement);
                JDBCUtil.safeClose((Connection)conn);
                throw throwable;
            }
        }
        JDBCUtil.safeClose((Statement)insertExplicitStatement);
        JDBCUtil.safeClose((Connection)conn);
    }

    private void addResourcesToGroupImplicit(Subject subject, Integer groupId, List<Integer> resourceIds, boolean filterByExplicitMembership, boolean isRecursive) throws ResourceGroupUpdateException {
        PreparedStatement insertImplicitStatement;
        Statement insertExplicitStatement;
        Connection conn;
        block10: {
            int[] resourceIdsToAdd;
            if (resourceIds == null || resourceIds.size() == 0) {
                return;
            }
            if (filterByExplicitMembership) {
                List<Integer> nonMemberResources = this.getNonMemberExplicitResources(groupId, resourceIds);
                if (nonMemberResources.size() == 0) {
                    return;
                }
                resourceIdsToAdd = ArrayUtils.unwrapCollection(nonMemberResources);
            } else {
                resourceIdsToAdd = ArrayUtils.unwrapCollection(resourceIds);
            }
            conn = null;
            insertExplicitStatement = null;
            insertImplicitStatement = null;
            try {
                conn = this.rhqDs.getConnection();
                if (isRecursive) {
                    insertImplicitStatement = conn.prepareStatement("    insert into RHQ_RESOURCE_GROUP_RES_IMP_MAP ( RESOURCE_ID, RESOURCE_GROUP_ID )          select res.ID, ?            from RHQ_RESOURCE res left outer join RHQ_RESOURCE g1parent on res.PARENT_RESOURCE_ID = g1parent.ID left outer join RHQ_RESOURCE g2parent on g1parent.PARENT_RESOURCE_ID = g2parent.ID left outer join RHQ_RESOURCE g3parent on g2parent.PARENT_RESOURCE_ID = g3parent.ID left outer join RHQ_RESOURCE g4parent on g3parent.PARENT_RESOURCE_ID = g4parent.ID left outer join RHQ_RESOURCE g5parent on g4parent.PARENT_RESOURCE_ID = g5parent.ID left outer join RHQ_RESOURCE g6parent on g5parent.PARENT_RESOURCE_ID = g6parent.ID           where ( res.ID = ? or                   g1parent.ID = ? or                   g2parent.ID = ? or                   g3parent.ID = ? or                   g4parent.ID = ? or                   g5parent.ID = ? or                   g6parent.ID = ? )             and ( res.ID not in ( select impRes.ID                                     from RHQ_RESOURCE_GROUP rg                               inner join RHQ_RESOURCE_GROUP_RES_IMP_MAP implicitMap on rg.ID = implicitMap.RESOURCE_GROUP_ID                               inner join RHQ_RESOURCE impRes on implicitMap.RESOURCE_ID = impRes.ID                                    where rg.ID = ? ) ) ");
                    insertImplicitStatement.setInt(1, groupId);
                    insertImplicitStatement.setInt(9, groupId);
                    for (int resourceId : resourceIdsToAdd) {
                        insertImplicitStatement.setInt(2, resourceId);
                        insertImplicitStatement.setInt(3, resourceId);
                        insertImplicitStatement.setInt(4, resourceId);
                        insertImplicitStatement.setInt(5, resourceId);
                        insertImplicitStatement.setInt(6, resourceId);
                        insertImplicitStatement.setInt(7, resourceId);
                        insertImplicitStatement.setInt(8, resourceId);
                        insertImplicitStatement.executeUpdate();
                    }
                    break block10;
                }
                String insertImplicitQueryString = JDBCUtil.transformQueryForMultipleInParameters((String)"    insert into RHQ_RESOURCE_GROUP_RES_IMP_MAP ( RESOURCE_ID, RESOURCE_GROUP_ID )          select res.ID, ?            from RHQ_RESOURCE res           where res.ID in ( @@RESOURCE_IDS@@ ) ", (String)"@@RESOURCE_IDS@@", (int)resourceIdsToAdd.length);
                insertImplicitStatement = conn.prepareStatement(insertImplicitQueryString);
                insertImplicitStatement.setInt(1, groupId);
                JDBCUtil.bindNTimes((PreparedStatement)insertImplicitStatement, (int[])resourceIdsToAdd, (int)2);
                insertImplicitStatement.executeUpdate();
            }
            catch (SQLException sqle) {
                try {
                    this.log.error((Object)("Error adding resources to group[id=" + groupId + "]: "), (Throwable)sqle);
                    throw new ResourceGroupUpdateException("Error adding resources from group[id=" + groupId + "]: " + sqle.getMessage());
                }
                catch (Throwable throwable) {
                    JDBCUtil.safeClose(insertExplicitStatement);
                    JDBCUtil.safeClose(insertImplicitStatement);
                    JDBCUtil.safeClose((Connection)conn);
                    throw throwable;
                }
            }
        }
        JDBCUtil.safeClose(insertExplicitStatement);
        JDBCUtil.safeClose((Statement)insertImplicitStatement);
        JDBCUtil.safeClose((Connection)conn);
    }

    private boolean isRecursive(int groupId) {
        Subject overlord = this.subjectManager.getOverlord();
        ResourceGroup attachedGroup = this.getResourceGroupById(overlord, groupId, null);
        return attachedGroup.isRecursive();
    }

    private List<Integer> getNonMemberExplicitResources(int groupId, List<Integer> resourceIds) {
        if (resourceIds == null || resourceIds.size() == 0) {
            return Collections.emptyList();
        }
        Query query = this.entityManager.createNamedQuery("ResourceGroup.findResourceIdsNotInGroupExplicit");
        query.setParameter("groupId", (Object)groupId);
        query.setParameter("resourceIds", resourceIds);
        List nonMemberResources = query.getResultList();
        return nonMemberResources;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void removeResourcesFromGroup(Subject subject, int groupId, int[] resourceIds) {
        this.removeResourcesFromGroup(subject, groupId, resourceIds, true);
    }

    private void removeResourcesFromGroup(Subject subject, int groupId, int[] resourceIds, boolean setType) {
        Object[] ids = ArrayUtils.wrapInArray((int[])resourceIds);
        if (ids == null || ids.length == 0) {
            return;
        }
        boolean isRecursive = this.isRecursive(groupId);
        for (int batchIndex = 0; batchIndex < ids.length; batchIndex += 1000) {
            Integer[] batchIdArray = (Integer[])ArrayUtils.copyOfRange((Object[])ids, (int)batchIndex, (int)(batchIndex + 1000));
            this.removeResourcesFromGroup_helper(subject, groupId, batchIdArray, isRecursive);
        }
        if (setType) {
            try {
                this.setResourceType(groupId);
            }
            catch (ResourceGroupDeleteException e) {
                throw new ResourceGroupNotFoundException(e.getMessage());
            }
        }
    }

    private void removeResourcesFromGroup_helper(Subject subject, Integer groupId, Integer[] resourceIds, boolean isRecursive) throws ResourceGroupNotFoundException, ResourceGroupUpdateException {
        List<Integer> nonMembersToBeRemoved = this.getNonMemberExplicitResources(groupId, Arrays.asList(resourceIds));
        if (nonMembersToBeRemoved.size() != 0) {
            throw new ResourceGroupUpdateException("Can not remove resources[" + nonMembersToBeRemoved + "] which are not part of the group[id=" + groupId + "]");
        }
        int[] resourceIdsToRemove = ArrayUtils.unwrapArray((Integer[])resourceIds);
        this.groupAlertDefinitionManager.removeGroupAlertDefinitions(subject, groupId, resourceIdsToRemove);
        Connection conn = null;
        PreparedStatement deleteExplicitStatement = null;
        PreparedStatement deleteImplicitStatement = null;
        try {
            conn = this.rhqDs.getConnection();
            if (isRecursive) {
                deleteImplicitStatement = conn.prepareStatement("   delete from RHQ_RESOURCE_GROUP_RES_IMP_MAP          where RESOURCE_GROUP_ID = ?            and RESOURCE_ID in                ( select res.id                    from RHQ_RESOURCE res         left outer join RHQ_RESOURCE g1parent on res.PARENT_RESOURCE_ID = g1parent.ID         left outer join RHQ_RESOURCE g2parent on g1parent.PARENT_RESOURCE_ID = g2parent.ID         left outer join RHQ_RESOURCE g3parent on g2parent.PARENT_RESOURCE_ID = g3parent.ID         left outer join RHQ_RESOURCE g4parent on g3parent.PARENT_RESOURCE_ID = g4parent.ID         left outer join RHQ_RESOURCE g5parent on g4parent.PARENT_RESOURCE_ID = g5parent.ID         left outer join RHQ_RESOURCE g6parent on g5parent.PARENT_RESOURCE_ID = g6parent.ID                   where ( res.ID = ? or                           g1parent.ID = ? or                           g2parent.ID = ? or                           g3parent.ID = ? or                           g4parent.ID = ? or                           g5parent.ID = ? or                           g6parent.ID = ? ) )            and RESOURCE_ID not in                ( select res.id                    from RHQ_RESOURCE_GROUP_RES_EXP_MAP alreadyMember, RHQ_RESOURCE res         left outer join RHQ_RESOURCE g1parent on res.PARENT_RESOURCE_ID = g1parent.ID         left outer join RHQ_RESOURCE g2parent on g1parent.PARENT_RESOURCE_ID = g2parent.ID         left outer join RHQ_RESOURCE g3parent on g2parent.PARENT_RESOURCE_ID = g3parent.ID         left outer join RHQ_RESOURCE g4parent on g3parent.PARENT_RESOURCE_ID = g4parent.ID         left outer join RHQ_RESOURCE g5parent on g4parent.PARENT_RESOURCE_ID = g5parent.ID         left outer join RHQ_RESOURCE g6parent on g5parent.PARENT_RESOURCE_ID = g6parent.ID                   where alreadyMember.RESOURCE_GROUP_ID = ?                     and alreadyMember.RESOURCE_ID <> ?                     and ( res.ID = alreadyMember.RESOURCE_ID or                           g1parent.ID = alreadyMember.RESOURCE_ID or                           g2parent.ID = alreadyMember.RESOURCE_ID or                           g3parent.ID = alreadyMember.RESOURCE_ID or                           g4parent.ID = alreadyMember.RESOURCE_ID or                           g5parent.ID = alreadyMember.RESOURCE_ID or                           g6parent.ID = alreadyMember.RESOURCE_ID ) ) ");
                deleteImplicitStatement.setInt(1, groupId);
                deleteImplicitStatement.setInt(9, groupId);
                for (int resourceId : resourceIdsToRemove) {
                    List<Integer> lineage = this.resourceManager.getResourceIdLineage(resourceId);
                    List<Integer> nonMembers = this.getNonMemberExplicitResources(groupId, lineage);
                    if (lineage.size() != nonMembers.size()) continue;
                    deleteImplicitStatement.setInt(2, resourceId);
                    deleteImplicitStatement.setInt(3, resourceId);
                    deleteImplicitStatement.setInt(4, resourceId);
                    deleteImplicitStatement.setInt(5, resourceId);
                    deleteImplicitStatement.setInt(6, resourceId);
                    deleteImplicitStatement.setInt(7, resourceId);
                    deleteImplicitStatement.setInt(8, resourceId);
                    deleteImplicitStatement.setInt(10, resourceId);
                    deleteImplicitStatement.executeUpdate();
                }
            } else {
                String deleteImplicitQueryString = JDBCUtil.transformQueryForMultipleInParameters((String)"    delete from RHQ_RESOURCE_GROUP_RES_IMP_MAP           where RESOURCE_GROUP_ID = ?             and RESOURCE_ID in ( @@RESOURCE_IDS@@ ) ", (String)"@@RESOURCE_IDS@@", (int)resourceIdsToRemove.length);
                deleteImplicitStatement = conn.prepareStatement(deleteImplicitQueryString);
                deleteImplicitStatement.setInt(1, groupId);
                JDBCUtil.bindNTimes((PreparedStatement)deleteImplicitStatement, (int[])resourceIdsToRemove, (int)2);
                deleteImplicitStatement.executeUpdate();
            }
            String deleteExplicitQueryString = JDBCUtil.transformQueryForMultipleInParameters((String)"    delete from RHQ_RESOURCE_GROUP_RES_EXP_MAP           where RESOURCE_GROUP_ID = ?             and RESOURCE_ID in ( @@RESOURCE_IDS@@ ) ", (String)"@@RESOURCE_IDS@@", (int)resourceIdsToRemove.length);
            deleteExplicitStatement = conn.prepareStatement(deleteExplicitQueryString);
            deleteExplicitStatement.setInt(1, groupId);
            JDBCUtil.bindNTimes((PreparedStatement)deleteExplicitStatement, (int[])resourceIdsToRemove, (int)2);
            deleteExplicitStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                this.log.error((Object)("Error removing resources from group[id=" + groupId + "]: "), (Throwable)sqle);
                throw new ResourceGroupUpdateException("Error removing resources from group[id=" + groupId + "]: " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(deleteExplicitStatement);
                JDBCUtil.safeClose(deleteImplicitStatement);
                JDBCUtil.safeClose((Connection)conn);
                throw throwable;
            }
        }
        JDBCUtil.safeClose((Statement)deleteExplicitStatement);
        JDBCUtil.safeClose((Statement)deleteImplicitStatement);
        JDBCUtil.safeClose((Connection)conn);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void removeAllResourcesFromGroup(Subject subject, int groupId) throws ResourceGroupDeleteException {
        Connection conn = null;
        PreparedStatement explicitStatement = null;
        PreparedStatement implicitStatement = null;
        try {
            conn = this.rhqDs.getConnection();
            explicitStatement = conn.prepareStatement("delete from rhq_resource_group_res_exp_map where resource_group_id = ?");
            implicitStatement = conn.prepareStatement("delete from rhq_resource_group_res_imp_map where resource_group_id = ?");
            explicitStatement.setInt(1, groupId);
            implicitStatement.setInt(1, groupId);
            explicitStatement.executeUpdate();
            implicitStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                this.log.error((Object)"Error removing group resources", (Throwable)sqle);
                throw new ResourceGroupDeleteException("Error removing group resources: " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(explicitStatement);
                JDBCUtil.safeClose(implicitStatement);
                JDBCUtil.safeClose((Connection)conn);
                throw throwable;
            }
        }
        JDBCUtil.safeClose((Statement)explicitStatement);
        JDBCUtil.safeClose((Statement)implicitStatement);
        JDBCUtil.safeClose((Connection)conn);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public PageList<ResourceGroup> findAvailableResourceGroupsForRole(Subject subject, int roleId, int[] excludeIds, PageControl pageControl) {
        pageControl.initDefaultOrderingField("rg.name");
        List excludeList = ArrayUtils.wrapInList((int[])excludeIds);
        String queryName = excludeList != null && excludeList.size() != 0 ? "ResourceGroup.getAvailableResourceGroupsForRoleWithExcludes" : "ResourceGroup.getAvailableResourceGroupsForRole";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pageControl);
        if (excludeList != null && excludeList.size() != 0) {
            queryCount.setParameter("excludeIds", (Object)excludeList);
            query.setParameter("excludeIds", (Object)excludeList);
        }
        queryCount.setParameter("roleId", (Object)roleId);
        query.setParameter("roleId", (Object)roleId);
        long count = (Long)queryCount.getSingleResult();
        List groups = query.getResultList();
        return new PageList((Collection)groups, (int)count, pageControl);
    }

    @Override
    public PageList<ResourceGroup> findResourceGroupByIds(Subject subject, int[] resourceGroupIds, PageControl pageControl) {
        String queryName;
        pageControl.initDefaultOrderingField("rg.name");
        List groupIdList = ArrayUtils.wrapInList((int[])resourceGroupIds);
        if (groupIdList == null || groupIdList.size() == 0) {
            return new PageList(pageControl);
        }
        Query queryCount = null;
        Query query = null;
        if (this.authorizationManager.isInventoryManager(subject)) {
            queryName = "ResourceGroup.findByIds_admin";
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ResourceGroup.findByIds_admin");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ResourceGroup.findByIds_admin", (PageControl)pageControl);
        } else {
            queryName = "ResourceGroup.findByIds";
            queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ResourceGroup.findByIds");
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ResourceGroup.findByIds", (PageControl)pageControl);
            queryCount.setParameter("subject", (Object)subject);
            query.setParameter("subject", (Object)subject);
        }
        queryCount.setParameter("ids", (Object)groupIdList);
        query.setParameter("ids", (Object)groupIdList);
        long count = (Long)queryCount.getSingleResult();
        List groups = query.getResultList();
        return new PageList((Collection)groups, (int)count, pageControl);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void updateImplicitGroupMembership(Subject subject, org.rhq.core.domain.resource.Resource resource) {
        Query query = this.entityManager.createNamedQuery("ResourceGroup.findImplicitRecursiveGroupIdsByResourceId");
        query.setParameter("id", (Object)resource.getParentResource().getId());
        List implicitRecursiveGroupIds = query.getResultList();
        if (implicitRecursiveGroupIds.size() == 0) {
            return;
        }
        ArrayList<Integer> resourceIdsToAdd = new ArrayList<Integer>();
        LinkedList<org.rhq.core.domain.resource.Resource> toBeSearched = new LinkedList<org.rhq.core.domain.resource.Resource>();
        toBeSearched.add(resource);
        while (toBeSearched.size() > 0) {
            org.rhq.core.domain.resource.Resource next = (org.rhq.core.domain.resource.Resource)toBeSearched.remove(0);
            resourceIdsToAdd.add(next.getId());
            toBeSearched.addAll(next.getChildResources());
        }
        Connection conn = null;
        PreparedStatement insertImplicitStatement = null;
        try {
            conn = this.rhqDs.getConnection();
            for (Integer implicitRecursiveGroupId : implicitRecursiveGroupIds) {
                String insertImplicitQueryString = JDBCUtil.transformQueryForMultipleInParameters((String)"    insert into RHQ_RESOURCE_GROUP_RES_IMP_MAP ( RESOURCE_ID, RESOURCE_GROUP_ID )          select res.ID, ?            from RHQ_RESOURCE res           where res.ID in ( @@RESOURCE_IDS@@ ) ", (String)"@@RESOURCE_IDS@@", (int)resourceIdsToAdd.size());
                insertImplicitStatement = conn.prepareStatement(insertImplicitQueryString);
                insertImplicitStatement.setInt(1, implicitRecursiveGroupId);
                JDBCUtil.bindNTimes((PreparedStatement)insertImplicitStatement, (int[])ArrayUtils.unwrapCollection(resourceIdsToAdd), (int)2);
                insertImplicitStatement.executeUpdate();
            }
        }
        catch (Exception e) {
            throw new ResourceGroupUpdateException("Could not add resource[id=" + resource.getId() + "] to necessary implicit groups", e);
        }
        finally {
            JDBCUtil.safeClose(insertImplicitStatement);
            JDBCUtil.safeClose((Connection)conn);
        }
    }

    @Override
    public List<org.rhq.core.domain.resource.Resource> findResourcesForAutoGroup(Subject subject, int autoGroupParentResourceId, int autoGroupChildResourceTypeId) {
        List resources;
        try {
            Query q = this.entityManager.createNamedQuery("Resource.findForAutogroup");
            q.setParameter("type", (Object)autoGroupChildResourceTypeId);
            q.setParameter("parent", (Object)autoGroupParentResourceId);
            q.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
            resources = q.getResultList();
        }
        catch (PersistenceException pe) {
            return new ArrayList<org.rhq.core.domain.resource.Resource>();
        }
        return resources;
    }

    @Override
    public List<org.rhq.core.domain.resource.Resource> findResourcesForResourceGroup(Subject subject, int groupId, GroupCategory category) {
        ResourceGroup group = this.getResourceGroupById(subject, groupId, category);
        Set res = group.getExplicitResources();
        if (res != null && res.size() > 0) {
            List resources = PersistenceUtility.getHibernateSession((EntityManager)this.entityManager).createFilter((Object)res, "where this.inventoryStatus = :inventoryStatus").setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED).list();
            return resources;
        }
        ArrayList<org.rhq.core.domain.resource.Resource> ret = new ArrayList<org.rhq.core.domain.resource.Resource>(res.size());
        ret.addAll(res);
        return ret;
    }

    @Override
    public int[] findDefinitionsForAutoGroup(Subject subject, int autoGroupParentResourceId, int autoGroupChildResourceTypeId, boolean displayTypeSummaryOnly) {
        int[] ret;
        try {
            ResourceType rt = (ResourceType)this.entityManager.find(ResourceType.class, (Object)autoGroupChildResourceTypeId);
            ret = this.getMeasurementDefinitionIdsForResourceType(rt, displayTypeSummaryOnly);
        }
        catch (EntityNotFoundException enfe) {
            ret = new int[]{};
        }
        return ret;
    }

    @Override
    public int[] findDefinitionsForCompatibleGroup(Subject subject, int groupId, boolean displayTypeSummaryOnly) {
        int[] ret = new int[]{};
        try {
            ResourceGroup group = this.getResourceGroupById(subject, groupId, GroupCategory.COMPATIBLE);
            Set resources = group.getExplicitResources();
            if (resources != null && resources.size() > 0) {
                org.rhq.core.domain.resource.Resource resource = (org.rhq.core.domain.resource.Resource)resources.iterator().next();
                ResourceType type = resource.getResourceType();
                ret = this.getMeasurementDefinitionIdsForResourceType(type, displayTypeSummaryOnly);
            }
        }
        catch (ResourceGroupNotFoundException e) {
            this.log.debug((Object)("Resources for groupID: " + groupId + " not found " + e));
        }
        return ret;
    }

    private int[] getMeasurementDefinitionIdsForResourceType(ResourceType type, boolean summariesOnly) {
        String queryString = "SELECT id   FROM MeasurementDefinition md  WHERE md.resourceType.id = :resourceTypeId ";
        queryString = queryString + " AND md.dataType = :dataType";
        if (summariesOnly) {
            queryString = queryString + " AND md.displayType = :dispType";
        }
        queryString = queryString + " ORDER BY md.displayOrder, md.displayName";
        Query q = this.entityManager.createQuery(queryString);
        q.setParameter("resourceTypeId", (Object)type.getId());
        q.setParameter("dataType", (Object)DataType.MEASUREMENT);
        if (summariesOnly) {
            q.setParameter("dispType", (Object)DisplayType.SUMMARY);
        }
        List res = q.getResultList();
        int[] ret = new int[res.size()];
        int i = 0;
        for (Integer r : res) {
            ret[i++] = r;
        }
        return ret;
    }

    @Override
    public ResourceGroup getByGroupDefinitionAndGroupByClause(int groupDefinitionId, String groupByClause) {
        Query query = this.entityManager.createNamedQuery("ResourceGroup.findByGroupDefinitionAndExpression");
        if (groupByClause.equals("")) {
            groupByClause = null;
        }
        query.setParameter("groupDefinitionId", (Object)groupDefinitionId);
        query.setParameter("groupByClause", (Object)groupByClause);
        List groups = query.getResultList();
        if (groups.size() == 1) {
            ResourceGroup group = (ResourceGroup)groups.get(0);
            return group;
        }
        return null;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setResourceType(int resourceGroupId) throws ResourceGroupDeleteException {
        Query query = this.entityManager.createNamedQuery("ResourceType.getExplicitResourceTypeCountsByGroup");
        query.setParameter("groupId", (Object)resourceGroupId);
        Subject overlord = this.subjectManager.getOverlord();
        ResourceGroup resourceGroup = this.getResourceGroupById(overlord, resourceGroupId, null);
        List results = query.getResultList();
        if (results.size() == 1) {
            Object[] info = (Object[])results.get(0);
            int resourceTypeId = (Integer)info[0];
            ResourceType flyWeightType = new ResourceType();
            flyWeightType.setId(resourceTypeId);
            resourceGroup.setResourceType(flyWeightType);
        } else {
            if (resourceGroup.getResourceType() != null) {
                this.removeCompatibleGroupConstructs(overlord, resourceGroup);
            }
            resourceGroup.setResourceType(null);
        }
    }

    @Override
    public int getExplicitGroupMemberCount(int resourceGroupId) {
        Query countQuery = this.entityManager.createNamedQuery("ResourceWithAvailability.findExplicitByResourceGroup_count_admin");
        countQuery.setParameter("groupId", (Object)resourceGroupId);
        long count = (Long)countQuery.getSingleResult();
        return (int)count;
    }

    @Override
    public int getImplicitGroupMemberCount(int resourceGroupId) {
        Query countQuery = this.entityManager.createNamedQuery("ResourceWithAvailability.findImplicitByResourceGroup_count_admin");
        countQuery.setParameter("groupId", (Object)resourceGroupId);
        long count = (Long)countQuery.getSingleResult();
        return (int)count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PageList<ResourceGroupComposite> findResourceGroupComposites(Subject subject, GroupCategory groupCategory, ResourceCategory resourceCategory, String resourceTypeName, String pluginName, String nameFilter, Integer resourceId, Integer groupId, PageControl pc) {
        Query queryCount;
        if (resourceId == null && groupId == null) {
            return new PageList(0, pc);
        }
        String query = "         SELECT               (     SELECT COUNT(eresAvail.ID)                       FROM rhq_resource_avail eresAvail                 INNER JOIN rhq_resource eres                         ON eresAvail.resource_id = eres.id                 INNER JOIN rhq_resource_group_res_exp_map expMap                         ON eres.id = expMap.resource_id                      WHERE expMap.resource_group_id = rg.id AND eres.inventory_status = 'COMMITTED'               ) as explicitCount,               (     SELECT COUNT(eresAvail.ID)                       FROM rhq_resource_avail eresAvail                 INNER JOIN rhq_resource eres                         ON eresAvail.resource_id = eres.id                 INNER JOIN rhq_resource_group_res_exp_map expMap                         ON eres.id = expMap.resource_id                      WHERE expMap.resource_group_id = rg.id AND eres.inventory_status = 'COMMITTED'                        AND eresAvail.availability_type = 0               ) as explicitDown,               (     SELECT COUNT(eresAvail.ID)                       FROM rhq_resource_avail eresAvail                 INNER JOIN rhq_resource eres                         ON eresAvail.resource_id = eres.id                 INNER JOIN rhq_resource_group_res_exp_map expMap                         ON eres.id = expMap.resource_id                      WHERE expMap.resource_group_id = rg.id AND eres.inventory_status = 'COMMITTED'                        AND eresAvail.availability_type = 2               ) as explicitUnknown,               (     SELECT COUNT(eresAvail.ID)                       FROM rhq_resource_avail eresAvail                 INNER JOIN rhq_resource eres                         ON eresAvail.resource_id = eres.id                 INNER JOIN rhq_resource_group_res_exp_map expMap                         ON eres.id = expMap.resource_id                      WHERE expMap.resource_group_id = rg.id AND eres.inventory_status = 'COMMITTED'                        AND eresAvail.availability_type = 3               ) as explicitDisabled,               (     SELECT COUNT(iresAvail.ID)                       FROM rhq_resource_avail iresAvail                 INNER JOIN rhq_resource ires                         ON iresAvail.resource_id = ires.id                 INNER JOIN rhq_resource_group_res_imp_map impMap                         ON ires.id = impMap.resource_id                      WHERE impMap.resource_group_id = rg.id AND ires.inventory_status = 'COMMITTED'               ) as implicitCount,               (     SELECT COUNT(iresAvail.ID)                       FROM rhq_resource_avail iresAvail                 INNER JOIN rhq_resource ires                         ON iresAvail.resource_id = ires.id                 INNER JOIN rhq_resource_group_res_imp_map impMap                         ON ires.id = impMap.resource_id                      WHERE impMap.resource_group_id = rg.id AND ires.inventory_status = 'COMMITTED'                        AND iresAvail.availability_type = 0               ) as implicitDown,               (     SELECT COUNT(iresAvail.ID)                       FROM rhq_resource_avail iresAvail                 INNER JOIN rhq_resource ires                         ON iresAvail.resource_id = ires.id                 INNER JOIN rhq_resource_group_res_imp_map impMap                         ON ires.id = impMap.resource_id                      WHERE impMap.resource_group_id = rg.id AND ires.inventory_status = 'COMMITTED'                        AND iresAvail.availability_type = 2               ) as implicitUnknown,               (     SELECT COUNT(iresAvail.ID)                       FROM rhq_resource_avail iresAvail                 INNER JOIN rhq_resource ires                         ON iresAvail.resource_id = ires.id                 INNER JOIN rhq_resource_group_res_imp_map impMap                         ON ires.id = impMap.resource_id                      WHERE impMap.resource_group_id = rg.id AND ires.inventory_status = 'COMMITTED'                        AND iresAvail.availability_type = 3               ) as implicitDisabled,                 rg.id as groupId,                 rg.name as groupName,                 rg.description as groupDescription,                 resType.name as resourceTypeName            FROM rhq_resource_group rg LEFT OUTER JOIN rhq_resource_type resType              ON rg.resource_type_id = resType.id LEFT OUTER JOIN rhq_resource_group_res_imp_map memberMap              ON rg.id = memberMap.resource_group_id LEFT OUTER JOIN rhq_resource res              ON memberMap.resource_id = res.id                 %SECURITY_FRAGMENT_JOIN%LEFT OUTER JOIN rhq_resource_avail resAvail              ON res.id = resAvail.resource_id           WHERE %GROUP_AND_VISIBILITY_FRAGMENT_WHERE%                 %RESOURCE_FRAGMENT_WHERE%             AND ( ? IS NULL                   OR UPPER(rg.name) LIKE ? ESCAPE ?                  OR UPPER(rg.description) LIKE ? ESCAPE ?)             AND ( rg.resource_type_id IS NULL                   OR ( ( resType.name = ? OR ? IS NULL )                       AND ( resType.plugin = ? OR ? IS NULL )                       AND ( resType.category = ? OR ? IS NULL ) ) )             AND ( rg.category = ? OR ? IS NULL )                 %SECURITY_FRAGMENT_WHERE%       GROUP BY rg.id, rg.category, rg.name, rg.group_by, rg.description, resType.name, resType.plugin ";
        if (this.authorizationManager.isInventoryManager(subject)) {
            query = query.replace("%SECURITY_FRAGMENT_JOIN%", "");
            query = query.replace("%SECURITY_FRAGMENT_WHERE%", "");
        } else {
            query = query.replace("%SECURITY_FRAGMENT_JOIN%", " INNER JOIN rhq_role_resource_group_map roleMap          ON roleMap.resource_group_id = rg.id  INNER JOIN rhq_subject_role_map subjectMap          ON subjectMap.role_id = roleMap.role_id ");
            query = query.replace("%SECURITY_FRAGMENT_WHERE%", " AND ( subjectMap.subject_id = ? ) ");
        }
        query = resourceId != null ? query.replace("%RESOURCE_FRAGMENT_WHERE%", " AND ( res.id = ? ) ") : query.replace("%RESOURCE_FRAGMENT_WHERE%", "");
        pc.initDefaultOrderingField("groupName");
        pc.truncateOrderingFields(1);
        OrderingField primary = (OrderingField)pc.getOrderingFields().get(0);
        String field = primary.getField();
        if (field.endsWith("Avail")) {
            String prefix = field.substring(0, field.length() - 5);
            String secondaryField = prefix + "Count";
            pc.addDefaultOrderingField(secondaryField, primary.getOrdering());
        }
        if (!field.equals("groupName")) {
            pc.addDefaultOrderingField("groupName");
        }
        nameFilter = QueryUtility.formatSearchParameter(nameFilter);
        Connection conn = null;
        PreparedStatement stmt = null;
        ArrayList<Object[]> rawResults = new ArrayList<Object[]>();
        try {
            conn = this.rhqDs.getConnection();
            if (groupId == null) {
                if (this.dbType instanceof PostgresqlDatabaseType || this.dbType instanceof H2DatabaseType) {
                    query = query.replace("%GROUP_AND_VISIBILITY_FRAGMENT_WHERE%", "rg.visible = TRUE");
                } else {
                    if (!(this.dbType instanceof OracleDatabaseType) && !(this.dbType instanceof SQLServerDatabaseType)) throw new RuntimeException("Unknown database type: " + this.dbType);
                    query = query.replace("%GROUP_AND_VISIBILITY_FRAGMENT_WHERE%", "rg.visible = 1");
                }
            } else {
                query = query.replace("%GROUP_AND_VISIBILITY_FRAGMENT_WHERE%", "rg.id = ?");
            }
            if (this.dbType instanceof PostgresqlDatabaseType) {
                query = PersistenceUtility.addPostgresNativePagingSortingToQuery((String)query, (PageControl)pc);
            } else if (this.dbType instanceof OracleDatabaseType) {
                query = PersistenceUtility.addOracleNativePagingSortingToQuery((String)query, (PageControl)pc);
            } else if (this.dbType instanceof H2DatabaseType) {
                query = PersistenceUtility.addH2NativePagingSortingToQuery((String)query, (PageControl)pc);
            } else {
                if (!(this.dbType instanceof SQLServerDatabaseType)) throw new RuntimeException("Unknown database type: " + this.dbType);
                query = PersistenceUtility.addSQLServerNativePagingSortingToQuery((String)query, (PageControl)pc);
            }
            stmt = conn.prepareStatement(query);
            String search = nameFilter;
            String resourceCategoryName = resourceCategory == null ? null : resourceCategory.name();
            String groupCategoryName = groupCategory == null ? null : groupCategory.name();
            int i = 0;
            if (resourceId != null) {
                stmt.setInt(++i, resourceId);
            }
            if (groupId != null) {
                stmt.setInt(++i, groupId);
            }
            if (search == null) {
                stmt.setNull(++i, 12);
                stmt.setNull(++i, 12);
                stmt.setString(++i, QueryUtility.getEscapeCharacter());
                stmt.setNull(++i, 12);
                stmt.setString(++i, QueryUtility.getEscapeCharacter());
            } else {
                stmt.setString(++i, search);
                stmt.setString(++i, search);
                stmt.setString(++i, QueryUtility.getEscapeCharacter());
                stmt.setString(++i, search);
                stmt.setString(++i, QueryUtility.getEscapeCharacter());
            }
            if (resourceTypeName == null) {
                stmt.setNull(++i, 12);
                stmt.setNull(++i, 12);
            } else {
                stmt.setString(++i, resourceTypeName);
                stmt.setString(++i, resourceTypeName);
            }
            if (pluginName == null) {
                stmt.setNull(++i, 12);
                stmt.setNull(++i, 12);
            } else {
                stmt.setString(++i, pluginName);
                stmt.setString(++i, pluginName);
            }
            if (resourceCategoryName == null) {
                stmt.setNull(++i, 12);
                stmt.setNull(++i, 12);
            } else {
                stmt.setString(++i, resourceCategoryName);
                stmt.setString(++i, resourceCategoryName);
            }
            if (groupCategoryName == null) {
                stmt.setNull(++i, 12);
                stmt.setNull(++i, 12);
            } else {
                stmt.setString(++i, groupCategoryName);
                stmt.setString(++i, groupCategoryName);
            }
            if (!this.authorizationManager.isInventoryManager(subject)) {
                stmt.setInt(++i, subject.getId());
            }
            ResultSet rs = stmt.executeQuery();
            try {
                while (rs.next()) {
                    long explicitCount = rs.getLong(1);
                    long explicitDown = rs.getLong(2);
                    long explicitUnknown = rs.getLong(3);
                    long explicitDisabled = rs.getLong(4);
                    long implicitCount = rs.getLong(5);
                    long implicitDown = rs.getLong(6);
                    long implicitUnknown = rs.getLong(7);
                    long implicitDisabled = rs.getLong(8);
                    int groupKey = rs.getInt(9);
                    Object[] next = new Object[]{explicitCount, explicitDown, explicitUnknown, explicitDisabled, implicitCount, implicitDown, implicitUnknown, implicitDisabled, groupKey};
                    rawResults.add(next);
                }
            }
            finally {
                rs.close();
            }
        }
        catch (Throwable t) {
            PageList resourceCategoryName;
            try {
                this.log.error((Object)("Could not execute groups query [ " + query + " ]: "), t);
                resourceCategoryName = new PageList();
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose((Connection)conn, stmt, null);
                throw throwable;
            }
            JDBCUtil.safeClose((Connection)conn, (Statement)stmt, null);
            return resourceCategoryName;
        }
        JDBCUtil.safeClose((Connection)conn, (Statement)stmt, null);
        if (this.authorizationManager.isInventoryManager(subject)) {
            queryCount = this.entityManager.createNamedQuery("ResourceGroup.findAllFiltered_Count_Admin");
        } else {
            queryCount = this.entityManager.createNamedQuery("ResourceGroup.findAllFiltered_Count");
            queryCount.setParameter("subject", (Object)subject);
        }
        queryCount.setParameter("groupCategory", (Object)groupCategory);
        queryCount.setParameter("category", (Object)resourceCategory);
        queryCount.setParameter("resourceTypeName", (Object)resourceTypeName);
        queryCount.setParameter("pluginName", (Object)pluginName);
        queryCount.setParameter("search", (Object)nameFilter);
        queryCount.setParameter("resourceId", (Object)resourceId);
        queryCount.setParameter("groupId", (Object)groupId);
        long count = (Long)queryCount.getSingleResult();
        ArrayList<Integer> groupIds = new ArrayList<Integer>();
        for (Object[] row : rawResults) {
            groupIds.add(((Number)row[8]).intValue());
        }
        Map<Integer, ResourceGroup> groupMap = this.getIdGroupMap(groupIds);
        ArrayList<ResourceGroupComposite> results = new ArrayList<ResourceGroupComposite>(rawResults.size());
        int i = 0;
        for (Object[] row : rawResults) {
            ResourceGroup group;
            ResourceType type;
            long explicitCount = (Long)row[0];
            long explicitDown = (Long)row[1];
            long explicitUnknown = (Long)row[2];
            long explicitDisabled = (Long)row[3];
            long implicitCount = (Long)row[4];
            long implicitDown = (Long)row[5];
            long implicitUnknown = (Long)row[6];
            long implicitDisabled = (Long)row[7];
            ResourceFacets facets = (type = (group = groupMap.get(groupIds.get(i++))).getResourceType()) == null ? ResourceFacets.NONE : this.resourceTypeManager.getResourceFacets(type.getId());
            ResourceGroupComposite composite = new ResourceGroupComposite(Long.valueOf(explicitCount), Long.valueOf(explicitDown), Long.valueOf(explicitUnknown), Long.valueOf(explicitDisabled), Long.valueOf(implicitCount), Long.valueOf(implicitDown), Long.valueOf(implicitUnknown), Long.valueOf(implicitDisabled), group, facets);
            Set<Permission> perms = this.authorizationManager.getImplicitGroupPermissions(subject, group.getId());
            composite.setResourcePermission(new ResourcePermission(perms));
            results.add(composite);
        }
        return new PageList(results, (int)count, pc);
    }

    private Map<Integer, ResourceGroup> getIdGroupMap(List<Integer> groupIds) {
        if (groupIds == null || groupIds.size() == 0) {
            return new HashMap<Integer, ResourceGroup>();
        }
        Query query = this.entityManager.createNamedQuery("ResourceGroup.findByIds_admin");
        query.setParameter("ids", groupIds);
        List groups = query.getResultList();
        HashMap<Integer, ResourceGroup> results = new HashMap<Integer, ResourceGroup>();
        for (ResourceGroup group : groups) {
            results.put(group.getId(), group);
        }
        return results;
    }

    @Override
    public List<Integer> findDeletedResourceGroupIds(int[] possibleGroupIds) {
        List groupIds = ArrayUtils.wrapInList((int[])possibleGroupIds);
        if (groupIds == null || groupIds.size() == 0) {
            return Collections.emptyList();
        }
        String queryString = "SELECT rg.id   FROM ResourceGroup rg  WHERE rg.id IN ( :groupIds ) ";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("groupIds", (Object)groupIds);
        List validIds = query.getResultList();
        groupIds.removeAll(validIds);
        return groupIds;
    }

    @Override
    public void setAssignedResources(Subject subject, int groupId, int[] resourceIds, boolean setType) throws ResourceGroupDeleteException {
        ResourceGroup group = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)groupId);
        if (group.isPrivateGroup()) {
            ArrayList<Integer> ids = new ArrayList<Integer>(resourceIds.length);
            for (int id : resourceIds) {
                ids.add(id);
            }
            if (!this.authorizationManager.canViewResources(subject, ids)) {
                throw new PermissionException("Subject [" + subject.getName() + "] does not have VIEW permission for all specified resources.");
            }
        } else if (!this.authorizationManager.isInventoryManager(subject)) {
            throw new PermissionException("Subject [" + subject.getName() + "] is not authorized for [ MANAGE_INVENTORY ]. Required for changing group membership ");
        }
        List<Integer> currentMembers = this.resourceManager.findExplicitResourceIdsByResourceGroup(groupId);
        List newMembers = ArrayUtils.wrapInList((int[])resourceIds);
        newMembers.removeAll(currentMembers);
        if (newMembers.size() > 0) {
            this.addResourcesToGroup(this.subjectManager.getOverlord(), groupId, ArrayUtils.unwrapCollection((Collection)newMembers), false);
        }
        ArrayList<Integer> extraMembers = new ArrayList<Integer>(currentMembers);
        extraMembers.removeAll(ArrayUtils.wrapInList((int[])resourceIds));
        if (extraMembers.size() > 0) {
            this.removeResourcesFromGroup(this.subjectManager.getOverlord(), groupId, ArrayUtils.unwrapCollection(extraMembers), false);
        }
        if (setType) {
            this.setResourceType(groupId);
        }
    }

    @Override
    public void setAssignedResourceGroupsForResource(Subject subject, int resourceId, int[] resourceGroupIds, boolean setType) throws ResourceGroupDeleteException {
        org.rhq.core.domain.resource.Resource resource = (org.rhq.core.domain.resource.Resource)this.entityManager.find(org.rhq.core.domain.resource.Resource.class, (Object)resourceId);
        Set currentGroups = resource.getExplicitGroups();
        ArrayList<Integer> currentGroupIds = new ArrayList<Integer>(currentGroups.size());
        for (ResourceGroup currentGroup : currentGroups) {
            currentGroupIds.add(currentGroup.getId());
        }
        int[] resourceIdArr = new int[]{resourceId};
        List addedGroupIds = ArrayUtils.wrapInList((int[])resourceGroupIds);
        addedGroupIds.removeAll(currentGroupIds);
        for (Integer addedGroupId : addedGroupIds) {
            this.addResourcesToGroup(subject, addedGroupId, resourceIdArr);
            if (!setType) continue;
            this.setResourceType(addedGroupId);
        }
        ArrayList removedGroupIds = new ArrayList(currentGroupIds);
        removedGroupIds.removeAll(ArrayUtils.wrapInList((int[])resourceGroupIds));
        for (Integer removedGroupId : removedGroupIds) {
            this.removeResourcesFromGroup(subject, removedGroupId, resourceIdArr);
            if (!setType) continue;
            this.setResourceType(removedGroupId);
        }
    }

    @Override
    public ResourceGroup getResourceGroup(Subject subject, int groupId) {
        return this.getResourceGroupById(subject, groupId, null);
    }

    @Override
    public ResourceGroupComposite getResourceGroupComposite(Subject subject, int groupId) {
        if (!this.authorizationManager.canViewGroup(subject, groupId)) {
            throw new PermissionException("You do not have permission to view this resource group");
        }
        String queryString = "SELECT \n  (SELECT count(er)        FROM ResourceGroup g JOIN g.explicitResources er where er.inventoryStatus = 'COMMITTED' and g.id = :groupId),\n  (SELECT count(er)        FROM ResourceGroup g JOIN g.explicitResources er where er.inventoryStatus = 'COMMITTED' and g.id = :groupId        AND er.currentAvailability.availabilityType = 0 ),\n  (SELECT count(er)        FROM ResourceGroup g JOIN g.explicitResources er where er.inventoryStatus = 'COMMITTED' and g.id = :groupId        AND er.currentAvailability.availabilityType = 2 ),\n  (SELECT count(er)        FROM ResourceGroup g JOIN g.explicitResources er where er.inventoryStatus = 'COMMITTED' and g.id = :groupId        AND er.currentAvailability.availabilityType = 3 ),\n  (SELECT count(ir)        FROM ResourceGroup g JOIN g.implicitResources ir where ir.inventoryStatus = 'COMMITTED' and g.id = :groupId),\n  (SELECT count(ir)        FROM ResourceGroup g JOIN g.implicitResources ir where ir.inventoryStatus = 'COMMITTED' and g.id = :groupId        AND ir.currentAvailability.availabilityType = 0 ),\n  (SELECT count(ir)        FROM ResourceGroup g JOIN g.implicitResources ir where ir.inventoryStatus = 'COMMITTED' and g.id = :groupId        AND ir.currentAvailability.availabilityType = 2 ),\n  (SELECT count(ir)        FROM ResourceGroup g JOIN g.implicitResources ir where ir.inventoryStatus = 'COMMITTED' and g.id = :groupId        AND ir.currentAvailability.availabilityType = 3 )\n,    g FROM ResourceGroup g where g.id = :groupId";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("groupId", (Object)groupId);
        List results = query.getResultList();
        if (results.size() == 0) {
            throw new ResourceGroupNotFoundException(groupId);
        }
        Object[] data = (Object[])results.get(0);
        ResourceGroup group = (ResourceGroup)data[8];
        ResourceType type = group.getResourceType();
        ResourceFacets facets = type == null ? ResourceFacets.NONE : this.resourceTypeManager.getResourceFacets(group.getResourceType().getId());
        ResourceGroupComposite composite = null;
        if (((Number)data[4]).longValue() > 0L) {
            long explicitCount = ((Number)data[0]).longValue();
            long explicitDown = ((Number)data[1]).longValue();
            long explicitUnknown = ((Number)data[2]).longValue();
            long explicitDisabled = ((Number)data[3]).longValue();
            long implicitCount = ((Number)data[4]).longValue();
            long implicitDown = ((Number)data[5]).longValue();
            long implicitUnknown = ((Number)data[6]).longValue();
            long implicitDisabled = ((Number)data[7]).longValue();
            composite = new ResourceGroupComposite(Long.valueOf(explicitCount), Long.valueOf(explicitDown), Long.valueOf(explicitUnknown), Long.valueOf(explicitDisabled), Long.valueOf(implicitCount), Long.valueOf(implicitDown), Long.valueOf(implicitUnknown), Long.valueOf(implicitDisabled), group, facets);
        } else {
            composite = new ResourceGroupComposite(Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), group, facets);
        }
        return composite;
    }

    @Override
    public PageList<ResourceGroup> findResourceGroupsForRole(Subject subject, int roleId, PageControl pc) {
        pc.initDefaultOrderingField("rg.name");
        String queryName = null;
        queryName = this.authorizationManager.hasGlobalPermission(subject, Permission.MANAGE_SETTINGS) ? "ResourceGroup.getResourceGroupsAssignedToRole_admin" : "ResourceGroup.getResourceGroupsAssignedToRole";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        if (!this.authorizationManager.hasGlobalPermission(subject, Permission.MANAGE_SETTINGS)) {
            queryCount.setParameter("subjectId", (Object)subject.getId());
            query.setParameter("subjectId", (Object)subject.getId());
        }
        queryCount.setParameter("id", (Object)roleId);
        query.setParameter("id", (Object)roleId);
        long count = (Long)queryCount.getSingleResult();
        List groups = query.getResultList();
        return new PageList((Collection)groups, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void setRecursive(Subject subject, int groupId, boolean isRecursive) {
        ResourceGroup group = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)groupId);
        if (group == null) {
            throw new ResourceGroupNotFoundException(groupId);
        }
        this.updateResourceGroup(subject, group, isRecursive ? RecursivityChangeType.AddedRecursion : RecursivityChangeType.RemovedRecursion);
    }

    @Override
    public PageList<ResourceGroup> findResourceGroupsByCriteria(Subject subject, ResourceGroupCriteria criteria) {
        CriteriaAuthzType authzType = this.getCriteriaAuthzType(subject, criteria);
        CriteriaQueryGenerator generator = this.getCriteriaQueryGenerator(subject, criteria, authzType);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        PageList result = queryRunner.execute();
        return result;
    }

    @Override
    public PageList<ResourceGroupComposite> findResourceGroupCompositesByCriteria(Subject subject, ResourceGroupCriteria criteria) {
        CriteriaAuthzType authzType = this.getCriteriaAuthzType(subject, criteria);
        String compositeProjection = null;
        switch (authzType) {
            case NONE: 
            case SUBJECT_OWNED: {
                compositeProjection = " new org.rhq.core.domain.resource.group.composite.ResourceGroupComposite(    ( SELECT COUNT(avail) FROM %alias%.explicitResources res JOIN res.currentAvailability avail WHERE res.inventoryStatus = 'COMMITTED' ) AS explicitCount,   ( SELECT COUNT(avail) FROM %alias%.explicitResources res JOIN res.currentAvailability avail WHERE res.inventoryStatus = 'COMMITTED' AND avail.availabilityType = 0 ) AS explicitDown,   ( SELECT COUNT(avail) FROM %alias%.explicitResources res JOIN res.currentAvailability avail WHERE res.inventoryStatus = 'COMMITTED' AND avail.availabilityType = 2 ) AS explicitUnknown,   ( SELECT COUNT(avail) FROM %alias%.explicitResources res JOIN res.currentAvailability avail WHERE res.inventoryStatus = 'COMMITTED' AND avail.availabilityType = 3 ) AS explicitDisabled,   ( SELECT COUNT(avail) FROM %alias%.implicitResources res JOIN res.currentAvailability avail WHERE res.inventoryStatus = 'COMMITTED' ) AS implicitCount,   ( SELECT COUNT(avail) FROM %alias%.implicitResources res JOIN res.currentAvailability avail WHERE res.inventoryStatus = 'COMMITTED' AND avail.availabilityType = 0 ) AS implicitDown,   ( SELECT COUNT(avail) FROM %alias%.implicitResources res JOIN res.currentAvailability avail WHERE res.inventoryStatus = 'COMMITTED' AND avail.availabilityType = 2 ) AS implicitUnknown,   ( SELECT COUNT(avail) FROM %alias%.implicitResources res JOIN res.currentAvailability avail WHERE res.inventoryStatus = 'COMMITTED' AND avail.availabilityType = 3 ) AS implicitDisabled,    %alias% ) ";
                break;
            }
            case ROLE_OWNED: 
            case AUTO_CLUSTER: {
                compositeProjection = " new org.rhq.core.domain.resource.group.composite.ResourceGroupComposite(    ( SELECT COUNT(avail) FROM %alias%.explicitResources res JOIN res.currentAvailability avail WHERE res.inventoryStatus = 'COMMITTED' ) AS explicitCount,   ( SELECT COUNT(avail) FROM %alias%.explicitResources res JOIN res.currentAvailability avail WHERE res.inventoryStatus = 'COMMITTED' AND avail.availabilityType = 0 ) AS explicitDown,   ( SELECT COUNT(avail) FROM %alias%.explicitResources res JOIN res.currentAvailability avail WHERE res.inventoryStatus = 'COMMITTED' AND avail.availabilityType = 2 ) AS explicitUnknown,   ( SELECT COUNT(avail) FROM %alias%.explicitResources res JOIN res.currentAvailability avail WHERE res.inventoryStatus = 'COMMITTED' AND avail.availabilityType = 3 ) AS explicitDisabled,   ( SELECT COUNT(avail) FROM %alias%.implicitResources res JOIN res.currentAvailability avail WHERE res.inventoryStatus = 'COMMITTED' ) AS implicitCount,   ( SELECT COUNT(avail) FROM %alias%.implicitResources res JOIN res.currentAvailability avail WHERE res.inventoryStatus = 'COMMITTED' AND avail.availabilityType = 0 ) AS implicitDown,   ( SELECT COUNT(avail) FROM %alias%.implicitResources res JOIN res.currentAvailability avail WHERE res.inventoryStatus = 'COMMITTED' AND avail.availabilityType = 2 ) AS implicitUnknown,   ( SELECT COUNT(avail) FROM %alias%.implicitResources res JOIN res.currentAvailability avail WHERE res.inventoryStatus = 'COMMITTED' AND avail.availabilityType = 3 ) AS implicitDisabled,    %alias%,    ( SELECT count(p) FROM %permAlias%.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 8 ),    ( SELECT count(p) FROM %permAlias%.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 4 ),    ( SELECT count(p) FROM %permAlias%.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 10 ),    ( SELECT count(p) FROM %permAlias%.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 7 ),    ( SELECT count(p) FROM %permAlias%.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 14 ),    ( SELECT count(p) FROM %permAlias%.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 13 ),    ( SELECT count(p) FROM %permAlias%.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 11 ),    ( SELECT count(p) FROM %permAlias%.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 9 ),    ( SELECT count(p) FROM %permAlias%.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 6 ),    ( SELECT count(p) FROM %permAlias%.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 5 ),    ( SELECT count(p) FROM %permAlias%.roles r JOIN r.subjects s JOIN r.permissions p WHERE s.id = %subjectId% AND p = 16 ))";
                compositeProjection = compositeProjection.replace("%subjectId%", String.valueOf(subject.getId()));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected CriteriaAuthzType: " + (Object)((Object)authzType));
            }
        }
        String alias = criteria.getAlias();
        compositeProjection = compositeProjection.replace("%alias%", alias);
        String permAlias = alias + (authzType == CriteriaAuthzType.AUTO_CLUSTER ? ".clusterResourceGroup" : "");
        compositeProjection = compositeProjection.replace("%permAlias%", permAlias);
        CriteriaQueryGenerator generator = this.getCriteriaQueryGenerator(subject, criteria, authzType);
        generator.alterProjection(compositeProjection);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager, false);
        Object results = queryRunner.execute();
        results = this.getAuthorizedGroupComposites(subject, authzType, (PageList<ResourceGroupComposite>)results);
        for (ResourceGroupComposite composite : results) {
            ResourceGroup group = composite.getResourceGroup();
            ResourceType type = group.getResourceType();
            ResourceFacets facets = type != null ? this.resourceTypeManager.getResourceFacets(type.getId()) : ResourceFacets.NONE;
            queryRunner.initFetchFields(group);
            composite.setResourceFacets(facets);
        }
        return results;
    }

    private CriteriaAuthzType getCriteriaAuthzType(Subject subject, ResourceGroupCriteria criteria) {
        Set<Permission> globalUserPerms = this.authorizationManager.getExplicitGlobalPermissions(subject);
        if (criteria.isSecurityManagerRequired() && !globalUserPerms.contains(Permission.MANAGE_SECURITY)) {
            throw new PermissionException("Subject [" + subject.getName() + "] requires SecurityManager permission for requested query criteria.");
        }
        boolean isInventoryManager = globalUserPerms.contains(Permission.MANAGE_INVENTORY);
        if (criteria.isInventoryManagerRequired() && !isInventoryManager) {
            throw new PermissionException("Subject [" + subject.getName() + "] requires InventoryManager permission for requested query criteria.");
        }
        CriteriaAuthzType result = CriteriaAuthzType.ROLE_OWNED;
        if (isInventoryManager) {
            result = CriteriaAuthzType.NONE;
        } else if (criteria.isFilterPrivate()) {
            result = CriteriaAuthzType.SUBJECT_OWNED;
        } else if (!criteria.isFilterVisible()) {
            result = CriteriaAuthzType.AUTO_CLUSTER;
        }
        return result;
    }

    private CriteriaQueryGenerator getCriteriaQueryGenerator(Subject subject, ResourceGroupCriteria criteria, CriteriaAuthzType authzType) {
        if (criteria.isFilterPrivate()) {
            criteria.addFilterPrivate(null);
            criteria.addFilterSubjectId(Integer.valueOf(subject.getId()));
        }
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (authzType != CriteriaAuthzType.NONE) {
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.GROUP, null, subject.getId());
        }
        return generator;
    }

    private PageList<ResourceGroupComposite> getAuthorizedGroupComposites(Subject subject, CriteriaAuthzType authzType, PageList<ResourceGroupComposite> groupComposites) {
        switch (authzType) {
            case NONE: {
                break;
            }
            case ROLE_OWNED: {
                break;
            }
            case AUTO_CLUSTER: {
                break;
            }
            case SUBJECT_OWNED: {
                for (ResourceGroupComposite groupComposite : groupComposites) {
                    ResourceGroup group = groupComposite.getResourceGroup();
                    Subject groupOwner = group.getSubject();
                    if (null != groupOwner) {
                        groupComposite.setResourcePermission(new ResourcePermission(this.authorizationManager.getExplicitGroupPermissions(groupOwner, group.getId())));
                        continue;
                    }
                    throw new IllegalStateException("Unexpected group, not subject owned: " + groupComposite);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected CriteriaAuthzType: " + (Object)((Object)authzType));
            }
        }
        return groupComposites;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void uninventoryMembers(Subject subject, int groupId) {
        List<Integer> resourceMemberIds = this.resourceManager.findExplicitResourceIdsByResourceGroup(groupId);
        for (int doomedResourceId : resourceMemberIds) {
            this.resourceManager.uninventoryResource(subject, doomedResourceId);
        }
    }

    public void updateResourceGroupName(Subject subject, int groupId, String name) {
        if (name == null) {
            throw new IllegalArgumentException("Group name cannot be null.");
        }
        ResourceGroup group = this.getResourceGroupToBeModified(subject, groupId);
        group.setName(name);
        group.setMtime(Long.valueOf(System.currentTimeMillis()));
    }

    public void updateResourceGroupDescription(Subject subject, int groupId, String description) {
        ResourceGroup group = this.getResourceGroupToBeModified(subject, groupId);
        group.setDescription(description);
        group.setMtime(Long.valueOf(System.currentTimeMillis()));
    }

    public void updateResourceGroupLocation(Subject subject, int groupId, String location) {
        ResourceGroup group = this.getResourceGroupToBeModified(subject, groupId);
        group.setDescription(location);
        group.setMtime(Long.valueOf(System.currentTimeMillis()));
    }

    private ResourceGroup getResourceGroupToBeModified(Subject subject, int groupId) {
        ResourceGroup group = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)groupId);
        if (group == null) {
            throw new ResourceGroupNotFoundException(groupId);
        }
        if (!this.authorizationManager.hasGroupPermission(subject, Permission.MODIFY_RESOURCE, groupId)) {
            throw new PermissionException("User [" + subject + "] does not have permission to modify Resource group with id [" + groupId + "].");
        }
        return group;
    }

    private static enum CriteriaAuthzType {
        NONE,
        ROLE_OWNED,
        SUBJECT_OWNED,
        AUTO_CLUSTER;

    }
}

