/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.group.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.ResourceGroupDefinitionCriteria;
import org.rhq.core.domain.resource.group.GroupDefinition;
import org.rhq.core.domain.resource.group.InvalidExpressionException;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.RecursivityChangeType;
import org.rhq.enterprise.server.resource.group.ResourceGroupDeleteException;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupUpdateException;
import org.rhq.enterprise.server.resource.group.definition.GroupDefinitionManagerLocal;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionAlreadyExistsException;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionCreateException;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionDeleteException;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionException;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionNotFoundException;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionUpdateException;
import org.rhq.enterprise.server.resource.group.definition.framework.ExpressionEvaluator;
import org.rhq.enterprise.server.resource.group.definition.mbean.GroupDefinitionRecalculationThreadMonitor;
import org.rhq.enterprise.server.resource.group.definition.mbean.GroupDefinitionRecalculationThreadMonitorMBean;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

@Stateless
public class GroupDefinitionManagerBean
implements GroupDefinitionManagerLocal {
    private final Log log = LogFactory.getLog(GroupDefinitionManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private GroupDefinitionManagerLocal groupDefinitionManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void recalculateDynaGroups(Subject subject) {
        Query recalculationFinderQuery = this.entityManager.createNamedQuery("GroupDefinition.findIdsForRecalculation_admin");
        recalculationFinderQuery.setParameter("now", (Object)System.currentTimeMillis());
        List groupDefinitionIdsToRecalculate = recalculationFinderQuery.getResultList();
        if (groupDefinitionIdsToRecalculate.size() == 0) {
            return;
        }
        GroupDefinitionRecalculationThreadMonitorMBean monitor = GroupDefinitionRecalculationThreadMonitor.getMBean();
        long totalStart = System.currentTimeMillis();
        for (Integer groupDefinitionId : groupDefinitionIdsToRecalculate) {
            long singleStart = System.currentTimeMillis();
            boolean success = false;
            try {
                this.groupDefinitionManager.calculateGroupMembership(subject, groupDefinitionId);
                success = true;
            }
            catch (Throwable t) {
                this.log.error((Object)("Error recalculating DynaGroups for GroupDefinition[id=" + groupDefinitionId + "]"), t);
            }
            long singleEnd = System.currentTimeMillis();
            try {
                GroupDefinition groupDefinition = this.getById(groupDefinitionId);
                int size = this.getManagedResourceGroupSizeForGroupDefinition(groupDefinitionId);
                monitor.updateStatistic(groupDefinition.getName(), size, success, singleEnd - singleStart);
            }
            catch (Throwable t) {
                this.log.error((Object)("Error updating DynaGroup statistics GroupDefinition[id=" + groupDefinitionId + "]"), t);
            }
        }
        long totalEnd = System.currentTimeMillis();
        monitor.updateAutoRecalculationThreadTime(totalEnd - totalStart);
    }

    @Override
    public GroupDefinition getById(int groupDefinitionId) throws GroupDefinitionNotFoundException {
        GroupDefinition groupDefinition = (GroupDefinition)this.entityManager.find(GroupDefinition.class, (Object)groupDefinitionId);
        if (groupDefinition == null) {
            throw new GroupDefinitionNotFoundException("Group definition with specified id does not exist");
        }
        return groupDefinition;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public GroupDefinition createGroupDefinition(Subject subject, GroupDefinition newGroupDefinition) throws GroupDefinitionAlreadyExistsException, GroupDefinitionCreateException {
        try {
            this.validate(newGroupDefinition, null);
        }
        catch (GroupDefinitionException gde) {
            throw new GroupDefinitionCreateException(gde.getMessage());
        }
        try {
            this.entityManager.persist((Object)newGroupDefinition);
        }
        catch (Exception e) {
            throw new GroupDefinitionCreateException(e);
        }
        return newGroupDefinition;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public GroupDefinition updateGroupDefinition(Subject subject, GroupDefinition groupDefinition) throws GroupDefinitionAlreadyExistsException, GroupDefinitionUpdateException, InvalidExpressionException, ResourceGroupUpdateException {
        boolean nameChanged = false;
        try {
            nameChanged = this.validate(groupDefinition, groupDefinition.getId());
        }
        catch (GroupDefinitionException gde) {
            throw new GroupDefinitionUpdateException(gde.getMessage());
        }
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        for (String expression : groupDefinition.getExpressionAsList()) {
            evaluator.addExpression(expression);
        }
        RecursivityChangeType changeType = RecursivityChangeType.None;
        GroupDefinition attachedGroupDefinition = null;
        try {
            attachedGroupDefinition = this.getById(groupDefinition.getId());
        }
        catch (GroupDefinitionNotFoundException gdnfe) {
            throw new GroupDefinitionUpdateException(gdnfe.getMessage());
        }
        if (groupDefinition.isRecursive() && !attachedGroupDefinition.isRecursive()) {
            changeType = RecursivityChangeType.AddedRecursion;
        } else if (!groupDefinition.isRecursive() && attachedGroupDefinition.isRecursive()) {
            changeType = RecursivityChangeType.RemovedRecursion;
        }
        if (nameChanged || changeType != RecursivityChangeType.None) {
            String oldGroupDefinitionName = attachedGroupDefinition.getName();
            Subject overlord = this.subjectManager.getOverlord();
            for (ResourceGroup dynaGroup : attachedGroupDefinition.getManagedResourceGroups()) {
                String dynaGroupName = dynaGroup.getName();
                String newDynaGroupName = this.updateDynaGroupName(oldGroupDefinitionName, groupDefinition.getName(), dynaGroupName);
                dynaGroup.setName(newDynaGroupName);
                this.resourceGroupManager.updateResourceGroup(overlord, dynaGroup, changeType);
            }
        }
        attachedGroupDefinition.setName(groupDefinition.getName());
        attachedGroupDefinition.setDescription(groupDefinition.getDescription());
        attachedGroupDefinition.setRecursive(groupDefinition.isRecursive());
        attachedGroupDefinition.setExpression(groupDefinition.getExpression());
        attachedGroupDefinition.setRecalculationInterval(groupDefinition.getRecalculationInterval());
        return attachedGroupDefinition;
    }

    private boolean validate(GroupDefinition definition, Integer id) throws GroupDefinitionException, GroupDefinitionAlreadyExistsException {
        String description;
        String name = definition.getName() == null ? "" : definition.getName().trim();
        String string = description = definition.getDescription() == null ? "" : definition.getDescription().trim();
        if (name.equals("")) {
            throw new GroupDefinitionException("Name is a required property");
        }
        if (name.length() > 100) {
            throw new GroupDefinitionException("Name is limited to 100 characters");
        }
        if (description.length() > 100) {
            throw new GroupDefinitionException("Description is limited to 100 characters");
        }
        if (name.contains("<") || name.contains("$") || name.contains("'") || name.contains("{") || name.contains("[")) {
            throw new GroupDefinitionException("Name must not contain <,$,',[,{ characters");
        }
        Query query = this.entityManager.createNamedQuery("GroupDefinition.findByName");
        query.setParameter("name", (Object)name);
        try {
            GroupDefinition found = (GroupDefinition)query.getSingleResult();
            if (id == null || found.getId() != id.intValue()) {
                throw new GroupDefinitionAlreadyExistsException("GroupDefinition with name " + name + " already exists");
            }
        }
        catch (NoResultException e) {
            return true;
        }
        return false;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void calculateGroupMembership(Subject subject, int groupDefinitionId) throws ResourceGroupDeleteException, GroupDefinitionDeleteException, GroupDefinitionNotFoundException, InvalidExpressionException, ResourceGroupUpdateException {
        long startTime = System.currentTimeMillis();
        GroupDefinition groupDefinition = this.getById(groupDefinitionId);
        groupDefinition.setLastCalculationTime(Long.valueOf(System.currentTimeMillis()));
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        for (String expression : groupDefinition.getExpressionAsList()) {
            evaluator.addExpression(expression);
        }
        ArrayList<Integer> doomedResourceGroupIds = new ArrayList<Integer>();
        for (Integer managedGroupId : this.getManagedResourceGroupIdsForGroupDefinition(groupDefinitionId)) {
            doomedResourceGroupIds.add(managedGroupId);
        }
        for (ExpressionEvaluator.Result result : evaluator) {
            if (result == null) continue;
            Integer nextResourceGroupId = this.groupDefinitionManager.calculateGroupMembership_helper(subject, groupDefinitionId, result);
            this.resourceGroupManager.setResourceType(nextResourceGroupId);
            doomedResourceGroupIds.remove(nextResourceGroupId);
        }
        for (Integer doomedGroupId : doomedResourceGroupIds) {
            this.groupDefinitionManager.removeManagedResource_helper(subject, groupDefinitionId, doomedGroupId);
        }
        long endTime = System.currentTimeMillis();
        this.log.debug((Object)("calculateGroupMembership took " + (endTime - startTime) + " millis"));
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Integer calculateGroupMembership_helper(Subject overlord, int groupDefinitionId, ExpressionEvaluator.Result result) throws ResourceGroupDeleteException, GroupDefinitionNotFoundException, GroupDefinitionNotFoundException {
        long startTime = System.currentTimeMillis();
        GroupDefinition groupDefinition = this.getById(groupDefinitionId);
        String groupByClause = result.getGroupByClause();
        ResourceGroup resourceGroup = this.resourceGroupManager.getByGroupDefinitionAndGroupByClause(groupDefinition.getId(), groupByClause);
        int resourceGroupId = 0;
        if (resourceGroup == null) {
            String newDynamicGroupName = this.getDynamicGroupName(groupDefinition.getName(), groupByClause);
            resourceGroup = new ResourceGroup(newDynamicGroupName);
            resourceGroupId = this.resourceGroupManager.createResourceGroup(overlord, resourceGroup).getId();
            resourceGroup.setRecursive(groupDefinition.isRecursive());
            resourceGroup.setGroupByClause(groupByClause);
            groupDefinition.addResourceGroup(resourceGroup);
        } else {
            resourceGroupId = resourceGroup.getId();
        }
        List<Integer> existingResourceIds = this.resourceManager.findExplicitResourceIdsByResourceGroup(resourceGroup.getId());
        HashSet<Integer> idsToAdd = new HashSet<Integer>(result.getData());
        idsToAdd.removeAll(existingResourceIds);
        HashSet<Integer> idsToRemove = new HashSet<Integer>(existingResourceIds);
        idsToRemove.removeAll(result.getData());
        this.resourceGroupManager.addResourcesToGroup(overlord, resourceGroupId, ArrayUtils.unwrapCollection(idsToAdd));
        this.resourceGroupManager.removeResourcesFromGroup(overlord, resourceGroupId, ArrayUtils.unwrapCollection(idsToRemove));
        long endTime = System.currentTimeMillis();
        this.log.debug((Object)("calculateGroupMembership_helper took " + (endTime - startTime) + " millis"));
        return resourceGroupId;
    }

    @Override
    public PageList<GroupDefinition> getGroupDefinitions(Subject subject, PageControl pc) {
        pc.initDefaultOrderingField("gd.name");
        if (this.authorizationManager.isInventoryManager(subject)) {
            Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"GroupDefinition.findAll", (PageControl)pc);
            List results = query.getResultList();
            int count = this.getGroupDefinitionCount(subject);
            return new PageList((Collection)results, count, pc);
        }
        return new PageList(pc);
    }

    @Override
    public PageList<GroupDefinition> findGroupDefinitionsByCriteria(Subject subject, ResourceGroupDefinitionCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject) && criteria.isInventoryManagerRequired()) {
            throw new PermissionException("Subject [" + subject.getName() + "] requires InventoryManager permission for requested query criteria.");
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public int getGroupDefinitionCount(Subject subject) {
        if (this.authorizationManager.isInventoryManager(subject)) {
            Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"GroupDefinition.findAll");
            long count = (Long)queryCount.getSingleResult();
            return (int)count;
        }
        return 0;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public int getAutoRecalculationGroupDefinitionCount(Subject subject) {
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"GroupDefinition.findAllRecalculating_admin");
        long count = (Long)queryCount.getSingleResult();
        return (int)count;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public int getDynaGroupCount(Subject subject) {
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"GroupDefinition.findAllMembers_admin");
        long count = (Long)queryCount.getSingleResult();
        return (int)count;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void removeGroupDefinition(Subject subject, Integer groupDefinitionId) throws GroupDefinitionNotFoundException, GroupDefinitionDeleteException {
        List<Integer> managedGroupIds = this.getManagedResourceGroupIdsForGroupDefinition(groupDefinitionId);
        Subject overlord = this.subjectManager.getOverlord();
        for (Integer managedGroupId : managedGroupIds) {
            this.removeManagedResource_helper(overlord, groupDefinitionId, managedGroupId);
        }
        GroupDefinition groupDefinition = this.getById(groupDefinitionId);
        try {
            this.entityManager.remove((Object)groupDefinition);
        }
        catch (Exception e) {
            throw new GroupDefinitionDeleteException("Error deleting groupDefinition '" + groupDefinition.getName() + "': ", e);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void removeManagedResource_helper(Subject overlord, int groupDefinitionId, Integer doomedGroupId) throws GroupDefinitionDeleteException, GroupDefinitionNotFoundException {
        GroupDefinition groupDefinition = this.getById(groupDefinitionId);
        ResourceGroup doomedGroup = (ResourceGroup)this.entityManager.getReference(ResourceGroup.class, (Object)doomedGroupId);
        groupDefinition.removeResourceGroup(doomedGroup);
        try {
            this.resourceGroupManager.deleteResourceGroup(this.subjectManager.getOverlord(), doomedGroupId);
        }
        catch (Exception e) {
            throw new GroupDefinitionDeleteException("Error removing managedGroup '" + doomedGroup.getName() + "' " + "from groupDefinition '" + groupDefinition.getName() + "': ", e);
        }
    }

    private List<Integer> getManagedResourceGroupIdsForGroupDefinition(int groupDefinitionId) {
        Query query = this.entityManager.createNamedQuery("GroupDefinition.findManagedResourceGroupIds_admin");
        query.setParameter("groupDefinitionId", (Object)groupDefinitionId);
        List results = query.getResultList();
        return results;
    }

    private int getManagedResourceGroupSizeForGroupDefinition(int groupDefinitionId) {
        Query query = this.entityManager.createNamedQuery("GroupDefinition.findManagedResourceGroupSize_admin");
        query.setParameter("groupDefinitionId", (Object)groupDefinitionId);
        Number result = (Number)query.getSingleResult();
        return result.intValue();
    }

    private String getDynamicGroupName(String groupDefinitionName, String groupByClause) {
        String newDynamicGroupName = "DynaGroup - " + groupDefinitionName + (groupByClause.equals("") ? "" : " ( " + groupByClause + " )");
        return newDynamicGroupName;
    }

    private String updateDynaGroupName(String oldGroupDefinitionName, String updatedGroupDefinitionName, String dynaGroupName) throws GroupDefinitionUpdateException {
        String newGroupDefinitionName = updatedGroupDefinitionName;
        int oldGroupNameIndexStart = 12;
        int oldGroupNameLength = oldGroupDefinitionName.length();
        return dynaGroupName.substring(0, oldGroupNameIndexStart) + newGroupDefinitionName + dynaGroupName.substring(oldGroupNameIndexStart + oldGroupNameLength);
    }
}

