/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.clientapi.agent.metadata.SubCategoriesMetadataParser;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftDefinitionComparator;
import org.rhq.core.domain.drift.DriftDefinitionTemplate;
import org.rhq.core.domain.resource.ProcessScan;
import org.rhq.core.domain.resource.ResourceSubCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupDeleteException;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.metadata.AlertMetadataManagerLocal;
import org.rhq.enterprise.server.resource.metadata.CollectionsUtil;
import org.rhq.enterprise.server.resource.metadata.ContentMetadataManagerLocal;
import org.rhq.enterprise.server.resource.metadata.EventMetdataManagerLocal;
import org.rhq.enterprise.server.resource.metadata.MeasurementMetadataManagerBean;
import org.rhq.enterprise.server.resource.metadata.MeasurementMetadataManagerLocal;
import org.rhq.enterprise.server.resource.metadata.OperationMetadataManagerLocal;
import org.rhq.enterprise.server.resource.metadata.PluginConfigurationMetadataManagerLocal;
import org.rhq.enterprise.server.resource.metadata.ResourceConfigurationMetadataManagerLocal;
import org.rhq.enterprise.server.resource.metadata.ResourceMetadataManagerLocal;

@Stateless
@Resource(name="RHQ_DS", mappedName="java:/RHQDS")
public class ResourceMetadataManagerBean
implements ResourceMetadataManagerLocal {
    private final Log log = LogFactory.getLog(ResourceMetadataManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    private ResourceMetadataManagerLocal resourceMetadataManager;
    @EJB
    private ContentMetadataManagerLocal contentMetadataMgr;
    @EJB
    private OperationMetadataManagerLocal operationMetadataMgr;
    @EJB
    private EventMetdataManagerLocal eventMetadataMgr;
    @EJB
    private MeasurementMetadataManagerLocal measurementMetadataMgr;
    @EJB
    private AlertMetadataManagerLocal alertMetadataMgr;
    @EJB
    private ResourceConfigurationMetadataManagerLocal resourceConfigMetadataMgr;
    @EJB
    private PluginConfigurationMetadataManagerLocal pluginConfigMetadataMgr;

    @Override
    public void updateTypes(Set<ResourceType> resourceTypes) throws Exception {
        HashSet<ResourceType> allChildren = new HashSet<ResourceType>();
        LinkedList unvisitedChildren = new LinkedList();
        for (ResourceType resourceType : resourceTypes) {
            unvisitedChildren.addAll(resourceType.getChildResourceTypes());
        }
        while (!unvisitedChildren.isEmpty()) {
            ResourceType childResourceType = (ResourceType)unvisitedChildren.poll();
            if (allChildren.contains(childResourceType)) continue;
            allChildren.add(childResourceType);
            unvisitedChildren.addAll(childResourceType.getChildResourceTypes());
        }
        LinkedHashSet<ResourceType> nonRunsInsideResourceTypes = new LinkedHashSet<ResourceType>();
        for (ResourceType resourceType : resourceTypes) {
            if (allChildren.contains(resourceType)) continue;
            nonRunsInsideResourceTypes.add(resourceType);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processing types: " + nonRunsInsideResourceTypes + "..."));
        }
        HashSet<ResourceType> legitimateChildren = new HashSet<ResourceType>();
        for (ResourceType resourceType : nonRunsInsideResourceTypes) {
            long startTime = System.currentTimeMillis();
            resourceType = this.resourceMetadataManager.updateType(resourceType);
            long endTime = System.currentTimeMillis();
            this.log.debug((Object)("Updated resource type [" + ResourceMetadataManagerBean.toConciseString(resourceType) + "] in " + (endTime - startTime) + " ms"));
            legitimateChildren.addAll(resourceType.getChildResourceTypes());
        }
        if (!legitimateChildren.isEmpty()) {
            this.updateTypes(legitimateChildren);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void removeObsoleteTypes(Subject subject, String pluginName, PluginMetadataManager metadataCache) {
        HashSet<ResourceType> obsoleteTypes = new HashSet<ResourceType>();
        HashSet<ResourceType> legitTypes = new HashSet<ResourceType>();
        try {
            this.resourceMetadataManager.getPluginTypes(subject, pluginName, legitTypes, obsoleteTypes, metadataCache);
            if (!obsoleteTypes.isEmpty()) {
                this.log.info((Object)("Removing " + obsoleteTypes.size() + " obsolete types: " + obsoleteTypes + "..."));
                this.removeResourceTypes(subject, obsoleteTypes, new HashSet<ResourceType>(obsoleteTypes));
            }
            for (ResourceType legitType : legitTypes) {
                ResourceType updateType = metadataCache.getType(legitType.getName(), legitType.getPlugin());
                if (updateType == null) continue;
                try {
                    this.resourceMetadataManager.removeObsoleteSubCategories(subject, updateType, legitType);
                }
                catch (Exception e) {
                    throw new Exception("Failed to delete obsolete subcategories from " + legitType + ".", e);
                    return;
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failure during removal of obsolete ResourceTypes and Subcategories.", (Throwable)e);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void getPluginTypes(Subject subject, String pluginName, Set<ResourceType> legitTypes, Set<ResourceType> obsoleteTypes, PluginMetadataManager metadataCache) {
        try {
            Query query = this.entityManager.createNamedQuery("ResourceType.findByPlugin");
            query.setParameter("plugin", (Object)pluginName);
            List existingTypes = query.getResultList();
            if (existingTypes != null) {
                for (ResourceType existingType : existingTypes) {
                    if (metadataCache.getType(existingType.getName(), existingType.getPlugin()) == null) {
                        obsoleteTypes.add(existingType);
                        continue;
                    }
                    legitTypes.add(existingType);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failure during removal of obsolete ResourceTypes and Subcategories.", (Throwable)e);
        }
    }

    private void removeResourceTypes(Subject subject, Set<ResourceType> candidateTypes, Set<ResourceType> typesToBeRemoved) throws Exception {
        for (ResourceType candidateType : candidateTypes) {
            List<ResourceType> childTypes = this.resourceTypeManager.getChildResourceTypes(subject, candidateType);
            if (childTypes != null && !childTypes.isEmpty()) {
                this.removeResourceTypes(subject, new HashSet<ResourceType>(childTypes), typesToBeRemoved);
            }
            if (!typesToBeRemoved.contains(candidateType)) continue;
            try {
                this.removeResourceType(subject, candidateType);
            }
            catch (Exception e) {
                throw new Exception("Failed to remove " + candidateType + ".", e);
            }
            typesToBeRemoved.remove(candidateType);
        }
    }

    private void removeResourceType(Subject subject, ResourceType existingType) {
        this.log.info((Object)("Removing ResourceType [" + ResourceMetadataManagerBean.toConciseString(existingType) + "]..."));
        ResourceCriteria c = new ResourceCriteria();
        c.addFilterResourceTypeId(Integer.valueOf(existingType.getId()));
        c.addFilterInventoryStatus(null);
        PageList<org.rhq.core.domain.resource.Resource> resources = this.resourceManager.findResourcesByCriteria(subject, c);
        if (resources != null) {
            Iterator resIter = resources.iterator();
            while (resIter.hasNext()) {
                org.rhq.core.domain.resource.Resource res = (org.rhq.core.domain.resource.Resource)resIter.next();
                List<Integer> deletedIds = this.resourceManager.uninventoryResource(subject, res.getId());
                for (Integer deletedResourceId : deletedIds) {
                    this.resourceManager.uninventoryResourceAsyncWork(subject, deletedResourceId);
                }
                resIter.remove();
            }
        }
        this.resourceMetadataManager.completeRemoveResourceType(subject, existingType);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void completeRemoveResourceType(Subject subject, ResourceType existingType) {
        if (this.entityManager.contains((Object)(existingType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)existingType.getId())))) {
            this.entityManager.refresh((Object)existingType);
        }
        this.removeFromParents(existingType);
        this.removeFromChildren(existingType);
        this.entityManager.merge((Object)existingType);
        this.contentMetadataMgr.deleteMetadata(subject, existingType);
        this.entityManager.flush();
        existingType = (ResourceType)this.entityManager.find(existingType.getClass(), (Object)existingType.getId());
        try {
            this.alertMetadataMgr.deleteAlertTemplates(subject, existingType);
        }
        catch (Exception e) {
            throw new RuntimeException("Alert template deletion failed. Cannot finish deleting " + existingType, e);
        }
        this.entityManager.flush();
        existingType = (ResourceType)this.entityManager.find(existingType.getClass(), (Object)existingType.getId());
        List compatGroups = existingType.getResourceGroups();
        if (compatGroups != null) {
            Iterator compatGroupIterator = compatGroups.iterator();
            while (compatGroupIterator.hasNext()) {
                ResourceGroup compatGroup = (ResourceGroup)compatGroupIterator.next();
                try {
                    this.resourceGroupManager.deleteResourceGroup(subject, compatGroup.getId());
                }
                catch (ResourceGroupDeleteException e) {
                    throw new RuntimeException(e);
                }
                compatGroupIterator.remove();
            }
        }
        this.entityManager.flush();
        this.measurementMetadataMgr.deleteMetadata(existingType);
        this.entityManager.flush();
        this.entityManager.refresh((Object)existingType);
        this.entityManager.remove((Object)existingType);
        this.entityManager.flush();
    }

    private void removeFromParents(ResourceType typeToBeRemoved) {
        HashSet parentTypes = new HashSet(typeToBeRemoved.getParentResourceTypes());
        for (ResourceType parentType : parentTypes) {
            parentType.removeChildResourceType(typeToBeRemoved);
            this.entityManager.merge((Object)parentType);
        }
    }

    private void removeFromChildren(ResourceType typeToBeRemoved) {
        HashSet childTypes = new HashSet(typeToBeRemoved.getChildResourceTypes());
        for (ResourceType childType : childTypes) {
            childType.removeParentResourceType(typeToBeRemoved);
            this.entityManager.merge((Object)childType);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ResourceType updateType(ResourceType resourceType) {
        ResourceType existingType;
        this.log.info((Object)("Updating resource type [" + ResourceMetadataManagerBean.toConciseString(resourceType) + "]..."));
        try {
            existingType = this.resourceTypeManager.getResourceTypeByNameAndPlugin(resourceType.getName(), resourceType.getPlugin());
        }
        catch (NonUniqueResultException nure) {
            this.log.info((Object)("Found more than one existing ResourceType for " + resourceType));
            throw new IllegalStateException(nure);
        }
        this.updateParentResourceTypes(resourceType, existingType);
        if (existingType == null) {
            this.persistNewType(resourceType);
        } else {
            this.mergeExistingType(resourceType, existingType);
        }
        return resourceType;
    }

    private void mergeExistingType(ResourceType resourceType, ResourceType existingType) {
        this.log.debug((Object)("Merging type [" + resourceType + "] + into existing type [" + existingType + "]..."));
        this.updateChildSubCategories(resourceType, existingType);
        this.entityManager.flush();
        long startTime = System.currentTimeMillis();
        this.pluginConfigMetadataMgr.updatePluginConfigurationDefinition(existingType, resourceType);
        long endTime = System.currentTimeMillis();
        this.log.debug((Object)("Updated plugin configuration definition for ResourceType[" + ResourceMetadataManagerBean.toConciseString(existingType) + "] in " + (endTime - startTime) + " ms"));
        this.resourceConfigMetadataMgr.updateResourceConfigurationDefinition(existingType, resourceType);
        this.measurementMetadataMgr.updateMetadata(existingType, resourceType);
        this.contentMetadataMgr.updateMetadata(existingType, resourceType);
        this.operationMetadataMgr.updateMetadata(existingType, resourceType);
        this.resourceMetadataManager.updateDriftMetadata(existingType, resourceType);
        this.updateProcessScans(resourceType, existingType);
        this.eventMetadataMgr.updateMetadata(existingType, resourceType);
        if (resourceType.getCategory() != existingType.getCategory()) {
            this.log.info((Object)("Changing category of Resource type [" + resourceType + "] from " + existingType.getCategory() + " to " + resourceType.getCategory() + "..."));
            existingType.setCategory(resourceType.getCategory());
        }
        existingType.setCreateDeletePolicy(resourceType.getCreateDeletePolicy());
        existingType.setCreationDataType(resourceType.getCreationDataType());
        existingType.setDescription(resourceType.getDescription());
        existingType.setSingleton(resourceType.isSingleton());
        existingType.setSupportsManualAdd(resourceType.isSupportsManualAdd());
        ResourceSubCategory oldSubCat = existingType.getSubCategory();
        ResourceSubCategory newSubCat = resourceType.getSubCategory();
        if (oldSubCat == null || !oldSubCat.equals((Object)newSubCat)) {
            if (newSubCat == null) {
                if (oldSubCat != null) {
                    this.log.info((Object)("Metadata update: Subcategory of ResourceType [" + resourceType.getName() + "] changed from " + oldSubCat + " to " + newSubCat));
                    existingType.setSubCategory(null);
                }
            } else {
                ResourceSubCategory existingSubCat = SubCategoriesMetadataParser.findSubCategoryOnResourceTypeAncestor((ResourceType)existingType, (String)newSubCat.getName());
                if (existingSubCat == null) {
                    throw new IllegalStateException("Resource type [" + resourceType.getName() + "] in plugin [" + resourceType.getPlugin() + "] has a subcategory (" + newSubCat.getName() + ") which was not defined as a child subcategory of one of its ancestor resource types.");
                }
                this.log.info((Object)("Metadata update: Subcategory of ResourceType [" + resourceType.getName() + "] changed from " + oldSubCat + " to " + existingSubCat));
                existingType.setSubCategory(existingSubCat);
            }
        }
        existingType = (ResourceType)this.entityManager.merge((Object)existingType);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateDriftMetadata(ResourceType existingType, ResourceType resourceType) {
        existingType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)existingType.getId());
        Set existingDriftTemplates = existingType.getDriftDefinitionTemplates();
        HashSet<DriftDefinitionTemplate> existingPluginDriftTemplates = new HashSet<DriftDefinitionTemplate>(existingDriftTemplates.size());
        for (DriftDefinitionTemplate existingTemplate : existingDriftTemplates) {
            if (existingTemplate.isUserDefined()) continue;
            existingPluginDriftTemplates.add(existingTemplate);
        }
        Set newPluginDriftTemplates = resourceType.getDriftDefinitionTemplates();
        HashSet<String> existingNames = new HashSet<String>(existingPluginDriftTemplates.size());
        DriftDefinitionComparator dirComp = new DriftDefinitionComparator(DriftDefinitionComparator.CompareMode.ONLY_DIRECTORY_SPECIFICATIONS);
        Iterator i = existingDriftTemplates.iterator();
        while (i.hasNext()) {
            DriftDefinitionTemplate existingTemplate = (DriftDefinitionTemplate)i.next();
            String existingName = existingTemplate.getName();
            DriftDefinition existingDef = existingTemplate.getTemplateDefinition();
            Set attachedDefs = existingTemplate.getDriftDefinitions();
            boolean noAttachedDefs = null == attachedDefs || attachedDefs.isEmpty();
            boolean notPinned = !existingTemplate.isPinned();
            boolean stillDefined = false;
            existingNames.add(existingName);
            for (DriftDefinitionTemplate newTemplate : newPluginDriftTemplates) {
                boolean noDirChanges;
                String newName = newTemplate.getName();
                if (!newName.equals(existingName)) continue;
                stillDefined = true;
                DriftDefinition newDef = newTemplate.getTemplateDefinition();
                boolean bl = noDirChanges = 0 == dirComp.compare(existingDef, newDef);
                if (noAttachedDefs && notPinned || noDirChanges) {
                    existingTemplate.setTemplateDefinition(newDef);
                    break;
                }
                this.log.error((Object)("Failed to update drift definition [" + newName + "] on type [" + resourceType.getName() + "]. It is not allowed to update directories on an existing template that is pinned " + "or has attached definitions. It would invalidate pinned snapshots as the fileset " + "would no longer map from template to definition."));
                break;
            }
            if (stillDefined) continue;
            if (noAttachedDefs) {
                this.entityManager.remove((Object)existingTemplate);
                i.remove();
                continue;
            }
            existingTemplate.setUserDefined(true);
            this.log.warn((Object)("Plugin no longer defines drift template [" + existingTemplate.getName() + "] on type [" + resourceType.getName() + "]. This template has attached definitions.  To preserve the existing definitions the " + " template will not be removed but is instead being set as user-defined.  The user will " + " be responsible for further maintenance of this template."));
        }
        for (DriftDefinitionTemplate newTemplate : newPluginDriftTemplates) {
            String newName = newTemplate.getName();
            if (existingNames.contains(newName)) continue;
            newTemplate.setResourceType(existingType);
            this.entityManager.persist((Object)newTemplate);
            existingDriftTemplates.add(newTemplate);
        }
    }

    private void persistNewType(ResourceType resourceType) {
        this.log.info((Object)("Persisting new ResourceType [" + ResourceMetadataManagerBean.toConciseString(resourceType) + "]..."));
        this.checkForValidSubcategories(resourceType.getChildSubCategories());
        this.linkSubCategoryToParents(resourceType);
        MeasurementMetadataManagerBean.getMetricDefinitions(resourceType);
        this.entityManager.persist((Object)resourceType);
    }

    private void linkSubCategoryToParents(ResourceType resourceType) {
        if (resourceType.getSubCategory() == null) {
            return;
        }
        ResourceSubCategory mySubCategory = resourceType.getSubCategory();
        ResourceSubCategory existingCat = SubCategoriesMetadataParser.findSubCategoryOnResourceTypeAncestor((ResourceType)resourceType, (String)mySubCategory.getName());
        if (existingCat == null) {
            throw new IllegalStateException("Subcategory " + mySubCategory.getName() + " defined on resource type " + resourceType.getName() + " in plugin " + resourceType.getPlugin() + " is not defined in a parent type");
        }
        resourceType.setSubCategory(existingCat);
    }

    private void updateParentResourceTypes(ResourceType newType, ResourceType existingType) {
        if (this.log.isDebugEnabled()) {
            if (existingType != null) {
                this.log.debug((Object)("Setting parent types on existing type: " + existingType + " to [" + newType.getParentResourceTypes() + "] - current parent types are [" + existingType.getParentResourceTypes() + "]..."));
            } else {
                this.log.debug((Object)("Setting parent types on new type: " + newType + " to [" + newType.getParentResourceTypes() + "]..."));
            }
        }
        Set newParentTypes = newType.getParentResourceTypes();
        newType.setParentResourceTypes(new HashSet());
        HashSet originalExistingParentTypes = new HashSet();
        if (existingType != null) {
            originalExistingParentTypes.addAll(existingType.getParentResourceTypes());
        }
        for (ResourceType newParentType : newParentTypes) {
            try {
                ResourceType type;
                boolean isExistingParent = originalExistingParentTypes.remove(newParentType);
                if (existingType != null && isExistingParent) continue;
                ResourceType realParentType = (ResourceType)this.entityManager.createNamedQuery("ResourceType.findByNameAndPlugin").setParameter("name", (Object)newParentType.getName()).setParameter("plugin", (Object)newParentType.getPlugin()).getSingleResult();
                ResourceType resourceType = type = existingType != null ? existingType : newType;
                if (existingType != null) {
                    this.log.info((Object)("Adding ResourceType [" + ResourceMetadataManagerBean.toConciseString(type) + "] as child of ResourceType [" + ResourceMetadataManagerBean.toConciseString(realParentType) + "]..."));
                }
                realParentType.addChildResourceType(type);
            }
            catch (NoResultException nre) {
                throw new RuntimeException("Couldn't persist type [" + newType + "] because parent [" + newParentType + "] wasn't already persisted.");
            }
        }
        for (ResourceType obsoleteParentType : originalExistingParentTypes) {
            this.log.info((Object)("Removing type [" + ResourceMetadataManagerBean.toConciseString(existingType) + "] from parent type [" + ResourceMetadataManagerBean.toConciseString(obsoleteParentType) + "]..."));
            obsoleteParentType.removeChildResourceType(existingType);
            this.moveResourcesToNewParent(existingType, obsoleteParentType, newParentTypes);
        }
    }

    private static String toConciseString(ResourceType type) {
        return type != null ? type.getPlugin() + ":" + type.getName() + "(id=" + type.getId() + ")" : "null";
    }

    private void moveResourcesToNewParent(ResourceType existingType, ResourceType obsoleteParentType, Set<ResourceType> newParentTypes) {
        Subject overlord = this.subjectManager.getOverlord();
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.addFilterResourceTypeId(Integer.valueOf(existingType.getId()));
        criteria.addFilterParentResourceTypeId(obsoleteParentType.getId());
        PageList<org.rhq.core.domain.resource.Resource> resources = this.resourceManager.findResourcesByCriteria(overlord, criteria);
        for (org.rhq.core.domain.resource.Resource resource : resources) {
            org.rhq.core.domain.resource.Resource newParent = null;
            block1: for (ResourceType newParentType : newParentTypes) {
                for (org.rhq.core.domain.resource.Resource ancestorResource = resource.getParentResource(); ancestorResource != null; ancestorResource = ancestorResource.getParentResource()) {
                    if (!ancestorResource.getResourceType().equals((Object)newParentType)) continue;
                    newParent = ancestorResource;
                    break block1;
                }
                for (org.rhq.core.domain.resource.Resource childResource : resource.getChildResources()) {
                    if (!childResource.getResourceType().equals((Object)newParentType)) continue;
                    newParent = childResource;
                    break block1;
                }
            }
            if (newParent != null) {
                if (resource.getParentResource() != null) {
                    resource.getParentResource().removeChildResource(resource);
                }
                newParent.addChildResource(resource);
                this.resourceManager.updateAncestry(this.subjectManager.getOverlord(), resource.getId());
                continue;
            }
            this.log.info((Object)("We were unable to move " + resource + " from invalid parent " + resource.getParentResource() + " to a new valid parent with one of the following types: " + newParentTypes));
        }
    }

    private void checkForValidSubcategories(List<ResourceSubCategory> subCategories) {
        HashSet<String> subCatNames = new HashSet<String>();
        for (ResourceSubCategory subCategory : subCategories) {
            List<ResourceSubCategory> allSubcategories = this.getAllSubcategories(subCategory);
            for (ResourceSubCategory subCategory2 : allSubcategories) {
                if (subCatNames.contains(subCategory2.getName())) {
                    throw new RuntimeException("Subcategory [" + subCategory.getName() + "] is duplicated");
                }
                subCatNames.add(subCategory2.getName());
            }
        }
    }

    private List<ResourceSubCategory> getAllSubcategories(ResourceSubCategory cat) {
        ArrayList<ResourceSubCategory> result = new ArrayList<ResourceSubCategory>();
        if (cat.getChildSubCategories() != null) {
            for (ResourceSubCategory cat2 : cat.getChildSubCategories()) {
                result.addAll(this.getAllSubcategories(cat2));
            }
        }
        result.add(cat);
        return result;
    }

    private void updateProcessScans(ResourceType resourceType, ResourceType existingType) {
        Set existingScans = existingType.getProcessScans();
        Set newScans = resourceType.getProcessScans();
        Set<ProcessScan> scansToPersist = CollectionsUtil.missingInFirstSet(existingScans, newScans);
        Set<ProcessScan> scansToDelete = CollectionsUtil.missingInFirstSet(newScans, existingScans);
        Set<ProcessScan> scansToUpdate = CollectionsUtil.intersection(existingScans, newScans);
        for (ProcessScan scan : scansToUpdate) {
            for (ProcessScan nScan : newScans) {
                if (!scan.equals((Object)nScan)) continue;
                scan.setName(nScan.getName());
            }
        }
        for (ProcessScan scan : scansToPersist) {
            existingType.addProcessScan(scan);
        }
        for (ProcessScan scan : scansToDelete) {
            existingScans.remove(scan);
            this.entityManager.remove((Object)scan);
        }
    }

    private void updateChildSubCategories(ResourceType newType, ResourceType existingType) {
        if (existingType.getChildSubCategories() == null) {
            for (ResourceSubCategory newSubCategory : newType.getChildSubCategories()) {
                this.log.info((Object)("Metadata update: Adding new child SubCategory [" + newSubCategory.getName() + "] to ResourceType [" + existingType.getName() + "]..."));
                existingType.addChildSubCategory(newSubCategory);
                this.entityManager.persist((Object)newSubCategory);
            }
            return;
        }
        HashMap<String, ResourceSubCategory> subCategoriesFromNewType = new HashMap<String, ResourceSubCategory>(newType.getChildSubCategories().size());
        for (ResourceSubCategory newSubCategory : newType.getChildSubCategories()) {
            subCategoriesFromNewType.put(newSubCategory.getName(), newSubCategory);
        }
        ArrayList mergedSubCategories = new ArrayList(existingType.getChildSubCategories());
        mergedSubCategories.retainAll(subCategoriesFromNewType.values());
        for (ResourceSubCategory existingSubCat : mergedSubCategories) {
            this.updateSubCategory(existingSubCat, (ResourceSubCategory)subCategoriesFromNewType.get(existingSubCat.getName()));
            this.entityManager.merge((Object)existingSubCat);
        }
        ArrayList newSubCategories = new ArrayList(newType.getChildSubCategories());
        newSubCategories.removeAll(existingType.getChildSubCategories());
        for (ResourceSubCategory newSubCat : newSubCategories) {
            this.log.info((Object)("Metadata update: Adding new child SubCategory [" + newSubCat.getName() + "] to ResourceType [" + existingType.getName() + "]..."));
            existingType.addChildSubCategory(newSubCat);
            this.entityManager.persist((Object)newSubCat);
        }
    }

    private void updateSubCategory(ResourceSubCategory existingSubCat, ResourceSubCategory newSubCategory) {
        existingSubCat.update(newSubCategory);
        if (existingSubCat.getChildSubCategories() == null || existingSubCat.getChildSubCategories().isEmpty()) {
            for (ResourceSubCategory newChildSubCategory : newSubCategory.getChildSubCategories()) {
                this.log.info((Object)("Metadata update: Adding new child SubCategory [" + newChildSubCategory.getName() + "] to SubCategory [" + existingSubCat.getName() + "]..."));
                existingSubCat.addChildSubCategory(newChildSubCategory);
                this.entityManager.persist((Object)newChildSubCategory);
            }
            return;
        }
        HashMap<String, ResourceSubCategory> childSubCategoriesFromNewSubCat = new HashMap<String, ResourceSubCategory>(newSubCategory.getChildSubCategories().size());
        for (ResourceSubCategory newChildSubCategory : newSubCategory.getChildSubCategories()) {
            childSubCategoriesFromNewSubCat.put(newChildSubCategory.getName(), newChildSubCategory);
        }
        ArrayList mergedChildSubCategories = new ArrayList(existingSubCat.getChildSubCategories());
        mergedChildSubCategories.retainAll(childSubCategoriesFromNewSubCat.values());
        for (ResourceSubCategory existingChildSubCategory : mergedChildSubCategories) {
            this.updateSubCategory(existingChildSubCategory, (ResourceSubCategory)childSubCategoriesFromNewSubCat.get(existingChildSubCategory.getName()));
            this.entityManager.merge((Object)existingChildSubCategory);
        }
        ArrayList newChildSubCategories = new ArrayList(newSubCategory.getChildSubCategories());
        newChildSubCategories.removeAll(existingSubCat.getChildSubCategories());
        for (ResourceSubCategory newChildSubCategory : newChildSubCategories) {
            this.log.info((Object)("Metadata update: Adding new child SubCategory [" + newChildSubCategory.getName() + "] to SubCategory [" + existingSubCat.getName() + "]..."));
            existingSubCat.addChildSubCategory(newChildSubCategory);
            this.entityManager.persist((Object)newChildSubCategory);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void removeObsoleteSubCategories(Subject subject, ResourceType newType, ResourceType existingType) {
        existingType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)existingType.getId());
        ArrayList removedSubCategories = new ArrayList(existingType.getChildSubCategories());
        removedSubCategories.removeAll(newType.getChildSubCategories());
        for (ResourceSubCategory removedSubCat : removedSubCategories) {
            existingType.getChildSubCategories().remove(removedSubCat);
            this.entityManager.remove((Object)removedSubCat);
        }
        this.removeChildSubCategories(existingType.getChildSubCategories(), newType.getChildSubCategories());
        this.entityManager.flush();
    }

    private void removeChildSubCategories(List<ResourceSubCategory> existingSubCategories, List<ResourceSubCategory> newSubCategories) {
        HashMap<String, ResourceSubCategory> mapOfNewSubCategories = new HashMap<String, ResourceSubCategory>(newSubCategories.size());
        for (ResourceSubCategory newSubCategory : newSubCategories) {
            mapOfNewSubCategories.put(newSubCategory.getName(), newSubCategory);
        }
        for (ResourceSubCategory existingSubCat : existingSubCategories) {
            ArrayList removedChildSubCategories = new ArrayList(existingSubCat.getChildSubCategories());
            List newChildSubCategories = ((ResourceSubCategory)mapOfNewSubCategories.get(existingSubCat.getName())).getChildSubCategories();
            removedChildSubCategories.removeAll(newChildSubCategories);
            for (ResourceSubCategory removedChildSubCat : removedChildSubCategories) {
                existingSubCat.removeChildSubCategory(removedChildSubCat);
                this.entityManager.remove((Object)removedChildSubCat);
            }
            this.removeChildSubCategories(existingSubCat.getChildSubCategories(), newChildSubCategories);
        }
    }
}

