/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionLog;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.alert.notification.AlertNotificationLog;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.criteria.AlertDefinitionCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.AlertHandlerLocal;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.AlertDefinitionRest;
import org.rhq.enterprise.server.rest.domain.AlertRest;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;
import org.rhq.enterprise.server.rest.domain.StringValue;

@Stateless
@Interceptors(value={SetCallerInterceptor.class})
public class AlertHandlerBean
extends AbstractRestBean
implements AlertHandlerLocal {
    @EJB
    AlertManagerLocal alertManager;
    @EJB
    AlertDefinitionManagerLocal alertDefinitionManager;

    @Override
    public Response listAlerts(int page, String prio, boolean slim, Long since, Integer resourceId, Request request, UriInfo uriInfo, HttpHeaders headers) {
        Response.ResponseBuilder builder;
        AlertCriteria criteria = new AlertCriteria();
        criteria.setPaging(page, 20);
        if (since != null) {
            criteria.addFilterStartTime(since);
        }
        if (resourceId != null) {
            criteria.addFilterResourceIds(new Integer[]{resourceId});
        }
        if (!prio.equals("All")) {
            AlertPriority alertPriority = AlertPriority.valueOf((String)prio.toUpperCase());
            criteria.addFilterPriorities(new AlertPriority[]{alertPriority});
        }
        criteria.addSortCtime(PageOrdering.DESC);
        PageList<Alert> alerts = this.alertManager.findAlertsByCriteria(this.caller, criteria);
        ArrayList<AlertRest> ret = new ArrayList<AlertRest>(alerts.size());
        for (Alert al : alerts) {
            AlertRest ar = this.alertToDomain(al, uriInfo, slim);
            ret.add(ar);
        }
        MediaType type = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (type.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listAlerts.ftl", ret), (MediaType)type);
        } else {
            GenericEntity<List<AlertRest>> entity = new GenericEntity<List<AlertRest>>(ret){};
            builder = Response.ok((Object)entity);
        }
        return builder.build();
    }

    @Override
    public int countAlerts(Long since) {
        AlertCriteria criteria = new AlertCriteria();
        criteria.setPageControl(PageControl.getUnlimitedInstance());
        criteria.fetchAlertDefinition(false);
        criteria.fetchConditionLogs(false);
        criteria.fetchRecoveryAlertDefinition(false);
        criteria.fetchNotificationLogs(false);
        criteria.setRestriction(Criteria.Restriction.COUNT_ONLY);
        if (since != null) {
            criteria.addFilterStartTime(since);
        }
        PageList<Alert> alerts = this.alertManager.findAlertsByCriteria(this.caller, criteria);
        int count = alerts.getTotalSize();
        return count;
    }

    @Override
    public Response getAlert(int id, boolean slim, UriInfo uriInfo, Request request, HttpHeaders headers) {
        Alert al = this.findAlertWithId(id);
        MediaType type = (MediaType)headers.getAcceptableMediaTypes().get(0);
        EntityTag eTag = new EntityTag(Integer.toHexString(al.hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            AlertRest ar = this.alertToDomain(al, uriInfo, slim);
            builder = type.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("alert.ftl", ar), (MediaType)type) : Response.ok((Object)ar);
        }
        builder.tag(eTag);
        return builder.build();
    }

    @Override
    public Response getConditionLogs(int id, Request request, UriInfo uriInfo, HttpHeaders headers) {
        Response.ResponseBuilder builder;
        Alert al = this.findAlertWithId(id);
        Set conditions = al.getConditionLogs();
        MediaType type = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (type.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            ArrayList<StringValue> result = new ArrayList<StringValue>(conditions.size());
            for (AlertConditionLog log : conditions) {
                AlertCondition condition = log.getCondition();
                String entry = String.format("category='%s', name='%s', comparator='%s', threshold='%s', option='%s' : %s", condition.getCategory(), condition.getName(), condition.getComparator(), condition.getThreshold(), condition.getOption(), log.getValue());
                StringValue sv = new StringValue(entry);
                result.add(sv);
            }
            GenericEntity<List<StringValue>> entity = new GenericEntity<List<StringValue>>(result){};
            builder = Response.ok((Object)entity);
        } else {
            ArrayList<String> result = new ArrayList<String>(conditions.size());
            for (AlertConditionLog log : conditions) {
                AlertCondition condition = log.getCondition();
                String entry = String.format("category='%s', name='%s', comparator='%s', threshold='%s', option='%s' : %s", condition.getCategory(), condition.getName(), condition.getComparator(), condition.getThreshold(), condition.getOption(), log.getValue());
                result.add(entry);
            }
            builder = type.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("genericStringList.ftl", result), (MediaType)type) : Response.ok(result);
        }
        return builder.build();
    }

    @Override
    public Response getNotificationLogs(int id, Request request, UriInfo uriInfo, HttpHeaders headers) {
        Response.ResponseBuilder builder;
        Alert al = this.findAlertWithId(id);
        MediaType type = (MediaType)headers.getAcceptableMediaTypes().get(0);
        List notifications = al.getAlertNotificationLogs();
        if (type.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            ArrayList<StringValue> result = new ArrayList<StringValue>(notifications.size());
            for (AlertNotificationLog log : notifications) {
                String entry = log.getSender() + ": " + log.getResultState() + ": " + log.getMessage();
                StringValue sv = new StringValue(entry);
                result.add(sv);
            }
            GenericEntity<List<StringValue>> entity = new GenericEntity<List<StringValue>>(result){};
            builder = Response.ok((Object)entity);
        } else {
            ArrayList<String> result = new ArrayList<String>(notifications.size());
            for (AlertNotificationLog log : notifications) {
                String entry = log.getSender() + ": " + log.getResultState() + ": " + log.getMessage();
                result.add(entry);
            }
            builder = type.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("genericStringList.ftl", result), (MediaType)type) : Response.ok(result);
        }
        return builder.build();
    }

    @Override
    public AlertRest ackAlert(int id, UriInfo uriInfo) {
        this.findAlertWithId(id);
        int count = this.alertManager.acknowledgeAlerts(this.caller, new int[]{id});
        Alert al = this.findAlertWithId(id);
        AlertRest ar = this.alertToDomain(al, uriInfo, true);
        return ar;
    }

    @Override
    public void purgeAlert(int id) {
        this.alertManager.deleteAlerts(this.caller, new int[]{id});
    }

    @Override
    public AlertDefinitionRest getDefinitionForAlert(int alertId) {
        Alert al = this.findAlertWithId(alertId);
        AlertDefinition def = al.getAlertDefinition();
        AlertDefinitionRest ret = this.definitionToDomain(def);
        return ret;
    }

    @Override
    public List<AlertDefinitionRest> listAlertDefinitions(int page, String status) {
        AlertDefinitionCriteria criteria = new AlertDefinitionCriteria();
        criteria.setPaging(page, 20);
        PageList<AlertDefinition> defs = this.alertDefinitionManager.findAlertDefinitionsByCriteria(this.caller, criteria);
        ArrayList<AlertDefinitionRest> ret = new ArrayList<AlertDefinitionRest>(defs.size());
        for (AlertDefinition def : defs) {
            AlertDefinitionRest adr = this.definitionToDomain(def);
            ret.add(adr);
        }
        return ret;
    }

    @Override
    public Response getAlertDefinition(int definitionId, Request request) {
        AlertDefinition def = this.alertDefinitionManager.getAlertDefinition(this.caller, definitionId);
        if (def == null) {
            throw new StuffNotFoundException("AlertDefinition with id " + definitionId);
        }
        EntityTag eTag = new EntityTag(Integer.toHexString(def.hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            AlertDefinitionRest adr = this.definitionToDomain(def);
            builder = Response.ok((Object)adr);
        }
        builder.tag(eTag);
        return builder.build();
    }

    @Override
    public Response updateDefinition(int definitionId, AlertDefinitionRest definitionRest, Request request) {
        AlertDefinition def = this.alertDefinitionManager.getAlertDefinition(this.caller, definitionId);
        if (def == null) {
            throw new StuffNotFoundException("AlertDefinition with id " + definitionId);
        }
        def.setEnabled(definitionRest.isEnabled());
        def.setPriority(AlertPriority.valueOf((String)definitionRest.getPriority()));
        def = this.alertDefinitionManager.updateAlertDefinition(this.caller, def.getId(), def, false);
        EntityTag eTag = new EntityTag(Integer.toHexString(def.hashCode()));
        AlertDefinitionRest adr = this.definitionToDomain(def);
        Response.ResponseBuilder builder = Response.ok((Object)adr);
        builder.tag(eTag);
        return builder.build();
    }

    private AlertDefinitionRest definitionToDomain(AlertDefinition def) {
        AlertDefinitionRest adr = new AlertDefinitionRest(def.getId());
        adr.setName(def.getName());
        adr.setEnabled(def.getEnabled());
        adr.setPriority(def.getPriority().getName());
        return adr;
    }

    private Alert findAlertWithId(int id) {
        AlertCriteria criteria = new AlertCriteria();
        criteria.addFilterId(Integer.valueOf(id));
        PageList<Alert> alerts = this.alertManager.findAlertsByCriteria(this.caller, criteria);
        if (alerts.isEmpty()) {
            throw new StuffNotFoundException("Alert with id " + id);
        }
        return (Alert)alerts.get(0);
    }

    public AlertRest alertToDomain(Alert al, UriInfo uriInfo, boolean slim) {
        AlertRest ret = new AlertRest();
        ret.setId(al.getId());
        AlertDefinition alertDefinition = al.getAlertDefinition();
        ret.setName(alertDefinition.getName());
        AlertDefinitionRest alertDefinitionRest = slim ? new AlertDefinitionRest(alertDefinition.getId()) : this.definitionToDomain(alertDefinition);
        ret.setAlertDefinition(alertDefinitionRest);
        ret.setDefinitionEnabled(alertDefinition.getEnabled());
        if (al.getAcknowledgingSubject() != null) {
            ret.setAckBy(al.getAcknowledgingSubject());
            ret.setAckTime(al.getAcknowledgeTime());
        }
        ret.setAlertTime(al.getCtime());
        ret.setDescription(this.alertManager.prettyPrintAlertConditions(al, false));
        Resource r = this.fetchResource(alertDefinition.getResource().getId());
        ResourceWithType rwt = slim ? new ResourceWithType(r.getName(), r.getId()) : this.fillRWT(r, uriInfo);
        ret.setResource(rwt);
        UriBuilder builder = uriInfo.getBaseUriBuilder();
        builder.path("/alert/{id}/conditions");
        URI uri = builder.build(new Object[]{al.getId()});
        Link link = new Link("conditions", uri.toString());
        ret.addLink(link);
        builder = uriInfo.getBaseUriBuilder();
        builder.path("/alert/{id}/notifications");
        uri = builder.build(new Object[]{al.getId()});
        link = new Link("notification", uri.toString());
        ret.addLink(link);
        builder = uriInfo.getBaseUriBuilder();
        builder.path("/alert/{id}/definition");
        uri = builder.build(new Object[]{al.getId()});
        link = new Link("definition", uri.toString());
        ret.addLink(link);
        return ret;
    }
}

