/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.rhq.core.domain.criteria.EventCriteria;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.event.EventSource;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.EventHandlerLocal;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.EventRest;
import org.rhq.enterprise.server.rest.domain.EventSourceRest;

@Stateless
@Interceptors(value={SetCallerInterceptor.class})
public class EventHandlerBean
extends AbstractRestBean
implements EventHandlerLocal {
    @EJB
    EventManagerLocal eventManager;
    @PersistenceContext(unitName="rhqpu")
    EntityManager em;

    @Override
    public Response listEventSourcesForResource(int resourceId, Request request, HttpHeaders headers) {
        Response.ResponseBuilder builder;
        Resource res = this.fetchResource(resourceId);
        Set eventSources = res.getEventSources();
        ArrayList<EventSourceRest> restSources = new ArrayList<EventSourceRest>(eventSources.size());
        for (EventSource source : eventSources) {
            EventSourceRest esr = this.convertEventSource(source);
            restSources.add(esr);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            GenericEntity<List<EventSourceRest>> list = new GenericEntity<List<EventSourceRest>>(restSources){};
            builder = Response.ok((Object)list, (MediaType)mediaType);
        } else {
            builder = Response.ok(restSources, (MediaType)mediaType);
        }
        return builder.build();
    }

    @Override
    public EventSourceRest getEventSource(int sourceId) {
        EventSource source = this.findEventSourceById(sourceId);
        EventSourceRest esr = this.convertEventSource(source);
        return esr;
    }

    @Override
    public EventSourceRest addEventSource(int resourceId, EventSourceRest esr) {
        EventSource source;
        Resource resource = this.fetchResource(resourceId);
        ResourceType rt = resource.getResourceType();
        Set eventDefinitions = rt.getEventDefinitions();
        EventDefinition eventDefinition = null;
        for (EventDefinition ed : eventDefinitions) {
            if (!ed.getName().equals(esr.getName())) continue;
            eventDefinition = ed;
            break;
        }
        if (eventDefinition == null) {
            throw new StuffNotFoundException("eventDefinition with name " + esr.getName());
        }
        Query q = this.em.createQuery("SELECT es FROM EventSource es WHERE es.location = :location AND es.eventDefinition = :definition AND es.resourceId = :resourceId");
        q.setParameter("location", (Object)esr.getLocation());
        q.setParameter("definition", (Object)eventDefinition);
        q.setParameter("resourceId", (Object)resourceId);
        List sources = q.getResultList();
        if (sources.isEmpty()) {
            source = new EventSource(esr.getLocation(), eventDefinition, resource);
            this.em.persist((Object)source);
        } else if (sources.size() == 1) {
            source = (EventSource)sources.get(0);
        } else {
            throw new IllegalStateException("We have more than one EventSource on the same Definition with the same location - must not happen");
        }
        EventSourceRest result = this.convertEventSource(source);
        return result;
    }

    @Override
    public Response deleteEventSource(int sourceId) {
        EventSource source = this.findEventSourceById(sourceId);
        this.em.remove((Object)source);
        return Response.ok().build();
    }

    @Override
    public Response getEventsForSource(int sourceId, long startTime, long endTime, String severity, Request request, HttpHeaders headers) {
        EventSource source = this.findEventSourceById(sourceId);
        EventCriteria criteria = new EventCriteria();
        criteria.addFilterSourceId(Integer.valueOf(source.getId()));
        if (startTime > 0L) {
            criteria.addFilterStartTime(Long.valueOf(startTime));
        }
        if (endTime > 0L) {
            criteria.addFilterEndTime(Long.valueOf(endTime));
        }
        if (startTime == 0L && endTime == 0L) {
            PageControl pageControl = new PageControl();
            pageControl.setPageSize(200);
            criteria.setPageControl(pageControl);
        }
        Response.ResponseBuilder builder = this.getEventsAsBuilderForCriteria(headers, criteria);
        return builder.build();
    }

    @Override
    public Response getEventsForResource(int resourceId, long startTime, long endTime, String severity, Request request, HttpHeaders headers) {
        EventCriteria criteria = new EventCriteria();
        criteria.addFilterResourceId(Integer.valueOf(resourceId));
        if (startTime > 0L) {
            criteria.addFilterStartTime(Long.valueOf(startTime));
        }
        if (endTime > 0L) {
            criteria.addFilterEndTime(Long.valueOf(endTime));
        }
        if (startTime == 0L && endTime == 0L) {
            PageControl pageControl = new PageControl();
            pageControl.setPageSize(200);
            criteria.setPageControl(pageControl);
        }
        Response.ResponseBuilder builder = this.getEventsAsBuilderForCriteria(headers, criteria);
        return builder.build();
    }

    @Override
    public Response addEventsToSource(int sourceId, List<EventRest> eventRest) {
        EventSource source = this.findEventSourceById(sourceId);
        HashMap<EventSource, Set<Event>> eventMap = new HashMap<EventSource, Set<Event>>();
        HashSet<Event> events = new HashSet<Event>(eventRest.size());
        for (EventRest eRest : eventRest) {
            EventSeverity eventSeverity = EventSeverity.valueOf((String)eRest.getSeverity());
            Event event = new Event(eRest.getTimestamp(), eventSeverity, source, eRest.getDetail());
            events.add(event);
        }
        eventMap.put(source, events);
        this.eventManager.addEventData(eventMap);
        return Response.noContent().build();
    }

    private Response.ResponseBuilder getEventsAsBuilderForCriteria(HttpHeaders headers, EventCriteria criteria) {
        Response.ResponseBuilder builder;
        PageList<Event> eventList = this.eventManager.findEventsByCriteria(this.caller, criteria);
        ArrayList<EventRest> restEvents = new ArrayList<EventRest>(eventList.size());
        for (Event event : eventList) {
            restEvents.add(this.convertEvent(event));
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            GenericEntity<List<EventRest>> list = new GenericEntity<List<EventRest>>(restEvents){};
            builder = Response.ok((Object)list, (MediaType)mediaType);
        } else {
            builder = Response.ok(restEvents, (MediaType)mediaType);
        }
        return builder;
    }

    private EventSourceRest convertEventSource(EventSource source) {
        EventSourceRest esr = new EventSourceRest();
        esr.setId(source.getId());
        esr.setDescription(source.getEventDefinition().getDescription());
        esr.setDisplayName(source.getEventDefinition().getDisplayName());
        esr.setName(source.getEventDefinition().getName());
        esr.setLocation(source.getLocation());
        esr.setResourceId(source.getResourceId());
        return esr;
    }

    private EventRest convertEvent(Event event) {
        EventRest er = new EventRest();
        er.setDetail(event.getDetail());
        er.setId(event.getId());
        er.setSeverity(event.getSeverity().toString());
        er.setTimestamp(event.getTimestamp());
        er.setSourceId(event.getSource().getId());
        return er;
    }

    private EventSource findEventSourceById(int sourceId) {
        EventSource source = (EventSource)this.em.find(EventSource.class, (Object)sourceId);
        if (source == null) {
            throw new StuffNotFoundException("Event source with id " + sourceId);
        }
        return source;
    }
}

