/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.criteria.ResourceGroupCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.GroupDefinition;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.resource.group.ResourceGroupDeleteException;
import org.rhq.enterprise.server.resource.group.definition.GroupDefinitionManagerLocal;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionAlreadyExistsException;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionCreateException;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionDeleteException;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionNotFoundException;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.GroupHandlerLocal;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.GroupDefinitionRest;
import org.rhq.enterprise.server.rest.domain.GroupRest;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.domain.MetricSchedule;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;

@Stateless
@Interceptors(value={SetCallerInterceptor.class})
public class GroupHandlerBean
extends AbstractRestBean
implements GroupHandlerLocal {
    private final Log log = LogFactory.getLog(GroupHandlerBean.class);
    @EJB
    ResourceManagerLocal resourceManager;
    @EJB
    ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    GroupDefinitionManagerLocal definitionManager;

    @Override
    public Response getGroups(@Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        ResourceGroupCriteria criteria = new ResourceGroupCriteria();
        PageList<ResourceGroup> groups = this.resourceGroupManager.findResourceGroupsByCriteria(this.caller, criteria);
        ArrayList<GroupRest> list = new ArrayList<GroupRest>(groups.size());
        for (ResourceGroup group : groups) {
            list.add(this.fillGroup(group, uriInfo));
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listGroup", list), (MediaType)mediaType);
        } else {
            GenericEntity<List<GroupRest>> ret = new GenericEntity<List<GroupRest>>(list){};
            builder = Response.ok((Object)ret);
        }
        return builder.build();
    }

    @Override
    public Response getGroup(int id, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        ResourceGroup group = this.fetchGroup(id, false);
        GroupRest groupRest = this.fillGroup(group, uriInfo);
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        Response.ResponseBuilder builder = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("group", groupRest), (MediaType)mediaType) : Response.ok((Object)groupRest, (MediaType)mediaType);
        return builder.build();
    }

    @Override
    public Response createGroup(GroupRest group, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        ResourceGroup newGroup = new ResourceGroup(group.getName());
        if (group.getResourceTypeId() != null) {
            ResourceType resourceType = null;
            try {
                resourceType = this.resourceTypeManager.getResourceTypeById(this.caller, group.getResourceTypeId());
                newGroup.setResourceType(resourceType);
            }
            catch (ResourceTypeNotFoundException e) {
                e.printStackTrace();
                throw new StuffNotFoundException("ResourceType with id " + group.getResourceTypeId());
            }
        }
        try {
            newGroup = this.resourceGroupManager.createResourceGroup(this.caller, newGroup);
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/group/{id}");
            URI uri = uriBuilder.build(new Object[]{newGroup.getId()});
            builder = Response.created((URI)uri);
            this.putToCache(newGroup.getId(), ResourceGroup.class, newGroup);
        }
        catch (Exception e) {
            e.printStackTrace();
            builder = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE);
        }
        return builder.build();
    }

    @Override
    public Response updateGroup(int id, GroupRest in, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        ResourceGroup resourceGroup = this.fetchGroup(id, false);
        resourceGroup.setName(in.getName());
        try {
            resourceGroup = this.resourceGroupManager.updateResourceGroup(this.caller, resourceGroup);
            builder = Response.ok((Object)this.fillGroup(resourceGroup, uriInfo));
            this.putToCache(resourceGroup.getId(), ResourceGroup.class, resourceGroup);
        }
        catch (Exception e) {
            builder = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE);
        }
        return builder.build();
    }

    @Override
    public Response deleteGroup(int id, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        try {
            this.resourceGroupManager.deleteResourceGroup(this.caller, id);
            this.removeFromCache(id, ResourceGroup.class);
            return Response.ok().build();
        }
        catch (ResourceGroupDeleteException e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
    }

    @Override
    public Response getResources(int id, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        ResourceGroup resourceGroup = this.fetchGroup(id, false);
        Set resources = resourceGroup.getExplicitResources();
        ArrayList<ResourceWithType> rwtList = new ArrayList<ResourceWithType>(resources.size());
        for (Resource res : resources) {
            rwtList.add(this.fillRWT(res, uriInfo));
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listResourceWithType", rwtList), (MediaType)mediaType);
        } else {
            GenericEntity<List<ResourceWithType>> list = new GenericEntity<List<ResourceWithType>>(rwtList){};
            builder = Response.ok((Object)list);
        }
        return builder.build();
    }

    @Override
    public Response addResource(int id, int resourceId, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        ResourceGroup resourceGroup = this.fetchGroup(id, false);
        Resource res = this.resourceManager.getResource(this.caller, resourceId);
        if (res == null) {
            throw new StuffNotFoundException("Resource with id " + resourceId);
        }
        if (resourceGroup.getResourceType() != null && !res.getResourceType().equals((Object)resourceGroup.getResourceType())) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        resourceGroup.addExplicitResource(res);
        return Response.ok().build();
    }

    @Override
    public Response removeResource(int id, int resourceId, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        ResourceGroup resourceGroup = this.fetchGroup(id, false);
        Resource res = this.resourceManager.getResource(this.caller, resourceId);
        if (res == null) {
            throw new StuffNotFoundException("Resource with id " + resourceId);
        }
        resourceGroup.removeExplicitResource(res);
        return Response.ok().build();
    }

    @Override
    public Response getMetricDefinitionsForGroup(int id, Request request, HttpHeaders headers, UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        ResourceGroup group = this.fetchGroup(id, true);
        Set definitions = group.getResourceType().getMetricDefinitions();
        ArrayList<MetricSchedule> schedules = new ArrayList<MetricSchedule>(definitions.size());
        for (MeasurementDefinition def : definitions) {
            MetricSchedule schedule = new MetricSchedule(def.getId(), def.getName(), def.getDisplayName(), false, def.getDefaultInterval(), def.getUnits().getName(), def.getDisplayType().toString());
            if (def.getDataType() == DataType.MEASUREMENT) {
                UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
                uriBuilder.path("/metric/data/group/{groupId}/{definitionId}");
                URI uri = uriBuilder.build(new Object[]{id, def.getId()});
                Link link = new Link("metric", uri.toString());
                schedule.addLink(link);
            }
            schedules.add(schedule);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listMetricDefinitions", schedules));
        } else {
            GenericEntity<List<MetricSchedule>> ret = new GenericEntity<List<MetricSchedule>>(schedules){};
            builder = Response.ok((Object)ret);
        }
        return builder.build();
    }

    private GroupRest fillGroup(ResourceGroup group, UriInfo uriInfo) {
        GroupRest gr = new GroupRest(group.getName());
        gr.setId(group.getId());
        gr.setCategory(group.getGroupCategory());
        gr.setRecursive(group.isRecursive());
        if (group.getGroupDefinition() != null) {
            gr.setDynaGroupDefinitionId(group.getGroupDefinition().getId());
        }
        gr.setExplicitCount(group.getExplicitResources().size());
        gr.setImplicitCount(group.getImplicitResources().size());
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/group/{id}");
        URI uri = uriBuilder.build(new Object[]{group.getId()});
        Link link = new Link("edit", uri.toASCIIString());
        gr.getLinks().add(link);
        uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/group/{id}/metricDefinitions");
        uri = uriBuilder.build(new Object[]{group.getId()});
        link = new Link("metricDefinitions", uri.toASCIIString());
        gr.getLinks().add(link);
        return gr;
    }

    @Override
    public Response getGroupDefinitions(@Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        PageList<GroupDefinition> gdlist = this.definitionManager.getGroupDefinitions(this.caller, new PageControl());
        ArrayList<GroupDefinitionRest> list = new ArrayList<GroupDefinitionRest>(gdlist.getTotalSize());
        for (GroupDefinition def : gdlist) {
            GroupDefinitionRest definitionRest = this.buildGDRestFromDefinition(def);
            this.createLinksForGDRest(uriInfo, definitionRest);
            list.add(definitionRest);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listGroupDefinition", list), (MediaType)mediaType);
        } else {
            GenericEntity<List<GroupDefinitionRest>> ret = new GenericEntity<List<GroupDefinitionRest>>(list){};
            builder = Response.ok((Object)ret);
        }
        return builder.build();
    }

    @Override
    public Response getGroupDefinition(int definitionId, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        try {
            GroupDefinition def = this.definitionManager.getById(definitionId);
            GroupDefinitionRest gdr = this.buildGDRestFromDefinition(def);
            this.createLinksForGDRest(uriInfo, gdr);
            MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
            Response.ResponseBuilder builder = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("groupDefinition", gdr), (MediaType)mediaType) : Response.ok((Object)gdr);
            return builder.build();
        }
        catch (GroupDefinitionNotFoundException e) {
            throw new StuffNotFoundException("Group definition with id " + definitionId);
        }
    }

    private GroupDefinitionRest buildGDRestFromDefinition(GroupDefinition def) {
        List<Integer> generatedGroups;
        GroupDefinitionRest gdr = new GroupDefinitionRest(def.getId(), def.getName(), def.getDescription(), def.getRecalculationInterval());
        gdr.setRecursive(def.isRecursive());
        if (def.getManagedResourceGroups() != null) {
            generatedGroups = new ArrayList<Integer>(def.getManagedResourceGroups().size());
            for (ResourceGroup group : def.getManagedResourceGroups()) {
                generatedGroups.add(group.getId());
            }
        } else {
            generatedGroups = Collections.emptyList();
        }
        gdr.setGeneratedGroupIds(generatedGroups);
        gdr.setExpression(def.getExpressionAsList());
        return gdr;
    }

    @Override
    public Response deleteGroupDefinition(int definitionId, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        try {
            GroupDefinition def = this.definitionManager.getById(definitionId);
            this.definitionManager.removeGroupDefinition(this.caller, definitionId);
            return Response.noContent().build();
        }
        catch (GroupDefinitionNotFoundException e) {
            return Response.noContent().build();
        }
        catch (GroupDefinitionDeleteException e) {
            throw new StuffNotFoundException("Group definition with id " + definitionId);
        }
    }

    @Override
    public Response createGroupDefinition(GroupDefinitionRest definition, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder = null;
        if (definition.getName() == null || definition.getName().isEmpty()) {
            builder = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE);
            builder.entity((Object)"No name for the definition given");
        }
        if (builder != null) {
            return builder.build();
        }
        GroupDefinition gd = new GroupDefinition(definition.getName());
        gd.setDescription(definition.getDescription());
        List<String> expressionList = definition.getExpression();
        StringBuilder sb = new StringBuilder();
        for (String e : expressionList) {
            sb.append(e);
            sb.append("\n");
        }
        gd.setExpression(sb.toString());
        gd.setRecalculationInterval(Long.valueOf(definition.getRecalcInterval()));
        gd.setRecursive(definition.isRecursive());
        try {
            GroupDefinition res = this.definitionManager.createGroupDefinition(this.caller, gd);
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/group/definition/{id}");
            URI location = uriBuilder.build(new Object[]{res.getId()});
            Link link = new Link("edit", location.toString());
            builder = Response.created((URI)location);
            GroupDefinitionRest gdr = this.buildGDRestFromDefinition(res);
            this.createLinksForGDRest(uriInfo, gdr);
            builder.entity((Object)gdr);
        }
        catch (GroupDefinitionAlreadyExistsException e) {
            builder = Response.status((Response.Status)Response.Status.CONFLICT);
        }
        catch (GroupDefinitionCreateException e) {
            e.printStackTrace();
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        return builder.build();
    }

    @Override
    public Response updateGroupDefinition(int definitionId, boolean recalculate, GroupDefinitionRest definition, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        GroupDefinition gd;
        try {
            gd = this.definitionManager.getById(definitionId);
        }
        catch (GroupDefinitionNotFoundException e) {
            throw new StuffNotFoundException("Group Definition with id " + definitionId);
        }
        Response.ResponseBuilder builder = null;
        if (!definition.getName().isEmpty()) {
            gd.setName(definition.getName());
        }
        gd.setDescription(definition.getDescription());
        List<String> expressionList = definition.getExpression();
        StringBuilder sb = new StringBuilder();
        for (String e : expressionList) {
            sb.append(e);
            sb.append("\n");
        }
        gd.setExpression(sb.toString());
        gd.setRecalculationInterval(Long.valueOf(definition.getRecalcInterval()));
        gd.setRecursive(definition.isRecursive());
        try {
            this.definitionManager.updateGroupDefinition(this.caller, gd);
        }
        catch (Exception e) {
            e.printStackTrace();
            builder = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE);
            builder.entity((Object)e.getLocalizedMessage());
            return builder.build();
        }
        if (recalculate) {
            try {
                this.definitionManager.calculateGroupMembership(this.caller, gd.getId());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            gd = this.definitionManager.getById(gd.getId());
            GroupDefinitionRest gdr = this.buildGDRestFromDefinition(gd);
            this.createLinksForGDRest(uriInfo, gdr);
            builder = Response.ok((Object)gdr);
        }
        catch (GroupDefinitionNotFoundException e) {
            throw new StuffNotFoundException("Group Definition with id " + gd.getId());
        }
        return builder.build();
    }

    private void createLinksForGDRest(UriInfo uriInfo, GroupDefinitionRest gdr) {
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/group/definition/{id}");
        URI location = uriBuilder.build(new Object[]{gdr.getId()});
        Link link = new Link("edit", location.toString());
        gdr.addLink(link);
        uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/group/definition");
        location = uriBuilder.build(new Object[0]);
        link = new Link("create", location.toString());
        gdr.addLink(link);
    }
}

