/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.sql.DataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.cache.Fqn;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementBaseline;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataPK;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.measurement.MeasurementAggregate;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.measurement.util.MeasurementDataManagerUtility;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.MetricHandlerLocal;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.Baseline;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.domain.MetricAggregate;
import org.rhq.enterprise.server.rest.domain.MetricSchedule;
import org.rhq.enterprise.server.rest.domain.NumericDataPoint;
import org.rhq.enterprise.server.rest.domain.StringValue;

@Interceptors(value={SetCallerInterceptor.class})
@Stateless
@Resource(name="RHQ_DS", mappedName="java:/RHQDS")
public class MetricHandlerBean
extends AbstractRestBean
implements MetricHandlerLocal {
    @EJB
    MeasurementDataManagerLocal dataManager;
    @EJB
    MeasurementScheduleManagerLocal scheduleManager;
    @EJB
    MeasurementDefinitionManagerLocal definitionManager;
    @EJB
    ResourceManagerLocal resMgr;
    @EJB
    ResourceGroupManagerLocal groupMgr;
    @PersistenceContext(unitName="rhqpu")
    EntityManager em;
    @Resource(name="RHQ_DS")
    private DataSource rhqDs;
    private static final long EIGHT_HOURS = 28800000L;

    @Override
    public Response getMetricData(int scheduleId, long startTime, long endTime, int dataPoints, boolean hideEmpty, @Context Request request, @Context HttpHeaders headers) {
        Response.ResponseBuilder builder;
        if (dataPoints <= 0) {
            throw new IllegalArgumentException("dataPoints must be >0 ");
        }
        if (startTime == 0L) {
            endTime = System.currentTimeMillis();
            startTime = endTime - 28800000L;
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        boolean isHtml = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE);
        MeasurementSchedule schedule = this.obtainSchedule(scheduleId, false, DataType.MEASUREMENT);
        MeasurementAggregate aggr = this.dataManager.getAggregate(this.caller, scheduleId, startTime, endTime);
        MetricAggregate res = new MetricAggregate(scheduleId, aggr.getMin(), aggr.getAvg(), aggr.getMax());
        int definitionId = schedule.getDefinition().getId();
        List<List<MeasurementDataNumericHighLowComposite>> listList = this.dataManager.findDataForResource(this.caller, schedule.getResource().getId(), new int[]{definitionId}, startTime, endTime, dataPoints);
        if (!listList.isEmpty()) {
            List<MeasurementDataNumericHighLowComposite> list = listList.get(0);
            this.fill(res, list, scheduleId, hideEmpty, isHtml);
        }
        CacheControl cc = new CacheControl();
        int maxAge = (int)(schedule.getInterval() / 1000L) / 2;
        cc.setMaxAge(maxAge);
        cc.setPrivate(false);
        cc.setNoCache(false);
        if (isHtml) {
            String htmlString = this.renderTemplate("metricData", res);
            builder = Response.ok((Object)htmlString, (MediaType)mediaType);
        } else {
            builder = Response.ok((Object)res, (MediaType)mediaType);
        }
        builder.cacheControl(cc);
        return builder.build();
    }

    @Override
    public Response getMetricDataForGroupAndDefinition(int groupId, int definitionId, long startTime, long endTime, int dataPoints, boolean hideEmpty, Request request, HttpHeaders headers) {
        Response.ResponseBuilder builder;
        if (startTime == 0L) {
            endTime = System.currentTimeMillis();
            startTime = endTime - 28800000L;
        }
        if (dataPoints < 1) {
            throw new IllegalArgumentException("datapoints must be >=0");
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        boolean isHtml = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE);
        this.fetchGroup(groupId, true);
        MeasurementDefinition definition = this.definitionManager.getMeasurementDefinition(this.caller, definitionId);
        if (definition == null) {
            throw new StuffNotFoundException("There is no definition with id " + definitionId);
        }
        MeasurementAggregate aggr = this.dataManager.getAggregate(this.caller, groupId, definitionId, startTime, endTime);
        MetricAggregate res = new MetricAggregate(definitionId, aggr.getMin(), aggr.getAvg(), aggr.getMax());
        res.setGroup(true);
        List<List<MeasurementDataNumericHighLowComposite>> listList = this.dataManager.findDataForCompatibleGroup(this.caller, groupId, definitionId, startTime, endTime, dataPoints);
        if (listList.isEmpty()) {
            throw new StuffNotFoundException("Data for group with id " + groupId + " and definition " + definitionId);
        }
        List<MeasurementDataNumericHighLowComposite> list = listList.get(0);
        if (!listList.isEmpty()) {
            this.fill(res, list, definitionId, hideEmpty, isHtml);
        }
        CacheControl cc = new CacheControl();
        int maxAge = (int)(definition.getDefaultInterval() / 1000L) / 2;
        cc.setMaxAge(maxAge);
        cc.setPrivate(false);
        cc.setNoCache(false);
        if (isHtml) {
            String htmlString = this.renderTemplate("metricData", res);
            builder = Response.ok((Object)htmlString, (MediaType)mediaType);
        } else {
            builder = Response.ok((Object)res, (MediaType)mediaType);
        }
        builder.cacheControl(cc);
        return builder.build();
    }

    private MeasurementSchedule obtainSchedule(int scheduleId, boolean force, DataType type) {
        MeasurementSchedule schedule = null;
        if (!force) {
            schedule = this.getFromCache(scheduleId, MeasurementSchedule.class);
        }
        if (schedule == null) {
            schedule = this.scheduleManager.getScheduleById(this.caller, scheduleId);
            if (schedule == null) {
                throw new StuffNotFoundException("Schedule with id " + scheduleId);
            }
            this.putToCache(scheduleId, MeasurementSchedule.class, schedule);
        }
        if (schedule.getDefinition().getDataType() != type) {
            throw new IllegalArgumentException("Schedule [" + scheduleId + "] is not a (" + type + ") metric");
        }
        return schedule;
    }

    private MetricAggregate fill(MetricAggregate res, List<MeasurementDataNumericHighLowComposite> list, int scheduleId, boolean hideEmpty, boolean isHtmlOutput) {
        long minTime = Long.MAX_VALUE;
        long maxTime = 0L;
        res.setScheduleId(scheduleId);
        for (MeasurementDataNumericHighLowComposite c : list) {
            MetricAggregate.DataPoint dp;
            long timestamp = c.getTimestamp();
            if (Double.isNaN(c.getValue()) && hideEmpty) continue;
            if (isHtmlOutput) {
                dp = new MetricAggregate.DataPoint(timestamp);
                Double v = c.getLowValue();
                v = this.nullifyIfNaN(v);
                dp.setLow(v);
                v = c.getHighValue();
                v = this.nullifyIfNaN(v);
                dp.setHigh(v);
                v = c.getValue();
                v = this.nullifyIfNaN(v);
                dp.setValue(v);
            } else {
                dp = new MetricAggregate.DataPoint(timestamp, c.getValue(), c.getHighValue(), c.getLowValue());
            }
            res.addDataPoint(dp);
            if (timestamp < minTime) {
                minTime = timestamp;
            }
            if (timestamp <= maxTime) continue;
            maxTime = timestamp;
        }
        res.setNumDataPoints(list.size());
        res.setMaxTimeStamp(maxTime);
        res.setMinTimeStamp(minTime);
        return res;
    }

    private Double nullifyIfNaN(Double v) {
        if (Double.isNaN(v)) {
            v = null;
        }
        return v;
    }

    @Override
    @GET
    @Path(value="data")
    @Produces(value={"application/json", "application/xml", "text/html"})
    public Response getMetricDataMulti(@QueryParam(value="sid") String schedules, @QueryParam(value="startTime") long startTime, @QueryParam(value="endTime") long endTime, @QueryParam(value="dataPoints") int dataPoints, @QueryParam(value="hideEmpty") boolean hideEmpty, @Context Request request, @Context HttpHeaders headers) {
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        long now = System.currentTimeMillis();
        if (endTime == 0L) {
            endTime = now;
        }
        if (startTime == 0L) {
            endTime = System.currentTimeMillis();
            startTime = endTime - 28800000L;
        }
        String[] tmp = schedules.split(",");
        Integer[] scheduleIds = new Integer[tmp.length];
        try {
            for (int i = 0; i < tmp.length; ++i) {
                scheduleIds[i] = Integer.parseInt(tmp[i]);
            }
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Bad input: " + nfe.getMessage());
        }
        ArrayList<MetricAggregate> resList = new ArrayList<MetricAggregate>(scheduleIds.length);
        for (Integer scheduleId : scheduleIds) {
            MeasurementSchedule sched = this.scheduleManager.getScheduleById(this.caller, scheduleId);
            if (sched == null) {
                throw new StuffNotFoundException("Schedule with id " + scheduleId);
            }
            int definitionId = sched.getDefinition().getId();
            List<List<MeasurementDataNumericHighLowComposite>> listList = this.dataManager.findDataForContext(this.caller, EntityContext.forResource((int)sched.getResource().getId()), definitionId, startTime, endTime, dataPoints);
            if (listList.isEmpty()) {
                throw new StuffNotFoundException("Metrics for schedule " + scheduleId);
            }
            List<MeasurementDataNumericHighLowComposite> list = listList.get(0);
            MetricAggregate res = new MetricAggregate();
            boolean isHtml = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE);
            this.fill(res, list, scheduleId, hideEmpty, isHtml);
            resList.add(res);
        }
        GenericEntity<List<MetricAggregate>> metAgg = new GenericEntity<List<MetricAggregate>>(resList){};
        return Response.ok((Object)metAgg, (MediaType)mediaType).build();
    }

    @Override
    public Response getSchedule(int scheduleId, Request request, HttpHeaders headers, UriInfo uriInfo) {
        EntityTag eTag;
        long tim;
        EntityTag eTag2;
        long tim2;
        Response.ResponseBuilder builder;
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        CacheControl cc = new CacheControl();
        cc.setMaxAge(300);
        cc.setPrivate(false);
        Fqn fqn = this.getFqn(scheduleId, MeasurementSchedule.class);
        MeasurementSchedule schedule = this.getFromCache(fqn, MeasurementSchedule.class);
        if (schedule != null && (builder = request.evaluatePreconditions(new Date(tim2 = schedule.getMtime() != null ? schedule.getMtime() : 0L), eTag2 = new EntityTag(Long.toOctalString((long)schedule.hashCode() + tim2)))) != null) {
            builder.cacheControl(cc);
            return builder.build();
        }
        if (schedule == null) {
            schedule = this.scheduleManager.getScheduleById(this.caller, scheduleId);
            if (schedule == null) {
                throw new StuffNotFoundException("Schedule with id " + scheduleId);
            }
            this.putToCache(fqn, schedule);
        }
        MeasurementDefinition definition = schedule.getDefinition();
        MetricSchedule metricSchedule = new MetricSchedule(schedule.getId(), definition.getName(), definition.getDisplayName(), schedule.isEnabled(), schedule.getInterval(), definition.getUnits().toString(), definition.getDataType().toString());
        if (schedule.getMtime() != null) {
            metricSchedule.setMtime(schedule.getMtime());
        }
        if ((builder = request.evaluatePreconditions(new Date(tim = schedule.getMtime() != null ? schedule.getMtime() : 0L), eTag = new EntityTag(Long.toOctalString((long)schedule.hashCode() + tim)))) == null) {
            Link link;
            URI uri;
            UriBuilder uriBuilder;
            if (definition.getDataType() == DataType.MEASUREMENT) {
                uriBuilder = uriInfo.getBaseUriBuilder();
                uriBuilder.path("metric/data/" + scheduleId);
                uri = uriBuilder.build(new Object[0]);
                link = new Link("metric", uri.toString());
                metricSchedule.addLink(link);
            }
            uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("resource/" + schedule.getResource().getId());
            uri = uriBuilder.build(new Object[0]);
            link = new Link("resource", uri.toString());
            metricSchedule.addLink(link);
            uriBuilder = uriInfo.getAbsolutePathBuilder();
            uri = uriBuilder.build(new Object[0]);
            Link updateLink = new Link("edit", uri.toString());
            metricSchedule.addLink(updateLink);
            builder = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("metricSchedule", metricSchedule), (MediaType)mediaType) : Response.ok((Object)metricSchedule, (MediaType)mediaType);
        }
        builder.cacheControl(cc);
        builder.tag(eTag);
        return builder.build();
    }

    @Override
    public List<MetricAggregate> getAggregatesForResource(int resourceId, long startTime, long endTime) {
        long now = System.currentTimeMillis();
        if (endTime == 0L) {
            endTime = now;
        }
        if (startTime == 0L) {
            startTime = endTime - 28800000L;
        }
        List<MeasurementSchedule> schedules = this.scheduleManager.findSchedulesForResourceAndType(this.caller, resourceId, DataType.MEASUREMENT, null, false);
        for (MeasurementSchedule sched : schedules) {
            this.putToCache(sched.getId(), MeasurementSchedule.class, sched);
        }
        ArrayList<MetricAggregate> ret = new ArrayList<MetricAggregate>(schedules.size());
        for (MeasurementSchedule schedule : schedules) {
            MeasurementAggregate aggr = this.dataManager.getAggregate(this.caller, schedule.getId(), startTime, endTime);
            MetricAggregate res = new MetricAggregate(schedule.getId(), aggr.getMin(), aggr.getAvg(), aggr.getMax());
            ret.add(res);
        }
        return ret;
    }

    @Override
    public List<MetricAggregate> getAggregatesForGroup(int groupId, long startTime, long endTime) {
        long now = System.currentTimeMillis();
        if (endTime == 0L) {
            endTime = now;
        }
        if (startTime == 0L) {
            startTime = endTime - 28800000L;
        }
        ResourceGroup group = this.fetchGroup(groupId, true);
        Set definitions = group.getResourceType().getMetricDefinitions();
        ArrayList<MetricAggregate> ret = new ArrayList<MetricAggregate>(definitions.size());
        for (MeasurementDefinition def : definitions) {
            if (def.getDataType() != DataType.MEASUREMENT) continue;
            MeasurementAggregate aggregate = this.dataManager.getAggregate(this.caller, groupId, def.getId(), startTime, endTime);
            MetricAggregate res = new MetricAggregate(def.getId(), aggregate.getMin(), aggregate.getAvg(), aggregate.getMax());
            res.setGroup(true);
            ret.add(res);
        }
        return ret;
    }

    @Override
    public Response updateSchedule(int scheduleId, MetricSchedule in, HttpHeaders httpHeaders) {
        if (in == null) {
            throw new StuffNotFoundException("Input is null");
        }
        if (in.getScheduleId() == null) {
            throw new StuffNotFoundException("Invalid input data");
        }
        MeasurementSchedule schedule = this.scheduleManager.getScheduleById(this.caller, scheduleId);
        if (schedule == null) {
            throw new StuffNotFoundException("Schedule with id " + scheduleId);
        }
        schedule.setEnabled(in.getEnabled().booleanValue());
        schedule.setInterval(in.getCollectionInterval());
        this.scheduleManager.updateSchedule(this.caller, schedule);
        schedule = this.scheduleManager.getScheduleById(this.caller, scheduleId);
        Fqn fqn = this.getFqn(scheduleId, MeasurementSchedule.class);
        this.putToCache(fqn, schedule);
        MeasurementDefinition def = schedule.getDefinition();
        MetricSchedule ret = new MetricSchedule(scheduleId, def.getName(), def.getDisplayName(), schedule.isEnabled(), schedule.getInterval(), def.getUnits().toString(), def.getDataType().toString());
        return Response.ok((Object)ret, (MediaType)((MediaType)httpHeaders.getAcceptableMediaTypes().get(0))).build();
    }

    @Override
    @GET
    @Path(value="data/{scheduleId}/raw")
    public StreamingOutput getMetricDataRaw(@PathParam(value="scheduleId") int scheduleId, @QueryParam(value="startTime") long startTime, @QueryParam(value="endTime") long endTime, long duration, Request request, HttpHeaders headers) {
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        long now = System.currentTimeMillis();
        if (endTime == 0L) {
            endTime = now;
        }
        if (startTime == 0L) {
            startTime = endTime - 28800000L;
        }
        if (duration > 0L) {
            startTime = endTime - duration * 1000L;
        }
        if (startTime < now - 604800000L) {
            throw new IllegalArgumentException("Start time is older than 7 days");
        }
        this.obtainSchedule(scheduleId, false, DataType.MEASUREMENT);
        RawNumericStreamingOutput so = new RawNumericStreamingOutput();
        so.scheduleId = scheduleId;
        so.startTime = startTime;
        so.endTime = endTime;
        so.mediaType = mediaType;
        so.now = now - 1L;
        return so;
    }

    @Override
    @PUT
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="data/{scheduleId}/raw/{timeStamp}")
    public Response putMetricValue(@PathParam(value="scheduleId") int scheduleId, @PathParam(value="timeStamp") long timestamp, NumericDataPoint point, @Context HttpHeaders headers, UriInfo uriInfo) {
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        MeasurementSchedule schedule = this.obtainSchedule(scheduleId, false, DataType.MEASUREMENT);
        HashSet<MeasurementDataNumeric> data = new HashSet<MeasurementDataNumeric>(1);
        data.add(new MeasurementDataNumeric(point.getTimeStamp(), scheduleId, point.getValue()));
        this.dataManager.addNumericData(data);
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/metric/data/{scheduleId}/raw");
        uriBuilder.queryParam("startTime", new Object[]{timestamp});
        uriBuilder.queryParam("endTime", new Object[]{timestamp});
        URI uri = uriBuilder.build(new Object[]{scheduleId});
        return Response.created((URI)uri).type(mediaType).build();
    }

    @Override
    public Response putTraitValue(@PathParam(value="scheduleId") int scheduleId, StringValue value) {
        MeasurementSchedule schedule = this.obtainSchedule(scheduleId, false, DataType.TRAIT);
        HashSet<MeasurementDataTrait> traits = new HashSet<MeasurementDataTrait>(1);
        MeasurementDataPK pk = new MeasurementDataPK(System.currentTimeMillis(), scheduleId);
        traits.add(new MeasurementDataTrait(pk, value.getValue()));
        this.dataManager.addTraitData(traits);
        return Response.ok().build();
    }

    @Override
    public Response getTraitValue(@PathParam(value="scheduleId") int scheduleId) {
        Response.ResponseBuilder builder;
        MeasurementSchedule schedule = this.obtainSchedule(scheduleId, false, DataType.TRAIT);
        List<MeasurementDataTrait> traits = this.dataManager.findTraits(this.caller, schedule.getResource().getId(), schedule.getDefinition().getId());
        if (traits != null && traits.size() > 0) {
            builder = Response.ok();
            StringValue value = new StringValue(traits.get(0).getValue());
            builder.entity((Object)value);
        } else {
            builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
        }
        return builder.build();
    }

    @Override
    @POST
    @Path(value="data/raw")
    @Consumes(value={"application/json", "application/xml"})
    public Response postMetricValues(Collection<NumericDataPoint> points, @Context HttpHeaders headers) {
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        HashSet<MeasurementDataNumeric> data = new HashSet<MeasurementDataNumeric>(points.size());
        for (NumericDataPoint point : points) {
            data.add(new MeasurementDataNumeric(point.getTimeStamp(), point.getScheduleId(), point.getValue()));
        }
        this.dataManager.addNumericData(data);
        return Response.noContent().type(mediaType).build();
    }

    @Override
    @GET
    @Path(value="data/{scheduleId}/baseline")
    public Baseline getBaseline(@PathParam(value="scheduleId") int scheduleId, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        MeasurementSchedule schedule = this.obtainSchedule(scheduleId, true, DataType.MEASUREMENT);
        MeasurementBaseline mBase = schedule.getBaseline();
        if (mBase == null) {
            throw new StuffNotFoundException("Baseline for schedule [" + scheduleId + "]");
        }
        Baseline b = new Baseline(mBase.getMin(), mBase.getMax(), mBase.getMean(), mBase.getComputeTime().getTime());
        return b;
    }

    @Override
    @PUT
    @Path(value="data/{scheduleId}/baseline")
    public void setBaseline(@PathParam(value="scheduleId") int scheduleId, Baseline baseline, HttpHeaders headers, @Context UriInfo uriInfo) {
        MeasurementSchedule schedule = this.obtainSchedule(scheduleId, false, DataType.MEASUREMENT);
        if (baseline.getMin() > baseline.getMean() || baseline.getMean() > baseline.getMax() || baseline.getMin() > baseline.getMax()) {
            throw new IllegalArgumentException("Baseline not correct. it should be min<=mean<=max");
        }
        MeasurementBaseline mBase = schedule.getBaseline();
        if (mBase == null) {
            mBase = new MeasurementBaseline();
            mBase.setSchedule(schedule);
            schedule.setBaseline(mBase);
            this.em.persist((Object)mBase);
        }
        mBase.setMax(Double.valueOf(baseline.getMax()));
        mBase.setMin(Double.valueOf(baseline.getMin()));
        mBase.setMean(Double.valueOf(baseline.getMean()));
        mBase.setUserEntered(true);
        this.scheduleManager.updateSchedule(this.caller, schedule);
    }

    private class RawNumericStreamingOutput
    implements StreamingOutput {
        int scheduleId;
        long startTime;
        long endTime;
        long now;
        MediaType mediaType;

        private RawNumericStreamingOutput() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(OutputStream outputStream) throws IOException, WebApplicationException {
            String[] tables = MeasurementDataManagerUtility.getTables(this.startTime, this.endTime, this.now);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < tables.length; ++i) {
                sb.append("SELECT time_stamp,value FROM ");
                sb.append(tables[i]);
                sb.append(" WHERE schedule_id = ? AND time_stamp BETWEEN ? AND ?");
                if (i >= tables.length - 1) continue;
                sb.append(" UNION ALL ");
            }
            sb.append(" ORDER BY time_stamp ASC");
            Connection connection = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                connection = MetricHandlerBean.this.rhqDs.getConnection();
                ps = connection.prepareStatement(sb.toString());
                for (int i = 0; i < tables.length; ++i) {
                    ps.setInt(i * 3 + 1, this.scheduleId);
                    ps.setLong(i * 3 + 2, this.startTime);
                    ps.setLong(i * 3 + 3, this.endTime);
                }
                rs = ps.executeQuery();
                PrintWriter pw = new PrintWriter(outputStream);
                if (this.mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                    boolean needsComma = false;
                    pw.println("[");
                    while (rs.next()) {
                        if (needsComma) {
                            pw.print(",\n");
                        }
                        needsComma = true;
                        pw.print("{");
                        pw.print("\"scheduleId\":");
                        pw.print(this.scheduleId);
                        pw.print(", ");
                        pw.print("\"timeStamp\":");
                        pw.print(rs.getLong(1));
                        pw.print(", ");
                        pw.print("\"value\":");
                        pw.print(rs.getDouble(2));
                        pw.print("}");
                    }
                    pw.println("]");
                } else if (this.mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
                    pw.println("<collection>");
                    while (rs.next()) {
                        pw.print("  <numericDataPoint scheduleId=\"");
                        pw.print(this.scheduleId);
                        pw.print("\" timeStamp=\"");
                        pw.print(rs.getLong(1));
                        pw.print("\" value=\"");
                        pw.print(rs.getDouble(2));
                        pw.println("\"/>");
                    }
                    pw.println("</collection>");
                } else if (this.mediaType.toString().equals("text/csv")) {
                    pw.println("#schedule,timestamp,value");
                    while (rs.next()) {
                        pw.print(this.scheduleId);
                        pw.print(',');
                        pw.print(rs.getLong(1));
                        pw.print(',');
                        pw.println(rs.getDouble(2));
                    }
                } else if (this.mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
                    pw.println("<table>");
                    pw.print("<tr><th>time</th><th>value</th></tr>\n");
                    while (rs.next()) {
                        pw.print("  <tr>");
                        pw.print("<td>");
                        pw.print(new Date(rs.getLong(1)));
                        pw.print("</td><td>");
                        pw.print(rs.getDouble(2));
                        pw.print("</td>");
                        pw.println("</tr>");
                    }
                    pw.println("</table>");
                }
                pw.flush();
                pw.close();
            }
            catch (SQLException e) {
                try {
                    MetricHandlerBean.this.log.error((Object)e);
                }
                catch (Throwable throwable) {
                    JDBCUtil.safeClose((Connection)connection, ps, rs);
                    throw throwable;
                }
                JDBCUtil.safeClose((Connection)connection, (Statement)ps, rs);
            }
            JDBCUtil.safeClose((Connection)connection, (Statement)ps, (ResultSet)rs);
        }
    }
}

