/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiError;
import com.wordnik.swagger.annotations.ApiErrors;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import javax.ejb.Local;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.GZIP;
import org.rhq.enterprise.server.rest.domain.Baseline;
import org.rhq.enterprise.server.rest.domain.MetricAggregate;
import org.rhq.enterprise.server.rest.domain.MetricSchedule;
import org.rhq.enterprise.server.rest.domain.NumericDataPoint;
import org.rhq.enterprise.server.rest.domain.StringValue;

@Api(value="Deal with metrics", description="This part of the API deals with exporting metrics")
@Produces(value={"application/json", "application/xml", "text/html"})
@Path(value="/metric")
@Local
public interface MetricHandlerLocal {
    public static final String NO_RESOURCE_FOR_ID = "If no resource with the passed id exists";
    public static final String NO_SCHEDULE_FOR_ID = "No schedule with the passed id exists";

    @GZIP
    @GET
    @Path(value="data/{scheduleId}")
    @Produces(value={"application/json", "application/xml", "text/html"})
    @ApiOperation(value="Get the bucketized metric values for the schedule ")
    @ApiError(code=404, reason="No schedule with the passed id exists")
    public Response getMetricData(@ApiParam(value="Schedule Id of the values to query") @PathParam(value="scheduleId") int var1, @ApiParam(value="Start time since epoch.", defaultValue="End time - 8h") @QueryParam(value="startTime") long var2, @ApiParam(value="End time since epoch.", defaultValue="Now") @QueryParam(value="endTime") long var4, @ApiParam(value="Number of buckets - currently fixed at 60") @QueryParam(value="dataPoints") @DefaultValue(value="60") int var6, @ApiParam(value="Hide rows that are NaN only", defaultValue="false") @QueryParam(value="hideEmpty") boolean var7, @Context Request var8, @Context HttpHeaders var9);

    @GET
    @Path(value="data")
    @Produces(value={"application/json", "application/xml", "text/html"})
    public Response getMetricDataMulti(@QueryParam(value="sid") String var1, @QueryParam(value="startTime") long var2, @QueryParam(value="endTime") long var4, @QueryParam(value="dataPoints") int var6, @QueryParam(value="hideEmpty") boolean var7, @Context Request var8, @Context HttpHeaders var9);

    @GET
    @Path(value="data/resource/{resourceId}")
    @ApiOperation(value="Retrieve a list of high/low/average/data aggregate for the resource")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    public List<MetricAggregate> getAggregatesForResource(@ApiParam(value="Id of the resource to query") @PathParam(value="resourceId") int var1, @ApiParam(value="Start time since epoch.", defaultValue="End time - 8h") @QueryParam(value="startTime") long var2, @ApiParam(value="End time since epoch.", defaultValue="Now") @QueryParam(value="endTime") long var4);

    @GET
    @Path(value="data/group/{groupId}")
    @ApiOperation(value="Retrieve a list of high/low/average/data aggregate for the group")
    public List<MetricAggregate> getAggregatesForGroup(@ApiParam(value="Id of the group to query") @PathParam(value="groupId") int var1, @ApiParam(value="Start time since epoch.", defaultValue="End time - 8h") @QueryParam(value="startTime") long var2, @ApiParam(value="End time since epoch.", defaultValue="Now") @QueryParam(value="endTime") long var4);

    @GZIP
    @GET
    @Path(value="data/group/{groupId}/{definitionId}")
    @ApiOperation(value="Get the bucketized metric values for the metric definition of the group ")
    @Produces(value={"application/json", "application/xml", "text/html"})
    public Response getMetricDataForGroupAndDefinition(@ApiParam(value="Id of the group to query") @PathParam(value="groupId") int var1, @ApiParam(value="Id of the metric definition to retrieve") @PathParam(value="definitionId") int var2, @ApiParam(value="Start time since epoch.", defaultValue="End time - 8h") @QueryParam(value="startTime") long var3, @ApiParam(value="End time since epoch.", defaultValue="Now") @QueryParam(value="endTime") long var5, @ApiParam(value="Number of buckets - currently fixed at 60") @QueryParam(value="dataPoints") @DefaultValue(value="60") int var7, @ApiParam(value="Hide rows that are NaN only", defaultValue="false") @QueryParam(value="hideEmpty") boolean var8, @Context Request var9, @Context HttpHeaders var10);

    @GET
    @Path(value="/schedule/{id}")
    @Produces(value={"application/json", "application/xml", "text/html"})
    @ApiOperation(value="Get the metric schedule for the passed id")
    @ApiError(code=404, reason="No schedule with the passed id exists")
    public Response getSchedule(@ApiParam(value="Schedule Id") @PathParam(value="id") int var1, @Context Request var2, @Context HttpHeaders var3, @Context UriInfo var4);

    @PUT
    @Path(value="/schedule/{id}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Update the schedule (enabled, interval) ", responseClass="MetricSchedule")
    @ApiError(code=404, reason="No schedule with the passed id exists")
    public Response updateSchedule(@ApiParam(value="Id of the schedule to query") @PathParam(value="id") int var1, @ApiParam(value="New schedule data", required=true) MetricSchedule var2, @Context HttpHeaders var3);

    @GZIP
    @ApiOperation(value="Expose the raw metrics of a single schedule. This can only expose raw data, which means the start date may not be older than 7 days.")
    @GET
    @Path(value="data/{scheduleId}/raw")
    @Produces(value={"application/json", "application/xml", "text/csv", "text/html"})
    @ApiErrors(value={@ApiError(code=404, reason="No schedule with the passed id exists")})
    public StreamingOutput getMetricDataRaw(@ApiParam(required=true) @PathParam(value="scheduleId") int var1, @ApiParam(value="Start time since epoch", defaultValue="Now - 8h") @QueryParam(value="startTime") long var2, @ApiParam(value="End time since epoch", defaultValue="Now") @QueryParam(value="endTime") long var4, @ApiParam(defaultValue="8h = 28800000ms", value="Timespan in ms") @QueryParam(value="duration") long var6, @Context Request var8, @Context HttpHeaders var9);

    @PUT
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="data/{scheduleId}/raw/{timeStamp}")
    @ApiOperation(value="Submit a single (numerical) metric to the server")
    @ApiError(code=404, reason="No schedule with the passed id exists")
    public Response putMetricValue(@ApiParam(value="Id of the schedule") @PathParam(value="scheduleId") int var1, @ApiParam(value="Timestamp of the metric") @PathParam(value="timeStamp") long var2, @ApiParam(value="Data point", required=true) NumericDataPoint var4, @Context HttpHeaders var5, @Context UriInfo var6);

    @POST
    @Path(value="data/raw")
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Submit a series of (numerical) metric values to the server", responseClass="No response")
    public Response postMetricValues(Collection<NumericDataPoint> var1, @Context HttpHeaders var2);

    @GET
    @Path(value="data/{scheduleId}/baseline")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Get the current baseline for the schedule")
    @ApiError(code=404, reason="No schedule with the passed id exists")
    public Baseline getBaseline(@ApiParam(value="Id of the schedule") @PathParam(value="scheduleId") int var1, @Context HttpHeaders var2, @Context UriInfo var3);

    @PUT
    @Path(value="data/{scheduleId}/baseline")
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Set a new baseline for the schedule")
    @ApiError(code=404, reason="No schedule with the passed id exists")
    public void setBaseline(@ApiParam(value="Id of the schedule") @PathParam(value="scheduleId") int var1, Baseline var2, @Context HttpHeaders var3, @Context UriInfo var4);

    @PUT
    @Path(value="data/{scheduleId}/trait")
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Submit a new trait value for the passed schedule id")
    @ApiError(code=404, reason="No schedule with the passed id exists")
    public Response putTraitValue(@ApiParam(value="Id of the schedule") @PathParam(value="scheduleId") int var1, StringValue var2);

    @GET
    @Path(value="data/{scheduleId}/trait")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Get the current value of the trait with the passed schedule id", responseClass="StringValue")
    @ApiError(code=404, reason="No schedule with the passed id exists")
    public Response getTraitValue(@ApiParam(value="Id of the schedule") @PathParam(value="scheduleId") int var1);
}

