/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import javax.ejb.Local;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.GZIP;
import org.jboss.resteasy.annotations.cache.Cache;
import org.rhq.enterprise.server.rest.domain.OperationRest;

@Local
@Path(value="/operation")
@Produces(value={"application/json", "application/xml"})
public interface OperationsHandlerLocal {
    @GET
    @Path(value="definition/{id}")
    @Cache(maxAge=1200)
    @ApiOperation(value="Retrieve a single operation definition by its id")
    public Response getOperationDefinition(@ApiParam(value="Id of the definition to retrieve") @PathParam(value="id") int var1, @ApiParam(value="Id of a resource that supports this operation") @QueryParam(value="resourceId") Integer var2, @Context UriInfo var3, @Context Request var4, @Context HttpHeaders var5);

    @GZIP
    @GET
    @Path(value="definitions")
    @Cache(maxAge=1200)
    @ApiOperation(value="List all operation definitions for a resource")
    public Response getOperationDefinitions(@ApiParam(value="Id of the resource", required=true) @QueryParam(value="resourceId") Integer var1, @Context UriInfo var2, @Context Request var3, @Context HttpHeaders var4);

    @POST
    @Path(value="definition/{id}")
    @ApiOperation(value="Create a new (draft) operation from the passed definition id for the passed resource")
    public Response createOperation(@ApiParam(value="Id of the definition") @PathParam(value="id") int var1, @ApiParam(value="Id of the resource", required=true) @QueryParam(value="resourceId") Integer var2, @Context UriInfo var3);

    @GET
    @Path(value="{id}")
    @ApiOperation(value="Return a (draft) operation")
    public Response getOperation(@ApiParam(value="Id of the operation to retrieve") @PathParam(value="id") int var1);

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Update a (draft) operation. If the state is set to 'ready', the operation will be scheduled")
    public Response updateOperation(@ApiParam(value="Id of the operation to update") @PathParam(value="id") int var1, OperationRest var2, @Context UriInfo var3);

    @DELETE
    @Path(value="{id}")
    @ApiOperation(value="Delete a (draft) operation")
    public Response cancelOperation(@ApiParam(value="Id of the operation to remove") @PathParam(value="id") int var1);

    @GZIP
    @GET
    @Path(value="history/{id}")
    @ApiOperation(value="Return the outcome of the scheduled operation")
    @Produces(value={"application/json", "application/xml", "text/html"})
    public Response outcome(@ApiParam(value="Name of the submitted job.") @PathParam(value="id") String var1, @Context UriInfo var2, @Context Request var3, @Context HttpHeaders var4);

    @GZIP
    @GET
    @Path(value="history")
    @ApiOperation(value="Return the outcome of the executed operations for a resource")
    @Produces(value={"application/json", "application/xml", "text/html"})
    public Response listHistory(@ApiParam(value="Id of a resource to limit to") @QueryParam(value="resourceId") int var1, @Context UriInfo var2, @Context Request var3, @Context HttpHeaders var4);

    @DELETE
    @Path(value="history/{id}")
    @ApiOperation(value="Delete the operation history item with the passed id")
    public Response deleteOperationHistoryItem(@ApiParam(value="Name fo the submitted job") @PathParam(value="id") String var1);
}

