/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.EJBContext;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.naming.OperationNotSupportedException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.auth.SessionException;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.util.LookupUtil;

public class ReportsInterceptor {
    private final Log log = LogFactory.getLog(ReportsInterceptor.class);
    @Resource
    private EJBContext ejbContext;
    @EJB
    private SubjectManagerLocal subjectManager;

    @AroundInvoke
    public Object setCaller(InvocationContext ctx) throws Exception {
        HttpServletRequest request = this.getRequest(ctx.getParameters());
        if (request == null) {
            String msg = "No " + HttpServletRequest.class.getName() + " parameter was found for " + this.getMethodName(ctx) + ". An " + HttpServletRequest.class.getName() + " parameter must be specified in order to support authentication";
            this.log.error((Object)msg);
            throw new OperationNotSupportedException(msg);
        }
        Subject subject = this.getSubject(request);
        if (subject == null) {
            throw new IllegalAccessException("Failed to validate request: could not access subject for request URL " + request.getRequestURL());
        }
        AbstractRestBean target = (AbstractRestBean)ctx.getTarget();
        target.caller = subject;
        Object result = ctx.proceed();
        if (result instanceof StreamingOutput) {
            return new LoggingStreamingOutput((StreamingOutput)result, this.getMethodName(ctx));
        }
        return result;
    }

    private String getMethodName(InvocationContext ctx) {
        return ctx.getTarget().getClass().getName() + "." + ctx.getMethod().getName();
    }

    private HttpServletRequest getRequest(Object[] params) {
        for (Object param : params) {
            if (!(param instanceof HttpServletRequest)) continue;
            return (HttpServletRequest)param;
        }
        return null;
    }

    private Subject getSubject(HttpServletRequest request) {
        Cookie rhqSession = this.getCookie(request, "RHQ_Session");
        if (rhqSession == null) {
            return null;
        }
        String sessionId = rhqSession.getValue();
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        try {
            return subjectMgr.getSubjectBySessionId(Integer.parseInt(sessionId));
        }
        catch (NumberFormatException e) {
            this.log.warn((Object)(sessionId + " is not a valid session id."), (Throwable)e);
            return null;
        }
        catch (SessionException e) {
            this.log.warn((Object)("Could not get subject for session id " + sessionId), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)("An unexpected exception occurred while trying to access subject for session id " + sessionId), (Throwable)e);
            return null;
        }
    }

    private Cookie getCookie(HttpServletRequest request, String name) {
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    private class LoggingStreamingOutput
    implements StreamingOutput {
        String methodName;
        StreamingOutput delegate;

        public LoggingStreamingOutput(StreamingOutput delegate, String methodName) {
            this.delegate = delegate;
            this.methodName = methodName;
        }

        public void write(OutputStream output) throws IOException, WebApplicationException {
            long start = System.currentTimeMillis();
            try {
                this.delegate.write(output);
            }
            catch (IOException e) {
                ReportsInterceptor.this.log.error((Object)("An exception occurred while executing " + this.methodName), (Throwable)e);
                throw e;
            }
            catch (RuntimeException e) {
                ReportsInterceptor.this.log.error((Object)("An exception occurred while executing " + this.methodName), (Throwable)e);
                throw e;
            }
            long end = System.currentTimeMillis();
            if (ReportsInterceptor.this.log.isDebugEnabled()) {
                ReportsInterceptor.this.log.debug((Object)(this.methodName + " finished streaming report in " + (end - start) + " ms"));
            }
        }
    }
}

