/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.criteria.AvailabilityCriteria;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.ResourceAlreadyExistsException;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.ResourceHandlerLocal;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.AvailabilityRest;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.domain.MetricSchedule;
import org.rhq.enterprise.server.rest.domain.ResourceWithChildren;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;
import org.rhq.enterprise.server.rest.domain.StringValue;

@Interceptors(value={SetCallerInterceptor.class})
@Stateless
public class ResourceHandlerBean
extends AbstractRestBean
implements ResourceHandlerLocal {
    @EJB
    AvailabilityManagerLocal availMgr;
    @EJB
    MeasurementScheduleManagerLocal scheduleManager;
    @EJB
    AlertManagerLocal alertManager;
    @EJB
    ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    AgentManagerLocal agentMgr;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    @Override
    public Response getResource(int id, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        EntityTag eTag;
        Resource res = this.fetchResource(id);
        long mtime = res.getMtime();
        Response.ResponseBuilder builder = request.evaluatePreconditions(new Date(mtime), eTag = new EntityTag(Long.toOctalString((long)res.hashCode() + mtime)));
        if (builder != null) {
            return builder.build();
        }
        ResourceWithType rwt = this.fillRWT(res, uriInfo);
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        builder = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("resourceWithType", rwt), (MediaType)mediaType) : Response.ok((Object)rwt);
        return builder.build();
    }

    @Override
    public Response getPlatforms(@Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        PageControl pc = new PageControl();
        PageList<Resource> ret = this.resMgr.findResourcesByCategory(this.caller, ResourceCategory.PLATFORM, InventoryStatus.COMMITTED, pc);
        ArrayList<ResourceWithType> rwtList = new ArrayList<ResourceWithType>(ret.size());
        for (Resource r : ret) {
            this.putToCache(r.getId(), Resource.class, r);
            ResourceWithType rwt = this.fillRWT(r, uriInfo);
            rwtList.add(rwt);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listResourceWithType", rwtList), (MediaType)mediaType);
        } else {
            GenericEntity<List<ResourceWithType>> list = new GenericEntity<List<ResourceWithType>>(rwtList){};
            builder = Response.ok((Object)list);
        }
        return builder.build();
    }

    @Override
    public ResourceWithChildren getHierarchy(int baseResourceId) {
        Resource start = this.obtainResource(baseResourceId);
        ResourceWithChildren rwc = this.getHierarchy(start);
        return rwc;
    }

    ResourceWithChildren getHierarchy(Resource baseResource) {
        ResourceWithChildren rwc = new ResourceWithChildren("" + baseResource.getId(), baseResource.getName());
        PageControl pc = new PageControl();
        PageList<Resource> ret = this.resMgr.findResourceByParentAndInventoryStatus(this.caller, baseResource, InventoryStatus.COMMITTED, pc);
        if (!ret.isEmpty()) {
            ArrayList<ResourceWithChildren> resList = new ArrayList<ResourceWithChildren>(ret.size());
            for (Resource res : ret) {
                ResourceWithChildren child = this.getHierarchy(res);
                resList.add(child);
                this.putToCache(res.getId(), Resource.class, res);
            }
            if (!resList.isEmpty()) {
                rwc.setChildren(resList);
            }
        }
        return rwc;
    }

    @Override
    public Response getAvailability(int resourceId, HttpHeaders headers) {
        Availability avail = this.availMgr.getCurrentAvailabilityForResource(this.caller, resourceId);
        AvailabilityRest availabilityRest = avail.getAvailabilityType() != null ? new AvailabilityRest(avail.getAvailabilityType(), avail.getStartTime(), avail.getResource().getId()) : new AvailabilityRest(avail.getStartTime(), resourceId);
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        Response.ResponseBuilder builder = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("availability.ftl", availabilityRest), (MediaType)mediaType) : Response.ok((Object)availabilityRest);
        return builder.build();
    }

    @Override
    public Response getAvailabilityHistory(int resourceId, long start, long end, HttpHeaders headers) {
        Response.ResponseBuilder builder;
        Object availabilityRest;
        if (end == 0L) {
            end = System.currentTimeMillis();
        }
        if (start == 0L) {
            start = end - 2592000000L;
        }
        AvailabilityCriteria criteria = new AvailabilityCriteria();
        criteria.addFilterInterval(Long.valueOf(start), Long.valueOf(end));
        criteria.addFilterResourceId(Integer.valueOf(resourceId));
        criteria.addSortStartTime(PageOrdering.DESC);
        PageList<Availability> points = this.availMgr.findAvailabilityByCriteria(this.caller, criteria);
        ArrayList<Object> ret = new ArrayList<Object>(points.size());
        for (Availability avail : points) {
            availabilityRest = avail.getAvailabilityType() != null ? new AvailabilityRest(avail.getAvailabilityType(), avail.getStartTime(), avail.getResource().getId()) : new AvailabilityRest(avail.getStartTime(), resourceId);
            if (avail.getEndTime() != null) {
                ((AvailabilityRest)availabilityRest).setUntil(avail.getEndTime());
            }
            ret.add(availabilityRest);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listAvailability.ftl", ret), (MediaType)mediaType);
        } else {
            availabilityRest = new GenericEntity<List<AvailabilityRest>>(ret){};
            builder = Response.ok((Object)availabilityRest);
        }
        return builder.build();
    }

    @Override
    public void reportAvailability(int resourceId, AvailabilityRest avail) {
        if (avail.getResourceId() != resourceId) {
            throw new IllegalArgumentException("Resource Ids do not match");
        }
        Resource resource = this.obtainResource(resourceId);
        AvailabilityType at = AvailabilityType.valueOf((String)avail.getType());
        AvailabilityReport report = new AvailabilityReport(true, resource.getAgent().getName());
        Availability availability = new Availability(resource, Long.valueOf(avail.getSince()), at);
        report.addAvailability(availability);
        this.availMgr.mergeAvailabilityReport(report);
    }

    @Override
    public Response getSchedules(int resourceId, String scheduleType, boolean enabledOnly, String name, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        if (scheduleType.equals("metric")) {
            scheduleType = DataType.MEASUREMENT.toString().toLowerCase();
        }
        Resource res = this.resMgr.getResource(this.caller, resourceId);
        Set schedules = res.getSchedules();
        ArrayList<MetricSchedule> ret = new ArrayList<MetricSchedule>(schedules.size());
        for (MeasurementSchedule schedule : schedules) {
            URI uri;
            UriBuilder uriBuilder;
            this.putToCache(schedule.getId(), MeasurementSchedule.class, schedule);
            MeasurementDefinition definition = schedule.getDefinition();
            if (!"all".equals(scheduleType) && !scheduleType.toLowerCase().equals(definition.getDataType().toString().toLowerCase()) || enabledOnly && (!enabledOnly || !schedule.isEnabled()) || name != null && (name == null || !name.equals(definition.getName()))) continue;
            MetricSchedule ms = new MetricSchedule(schedule.getId(), definition.getName(), definition.getDisplayName(), schedule.isEnabled(), schedule.getInterval(), definition.getUnits().toString(), definition.getDataType().toString());
            if (definition.getDataType() == DataType.MEASUREMENT) {
                uriBuilder = uriInfo.getBaseUriBuilder();
                uriBuilder.path("/metric/data/{id}");
                uri = uriBuilder.build(new Object[]{schedule.getId()});
                Link metricLink = new Link("metric", uri.toString());
                ms.addLink(metricLink);
                uriBuilder = uriInfo.getBaseUriBuilder();
                uriBuilder.path("/metric/data/{id}/raw");
                uri = uriBuilder.build(new Object[]{schedule.getId()});
                metricLink = new Link("metric-raw", uri.toString());
                ms.addLink(metricLink);
            }
            uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("resource/" + schedule.getResource().getId());
            uri = uriBuilder.build(new Object[0]);
            Link link = new Link("resource", uri.toString());
            ms.addLink(link);
            ret.add(ms);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listMetricSchedule", ret), (MediaType)mediaType);
        } else {
            GenericEntity<List<MetricSchedule>> list = new GenericEntity<List<MetricSchedule>>(ret){};
            builder = Response.ok((Object)list, (MediaType)mediaType);
        }
        return builder.build();
    }

    @Override
    public Response getChildren(int id, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        PageControl pc = new PageControl();
        Resource parent = this.fetchResource(id);
        PageList<Resource> ret = this.resMgr.findResourceByParentAndInventoryStatus(this.caller, parent, InventoryStatus.COMMITTED, pc);
        ArrayList<ResourceWithType> rwtList = new ArrayList<ResourceWithType>(ret.size());
        for (Resource r : ret) {
            ResourceWithType rwt = this.fillRWT(r, uriInfo);
            rwtList.add(rwt);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listResourceWithType", rwtList), (MediaType)mediaType);
        } else {
            GenericEntity<List<ResourceWithType>> list = new GenericEntity<List<ResourceWithType>>(rwtList){};
            builder = Response.ok((Object)list);
        }
        return builder.build();
    }

    private Resource obtainResource(int resourceId) {
        Resource resource = this.getFromCache(resourceId, Resource.class);
        if (resource == null && (resource = this.resMgr.getResource(this.caller, resourceId)) != null) {
            this.putToCache(resourceId, Resource.class, resource);
        }
        return resource;
    }

    @Override
    public List<Link> getAlertsForResource(int resourceId) {
        AlertCriteria criteria = new AlertCriteria();
        criteria.addFilterResourceIds(new Integer[]{resourceId});
        PageList<Alert> alerts = this.alertManager.findAlertsByCriteria(this.caller, criteria);
        ArrayList<Link> links = new ArrayList<Link>(alerts.size());
        for (Alert al : alerts) {
            Link link = new Link();
            link.setRel("alert");
            link.setHref("/alert/" + al.getId());
            links.add(link);
        }
        return links;
    }

    @Override
    public Response createPlatform(@PathParam(value="name") String name, StringValue typeValue, @Context UriInfo uriInfo) {
        String typeName = typeValue.getValue();
        ResourceType type = this.resourceTypeManager.getResourceTypeByNameAndPlugin(typeName, "Platforms");
        if (type == null) {
            throw new StuffNotFoundException("Platform with type [" + typeName + "]");
        }
        String resourceKey = "p:" + name;
        Resource r = this.resMgr.getResourceByParentAndKey(this.caller, null, resourceKey, "Platforms", typeName);
        if (r != null) {
            ResourceWithType rwt = this.fillRWT(r, uriInfo);
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/{id}");
            URI uri = uriBuilder.build(new Object[]{r.getId()});
            Response.ResponseBuilder builder = Response.ok((Object)rwt);
            builder.location(uri);
            return builder.build();
        }
        Agent agent = new Agent("dummy-agent:name" + name, "-dummy-p:" + name, 12345, "http://foo.com/p:name/" + name, "abc-" + name);
        this.agentMgr.createAgent(agent);
        Resource platform = new Resource(resourceKey, name, type);
        platform.setUuid(resourceKey);
        platform.setAgent(agent);
        platform.setInventoryStatus(InventoryStatus.COMMITTED);
        platform.setModifiedBy(this.caller.getName());
        platform.setDescription(type.getDescription() + ". Created via REST-api");
        platform.setItime(System.currentTimeMillis());
        try {
            this.resMgr.createResource(this.caller, platform, -1);
            this.createSchedules(platform);
            ResourceWithType rwt = this.fillRWT(platform, uriInfo);
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/{id}");
            URI uri = uriBuilder.build(new Object[]{platform.getId()});
            Response.ResponseBuilder builder = Response.created((URI)uri);
            builder.entity((Object)rwt);
            return builder.build();
        }
        catch (ResourceAlreadyExistsException e) {
            throw new IllegalArgumentException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createSchedules(Resource resource) {
        ResourceType rt = resource.getResourceType();
        Set definitions = rt.getMetricDefinitions();
        for (MeasurementDefinition definition : definitions) {
            MeasurementSchedule schedule = new MeasurementSchedule(definition, resource);
            schedule.setEnabled(definition.isDefaultOn());
            schedule.setInterval(definition.getDefaultInterval());
            this.entityManager.persist((Object)schedule);
        }
    }

    @Override
    public Response createResource(@PathParam(value="name") String name, StringValue typeValue, @QueryParam(value="plugin") String plugin, int parentId, UriInfo uriInfo) {
        Resource parent = this.resMgr.getResourceById(this.caller, parentId);
        if (parent == null) {
            throw new StuffNotFoundException("Parent with id [" + parentId + "]");
        }
        String typeName = typeValue.getValue();
        ResourceType resType = this.resourceTypeManager.getResourceTypeByNameAndPlugin(typeName, plugin);
        if (resType == null) {
            throw new StuffNotFoundException("ResourceType with name [" + typeName + "] and plugin [" + plugin + "]");
        }
        String resourceKey = "res:" + name + ":" + parentId;
        Resource r = this.resMgr.getResourceByParentAndKey(this.caller, null, resourceKey, plugin, typeName);
        if (r != null) {
            ResourceWithType rwt = this.fillRWT(r, uriInfo);
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/{id}");
            URI uri = uriBuilder.build(new Object[]{r.getId()});
            Response.ResponseBuilder builder = Response.ok((Object)rwt);
            builder.location(uri);
            return builder.build();
        }
        Resource res = new Resource(resourceKey, name, resType);
        res.setUuid(resourceKey);
        res.setAgent(parent.getAgent());
        res.setParentResource(parent);
        res.setInventoryStatus(InventoryStatus.COMMITTED);
        res.setDescription(resType.getDescription() + ". Created via REST-api");
        try {
            this.resMgr.createResource(this.caller, res, parent.getId());
            this.createSchedules(res);
            ResourceWithType rwt = this.fillRWT(res, uriInfo);
            Response.ResponseBuilder builder = Response.ok((Object)rwt);
            return builder.build();
        }
        catch (ResourceAlreadyExistsException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

