/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiError;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.util.List;
import javax.ejb.Local;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.GZIP;
import org.jboss.resteasy.annotations.cache.Cache;
import org.jboss.resteasy.links.AddLinks;
import org.jboss.resteasy.links.LinkResource;
import org.jboss.resteasy.links.LinkResources;
import org.rhq.enterprise.server.rest.domain.AvailabilityRest;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.domain.MetricSchedule;
import org.rhq.enterprise.server.rest.domain.ResourceWithChildren;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;
import org.rhq.enterprise.server.rest.domain.StringValue;

@Produces(value={"application/json", "application/xml", "text/html"})
@Path(value="/resource")
@Local
@Api(value="Resource related", description="This endpoint deals with single resources, not groups")
public interface ResourceHandlerLocal {
    public static final String NO_RESOURCE_FOR_ID = "If no resource with the passed id exists";

    @AddLinks
    @LinkResources(value={@LinkResource(rel="children", value=ResourceWithType.class)})
    @GET
    @Path(value="/{id}")
    @Cache(isPrivate=true, maxAge=120)
    @ApiOperation(value="Retrieve a single resource", responseClass="ResourceWithType")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    public Response getResource(@ApiParam(value="Id of the resource to retrieve") @PathParam(value="id") int var1, @Context Request var2, @Context HttpHeaders var3, @Context UriInfo var4);

    @GZIP
    @GET
    @Path(value="/platforms")
    @Cache(isPrivate=true, maxAge=300)
    @ApiOperation(value="List all platforms in the system", multiValueResponse=true, responseClass="ResourceWithType")
    public Response getPlatforms(@Context Request var1, @Context HttpHeaders var2, @Context UriInfo var3);

    @GET
    @Path(value="/{id}/hierarchy")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Retrieve the hierarchy of resources starting with the passed one", multiValueResponse=true, responseClass="ResourceWithType")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    public ResourceWithChildren getHierarchy(@ApiParam(value="Id of the resource to start with") @PathParam(value="id") int var1);

    @GET
    @Path(value="/{id}/availability")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    @ApiOperation(value="Return the current availability for the passed resource", responseClass="AvailabilityRest")
    public Response getAvailability(@ApiParam(value="Id of the resource to query") @PathParam(value="id") int var1, @Context HttpHeaders var2);

    @GZIP
    @GET
    @Path(value="/{id}/availability/history")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    @ApiOperation(value="Return the availability history for the passed resource", responseClass="AvailabilityRest", multiValueResponse=true)
    public Response getAvailabilityHistory(@ApiParam(value="Id of the resource to query") @PathParam(value="id") int var1, @ApiParam(value="Start time", defaultValue="30 days ago") @QueryParam(value="start") long var2, @ApiParam(value="End time", defaultValue="Now") @QueryParam(value="end") long var4, @Context HttpHeaders var6);

    @PUT
    @Path(value="/{id}/availability")
    @ApiOperation(value="Set the current availability of the passed resource")
    public void reportAvailability(@ApiParam(value="Id of the resource to update") @PathParam(value="id") int var1, @ApiParam(value="New Availability setting", required=true) AvailabilityRest var2);

    @GZIP
    @GET
    @Path(value="/{id}/schedules")
    @LinkResource(rel="schedules", value=MetricSchedule.class)
    @Cache(isPrivate=true, maxAge=60)
    @ApiOperation(value="Get the metric schedules of the passed resource id", multiValueResponse=true, responseClass="MetricSchedule")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    public Response getSchedules(@ApiParam(value="Id of the resource to obtain the schedules for") @PathParam(value="id") int var1, @ApiParam(value="Limit by type", allowableValues="<empty>, all, metric, trait, measurement") @QueryParam(value="type") @DefaultValue(value="all") String var2, @ApiParam(value="Limit by enabled schedules") @QueryParam(value="enabledOnly") @DefaultValue(value="true") boolean var3, @ApiParam(value="Limit by name") @QueryParam(value="name") String var4, @Context Request var5, @Context HttpHeaders var6, @Context UriInfo var7);

    @GZIP
    @GET
    @Path(value="/{id}/children")
    @LinkResource(rel="children", value=ResourceWithType.class)
    @ApiOperation(value="Get the direct children of the passed resource")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    public Response getChildren(@ApiParam(value="Id of the resource to get children") @PathParam(value="id") int var1, @Context Request var2, @Context HttpHeaders var3, @Context UriInfo var4);

    @GZIP
    @AddLinks
    @GET
    @Path(value="/{id}/alerts")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    @ApiOperation(value="Get a list of links to the alerts for the passed resource")
    public List<Link> getAlertsForResource(@ApiParam(value="Id of the resource to query") @PathParam(value="id") int var1);

    @ApiOperation(value="Creata a new platform in the Server. If the platform already exists, this is a no-op.The platform internally has a special name so that it will not clash with one that was generatedvia a normal RHQ agent")
    @POST
    @Path(value="platform/{name}")
    public Response createPlatform(@ApiParam(value="Name of the platform") @PathParam(value="name") String var1, @ApiParam(value="Type of the platform", allowableValues="Linux,Windows,... TODO") StringValue var2, @Context UriInfo var3);

    @ApiOperation(value="Create a resource with a given type below a certain parent")
    @POST
    @Path(value="{name}")
    public Response createResource(@ApiParam(value="Name of the new resource") @PathParam(value="name") String var1, @ApiParam(value="Name of the Resource tpye") StringValue var2, @ApiParam(value="Name of the plugin providing the type") @QueryParam(value="plugin") String var3, @ApiParam(value="Id of the future parent to attach this to") @QueryParam(value="parentId") int var4, @Context UriInfo var5);
}

