/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.util.Map;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.rhq.core.domain.cloud.Server;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StatusHandlerLocal;
import org.rhq.enterprise.server.rest.domain.Status;
import org.rhq.enterprise.server.rest.domain.StringValue;
import org.rhq.enterprise.server.system.SystemInfoManagerLocal;

@Stateless
@Interceptors(value={SetCallerInterceptor.class})
public class StatusHandlerBean
extends AbstractRestBean
implements StatusHandlerLocal {
    @EJB
    SystemInfoManagerLocal infoMgr;
    @EJB
    ServerManagerLocal serverManager;

    @Override
    public Response getStatus(HttpHeaders httpHeaders) {
        Response.ResponseBuilder builder;
        Map<String, String> statusMap = this.infoMgr.getSystemInformation(this.caller);
        Status status = new Status();
        status.setValues(statusMap);
        MediaType mediaType = (MediaType)httpHeaders.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            String htmlString = this.renderTemplate("status", status);
            builder = Response.ok((Object)htmlString, (MediaType)mediaType);
        } else {
            builder = Response.ok((Object)status, (MediaType)((MediaType)httpHeaders.getAcceptableMediaTypes().get(0)));
        }
        return builder.build();
    }

    @Override
    public StringValue serverState() {
        Server server = this.serverManager.getServer();
        StringValue sv = new StringValue(server.getOperationMode().name());
        return sv;
    }
}

