/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceNotFoundException;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.ResourceHandlerLocal;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.UserHandlerLocal;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;
import org.rhq.enterprise.server.rest.domain.UserRest;

@Interceptors(value={SetCallerInterceptor.class})
@Stateless
public class UserHandlerBean
extends AbstractRestBean
implements UserHandlerLocal {
    public static final String RESOURCE_HEALTH_RESOURCES = ".dashContent.resourcehealth.resources";
    public static final String GROUP_HEALTH_GROUPS = ".dashContent.grouphealth.groups";
    @EJB
    SubjectManagerLocal subjectManager;
    @EJB
    ResourceHandlerLocal resourceHandler;
    @EJB
    ResourceManagerLocal resourceManager;

    @Override
    public Response getFavorites(UriInfo uriInfo, HttpHeaders httpHeaders) {
        Response.ResponseBuilder builder;
        Set<Integer> favIds = this.getResourceIdsForFavorites();
        ArrayList<ResourceWithType> ret = new ArrayList<ResourceWithType>();
        MediaType mediaType = (MediaType)httpHeaders.getAcceptableMediaTypes().get(0);
        for (Integer id : favIds) {
            try {
                Resource res = this.resourceManager.getResource(this.caller, id);
                ResourceWithType rwt = this.fillRWT(res, uriInfo);
                ret.add(rwt);
            }
            catch (Exception e) {
                if (e.getCause() != null && e.getCause() instanceof ResourceNotFoundException) {
                    this.log.debug((Object)("Favorite resource with id " + id + " not found - not returning to the user"));
                    continue;
                }
                this.log.warn((Object)("Retrieving resource with id " + id + " failed: " + e.getLocalizedMessage()));
            }
        }
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listResourceWithType", ret), (MediaType)mediaType);
        } else {
            GenericEntity<List<ResourceWithType>> list = new GenericEntity<List<ResourceWithType>>(ret){};
            builder = Response.ok((Object)list);
        }
        return builder.build();
    }

    @Override
    public void addFavoriteResource(int id) {
        Set<Integer> favIds = this.getResourceIdsForFavorites();
        if (!favIds.contains(id)) {
            favIds.add(id);
            this.updateFavorites(favIds);
        }
    }

    @Override
    public void removeResourceFromFavorites(int id) {
        Set<Integer> favIds = this.getResourceIdsForFavorites();
        if (favIds.contains(id)) {
            favIds.remove(id);
            this.updateFavorites(favIds);
        }
    }

    @Override
    public Response getUserDetails(String loginName, Request request, HttpHeaders headers) {
        Subject subject = this.subjectManager.getSubjectByName(loginName);
        if (subject == null) {
            throw new StuffNotFoundException("User with login " + loginName);
        }
        EntityTag eTag = new EntityTag(Long.toOctalString(subject.hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            UserRest user = new UserRest(subject.getId(), subject.getName());
            user.setFirstName(subject.getFirstName());
            user.setLastName(subject.getLastName());
            user.setEmail(subject.getEmailAddress());
            user.setTel(subject.getPhoneNumber());
            MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
            builder = Response.ok((Object)user, (MediaType)mediaType);
            builder.tag(eTag);
        }
        return builder.build();
    }

    private void updateFavorites(Set<Integer> favIds) {
        Configuration conf = this.caller.getUserConfiguration();
        StringBuilder builder = new StringBuilder();
        Iterator<Integer> iter = favIds.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append('|');
        }
        PropertySimple prop = conf.getSimple(RESOURCE_HEALTH_RESOURCES);
        if (prop == null) {
            conf.put((Property)new PropertySimple(RESOURCE_HEALTH_RESOURCES, (Object)builder.toString()));
        } else {
            prop.setStringValue(builder.toString());
        }
        this.caller.setUserConfiguration(conf);
        this.subjectManager.updateSubject(this.caller, this.caller);
    }

    private Set<Integer> getResourceIdsForFavorites() {
        Configuration conf = this.caller.getUserConfiguration();
        String favsString = conf.getSimpleValue(RESOURCE_HEALTH_RESOURCES, "");
        TreeSet<Integer> favIds = new TreeSet<Integer>();
        if (!favsString.isEmpty()) {
            String[] favStringArray;
            for (String tmp : favStringArray = favsString.split("\\|")) {
                favIds.add(Integer.valueOf(tmp));
            }
        }
        return favIds;
    }
}

