/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.reporting;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.criteria.ResourceOperationHistoryCriteria;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.ReportsInterceptor;
import org.rhq.enterprise.server.rest.reporting.CsvWriter;
import org.rhq.enterprise.server.rest.reporting.PropertyConverter;
import org.rhq.enterprise.server.rest.reporting.RecentOperationsLocal;
import org.rhq.enterprise.server.rest.reporting.ReportFormatHelper;
import org.rhq.enterprise.server.util.CriteriaQuery;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;

@Interceptors(value={ReportsInterceptor.class})
@Stateless
public class RecentOperationsHandler
extends AbstractRestBean
implements RecentOperationsLocal {
    private final Log log = LogFactory.getLog(RecentOperationsHandler.class);
    @EJB
    private OperationManagerLocal operationManager;

    @Override
    public StreamingOutput recentOperations(final String operationRequestStatus, final Long startTime, final Long endTime, final HttpServletRequest request) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received request to generate report for " + this.caller));
        }
        return new StreamingOutput(){

            public void write(OutputStream stream) throws IOException, WebApplicationException {
                String[] statuses;
                ResourceOperationHistoryCriteria criteria = new ResourceOperationHistoryCriteria();
                criteria.addSortEndTime(PageOrdering.DESC);
                if (startTime != null) {
                    criteria.addFilterStartTime(startTime);
                }
                if (endTime != null) {
                    criteria.addFilterEndTime(endTime);
                }
                if (startTime != null && endTime == null) {
                    Date today = new Date();
                    criteria.addFilterEndTime(Long.valueOf(today.getTime()));
                }
                ArrayList<OperationRequestStatus> operationRequestStatusList = new ArrayList<OperationRequestStatus>(10);
                for (String requestStatus : statuses = operationRequestStatus.split(",")) {
                    RecentOperationsHandler.this.log.info((Object)("OperationRequestStatus Filter set for: " + requestStatus));
                    operationRequestStatusList.add(OperationRequestStatus.valueOf((String)requestStatus.toUpperCase()));
                }
                criteria.addFilterStatuses(operationRequestStatusList.toArray(new OperationRequestStatus[operationRequestStatusList.size()]));
                CriteriaQueryExecutor<ResourceOperationHistory, ResourceOperationHistoryCriteria> queryExecutor = new CriteriaQueryExecutor<ResourceOperationHistory, ResourceOperationHistoryCriteria>(){

                    @Override
                    public PageList<ResourceOperationHistory> execute(ResourceOperationHistoryCriteria criteria) {
                        return RecentOperationsHandler.this.operationManager.findResourceOperationHistoriesByCriteria(RecentOperationsHandler.this.caller, criteria);
                    }
                };
                CriteriaQuery<ResourceOperationHistory, ResourceOperationHistoryCriteria> query = new CriteriaQuery<ResourceOperationHistory, ResourceOperationHistoryCriteria>(criteria, queryExecutor);
                CsvWriter csvWriter = new CsvWriter();
                csvWriter.setColumns("startedTime", "operationDefinition.displayName", "subjectName", "status", "resource.name", "ancestry", "detailsURL");
                csvWriter.setPropertyConverter("startedTime", csvWriter.DATE_CONVERTER);
                csvWriter.setPropertyConverter("ancestry", new PropertyConverter<ResourceOperationHistory>(){

                    @Override
                    public Object convert(ResourceOperationHistory history, String propertyName) {
                        return ReportFormatHelper.parseAncestry(history.getResource().getAncestry());
                    }
                });
                csvWriter.setPropertyConverter("detailsURL", new PropertyConverter<ResourceOperationHistory>(){

                    @Override
                    public Object convert(ResourceOperationHistory history, String propertyName) {
                        return this.getDetailsURL(history);
                    }
                });
                stream.write((this.getHeader() + "\n").getBytes());
                for (ResourceOperationHistory history : query) {
                    csvWriter.write(history, stream);
                }
            }

            private String getHeader() {
                return "Date Submitted,Operation,Requester,Status,Resource,Ancestry,Details URL";
            }

            private String getDetailsURL(ResourceOperationHistory history) {
                String protocol = request.isSecure() ? "https" : "http";
                return protocol + "://" + request.getServerName() + ":" + request.getServerPort() + "/coregui/#Resource/" + history.getResource().getId() + "/Operations/History/" + history.getId();
            }
        };
    }
}

