/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.reporting;

import java.io.IOException;
import java.io.OutputStream;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.measurement.composite.MeasurementOOBComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.measurement.MeasurementOOBManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.ReportsInterceptor;
import org.rhq.enterprise.server.rest.reporting.CsvWriter;
import org.rhq.enterprise.server.rest.reporting.MeasurementConverter;
import org.rhq.enterprise.server.rest.reporting.PropertyConverter;
import org.rhq.enterprise.server.rest.reporting.ReportFormatHelper;
import org.rhq.enterprise.server.rest.reporting.SuspectMetricLocal;
import org.rhq.enterprise.server.util.CriteriaQuery;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;

@Interceptors(value={ReportsInterceptor.class})
@Stateless
public class SuspectMetricHandler
extends AbstractRestBean
implements SuspectMetricLocal {
    private final Log log = LogFactory.getLog(SuspectMetricHandler.class);
    @EJB
    private MeasurementOOBManagerLocal measurementOOBMManager;

    @Override
    public StreamingOutput suspectMetrics(HttpServletRequest request) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received request to generate report for " + this.caller));
        }
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                Criteria criteria = new Criteria(){

                    public Class<?> getPersistentClass() {
                        return MeasurementOOBComposite.class;
                    }
                };
                criteria.setPaging(0, 5);
                CriteriaQueryExecutor<MeasurementOOBComposite, Criteria> queryExecutor = new CriteriaQueryExecutor<MeasurementOOBComposite, Criteria>(){

                    @Override
                    public PageList<MeasurementOOBComposite> execute(Criteria criteria) {
                        return SuspectMetricHandler.this.measurementOOBMManager.getSchedulesWithOOBs(SuspectMetricHandler.this.caller, null, null, null, new PageControl(criteria.getPageNumber().intValue(), criteria.getPageSize().intValue()));
                    }
                };
                CriteriaQuery<MeasurementOOBComposite, Criteria> query = new CriteriaQuery<MeasurementOOBComposite, Criteria>(criteria, queryExecutor);
                CsvWriter<MeasurementOOBComposite> csvWriter = new CsvWriter<MeasurementOOBComposite>();
                csvWriter.setColumns("resourceName", "ancestry", "scheduleName", "formattedBaseband", "formattedOutlier");
                csvWriter.setPropertyConverter("ancestry", new PropertyConverter<MeasurementOOBComposite>(){

                    @Override
                    public Object convert(MeasurementOOBComposite composite, String propertyName) {
                        return ReportFormatHelper.parseAncestry(composite.getResourceAncestry());
                    }
                });
                output.write((SuspectMetricHandler.this.getHeader() + "\n").getBytes());
                for (MeasurementOOBComposite composite : query) {
                    SuspectMetricHandler.this.applyFormatting(composite);
                    SuspectMetricHandler.this.formatBaseband(composite);
                    csvWriter.write(composite, output);
                }
            }
        };
    }

    private String getHeader() {
        return "Resource,Ancestry,Metric,Band,Outlier,Out of Range Factor (%)";
    }

    private void applyFormatting(MeasurementOOBComposite oob) {
        oob.setFormattedOutlier(MeasurementConverter.format(oob.getOutlier(), oob.getUnits(), true));
        this.formatBaseband(oob);
    }

    private void formatBaseband(MeasurementOOBComposite oob) {
        String min = MeasurementConverter.format(oob.getBlMin(), oob.getUnits(), true);
        String max = MeasurementConverter.format(oob.getBlMax(), oob.getUnits(), true);
        oob.setFormattedBaseband(min + ", " + max);
    }
}

